package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBaselines invokes the dataworks_public.ListBaselines API synchronously
func (client *Client) ListBaselines(request *ListBaselinesRequest) (response *ListBaselinesResponse, err error) {
	response = CreateListBaselinesResponse()
	err = client.DoAction(request, response)
	return
}

// ListBaselinesWithChan invokes the dataworks_public.ListBaselines API asynchronously
func (client *Client) ListBaselinesWithChan(request *ListBaselinesRequest) (<-chan *ListBaselinesResponse, <-chan error) {
	responseChan := make(chan *ListBaselinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBaselines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBaselinesWithCallback invokes the dataworks_public.ListBaselines API asynchronously
func (client *Client) ListBaselinesWithCallback(request *ListBaselinesRequest, callback func(response *ListBaselinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBaselinesResponse
		var err error
		defer close(result)
		response, err = client.ListBaselines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBaselinesRequest is the request struct for api ListBaselines
type ListBaselinesRequest struct {
	*requests.RpcRequest
	Owner         string           `position:"Body" name:"Owner"`
	SearchText    string           `position:"Body" name:"SearchText"`
	Priority      string           `position:"Body" name:"Priority"`
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	Enable        requests.Boolean `position:"Body" name:"Enable"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	ProjectId     requests.Integer `position:"Body" name:"ProjectId"`
	BaselineTypes string           `position:"Body" name:"BaselineTypes"`
}

// ListBaselinesResponse is the response struct for api ListBaselines
type ListBaselinesResponse struct {
	*responses.BaseResponse
	Success             bool                `json:"Success" xml:"Success"`
	ErrorCode           string              `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage        string              `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode      int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	DynamicErrorCode    string              `json:"DynamicErrorCode" xml:"DynamicErrorCode"`
	DynamicErrorMessage string              `json:"DynamicErrorMessage" xml:"DynamicErrorMessage"`
	Data                DataInListBaselines `json:"Data" xml:"Data"`
}

// CreateListBaselinesRequest creates a request to invoke ListBaselines API
func CreateListBaselinesRequest() (request *ListBaselinesRequest) {
	request = &ListBaselinesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListBaselines", "", "")
	request.Method = requests.POST
	return
}

// CreateListBaselinesResponse creates a response to parse from ListBaselines response
func CreateListBaselinesResponse() (response *ListBaselinesResponse) {
	response = &ListBaselinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
