package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEventSubscription invokes the das.GetEventSubscription API synchronously
func (client *Client) GetEventSubscription(request *GetEventSubscriptionRequest) (response *GetEventSubscriptionResponse, err error) {
	response = CreateGetEventSubscriptionResponse()
	err = client.DoAction(request, response)
	return
}

// GetEventSubscriptionWithChan invokes the das.GetEventSubscription API asynchronously
func (client *Client) GetEventSubscriptionWithChan(request *GetEventSubscriptionRequest) (<-chan *GetEventSubscriptionResponse, <-chan error) {
	responseChan := make(chan *GetEventSubscriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEventSubscription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEventSubscriptionWithCallback invokes the das.GetEventSubscription API asynchronously
func (client *Client) GetEventSubscriptionWithCallback(request *GetEventSubscriptionRequest, callback func(response *GetEventSubscriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEventSubscriptionResponse
		var err error
		defer close(result)
		response, err = client.GetEventSubscription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEventSubscriptionRequest is the request struct for api GetEventSubscription
type GetEventSubscriptionRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetEventSubscriptionResponse is the response struct for api GetEventSubscription
type GetEventSubscriptionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetEventSubscriptionRequest creates a request to invoke GetEventSubscription API
func CreateGetEventSubscriptionRequest() (request *GetEventSubscriptionRequest) {
	request = &GetEventSubscriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetEventSubscription", "", "")
	request.Method = requests.POST
	return
}

// CreateGetEventSubscriptionResponse creates a response to parse from GetEventSubscription response
func CreateGetEventSubscriptionResponse() (response *GetEventSubscriptionResponse) {
	response = &GetEventSubscriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
