package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCredentialsList invokes the csb.DeleteCredentialsList API synchronously
// api document: https://help.aliyun.com/api/csb/deletecredentialslist.html
func (client *Client) DeleteCredentialsList(request *DeleteCredentialsListRequest) (response *DeleteCredentialsListResponse, err error) {
	response = CreateDeleteCredentialsListResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCredentialsListWithChan invokes the csb.DeleteCredentialsList API asynchronously
// api document: https://help.aliyun.com/api/csb/deletecredentialslist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCredentialsListWithChan(request *DeleteCredentialsListRequest) (<-chan *DeleteCredentialsListResponse, <-chan error) {
	responseChan := make(chan *DeleteCredentialsListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCredentialsList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCredentialsListWithCallback invokes the csb.DeleteCredentialsList API asynchronously
// api document: https://help.aliyun.com/api/csb/deletecredentialslist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteCredentialsListWithCallback(request *DeleteCredentialsListRequest, callback func(response *DeleteCredentialsListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCredentialsListResponse
		var err error
		defer close(result)
		response, err = client.DeleteCredentialsList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCredentialsListRequest is the request struct for api DeleteCredentialsList
type DeleteCredentialsListRequest struct {
	*requests.RpcRequest
	Data        string           `position:"Body" name:"Data"`
	IgnoreDauth requests.Boolean `position:"Query" name:"IgnoreDauth"`
	Force       requests.Boolean `position:"Query" name:"Force"`
}

// DeleteCredentialsListResponse is the response struct for api DeleteCredentialsList
type DeleteCredentialsListResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCredentialsListRequest creates a request to invoke DeleteCredentialsList API
func CreateDeleteCredentialsListRequest() (request *DeleteCredentialsListRequest) {
	request = &DeleteCredentialsListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "DeleteCredentialsList", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteCredentialsListResponse creates a response to parse from DeleteCredentialsList response
func CreateDeleteCredentialsListResponse() (response *DeleteCredentialsListResponse) {
	response = &DeleteCredentialsListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
