package crm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLabelForBid invokes the crm.DeleteLabelForBid API synchronously
// api document: https://help.aliyun.com/api/crm/deletelabelforbid.html
func (client *Client) DeleteLabelForBid(request *DeleteLabelForBidRequest) (response *DeleteLabelForBidResponse, err error) {
	response = CreateDeleteLabelForBidResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLabelForBidWithChan invokes the crm.DeleteLabelForBid API asynchronously
// api document: https://help.aliyun.com/api/crm/deletelabelforbid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLabelForBidWithChan(request *DeleteLabelForBidRequest) (<-chan *DeleteLabelForBidResponse, <-chan error) {
	responseChan := make(chan *DeleteLabelForBidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLabelForBid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLabelForBidWithCallback invokes the crm.DeleteLabelForBid API asynchronously
// api document: https://help.aliyun.com/api/crm/deletelabelforbid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLabelForBidWithCallback(request *DeleteLabelForBidRequest, callback func(response *DeleteLabelForBidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLabelForBidResponse
		var err error
		defer close(result)
		response, err = client.DeleteLabelForBid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLabelForBidRequest is the request struct for api DeleteLabelForBid
type DeleteLabelForBidRequest struct {
	*requests.RpcRequest
	LabelSeries string `position:"Query" name:"LabelSeries"`
	PK          string `position:"Query" name:"PK"`
	Label       string `position:"Query" name:"Label"`
}

// DeleteLabelForBidResponse is the response struct for api DeleteLabelForBid
type DeleteLabelForBidResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDeleteLabelForBidRequest creates a request to invoke DeleteLabelForBid API
func CreateDeleteLabelForBidRequest() (request *DeleteLabelForBidRequest) {
	request = &DeleteLabelForBidRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Crm", "2015-04-08", "DeleteLabelForBid", "crm", "openAPI")
	return
}

// CreateDeleteLabelForBidResponse creates a response to parse from DeleteLabelForBid response
func CreateDeleteLabelForBidResponse() (response *DeleteLabelForBidResponse) {
	response = &DeleteLabelForBidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
