package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateResourceComplianceByConfigRule invokes the config.GetAggregateResourceComplianceByConfigRule API synchronously
func (client *Client) GetAggregateResourceComplianceByConfigRule(request *GetAggregateResourceComplianceByConfigRuleRequest) (response *GetAggregateResourceComplianceByConfigRuleResponse, err error) {
	response = CreateGetAggregateResourceComplianceByConfigRuleResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateResourceComplianceByConfigRuleWithChan invokes the config.GetAggregateResourceComplianceByConfigRule API asynchronously
func (client *Client) GetAggregateResourceComplianceByConfigRuleWithChan(request *GetAggregateResourceComplianceByConfigRuleRequest) (<-chan *GetAggregateResourceComplianceByConfigRuleResponse, <-chan error) {
	responseChan := make(chan *GetAggregateResourceComplianceByConfigRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateResourceComplianceByConfigRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateResourceComplianceByConfigRuleWithCallback invokes the config.GetAggregateResourceComplianceByConfigRule API asynchronously
func (client *Client) GetAggregateResourceComplianceByConfigRuleWithCallback(request *GetAggregateResourceComplianceByConfigRuleRequest, callback func(response *GetAggregateResourceComplianceByConfigRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateResourceComplianceByConfigRuleResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateResourceComplianceByConfigRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateResourceComplianceByConfigRuleRequest is the request struct for api GetAggregateResourceComplianceByConfigRule
type GetAggregateResourceComplianceByConfigRuleRequest struct {
	*requests.RpcRequest
	ConfigRuleId    string           `position:"Query" name:"ConfigRuleId"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AggregatorId    string           `position:"Query" name:"AggregatorId"`
	ComplianceType  string           `position:"Query" name:"ComplianceType"`
}

// GetAggregateResourceComplianceByConfigRuleResponse is the response struct for api GetAggregateResourceComplianceByConfigRule
type GetAggregateResourceComplianceByConfigRuleResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	ComplianceResult ComplianceResult `json:"ComplianceResult" xml:"ComplianceResult"`
}

// CreateGetAggregateResourceComplianceByConfigRuleRequest creates a request to invoke GetAggregateResourceComplianceByConfigRule API
func CreateGetAggregateResourceComplianceByConfigRuleRequest() (request *GetAggregateResourceComplianceByConfigRuleRequest) {
	request = &GetAggregateResourceComplianceByConfigRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateResourceComplianceByConfigRule", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAggregateResourceComplianceByConfigRuleResponse creates a response to parse from GetAggregateResourceComplianceByConfigRule response
func CreateGetAggregateResourceComplianceByConfigRuleResponse() (response *GetAggregateResourceComplianceByConfigRuleResponse) {
	response = &GetAggregateResourceComplianceByConfigRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
