package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutExporterRule invokes the cms.PutExporterRule API synchronously
func (client *Client) PutExporterRule(request *PutExporterRuleRequest) (response *PutExporterRuleResponse, err error) {
	response = CreatePutExporterRuleResponse()
	err = client.DoAction(request, response)
	return
}

// PutExporterRuleWithChan invokes the cms.PutExporterRule API asynchronously
func (client *Client) PutExporterRuleWithChan(request *PutExporterRuleRequest) (<-chan *PutExporterRuleResponse, <-chan error) {
	responseChan := make(chan *PutExporterRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutExporterRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutExporterRuleWithCallback invokes the cms.PutExporterRule API asynchronously
func (client *Client) PutExporterRuleWithCallback(request *PutExporterRuleRequest, callback func(response *PutExporterRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutExporterRuleResponse
		var err error
		defer close(result)
		response, err = client.PutExporterRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutExporterRuleRequest is the request struct for api PutExporterRule
type PutExporterRuleRequest struct {
	*requests.RpcRequest
	RuleName      string    `position:"Query" name:"RuleName"`
	DstNames      *[]string `position:"Query" name:"DstNames"  type:"Repeated"`
	Namespace     string    `position:"Query" name:"Namespace"`
	TargetWindows string    `position:"Query" name:"TargetWindows"`
	Describe      string    `position:"Query" name:"Describe"`
	MetricName    string    `position:"Query" name:"MetricName"`
}

// PutExporterRuleResponse is the response struct for api PutExporterRule
type PutExporterRuleResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreatePutExporterRuleRequest creates a request to invoke PutExporterRule API
func CreatePutExporterRuleRequest() (request *PutExporterRuleRequest) {
	request = &PutExporterRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "PutExporterRule", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutExporterRuleResponse creates a response to parse from PutExporterRule response
func CreatePutExporterRuleResponse() (response *PutExporterRuleResponse) {
	response = &PutExporterRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
