package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUpgradeAPProgress invokes the cloudwf.GetUpgradeAPProgress API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getupgradeapprogress.html
func (client *Client) GetUpgradeAPProgress(request *GetUpgradeAPProgressRequest) (response *GetUpgradeAPProgressResponse, err error) {
	response = CreateGetUpgradeAPProgressResponse()
	err = client.DoAction(request, response)
	return
}

// GetUpgradeAPProgressWithChan invokes the cloudwf.GetUpgradeAPProgress API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getupgradeapprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUpgradeAPProgressWithChan(request *GetUpgradeAPProgressRequest) (<-chan *GetUpgradeAPProgressResponse, <-chan error) {
	responseChan := make(chan *GetUpgradeAPProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUpgradeAPProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUpgradeAPProgressWithCallback invokes the cloudwf.GetUpgradeAPProgress API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getupgradeapprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUpgradeAPProgressWithCallback(request *GetUpgradeAPProgressRequest, callback func(response *GetUpgradeAPProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUpgradeAPProgressResponse
		var err error
		defer close(result)
		response, err = client.GetUpgradeAPProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUpgradeAPProgressRequest is the request struct for api GetUpgradeAPProgress
type GetUpgradeAPProgressRequest struct {
	*requests.RpcRequest
}

// GetUpgradeAPProgressResponse is the response struct for api GetUpgradeAPProgress
type GetUpgradeAPProgressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetUpgradeAPProgressRequest creates a request to invoke GetUpgradeAPProgress API
func CreateGetUpgradeAPProgressRequest() (request *GetUpgradeAPProgressRequest) {
	request = &GetUpgradeAPProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetUpgradeAPProgress", "cloudwf", "openAPI")
	return
}

// CreateGetUpgradeAPProgressResponse creates a response to parse from GetUpgradeAPProgress response
func CreateGetUpgradeAPProgressResponse() (response *GetUpgradeAPProgressResponse) {
	response = &GetUpgradeAPProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
