package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteInstanceEx invokes the cloudcallcenter.DeleteInstanceEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deleteinstanceex.html
func (client *Client) DeleteInstanceEx(request *DeleteInstanceExRequest) (response *DeleteInstanceExResponse, err error) {
	response = CreateDeleteInstanceExResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteInstanceExWithChan invokes the cloudcallcenter.DeleteInstanceEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deleteinstanceex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteInstanceExWithChan(request *DeleteInstanceExRequest) (<-chan *DeleteInstanceExResponse, <-chan error) {
	responseChan := make(chan *DeleteInstanceExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteInstanceEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteInstanceExWithCallback invokes the cloudcallcenter.DeleteInstanceEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deleteinstanceex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteInstanceExWithCallback(request *DeleteInstanceExRequest, callback func(response *DeleteInstanceExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteInstanceExResponse
		var err error
		defer close(result)
		response, err = client.DeleteInstanceEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteInstanceExRequest is the request struct for api DeleteInstanceEx
type DeleteInstanceExRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteInstanceExResponse is the response struct for api DeleteInstanceEx
type DeleteInstanceExResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateDeleteInstanceExRequest creates a request to invoke DeleteInstanceEx API
func CreateDeleteInstanceExRequest() (request *DeleteInstanceExRequest) {
	request = &DeleteInstanceExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DeleteInstanceEx", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteInstanceExResponse creates a response to parse from DeleteInstanceEx response
func CreateDeleteInstanceExResponse() (response *DeleteInstanceExResponse) {
	response = &DeleteInstanceExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
