package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDeployApis invokes the cloudapi.BatchDeployApis API synchronously
func (client *Client) BatchDeployApis(request *BatchDeployApisRequest) (response *BatchDeployApisResponse, err error) {
	response = CreateBatchDeployApisResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDeployApisWithChan invokes the cloudapi.BatchDeployApis API asynchronously
func (client *Client) BatchDeployApisWithChan(request *BatchDeployApisRequest) (<-chan *BatchDeployApisResponse, <-chan error) {
	responseChan := make(chan *BatchDeployApisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDeployApis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDeployApisWithCallback invokes the cloudapi.BatchDeployApis API asynchronously
func (client *Client) BatchDeployApisWithCallback(request *BatchDeployApisRequest, callback func(response *BatchDeployApisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDeployApisResponse
		var err error
		defer close(result)
		response, err = client.BatchDeployApis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDeployApisRequest is the request struct for api BatchDeployApis
type BatchDeployApisRequest struct {
	*requests.RpcRequest
	StageName     string                `position:"Query" name:"StageName"`
	Description   string                `position:"Query" name:"Description"`
	SecurityToken string                `position:"Query" name:"SecurityToken"`
	Api           *[]BatchDeployApisApi `position:"Query" name:"Api"  type:"Repeated"`
}

// BatchDeployApisApi is a repeated param struct in BatchDeployApisRequest
type BatchDeployApisApi struct {
	GroupId string `name:"GroupId"`
	ApiUid  string `name:"ApiUid"`
}

// BatchDeployApisResponse is the response struct for api BatchDeployApis
type BatchDeployApisResponse struct {
	*responses.BaseResponse
	OperationId string `json:"OperationId" xml:"OperationId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchDeployApisRequest creates a request to invoke BatchDeployApis API
func CreateBatchDeployApisRequest() (request *BatchDeployApisRequest) {
	request = &BatchDeployApisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "BatchDeployApis", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchDeployApisResponse creates a response to parse from BatchDeployApis response
func CreateBatchDeployApisResponse() (response *BatchDeployApisResponse) {
	response = &BatchDeployApisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
