package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMonitor invokes the cdrs.AddMonitor API synchronously
func (client *Client) AddMonitor(request *AddMonitorRequest) (response *AddMonitorResponse, err error) {
	response = CreateAddMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// AddMonitorWithChan invokes the cdrs.AddMonitor API asynchronously
func (client *Client) AddMonitorWithChan(request *AddMonitorRequest) (<-chan *AddMonitorResponse, <-chan error) {
	responseChan := make(chan *AddMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMonitorWithCallback invokes the cdrs.AddMonitor API asynchronously
func (client *Client) AddMonitorWithCallback(request *AddMonitorRequest, callback func(response *AddMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMonitorResponse
		var err error
		defer close(result)
		response, err = client.AddMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMonitorRequest is the request struct for api AddMonitor
type AddMonitorRequest struct {
	*requests.RpcRequest
	MonitorType          string           `position:"Body" name:"MonitorType"`
	CorpId               string           `position:"Body" name:"CorpId"`
	Description          string           `position:"Body" name:"Description"`
	NotifierAppSecret    string           `position:"Body" name:"NotifierAppSecret"`
	NotifierExtendValues string           `position:"Body" name:"NotifierExtendValues"`
	NotifierUrl          string           `position:"Body" name:"NotifierUrl"`
	NotifierType         string           `position:"Body" name:"NotifierType"`
	BatchIndicator       requests.Integer `position:"Body" name:"BatchIndicator"`
	BizId                string           `position:"Body" name:"BizId"`
	NotifierTimeOut      requests.Integer `position:"Body" name:"NotifierTimeOut"`
	AlgorithmVendor      string           `position:"Body" name:"AlgorithmVendor"`
}

// AddMonitorResponse is the response struct for api AddMonitor
type AddMonitorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddMonitorRequest creates a request to invoke AddMonitor API
func CreateAddMonitorRequest() (request *AddMonitorRequest) {
	request = &AddMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "AddMonitor", "", "")
	request.Method = requests.POST
	return
}

// CreateAddMonitorResponse creates a response to parse from AddMonitor response
func CreateAddMonitorResponse() (response *AddMonitorResponse) {
	response = &AddMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
