package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LaunchSurvey invokes the ccc.LaunchSurvey API synchronously
func (client *Client) LaunchSurvey(request *LaunchSurveyRequest) (response *LaunchSurveyResponse, err error) {
	response = CreateLaunchSurveyResponse()
	err = client.DoAction(request, response)
	return
}

// LaunchSurveyWithChan invokes the ccc.LaunchSurvey API asynchronously
func (client *Client) LaunchSurveyWithChan(request *LaunchSurveyRequest) (<-chan *LaunchSurveyResponse, <-chan error) {
	responseChan := make(chan *LaunchSurveyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LaunchSurvey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LaunchSurveyWithCallback invokes the ccc.LaunchSurvey API asynchronously
func (client *Client) LaunchSurveyWithCallback(request *LaunchSurveyRequest, callback func(response *LaunchSurveyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LaunchSurveyResponse
		var err error
		defer close(result)
		response, err = client.LaunchSurvey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LaunchSurveyRequest is the request struct for api LaunchSurvey
type LaunchSurveyRequest struct {
	*requests.RpcRequest
	ContactFlowId        string `position:"Query" name:"ContactFlowId"`
	ContactFlowVariables string `position:"Query" name:"ContactFlowVariables"`
	UserId               string `position:"Query" name:"UserId"`
	DeviceId             string `position:"Query" name:"DeviceId"`
	JobId                string `position:"Query" name:"JobId"`
	InstanceId           string `position:"Query" name:"InstanceId"`
	SmsMetadataId        string `position:"Query" name:"SmsMetadataId"`
	SurveyChannel        string `position:"Query" name:"SurveyChannel"`
}

// LaunchSurveyResponse is the response struct for api LaunchSurvey
type LaunchSurveyResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateLaunchSurveyRequest creates a request to invoke LaunchSurvey API
func CreateLaunchSurveyRequest() (request *LaunchSurveyRequest) {
	request = &LaunchSurveyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "LaunchSurvey", "", "")
	request.Method = requests.POST
	return
}

// CreateLaunchSurveyResponse creates a response to parse from LaunchSurvey response
func CreateLaunchSurveyResponse() (response *LaunchSurveyResponse) {
	response = &LaunchSurveyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
