package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisassociateTransitRouterMulticastDomain invokes the cbn.DisassociateTransitRouterMulticastDomain API synchronously
func (client *Client) DisassociateTransitRouterMulticastDomain(request *DisassociateTransitRouterMulticastDomainRequest) (response *DisassociateTransitRouterMulticastDomainResponse, err error) {
	response = CreateDisassociateTransitRouterMulticastDomainResponse()
	err = client.DoAction(request, response)
	return
}

// DisassociateTransitRouterMulticastDomainWithChan invokes the cbn.DisassociateTransitRouterMulticastDomain API asynchronously
func (client *Client) DisassociateTransitRouterMulticastDomainWithChan(request *DisassociateTransitRouterMulticastDomainRequest) (<-chan *DisassociateTransitRouterMulticastDomainResponse, <-chan error) {
	responseChan := make(chan *DisassociateTransitRouterMulticastDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisassociateTransitRouterMulticastDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisassociateTransitRouterMulticastDomainWithCallback invokes the cbn.DisassociateTransitRouterMulticastDomain API asynchronously
func (client *Client) DisassociateTransitRouterMulticastDomainWithCallback(request *DisassociateTransitRouterMulticastDomainRequest, callback func(response *DisassociateTransitRouterMulticastDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisassociateTransitRouterMulticastDomainResponse
		var err error
		defer close(result)
		response, err = client.DisassociateTransitRouterMulticastDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisassociateTransitRouterMulticastDomainRequest is the request struct for api DisassociateTransitRouterMulticastDomain
type DisassociateTransitRouterMulticastDomainRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                    string           `position:"Query" name:"ClientToken"`
	VSwitchIds                     *[]string        `position:"Query" name:"VSwitchIds"  type:"Repeated"`
	TransitRouterMulticastDomainId string           `position:"Query" name:"TransitRouterMulticastDomainId"`
	DryRun                         requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount           string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                   string           `position:"Query" name:"OwnerAccount"`
	OwnerId                        requests.Integer `position:"Query" name:"OwnerId"`
	Version                        string           `position:"Query" name:"Version"`
	TransitRouterAttachmentId      string           `position:"Query" name:"TransitRouterAttachmentId"`
}

// DisassociateTransitRouterMulticastDomainResponse is the response struct for api DisassociateTransitRouterMulticastDomain
type DisassociateTransitRouterMulticastDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisassociateTransitRouterMulticastDomainRequest creates a request to invoke DisassociateTransitRouterMulticastDomain API
func CreateDisassociateTransitRouterMulticastDomainRequest() (request *DisassociateTransitRouterMulticastDomainRequest) {
	request = &DisassociateTransitRouterMulticastDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DisassociateTransitRouterMulticastDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateDisassociateTransitRouterMulticastDomainResponse creates a response to parse from DisassociateTransitRouterMulticastDomain response
func CreateDisassociateTransitRouterMulticastDomainResponse() (response *DisassociateTransitRouterMulticastDomainResponse) {
	response = &DisassociateTransitRouterMulticastDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
