package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTransitRouteTableAggregation invokes the cbn.CreateTransitRouteTableAggregation API synchronously
func (client *Client) CreateTransitRouteTableAggregation(request *CreateTransitRouteTableAggregationRequest) (response *CreateTransitRouteTableAggregationResponse, err error) {
	response = CreateCreateTransitRouteTableAggregationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTransitRouteTableAggregationWithChan invokes the cbn.CreateTransitRouteTableAggregation API asynchronously
func (client *Client) CreateTransitRouteTableAggregationWithChan(request *CreateTransitRouteTableAggregationRequest) (<-chan *CreateTransitRouteTableAggregationResponse, <-chan error) {
	responseChan := make(chan *CreateTransitRouteTableAggregationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTransitRouteTableAggregation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTransitRouteTableAggregationWithCallback invokes the cbn.CreateTransitRouteTableAggregation API asynchronously
func (client *Client) CreateTransitRouteTableAggregationWithCallback(request *CreateTransitRouteTableAggregationRequest, callback func(response *CreateTransitRouteTableAggregationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTransitRouteTableAggregationResponse
		var err error
		defer close(result)
		response, err = client.CreateTransitRouteTableAggregation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTransitRouteTableAggregationRequest is the request struct for api CreateTransitRouteTableAggregation
type CreateTransitRouteTableAggregationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                             string           `position:"Query" name:"ClientToken"`
	TransitRouteTableAggregationDescription string           `position:"Query" name:"TransitRouteTableAggregationDescription"`
	TransitRouteTableAggregationName        string           `position:"Query" name:"TransitRouteTableAggregationName"`
	DryRun                                  requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount                    string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                            string           `position:"Query" name:"OwnerAccount"`
	TransitRouteTableAggregationScop        string           `position:"Query" name:"TransitRouteTableAggregationScop"`
	OwnerId                                 requests.Integer `position:"Query" name:"OwnerId"`
	Version                                 string           `position:"Query" name:"Version"`
	TransitRouteTableId                     string           `position:"Query" name:"TransitRouteTableId"`
	TransitRouteTableAggregationCidr        string           `position:"Query" name:"TransitRouteTableAggregationCidr"`
}

// CreateTransitRouteTableAggregationResponse is the response struct for api CreateTransitRouteTableAggregation
type CreateTransitRouteTableAggregationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTransitRouteTableAggregationRequest creates a request to invoke CreateTransitRouteTableAggregation API
func CreateCreateTransitRouteTableAggregationRequest() (request *CreateTransitRouteTableAggregationRequest) {
	request = &CreateTransitRouteTableAggregationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateTransitRouteTableAggregation", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTransitRouteTableAggregationResponse creates a response to parse from CreateTransitRouteTableAggregation response
func CreateCreateTransitRouteTableAggregationResponse() (response *CreateTransitRouteTableAggregationResponse) {
	response = &CreateTransitRouteTableAggregationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
