package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateTransitRouterAttachmentWithRouteTable invokes the cbn.AssociateTransitRouterAttachmentWithRouteTable API synchronously
func (client *Client) AssociateTransitRouterAttachmentWithRouteTable(request *AssociateTransitRouterAttachmentWithRouteTableRequest) (response *AssociateTransitRouterAttachmentWithRouteTableResponse, err error) {
	response = CreateAssociateTransitRouterAttachmentWithRouteTableResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateTransitRouterAttachmentWithRouteTableWithChan invokes the cbn.AssociateTransitRouterAttachmentWithRouteTable API asynchronously
func (client *Client) AssociateTransitRouterAttachmentWithRouteTableWithChan(request *AssociateTransitRouterAttachmentWithRouteTableRequest) (<-chan *AssociateTransitRouterAttachmentWithRouteTableResponse, <-chan error) {
	responseChan := make(chan *AssociateTransitRouterAttachmentWithRouteTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateTransitRouterAttachmentWithRouteTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateTransitRouterAttachmentWithRouteTableWithCallback invokes the cbn.AssociateTransitRouterAttachmentWithRouteTable API asynchronously
func (client *Client) AssociateTransitRouterAttachmentWithRouteTableWithCallback(request *AssociateTransitRouterAttachmentWithRouteTableRequest, callback func(response *AssociateTransitRouterAttachmentWithRouteTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateTransitRouterAttachmentWithRouteTableResponse
		var err error
		defer close(result)
		response, err = client.AssociateTransitRouterAttachmentWithRouteTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateTransitRouterAttachmentWithRouteTableRequest is the request struct for api AssociateTransitRouterAttachmentWithRouteTable
type AssociateTransitRouterAttachmentWithRouteTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken               string           `position:"Query" name:"ClientToken"`
	TransitRouterRouteTableId string           `position:"Query" name:"TransitRouterRouteTableId"`
	DryRun                    requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	Version                   string           `position:"Query" name:"Version"`
	TransitRouterAttachmentId string           `position:"Query" name:"TransitRouterAttachmentId"`
}

// AssociateTransitRouterAttachmentWithRouteTableResponse is the response struct for api AssociateTransitRouterAttachmentWithRouteTable
type AssociateTransitRouterAttachmentWithRouteTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociateTransitRouterAttachmentWithRouteTableRequest creates a request to invoke AssociateTransitRouterAttachmentWithRouteTable API
func CreateAssociateTransitRouterAttachmentWithRouteTableRequest() (request *AssociateTransitRouterAttachmentWithRouteTableRequest) {
	request = &AssociateTransitRouterAttachmentWithRouteTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "AssociateTransitRouterAttachmentWithRouteTable", "", "")
	request.Method = requests.POST
	return
}

// CreateAssociateTransitRouterAttachmentWithRouteTableResponse creates a response to parse from AssociateTransitRouterAttachmentWithRouteTable response
func CreateAssociateTransitRouterAttachmentWithRouteTableResponse() (response *AssociateTransitRouterAttachmentWithRouteTableResponse) {
	response = &AssociateTransitRouterAttachmentWithRouteTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
