package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterDashboard invokes the cassandra.DescribeClusterDashboard API synchronously
func (client *Client) DescribeClusterDashboard(request *DescribeClusterDashboardRequest) (response *DescribeClusterDashboardResponse, err error) {
	response = CreateDescribeClusterDashboardResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterDashboardWithChan invokes the cassandra.DescribeClusterDashboard API asynchronously
func (client *Client) DescribeClusterDashboardWithChan(request *DescribeClusterDashboardRequest) (<-chan *DescribeClusterDashboardResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterDashboardResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterDashboard(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterDashboardWithCallback invokes the cassandra.DescribeClusterDashboard API asynchronously
func (client *Client) DescribeClusterDashboardWithCallback(request *DescribeClusterDashboardRequest, callback func(response *DescribeClusterDashboardResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterDashboardResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterDashboard(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterDashboardRequest is the request struct for api DescribeClusterDashboard
type DescribeClusterDashboardRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeClusterDashboardResponse is the response struct for api DescribeClusterDashboard
type DescribeClusterDashboardResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Dashboard Dashboard `json:"Dashboard" xml:"Dashboard"`
}

// CreateDescribeClusterDashboardRequest creates a request to invoke DescribeClusterDashboard API
func CreateDescribeClusterDashboardRequest() (request *DescribeClusterDashboardRequest) {
	request = &DescribeClusterDashboardRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DescribeClusterDashboard", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterDashboardResponse creates a response to parse from DescribeClusterDashboard response
func CreateDescribeClusterDashboardResponse() (response *DescribeClusterDashboardResponse) {
	response = &DescribeClusterDashboardResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
