package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePCACert invokes the cas.DeletePCACert API synchronously
func (client *Client) DeletePCACert(request *DeletePCACertRequest) (response *DeletePCACertResponse, err error) {
	response = CreateDeletePCACertResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePCACertWithChan invokes the cas.DeletePCACert API asynchronously
func (client *Client) DeletePCACertWithChan(request *DeletePCACertRequest) (<-chan *DeletePCACertResponse, <-chan error) {
	responseChan := make(chan *DeletePCACertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePCACert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePCACertWithCallback invokes the cas.DeletePCACert API asynchronously
func (client *Client) DeletePCACertWithCallback(request *DeletePCACertRequest, callback func(response *DeletePCACertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePCACertResponse
		var err error
		defer close(result)
		response, err = client.DeletePCACert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePCACertRequest is the request struct for api DeletePCACert
type DeletePCACertRequest struct {
	*requests.RpcRequest
	Identifier string `position:"Query" name:"Identifier"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// DeletePCACertResponse is the response struct for api DeletePCACert
type DeletePCACertResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePCACertRequest creates a request to invoke DeletePCACert API
func CreateDeletePCACertRequest() (request *DeletePCACertRequest) {
	request = &DeletePCACertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "DeletePCACert", "", "")
	request.Method = requests.POST
	return
}

// CreateDeletePCACertResponse creates a response to parse from DeletePCACert response
func CreateDeletePCACertResponse() (response *DeletePCACertResponse) {
	response = &DeletePCACertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
