package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListActivatedAlerts invokes the arms.ListActivatedAlerts API synchronously
func (client *Client) ListActivatedAlerts(request *ListActivatedAlertsRequest) (response *ListActivatedAlertsResponse, err error) {
	response = CreateListActivatedAlertsResponse()
	err = client.DoAction(request, response)
	return
}

// ListActivatedAlertsWithChan invokes the arms.ListActivatedAlerts API asynchronously
func (client *Client) ListActivatedAlertsWithChan(request *ListActivatedAlertsRequest) (<-chan *ListActivatedAlertsResponse, <-chan error) {
	responseChan := make(chan *ListActivatedAlertsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListActivatedAlerts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListActivatedAlertsWithCallback invokes the arms.ListActivatedAlerts API asynchronously
func (client *Client) ListActivatedAlertsWithCallback(request *ListActivatedAlertsRequest, callback func(response *ListActivatedAlertsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListActivatedAlertsResponse
		var err error
		defer close(result)
		response, err = client.ListActivatedAlerts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListActivatedAlertsRequest is the request struct for api ListActivatedAlerts
type ListActivatedAlertsRequest struct {
	*requests.RpcRequest
	Filter      string           `position:"Query" name:"Filter"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	ProxyUserId string           `position:"Query" name:"ProxyUserId"`
}

// ListActivatedAlertsResponse is the response struct for api ListActivatedAlerts
type ListActivatedAlertsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Page      Page   `json:"Page" xml:"Page"`
}

// CreateListActivatedAlertsRequest creates a request to invoke ListActivatedAlerts API
func CreateListActivatedAlertsRequest() (request *ListActivatedAlertsRequest) {
	request = &ListActivatedAlertsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListActivatedAlerts", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListActivatedAlertsResponse creates a response to parse from ListActivatedAlerts response
func CreateListActivatedAlertsResponse() (response *ListActivatedAlertsResponse) {
	response = &ListActivatedAlertsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
