package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIntegrationState invokes the arms.GetIntegrationState API synchronously
func (client *Client) GetIntegrationState(request *GetIntegrationStateRequest) (response *GetIntegrationStateResponse, err error) {
	response = CreateGetIntegrationStateResponse()
	err = client.DoAction(request, response)
	return
}

// GetIntegrationStateWithChan invokes the arms.GetIntegrationState API asynchronously
func (client *Client) GetIntegrationStateWithChan(request *GetIntegrationStateRequest) (<-chan *GetIntegrationStateResponse, <-chan error) {
	responseChan := make(chan *GetIntegrationStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIntegrationState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIntegrationStateWithCallback invokes the arms.GetIntegrationState API asynchronously
func (client *Client) GetIntegrationStateWithCallback(request *GetIntegrationStateRequest, callback func(response *GetIntegrationStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIntegrationStateResponse
		var err error
		defer close(result)
		response, err = client.GetIntegrationState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIntegrationStateRequest is the request struct for api GetIntegrationState
type GetIntegrationStateRequest struct {
	*requests.RpcRequest
	Integration string `position:"Query" name:"Integration"`
	ClusterId   string `position:"Query" name:"ClusterId"`
}

// GetIntegrationStateResponse is the response struct for api GetIntegrationState
type GetIntegrationStateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	State     bool   `json:"State" xml:"State"`
}

// CreateGetIntegrationStateRequest creates a request to invoke GetIntegrationState API
func CreateGetIntegrationStateRequest() (request *GetIntegrationStateRequest) {
	request = &GetIntegrationStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetIntegrationState", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetIntegrationStateResponse creates a response to parse from GetIntegrationState response
func CreateGetIntegrationStateResponse() (response *GetIntegrationStateResponse) {
	response = &GetIntegrationStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
