package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePrometheusAlertRule invokes the arms.DescribePrometheusAlertRule API synchronously
func (client *Client) DescribePrometheusAlertRule(request *DescribePrometheusAlertRuleRequest) (response *DescribePrometheusAlertRuleResponse, err error) {
	response = CreateDescribePrometheusAlertRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePrometheusAlertRuleWithChan invokes the arms.DescribePrometheusAlertRule API asynchronously
func (client *Client) DescribePrometheusAlertRuleWithChan(request *DescribePrometheusAlertRuleRequest) (<-chan *DescribePrometheusAlertRuleResponse, <-chan error) {
	responseChan := make(chan *DescribePrometheusAlertRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePrometheusAlertRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePrometheusAlertRuleWithCallback invokes the arms.DescribePrometheusAlertRule API asynchronously
func (client *Client) DescribePrometheusAlertRuleWithCallback(request *DescribePrometheusAlertRuleRequest, callback func(response *DescribePrometheusAlertRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePrometheusAlertRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribePrometheusAlertRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePrometheusAlertRuleRequest is the request struct for api DescribePrometheusAlertRule
type DescribePrometheusAlertRuleRequest struct {
	*requests.RpcRequest
	AlertId requests.Integer `position:"Query" name:"AlertId"`
}

// DescribePrometheusAlertRuleResponse is the response struct for api DescribePrometheusAlertRule
type DescribePrometheusAlertRuleResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	PrometheusAlertRule PrometheusAlertRule `json:"PrometheusAlertRule" xml:"PrometheusAlertRule"`
}

// CreateDescribePrometheusAlertRuleRequest creates a request to invoke DescribePrometheusAlertRule API
func CreateDescribePrometheusAlertRuleRequest() (request *DescribePrometheusAlertRuleRequest) {
	request = &DescribePrometheusAlertRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DescribePrometheusAlertRule", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePrometheusAlertRuleResponse creates a response to parse from DescribePrometheusAlertRule response
func CreateDescribePrometheusAlertRuleResponse() (response *DescribePrometheusAlertRuleResponse) {
	response = &DescribePrometheusAlertRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
