package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPrometheusGlobalViewByAliClusterIds invokes the arms.AddPrometheusGlobalViewByAliClusterIds API synchronously
func (client *Client) AddPrometheusGlobalViewByAliClusterIds(request *AddPrometheusGlobalViewByAliClusterIdsRequest) (response *AddPrometheusGlobalViewByAliClusterIdsResponse, err error) {
	response = CreateAddPrometheusGlobalViewByAliClusterIdsResponse()
	err = client.DoAction(request, response)
	return
}

// AddPrometheusGlobalViewByAliClusterIdsWithChan invokes the arms.AddPrometheusGlobalViewByAliClusterIds API asynchronously
func (client *Client) AddPrometheusGlobalViewByAliClusterIdsWithChan(request *AddPrometheusGlobalViewByAliClusterIdsRequest) (<-chan *AddPrometheusGlobalViewByAliClusterIdsResponse, <-chan error) {
	responseChan := make(chan *AddPrometheusGlobalViewByAliClusterIdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPrometheusGlobalViewByAliClusterIds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPrometheusGlobalViewByAliClusterIdsWithCallback invokes the arms.AddPrometheusGlobalViewByAliClusterIds API asynchronously
func (client *Client) AddPrometheusGlobalViewByAliClusterIdsWithCallback(request *AddPrometheusGlobalViewByAliClusterIdsRequest, callback func(response *AddPrometheusGlobalViewByAliClusterIdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPrometheusGlobalViewByAliClusterIdsResponse
		var err error
		defer close(result)
		response, err = client.AddPrometheusGlobalViewByAliClusterIds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPrometheusGlobalViewByAliClusterIdsRequest is the request struct for api AddPrometheusGlobalViewByAliClusterIds
type AddPrometheusGlobalViewByAliClusterIdsRequest struct {
	*requests.RpcRequest
	ProductCode string `position:"Query" name:"ProductCode"`
	ClusterIds  string `position:"Query" name:"ClusterIds"`
	GroupName   string `position:"Query" name:"GroupName"`
}

// AddPrometheusGlobalViewByAliClusterIdsResponse is the response struct for api AddPrometheusGlobalViewByAliClusterIds
type AddPrometheusGlobalViewByAliClusterIdsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddPrometheusGlobalViewByAliClusterIdsRequest creates a request to invoke AddPrometheusGlobalViewByAliClusterIds API
func CreateAddPrometheusGlobalViewByAliClusterIdsRequest() (request *AddPrometheusGlobalViewByAliClusterIdsRequest) {
	request = &AddPrometheusGlobalViewByAliClusterIdsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "AddPrometheusGlobalViewByAliClusterIds", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddPrometheusGlobalViewByAliClusterIdsResponse creates a response to parse from AddPrometheusGlobalViewByAliClusterIds response
func CreateAddPrometheusGlobalViewByAliClusterIdsResponse() (response *AddPrometheusGlobalViewByAliClusterIdsResponse) {
	response = &AddPrometheusGlobalViewByAliClusterIdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
