package antiddos_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDdosThreshold invokes the antiddos_public.DescribeDdosThreshold API synchronously
func (client *Client) DescribeDdosThreshold(request *DescribeDdosThresholdRequest) (response *DescribeDdosThresholdResponse, err error) {
	response = CreateDescribeDdosThresholdResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDdosThresholdWithChan invokes the antiddos_public.DescribeDdosThreshold API asynchronously
func (client *Client) DescribeDdosThresholdWithChan(request *DescribeDdosThresholdRequest) (<-chan *DescribeDdosThresholdResponse, <-chan error) {
	responseChan := make(chan *DescribeDdosThresholdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDdosThreshold(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDdosThresholdWithCallback invokes the antiddos_public.DescribeDdosThreshold API asynchronously
func (client *Client) DescribeDdosThresholdWithCallback(request *DescribeDdosThresholdRequest, callback func(response *DescribeDdosThresholdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDdosThresholdResponse
		var err error
		defer close(result)
		response, err = client.DescribeDdosThreshold(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDdosThresholdRequest is the request struct for api DescribeDdosThreshold
type DescribeDdosThresholdRequest struct {
	*requests.RpcRequest
	DdosType     string    `position:"Query" name:"DdosType"`
	SourceIp     string    `position:"Query" name:"SourceIp"`
	DdosRegionId string    `position:"Query" name:"DdosRegionId"`
	InstanceType string    `position:"Query" name:"InstanceType"`
	Lang         string    `position:"Query" name:"Lang"`
	InstanceIds  *[]string `position:"Query" name:"InstanceIds"  type:"Repeated"`
}

// DescribeDdosThresholdResponse is the response struct for api DescribeDdosThreshold
type DescribeDdosThresholdResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Thresholds Thresholds `json:"Thresholds" xml:"Thresholds"`
}

// CreateDescribeDdosThresholdRequest creates a request to invoke DescribeDdosThreshold API
func CreateDescribeDdosThresholdRequest() (request *DescribeDdosThresholdRequest) {
	request = &DescribeDdosThresholdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("antiddos-public", "2017-05-18", "DescribeDdosThreshold", "ddosbasic", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDdosThresholdResponse creates a response to parse from DescribeDdosThreshold response
func CreateDescribeDdosThresholdResponse() (response *DescribeDdosThresholdResponse) {
	response = &DescribeDdosThresholdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
