package alikafka

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConsumerList invokes the alikafka.GetConsumerList API synchronously
func (client *Client) GetConsumerList(request *GetConsumerListRequest) (response *GetConsumerListResponse, err error) {
	response = CreateGetConsumerListResponse()
	err = client.DoAction(request, response)
	return
}

// GetConsumerListWithChan invokes the alikafka.GetConsumerList API asynchronously
func (client *Client) GetConsumerListWithChan(request *GetConsumerListRequest) (<-chan *GetConsumerListResponse, <-chan error) {
	responseChan := make(chan *GetConsumerListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConsumerList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConsumerListWithCallback invokes the alikafka.GetConsumerList API asynchronously
func (client *Client) GetConsumerListWithCallback(request *GetConsumerListRequest, callback func(response *GetConsumerListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConsumerListResponse
		var err error
		defer close(result)
		response, err = client.GetConsumerList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConsumerListRequest is the request struct for api GetConsumerList
type GetConsumerListRequest struct {
	*requests.RpcRequest
	ConsumerId  string           `position:"Query" name:"ConsumerId"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// GetConsumerListResponse is the response struct for api GetConsumerList
type GetConsumerListResponse struct {
	*responses.BaseResponse
	Code         int          `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	ConsumerList ConsumerList `json:"ConsumerList" xml:"ConsumerList"`
}

// CreateGetConsumerListRequest creates a request to invoke GetConsumerList API
func CreateGetConsumerListRequest() (request *GetConsumerListRequest) {
	request = &GetConsumerListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alikafka", "2019-09-16", "GetConsumerList", "alikafka", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetConsumerListResponse creates a response to parse from GetConsumerList response
func CreateGetConsumerListResponse() (response *GetConsumerListResponse) {
	response = &GetConsumerListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
