package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRulesAttribute invokes the alb.UpdateRulesAttribute API synchronously
func (client *Client) UpdateRulesAttribute(request *UpdateRulesAttributeRequest) (response *UpdateRulesAttributeResponse, err error) {
	response = CreateUpdateRulesAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRulesAttributeWithChan invokes the alb.UpdateRulesAttribute API asynchronously
func (client *Client) UpdateRulesAttributeWithChan(request *UpdateRulesAttributeRequest) (<-chan *UpdateRulesAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateRulesAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRulesAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRulesAttributeWithCallback invokes the alb.UpdateRulesAttribute API asynchronously
func (client *Client) UpdateRulesAttributeWithCallback(request *UpdateRulesAttributeRequest, callback func(response *UpdateRulesAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRulesAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateRulesAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRulesAttributeRequest is the request struct for api UpdateRulesAttribute
type UpdateRulesAttributeRequest struct {
	*requests.RpcRequest
	ClientToken string                       `position:"Query" name:"ClientToken"`
	Rules       *[]UpdateRulesAttributeRules `position:"Query" name:"Rules"  type:"Repeated"`
	DryRun      requests.Boolean             `position:"Query" name:"DryRun"`
}

// UpdateRulesAttributeRules is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRules struct {
	RuleConditions *[]UpdateRulesAttributeRulesRuleConditionsItem `name:"RuleConditions" type:"Repeated"`
	RuleName       string                                         `name:"RuleName"`
	Priority       string                                         `name:"Priority"`
	RuleId         string                                         `name:"RuleId"`
	RuleActions    *[]UpdateRulesAttributeRulesRuleActionsItem    `name:"RuleActions" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleConditionsItem is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItem struct {
	MethodConfig             UpdateRulesAttributeRulesRuleConditionsItemMethodConfig             `name:"MethodConfig" type:"Struct"`
	SourceIpConfig           UpdateRulesAttributeRulesRuleConditionsItemSourceIpConfig           `name:"SourceIpConfig" type:"Struct"`
	HostConfig               UpdateRulesAttributeRulesRuleConditionsItemHostConfig               `name:"HostConfig" type:"Struct"`
	QueryStringConfig        UpdateRulesAttributeRulesRuleConditionsItemQueryStringConfig        `name:"QueryStringConfig" type:"Struct"`
	ResponseStatusCodeConfig UpdateRulesAttributeRulesRuleConditionsItemResponseStatusCodeConfig `name:"ResponseStatusCodeConfig" type:"Struct"`
	PathConfig               UpdateRulesAttributeRulesRuleConditionsItemPathConfig               `name:"PathConfig" type:"Struct"`
	CookieConfig             UpdateRulesAttributeRulesRuleConditionsItemCookieConfig             `name:"CookieConfig" type:"Struct"`
	Type                     string                                                              `name:"Type"`
	HeaderConfig             UpdateRulesAttributeRulesRuleConditionsItemHeaderConfig             `name:"HeaderConfig" type:"Struct"`
	ResponseHeaderConfig     UpdateRulesAttributeRulesRuleConditionsItemResponseHeaderConfig     `name:"ResponseHeaderConfig" type:"Struct"`
}

// UpdateRulesAttributeRulesRuleActionsItem is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItem struct {
	FixedResponseConfig UpdateRulesAttributeRulesRuleActionsItemFixedResponseConfig `name:"FixedResponseConfig" type:"Struct"`
	TrafficMirrorConfig UpdateRulesAttributeRulesRuleActionsItemTrafficMirrorConfig `name:"TrafficMirrorConfig" type:"Struct"`
	ForwardGroupConfig  UpdateRulesAttributeRulesRuleActionsItemForwardGroupConfig  `name:"ForwardGroupConfig" type:"Struct"`
	RemoveHeaderConfig  UpdateRulesAttributeRulesRuleActionsItemRemoveHeaderConfig  `name:"RemoveHeaderConfig" type:"Struct"`
	InsertHeaderConfig  UpdateRulesAttributeRulesRuleActionsItemInsertHeaderConfig  `name:"InsertHeaderConfig" type:"Struct"`
	TrafficLimitConfig  UpdateRulesAttributeRulesRuleActionsItemTrafficLimitConfig  `name:"TrafficLimitConfig" type:"Struct"`
	CorsConfig          UpdateRulesAttributeRulesRuleActionsItemCorsConfig          `name:"CorsConfig" type:"Struct"`
	RedirectConfig      UpdateRulesAttributeRulesRuleActionsItemRedirectConfig      `name:"RedirectConfig" type:"Struct"`
	Type                string                                                      `name:"Type"`
	Order               string                                                      `name:"Order"`
	RewriteConfig       UpdateRulesAttributeRulesRuleActionsItemRewriteConfig       `name:"RewriteConfig" type:"Struct"`
}

// UpdateRulesAttributeRulesRuleConditionsItemMethodConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemMethodConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleConditionsItemSourceIpConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemSourceIpConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleConditionsItemHostConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemHostConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleConditionsItemQueryStringConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemQueryStringConfig struct {
	Values *[]UpdateRulesAttributeRulesRuleConditionsItemQueryStringConfigValuesItem `name:"Values" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleConditionsItemResponseStatusCodeConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemResponseStatusCodeConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleConditionsItemPathConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemPathConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleConditionsItemCookieConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemCookieConfig struct {
	Values *[]UpdateRulesAttributeRulesRuleConditionsItemCookieConfigValuesItem `name:"Values" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleConditionsItemHeaderConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemHeaderConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
	Key    string    `name:"Key"`
}

// UpdateRulesAttributeRulesRuleConditionsItemResponseHeaderConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemResponseHeaderConfig struct {
	Values *[]string `name:"Values" type:"Repeated"`
	Key    string    `name:"Key"`
}

// UpdateRulesAttributeRulesRuleActionsItemFixedResponseConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemFixedResponseConfig struct {
	HttpCode    string `name:"HttpCode"`
	Content     string `name:"Content"`
	ContentType string `name:"ContentType"`
}

// UpdateRulesAttributeRulesRuleActionsItemTrafficMirrorConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemTrafficMirrorConfig struct {
	MirrorGroupConfig UpdateRulesAttributeRulesRuleActionsItemTrafficMirrorConfigMirrorGroupConfig `name:"MirrorGroupConfig" type:"Struct"`
	TargetType        string                                                                       `name:"TargetType"`
}

// UpdateRulesAttributeRulesRuleActionsItemForwardGroupConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemForwardGroupConfig struct {
	ServerGroupStickySession UpdateRulesAttributeRulesRuleActionsItemForwardGroupConfigServerGroupStickySession `name:"ServerGroupStickySession" type:"Struct"`
	ServerGroupTuples        *[]UpdateRulesAttributeRulesRuleActionsItemForwardGroupConfigServerGroupTuplesItem `name:"ServerGroupTuples" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleActionsItemRemoveHeaderConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemRemoveHeaderConfig struct {
	Key string `name:"Key"`
}

// UpdateRulesAttributeRulesRuleActionsItemInsertHeaderConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemInsertHeaderConfig struct {
	ValueType    string `name:"ValueType"`
	CoverEnabled string `name:"CoverEnabled"`
	Value        string `name:"Value"`
	Key          string `name:"Key"`
}

// UpdateRulesAttributeRulesRuleActionsItemTrafficLimitConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemTrafficLimitConfig struct {
	QPS      string `name:"QPS"`
	PerIpQps string `name:"PerIpQps"`
}

// UpdateRulesAttributeRulesRuleActionsItemCorsConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemCorsConfig struct {
	AllowCredentials string    `name:"AllowCredentials"`
	AllowOrigin      *[]string `name:"AllowOrigin" type:"Repeated"`
	MaxAge           string    `name:"MaxAge"`
	AllowMethods     *[]string `name:"AllowMethods" type:"Repeated"`
	AllowHeaders     *[]string `name:"AllowHeaders" type:"Repeated"`
	ExposeHeaders    *[]string `name:"ExposeHeaders" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleActionsItemRedirectConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemRedirectConfig struct {
	Path     string `name:"Path"`
	Protocol string `name:"Protocol"`
	Port     string `name:"Port"`
	Query    string `name:"Query"`
	Host     string `name:"Host"`
	HttpCode string `name:"HttpCode"`
}

// UpdateRulesAttributeRulesRuleActionsItemRewriteConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemRewriteConfig struct {
	Path  string `name:"Path"`
	Query string `name:"Query"`
	Host  string `name:"Host"`
}

// UpdateRulesAttributeRulesRuleConditionsItemQueryStringConfigValuesItem is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemQueryStringConfigValuesItem struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// UpdateRulesAttributeRulesRuleConditionsItemCookieConfigValuesItem is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleConditionsItemCookieConfigValuesItem struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// UpdateRulesAttributeRulesRuleActionsItemTrafficMirrorConfigMirrorGroupConfig is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemTrafficMirrorConfigMirrorGroupConfig struct {
	ServerGroupTuples *[]UpdateRulesAttributeRulesRuleActionsItemTrafficMirrorConfigMirrorGroupConfigServerGroupTuplesItem `name:"ServerGroupTuples" type:"Repeated"`
}

// UpdateRulesAttributeRulesRuleActionsItemForwardGroupConfigServerGroupStickySession is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemForwardGroupConfigServerGroupStickySession struct {
	Enabled string `name:"Enabled"`
	Timeout string `name:"Timeout"`
}

// UpdateRulesAttributeRulesRuleActionsItemForwardGroupConfigServerGroupTuplesItem is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemForwardGroupConfigServerGroupTuplesItem struct {
	ServerGroupId string `name:"ServerGroupId"`
	Weight        string `name:"Weight"`
}

// UpdateRulesAttributeRulesRuleActionsItemTrafficMirrorConfigMirrorGroupConfigServerGroupTuplesItem is a repeated param struct in UpdateRulesAttributeRequest
type UpdateRulesAttributeRulesRuleActionsItemTrafficMirrorConfigMirrorGroupConfigServerGroupTuplesItem struct {
	ServerGroupId string `name:"ServerGroupId"`
}

// UpdateRulesAttributeResponse is the response struct for api UpdateRulesAttribute
type UpdateRulesAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateUpdateRulesAttributeRequest creates a request to invoke UpdateRulesAttribute API
func CreateUpdateRulesAttributeRequest() (request *UpdateRulesAttributeRequest) {
	request = &UpdateRulesAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "UpdateRulesAttribute", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateRulesAttributeResponse creates a response to parse from UpdateRulesAttribute response
func CreateUpdateRulesAttributeResponse() (response *UpdateRulesAttributeResponse) {
	response = &UpdateRulesAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
