package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateListenerLogConfig invokes the alb.UpdateListenerLogConfig API synchronously
func (client *Client) UpdateListenerLogConfig(request *UpdateListenerLogConfigRequest) (response *UpdateListenerLogConfigResponse, err error) {
	response = CreateUpdateListenerLogConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateListenerLogConfigWithChan invokes the alb.UpdateListenerLogConfig API asynchronously
func (client *Client) UpdateListenerLogConfigWithChan(request *UpdateListenerLogConfigRequest) (<-chan *UpdateListenerLogConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateListenerLogConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateListenerLogConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateListenerLogConfigWithCallback invokes the alb.UpdateListenerLogConfig API asynchronously
func (client *Client) UpdateListenerLogConfigWithCallback(request *UpdateListenerLogConfigRequest, callback func(response *UpdateListenerLogConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateListenerLogConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateListenerLogConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateListenerLogConfigRequest is the request struct for api UpdateListenerLogConfig
type UpdateListenerLogConfigRequest struct {
	*requests.RpcRequest
	ClientToken                             string                                        `position:"Query" name:"ClientToken"`
	ListenerId                              string                                        `position:"Query" name:"ListenerId"`
	AccessLogRecordCustomizedHeadersEnabled requests.Boolean                              `position:"Query" name:"AccessLogRecordCustomizedHeadersEnabled"`
	DryRun                                  requests.Boolean                              `position:"Query" name:"DryRun"`
	AccessLogTracingConfig                  UpdateListenerLogConfigAccessLogTracingConfig `position:"Query" name:"AccessLogTracingConfig"  type:"Struct"`
}

// UpdateListenerLogConfigAccessLogTracingConfig is a repeated param struct in UpdateListenerLogConfigRequest
type UpdateListenerLogConfigAccessLogTracingConfig struct {
	TracingType    string `name:"TracingType"`
	TracingEnabled string `name:"TracingEnabled"`
	TracingSample  string `name:"TracingSample"`
}

// UpdateListenerLogConfigResponse is the response struct for api UpdateListenerLogConfig
type UpdateListenerLogConfigResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateListenerLogConfigRequest creates a request to invoke UpdateListenerLogConfig API
func CreateUpdateListenerLogConfigRequest() (request *UpdateListenerLogConfigRequest) {
	request = &UpdateListenerLogConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "UpdateListenerLogConfig", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateListenerLogConfigResponse creates a response to parse from UpdateListenerLogConfig response
func CreateUpdateListenerLogConfigResponse() (response *UpdateListenerLogConfigResponse) {
	response = &UpdateListenerLogConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
