package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnosisRecords invokes the adb.DescribeDiagnosisRecords API synchronously
func (client *Client) DescribeDiagnosisRecords(request *DescribeDiagnosisRecordsRequest) (response *DescribeDiagnosisRecordsResponse, err error) {
	response = CreateDescribeDiagnosisRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnosisRecordsWithChan invokes the adb.DescribeDiagnosisRecords API asynchronously
func (client *Client) DescribeDiagnosisRecordsWithChan(request *DescribeDiagnosisRecordsRequest) (<-chan *DescribeDiagnosisRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnosisRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnosisRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnosisRecordsWithCallback invokes the adb.DescribeDiagnosisRecords API asynchronously
func (client *Client) DescribeDiagnosisRecordsWithCallback(request *DescribeDiagnosisRecordsRequest, callback func(response *DescribeDiagnosisRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnosisRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnosisRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnosisRecordsRequest is the request struct for api DescribeDiagnosisRecords
type DescribeDiagnosisRecordsRequest struct {
	*requests.RpcRequest
	QueryCondition string           `position:"Query" name:"QueryCondition"`
	StartTime      string           `position:"Query" name:"StartTime"`
	RawStartTime   string           `position:"Query" name:"RawStartTime"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	RawEndTime     string           `position:"Query" name:"RawEndTime"`
	Database       string           `position:"Query" name:"Database"`
	ClientIp       string           `position:"Query" name:"ClientIp"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Keyword        string           `position:"Query" name:"Keyword"`
	Lang           string           `position:"Query" name:"Lang"`
	Order          string           `position:"Query" name:"Order"`
	MaxScanSize    requests.Integer `position:"Query" name:"MaxScanSize"`
	ResourceGroup  string           `position:"Query" name:"ResourceGroup"`
	DBClusterId    string           `position:"Query" name:"DBClusterId"`
	PatternId      requests.Integer `position:"Query" name:"PatternId"`
	EndTime        string           `position:"Query" name:"EndTime"`
	MinPeakMemory  requests.Integer `position:"Query" name:"MinPeakMemory"`
	MinScanSize    requests.Integer `position:"Query" name:"MinScanSize"`
	MaxPeakMemory  requests.Integer `position:"Query" name:"MaxPeakMemory"`
	UserName       string           `position:"Query" name:"UserName"`
}

// DescribeDiagnosisRecordsResponse is the response struct for api DescribeDiagnosisRecords
type DescribeDiagnosisRecordsResponse struct {
	*responses.BaseResponse
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	Querys     []Items `json:"Querys" xml:"Querys"`
}

// CreateDescribeDiagnosisRecordsRequest creates a request to invoke DescribeDiagnosisRecords API
func CreateDescribeDiagnosisRecordsRequest() (request *DescribeDiagnosisRecordsRequest) {
	request = &DescribeDiagnosisRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDiagnosisRecords", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiagnosisRecordsResponse creates a response to parse from DescribeDiagnosisRecords response
func CreateDescribeDiagnosisRecordsResponse() (response *DescribeDiagnosisRecordsResponse) {
	response = &DescribeDiagnosisRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
