package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterForecast invokes the adb.DescribeDBClusterForecast API synchronously
func (client *Client) DescribeDBClusterForecast(request *DescribeDBClusterForecastRequest) (response *DescribeDBClusterForecastResponse, err error) {
	response = CreateDescribeDBClusterForecastResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterForecastWithChan invokes the adb.DescribeDBClusterForecast API asynchronously
func (client *Client) DescribeDBClusterForecastWithChan(request *DescribeDBClusterForecastRequest) (<-chan *DescribeDBClusterForecastResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterForecastResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterForecast(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterForecastWithCallback invokes the adb.DescribeDBClusterForecast API asynchronously
func (client *Client) DescribeDBClusterForecastWithCallback(request *DescribeDBClusterForecastRequest, callback func(response *DescribeDBClusterForecastResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterForecastResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterForecast(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterForecastRequest is the request struct for api DescribeDBClusterForecast
type DescribeDBClusterForecastRequest struct {
	*requests.RpcRequest
	MetricType  string `position:"Query" name:"MetricType"`
	DBClusterId string `position:"Query" name:"DBClusterId"`
	StartTime   string `position:"Query" name:"StartTime"`
}

// DescribeDBClusterForecastResponse is the response struct for api DescribeDBClusterForecast
type DescribeDBClusterForecastResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	Performances []PerformancesItem `json:"Performances" xml:"Performances"`
}

// CreateDescribeDBClusterForecastRequest creates a request to invoke DescribeDBClusterForecast API
func CreateDescribeDBClusterForecastRequest() (request *DescribeDBClusterForecastRequest) {
	request = &DescribeDBClusterForecastRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDBClusterForecast", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterForecastResponse creates a response to parse from DescribeDBClusterForecast response
func CreateDescribeDBClusterForecastResponse() (response *DescribeDBClusterForecastResponse) {
	response = &DescribeDBClusterForecastResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
