package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccessKeyLastUsedIps invokes the actiontrail.GetAccessKeyLastUsedIps API synchronously
func (client *Client) GetAccessKeyLastUsedIps(request *GetAccessKeyLastUsedIpsRequest) (response *GetAccessKeyLastUsedIpsResponse, err error) {
	response = CreateGetAccessKeyLastUsedIpsResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccessKeyLastUsedIpsWithChan invokes the actiontrail.GetAccessKeyLastUsedIps API asynchronously
func (client *Client) GetAccessKeyLastUsedIpsWithChan(request *GetAccessKeyLastUsedIpsRequest) (<-chan *GetAccessKeyLastUsedIpsResponse, <-chan error) {
	responseChan := make(chan *GetAccessKeyLastUsedIpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccessKeyLastUsedIps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccessKeyLastUsedIpsWithCallback invokes the actiontrail.GetAccessKeyLastUsedIps API asynchronously
func (client *Client) GetAccessKeyLastUsedIpsWithCallback(request *GetAccessKeyLastUsedIpsRequest, callback func(response *GetAccessKeyLastUsedIpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccessKeyLastUsedIpsResponse
		var err error
		defer close(result)
		response, err = client.GetAccessKeyLastUsedIps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccessKeyLastUsedIpsRequest is the request struct for api GetAccessKeyLastUsedIps
type GetAccessKeyLastUsedIpsRequest struct {
	*requests.RpcRequest
	AccessKey   string `position:"Query" name:"AccessKey"`
	NextToken   string `position:"Query" name:"NextToken"`
	PageSize    string `position:"Query" name:"PageSize"`
	ServiceName string `position:"Query" name:"ServiceName"`
}

// GetAccessKeyLastUsedIpsResponse is the response struct for api GetAccessKeyLastUsedIps
type GetAccessKeyLastUsedIpsResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	NextToken string    `json:"NextToken" xml:"NextToken"`
	Ips       []IpsItem `json:"Ips" xml:"Ips"`
}

// CreateGetAccessKeyLastUsedIpsRequest creates a request to invoke GetAccessKeyLastUsedIps API
func CreateGetAccessKeyLastUsedIpsRequest() (request *GetAccessKeyLastUsedIpsRequest) {
	request = &GetAccessKeyLastUsedIpsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2020-07-06", "GetAccessKeyLastUsedIps", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAccessKeyLastUsedIpsResponse creates a response to parse from GetAccessKeyLastUsedIps response
func CreateGetAccessKeyLastUsedIpsResponse() (response *GetAccessKeyLastUsedIpsResponse) {
	response = &GetAccessKeyLastUsedIpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
