# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_lacp__lacp_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for LACP
  """
  __slots__ = ('_path_helper', '_extmethods', '__system_priority',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__system_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'config']

  def _get_system_priority(self):
    """
    Getter method for system_priority, mapped from YANG variable /lacp/config/system_priority (uint16)

    YANG Description: Sytem priority used by the node on this LAG interface.
Lower value is higher priority for determining which node
is the controlling system.
    """
    return self.__system_priority
      
  def _set_system_priority(self, v, load=False):
    """
    Setter method for system_priority, mapped from YANG variable /lacp/config/system_priority (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_priority() directly.

    YANG Description: Sytem priority used by the node on this LAG interface.
Lower value is higher priority for determining which node
is the controlling system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_priority must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=True)""",
        })

    self.__system_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_priority(self):
    self.__system_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=True)

  system_priority = __builtin__.property(_get_system_priority, _set_system_priority)


  _pyangbind_elements = OrderedDict([('system_priority', system_priority), ])


class yc_state_openconfig_lacp__lacp_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for LACP
  """
  __slots__ = ('_path_helper', '_extmethods', '__system_priority',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__system_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'state']

  def _get_system_priority(self):
    """
    Getter method for system_priority, mapped from YANG variable /lacp/state/system_priority (uint16)

    YANG Description: Sytem priority used by the node on this LAG interface.
Lower value is higher priority for determining which node
is the controlling system.
    """
    return self.__system_priority
      
  def _set_system_priority(self, v, load=False):
    """
    Setter method for system_priority, mapped from YANG variable /lacp/state/system_priority (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_priority() directly.

    YANG Description: Sytem priority used by the node on this LAG interface.
Lower value is higher priority for determining which node
is the controlling system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_priority must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)""",
        })

    self.__system_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_priority(self):
    self.__system_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)

  system_priority = __builtin__.property(_get_system_priority)


  _pyangbind_elements = OrderedDict([('system_priority', system_priority), ])


class yc_config_openconfig_lacp__lacp_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for each LACP aggregate interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__interval','__lacp_mode','__system_id_mac','__system_priority',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FAST': {}, 'SLOW': {}},), default=six.text_type("SLOW"), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-period-type', is_config=True)
    self.__lacp_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), default=six.text_type("ACTIVE"), is_leaf=True, yang_name="lacp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=True)
    self.__system_id_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=True)
    self.__system_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /lacp/interfaces/interface/config/name (oc-if:base-interface-ref)

    YANG Description: Reference to the interface on which LACP should be
configured.   The type of the target interface must be
ieee8023adLag
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /lacp/interfaces/interface/config/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the interface on which LACP should be
configured.   The type of the target interface must be
ieee8023adLag
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /lacp/interfaces/interface/config/interval (lacp-period-type)

    YANG Description: Set the period between LACP messages -- uses
the lacp-period-type enumeration.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /lacp/interfaces/interface/config/interval (lacp-period-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: Set the period between LACP messages -- uses
the lacp-period-type enumeration.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FAST': {}, 'SLOW': {}},), default=six.text_type("SLOW"), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-period-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with lacp-period-type""",
          'defined-type': "openconfig-lacp:lacp-period-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FAST': {}, 'SLOW': {}},), default=six.text_type("SLOW"), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-period-type', is_config=True)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FAST': {}, 'SLOW': {}},), default=six.text_type("SLOW"), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-period-type', is_config=True)


  def _get_lacp_mode(self):
    """
    Getter method for lacp_mode, mapped from YANG variable /lacp/interfaces/interface/config/lacp_mode (lacp-activity-type)

    YANG Description: ACTIVE is to initiate the transmission of LACP packets.
PASSIVE is to wait for peer to initiate the transmission of
LACP packets.
    """
    return self.__lacp_mode
      
  def _set_lacp_mode(self, v, load=False):
    """
    Setter method for lacp_mode, mapped from YANG variable /lacp/interfaces/interface/config/lacp_mode (lacp-activity-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp_mode() directly.

    YANG Description: ACTIVE is to initiate the transmission of LACP packets.
PASSIVE is to wait for peer to initiate the transmission of
LACP packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), default=six.text_type("ACTIVE"), is_leaf=True, yang_name="lacp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp_mode must be of a type compatible with lacp-activity-type""",
          'defined-type': "openconfig-lacp:lacp-activity-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), default=six.text_type("ACTIVE"), is_leaf=True, yang_name="lacp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=True)""",
        })

    self.__lacp_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp_mode(self):
    self.__lacp_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), default=six.text_type("ACTIVE"), is_leaf=True, yang_name="lacp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=True)


  def _get_system_id_mac(self):
    """
    Getter method for system_id_mac, mapped from YANG variable /lacp/interfaces/interface/config/system_id_mac (oc-yang:mac-address)

    YANG Description: The MAC address portion of the node's System ID. This is
combined with the system priority to construct the 8-octet
system-id
    """
    return self.__system_id_mac
      
  def _set_system_id_mac(self, v, load=False):
    """
    Setter method for system_id_mac, mapped from YANG variable /lacp/interfaces/interface/config/system_id_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_id_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_id_mac() directly.

    YANG Description: The MAC address portion of the node's System ID. This is
combined with the system priority to construct the 8-octet
system-id
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_id_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__system_id_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_id_mac(self):
    self.__system_id_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=True)


  def _get_system_priority(self):
    """
    Getter method for system_priority, mapped from YANG variable /lacp/interfaces/interface/config/system_priority (uint16)

    YANG Description: Sytem priority used by the node on this LAG interface.
Lower value is higher priority for determining which node
is the controlling system.
    """
    return self.__system_priority
      
  def _set_system_priority(self, v, load=False):
    """
    Setter method for system_priority, mapped from YANG variable /lacp/interfaces/interface/config/system_priority (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_priority() directly.

    YANG Description: Sytem priority used by the node on this LAG interface.
Lower value is higher priority for determining which node
is the controlling system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_priority must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=True)""",
        })

    self.__system_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_priority(self):
    self.__system_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  interval = __builtin__.property(_get_interval, _set_interval)
  lacp_mode = __builtin__.property(_get_lacp_mode, _set_lacp_mode)
  system_id_mac = __builtin__.property(_get_system_id_mac, _set_system_id_mac)
  system_priority = __builtin__.property(_get_system_priority, _set_system_priority)


  _pyangbind_elements = OrderedDict([('name', name), ('interval', interval), ('lacp_mode', lacp_mode), ('system_id_mac', system_id_mac), ('system_priority', system_priority), ])


class yc_state_openconfig_lacp__lacp_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each LACP aggregate
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__interval','__lacp_mode','__system_id_mac','__system_priority',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FAST': {}, 'SLOW': {}},), default=six.text_type("SLOW"), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-period-type', is_config=False)
    self.__lacp_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), default=six.text_type("ACTIVE"), is_leaf=True, yang_name="lacp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=False)
    self.__system_id_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)
    self.__system_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'interfaces', 'interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /lacp/interfaces/interface/state/name (oc-if:base-interface-ref)

    YANG Description: Reference to the interface on which LACP should be
configured.   The type of the target interface must be
ieee8023adLag
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /lacp/interfaces/interface/state/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the interface on which LACP should be
configured.   The type of the target interface must be
ieee8023adLag
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /lacp/interfaces/interface/state/interval (lacp-period-type)

    YANG Description: Set the period between LACP messages -- uses
the lacp-period-type enumeration.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /lacp/interfaces/interface/state/interval (lacp-period-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: Set the period between LACP messages -- uses
the lacp-period-type enumeration.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FAST': {}, 'SLOW': {}},), default=six.text_type("SLOW"), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-period-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with lacp-period-type""",
          'defined-type': "openconfig-lacp:lacp-period-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FAST': {}, 'SLOW': {}},), default=six.text_type("SLOW"), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-period-type', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FAST': {}, 'SLOW': {}},), default=six.text_type("SLOW"), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-period-type', is_config=False)


  def _get_lacp_mode(self):
    """
    Getter method for lacp_mode, mapped from YANG variable /lacp/interfaces/interface/state/lacp_mode (lacp-activity-type)

    YANG Description: ACTIVE is to initiate the transmission of LACP packets.
PASSIVE is to wait for peer to initiate the transmission of
LACP packets.
    """
    return self.__lacp_mode
      
  def _set_lacp_mode(self, v, load=False):
    """
    Setter method for lacp_mode, mapped from YANG variable /lacp/interfaces/interface/state/lacp_mode (lacp-activity-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp_mode() directly.

    YANG Description: ACTIVE is to initiate the transmission of LACP packets.
PASSIVE is to wait for peer to initiate the transmission of
LACP packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), default=six.text_type("ACTIVE"), is_leaf=True, yang_name="lacp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp_mode must be of a type compatible with lacp-activity-type""",
          'defined-type': "openconfig-lacp:lacp-activity-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), default=six.text_type("ACTIVE"), is_leaf=True, yang_name="lacp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=False)""",
        })

    self.__lacp_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp_mode(self):
    self.__lacp_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), default=six.text_type("ACTIVE"), is_leaf=True, yang_name="lacp-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=False)


  def _get_system_id_mac(self):
    """
    Getter method for system_id_mac, mapped from YANG variable /lacp/interfaces/interface/state/system_id_mac (oc-yang:mac-address)

    YANG Description: The MAC address portion of the node's System ID. This is
combined with the system priority to construct the 8-octet
system-id
    """
    return self.__system_id_mac
      
  def _set_system_id_mac(self, v, load=False):
    """
    Setter method for system_id_mac, mapped from YANG variable /lacp/interfaces/interface/state/system_id_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_id_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_id_mac() directly.

    YANG Description: The MAC address portion of the node's System ID. This is
combined with the system priority to construct the 8-octet
system-id
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_id_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__system_id_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_id_mac(self):
    self.__system_id_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)


  def _get_system_priority(self):
    """
    Getter method for system_priority, mapped from YANG variable /lacp/interfaces/interface/state/system_priority (uint16)

    YANG Description: Sytem priority used by the node on this LAG interface.
Lower value is higher priority for determining which node
is the controlling system.
    """
    return self.__system_priority
      
  def _set_system_priority(self, v, load=False):
    """
    Setter method for system_priority, mapped from YANG variable /lacp/interfaces/interface/state/system_priority (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_priority() directly.

    YANG Description: Sytem priority used by the node on this LAG interface.
Lower value is higher priority for determining which node
is the controlling system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_priority must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)""",
        })

    self.__system_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_priority(self):
    self.__system_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="system-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)

  name = __builtin__.property(_get_name)
  interval = __builtin__.property(_get_interval)
  lacp_mode = __builtin__.property(_get_lacp_mode)
  system_id_mac = __builtin__.property(_get_system_id_mac)
  system_priority = __builtin__.property(_get_system_priority)


  _pyangbind_elements = OrderedDict([('name', name), ('interval', interval), ('lacp_mode', lacp_mode), ('system_id_mac', system_id_mac), ('system_priority', system_priority), ])


class yc_counters_openconfig_lacp__lacp_interfaces_interface_members_member_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/interfaces/interface/members/member/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: LACP protocol counters
  """
  __slots__ = ('_path_helper', '_extmethods', '__lacp_in_pkts','__lacp_out_pkts','__lacp_rx_errors','__lacp_tx_errors','__lacp_unknown_errors','__lacp_errors','__lacp_timeout_transitions',)

  _yang_name = 'counters'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__lacp_in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    self.__lacp_out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    self.__lacp_rx_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-rx-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    self.__lacp_tx_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-tx-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    self.__lacp_unknown_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-unknown-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    self.__lacp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    self.__lacp_timeout_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-timeout-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'interfaces', 'interface', 'members', 'member', 'state', 'counters']

  def _get_lacp_in_pkts(self):
    """
    Getter method for lacp_in_pkts, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_in_pkts (oc-yang:counter64)

    YANG Description: Number of LACPDUs received
    """
    return self.__lacp_in_pkts
      
  def _set_lacp_in_pkts(self, v, load=False):
    """
    Setter method for lacp_in_pkts, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp_in_pkts() directly.

    YANG Description: Number of LACPDUs received
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp_in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lacp_in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp_in_pkts(self):
    self.__lacp_in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)


  def _get_lacp_out_pkts(self):
    """
    Getter method for lacp_out_pkts, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_out_pkts (oc-yang:counter64)

    YANG Description: Number of LACPDUs transmitted
    """
    return self.__lacp_out_pkts
      
  def _set_lacp_out_pkts(self, v, load=False):
    """
    Setter method for lacp_out_pkts, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp_out_pkts() directly.

    YANG Description: Number of LACPDUs transmitted
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp_out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lacp_out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp_out_pkts(self):
    self.__lacp_out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)


  def _get_lacp_rx_errors(self):
    """
    Getter method for lacp_rx_errors, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_rx_errors (oc-yang:counter64)

    YANG Description: Number of LACPDU receive packet errors
    """
    return self.__lacp_rx_errors
      
  def _set_lacp_rx_errors(self, v, load=False):
    """
    Setter method for lacp_rx_errors, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_rx_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp_rx_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp_rx_errors() directly.

    YANG Description: Number of LACPDU receive packet errors
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-rx-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp_rx_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-rx-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lacp_rx_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp_rx_errors(self):
    self.__lacp_rx_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-rx-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)


  def _get_lacp_tx_errors(self):
    """
    Getter method for lacp_tx_errors, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_tx_errors (oc-yang:counter64)

    YANG Description: Number of LACPDU transmit packet errors
    """
    return self.__lacp_tx_errors
      
  def _set_lacp_tx_errors(self, v, load=False):
    """
    Setter method for lacp_tx_errors, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_tx_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp_tx_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp_tx_errors() directly.

    YANG Description: Number of LACPDU transmit packet errors
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-tx-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp_tx_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-tx-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lacp_tx_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp_tx_errors(self):
    self.__lacp_tx_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-tx-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)


  def _get_lacp_unknown_errors(self):
    """
    Getter method for lacp_unknown_errors, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_unknown_errors (oc-yang:counter64)

    YANG Description: Number of LACPDU unknown packet errors
    """
    return self.__lacp_unknown_errors
      
  def _set_lacp_unknown_errors(self, v, load=False):
    """
    Setter method for lacp_unknown_errors, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_unknown_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp_unknown_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp_unknown_errors() directly.

    YANG Description: Number of LACPDU unknown packet errors
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-unknown-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp_unknown_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-unknown-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lacp_unknown_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp_unknown_errors(self):
    self.__lacp_unknown_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-unknown-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)


  def _get_lacp_errors(self):
    """
    Getter method for lacp_errors, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_errors (oc-yang:counter64)

    YANG Description: Number of LACPDU illegal packet errors
    """
    return self.__lacp_errors
      
  def _set_lacp_errors(self, v, load=False):
    """
    Setter method for lacp_errors, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp_errors() directly.

    YANG Description: Number of LACPDU illegal packet errors
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lacp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp_errors(self):
    self.__lacp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)


  def _get_lacp_timeout_transitions(self):
    """
    Getter method for lacp_timeout_transitions, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_timeout_transitions (oc-yang:counter64)

    YANG Description: Number of times the LACP state has transitioned
with a timeout since the time the device restarted
or the interface was brought up, whichever is most
recent. The last state change of the LACP timeout
is defined as what is reported as the operating state
to the system. The state change is both a timeout
event and when the timeout event is no longer active.
    """
    return self.__lacp_timeout_transitions
      
  def _set_lacp_timeout_transitions(self, v, load=False):
    """
    Setter method for lacp_timeout_transitions, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters/lacp_timeout_transitions (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp_timeout_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp_timeout_transitions() directly.

    YANG Description: Number of times the LACP state has transitioned
with a timeout since the time the device restarted
or the interface was brought up, whichever is most
recent. The last state change of the LACP timeout
is defined as what is reported as the operating state
to the system. The state change is both a timeout
event and when the timeout event is no longer active.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-timeout-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp_timeout_transitions must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-timeout-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lacp_timeout_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp_timeout_transitions(self):
    self.__lacp_timeout_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lacp-timeout-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:counter64', is_config=False)

  lacp_in_pkts = __builtin__.property(_get_lacp_in_pkts)
  lacp_out_pkts = __builtin__.property(_get_lacp_out_pkts)
  lacp_rx_errors = __builtin__.property(_get_lacp_rx_errors)
  lacp_tx_errors = __builtin__.property(_get_lacp_tx_errors)
  lacp_unknown_errors = __builtin__.property(_get_lacp_unknown_errors)
  lacp_errors = __builtin__.property(_get_lacp_errors)
  lacp_timeout_transitions = __builtin__.property(_get_lacp_timeout_transitions)


  _pyangbind_elements = OrderedDict([('lacp_in_pkts', lacp_in_pkts), ('lacp_out_pkts', lacp_out_pkts), ('lacp_rx_errors', lacp_rx_errors), ('lacp_tx_errors', lacp_tx_errors), ('lacp_unknown_errors', lacp_unknown_errors), ('lacp_errors', lacp_errors), ('lacp_timeout_transitions', lacp_timeout_transitions), ])


class yc_state_openconfig_lacp__lacp_interfaces_interface_members_member_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/interfaces/interface/members/member/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for aggregate members
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__activity','__timeout','__synchronization','__aggregatable','__collecting','__distributing','__system_id','__oper_key','__partner_id','__partner_key','__port_num','__partner_port_num','__last_change','__counters',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__activity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), is_leaf=True, yang_name="activity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=False)
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LONG': {}, 'SHORT': {}},), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-timeout-type', is_config=False)
    self.__synchronization = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IN_SYNC': {}, 'OUT_SYNC': {}},), is_leaf=True, yang_name="synchronization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-synchronization-type', is_config=False)
    self.__aggregatable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="aggregatable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)
    self.__collecting = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="collecting", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)
    self.__distributing = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="distributing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)
    self.__system_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)
    self.__oper_key = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="oper-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    self.__partner_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="partner-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)
    self.__partner_key = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="partner-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    self.__port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    self.__partner_port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="partner-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-types:timeticks64', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_lacp__lacp_interfaces_interface_members_member_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'interfaces', 'interface', 'members', 'member', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /lacp/interfaces/interface/members/member/state/interface (oc-if:base-interface-ref)

    YANG Description: Reference to interface member of the LACP aggregate
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /lacp/interfaces/interface/members/member/state/interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to interface member of the LACP aggregate
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_activity(self):
    """
    Getter method for activity, mapped from YANG variable /lacp/interfaces/interface/members/member/state/activity (lacp-activity-type)

    YANG Description: Indicates participant is active or passive
    """
    return self.__activity
      
  def _set_activity(self, v, load=False):
    """
    Setter method for activity, mapped from YANG variable /lacp/interfaces/interface/members/member/state/activity (lacp-activity-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_activity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_activity() directly.

    YANG Description: Indicates participant is active or passive
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), is_leaf=True, yang_name="activity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """activity must be of a type compatible with lacp-activity-type""",
          'defined-type': "openconfig-lacp:lacp-activity-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), is_leaf=True, yang_name="activity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=False)""",
        })

    self.__activity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_activity(self):
    self.__activity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}},), is_leaf=True, yang_name="activity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-activity-type', is_config=False)


  def _get_timeout(self):
    """
    Getter method for timeout, mapped from YANG variable /lacp/interfaces/interface/members/member/state/timeout (lacp-timeout-type)

    YANG Description: The timeout type (short or long) used by the
participant
    """
    return self.__timeout
      
  def _set_timeout(self, v, load=False):
    """
    Setter method for timeout, mapped from YANG variable /lacp/interfaces/interface/members/member/state/timeout (lacp-timeout-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timeout() directly.

    YANG Description: The timeout type (short or long) used by the
participant
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LONG': {}, 'SHORT': {}},), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-timeout-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timeout must be of a type compatible with lacp-timeout-type""",
          'defined-type': "openconfig-lacp:lacp-timeout-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LONG': {}, 'SHORT': {}},), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-timeout-type', is_config=False)""",
        })

    self.__timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timeout(self):
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LONG': {}, 'SHORT': {}},), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-timeout-type', is_config=False)


  def _get_synchronization(self):
    """
    Getter method for synchronization, mapped from YANG variable /lacp/interfaces/interface/members/member/state/synchronization (lacp-synchronization-type)

    YANG Description: Indicates whether the participant is in-sync or
out-of-sync
    """
    return self.__synchronization
      
  def _set_synchronization(self, v, load=False):
    """
    Setter method for synchronization, mapped from YANG variable /lacp/interfaces/interface/members/member/state/synchronization (lacp-synchronization-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_synchronization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_synchronization() directly.

    YANG Description: Indicates whether the participant is in-sync or
out-of-sync
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IN_SYNC': {}, 'OUT_SYNC': {}},), is_leaf=True, yang_name="synchronization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-synchronization-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """synchronization must be of a type compatible with lacp-synchronization-type""",
          'defined-type': "openconfig-lacp:lacp-synchronization-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IN_SYNC': {}, 'OUT_SYNC': {}},), is_leaf=True, yang_name="synchronization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-synchronization-type', is_config=False)""",
        })

    self.__synchronization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_synchronization(self):
    self.__synchronization = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IN_SYNC': {}, 'OUT_SYNC': {}},), is_leaf=True, yang_name="synchronization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='lacp-synchronization-type', is_config=False)


  def _get_aggregatable(self):
    """
    Getter method for aggregatable, mapped from YANG variable /lacp/interfaces/interface/members/member/state/aggregatable (boolean)

    YANG Description: A true value indicates that the participant will allow
the link to be used as part of the aggregate. A false
value indicates the link should be used as an individual
link
    """
    return self.__aggregatable
      
  def _set_aggregatable(self, v, load=False):
    """
    Setter method for aggregatable, mapped from YANG variable /lacp/interfaces/interface/members/member/state/aggregatable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_aggregatable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_aggregatable() directly.

    YANG Description: A true value indicates that the participant will allow
the link to be used as part of the aggregate. A false
value indicates the link should be used as an individual
link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="aggregatable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """aggregatable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="aggregatable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)""",
        })

    self.__aggregatable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_aggregatable(self):
    self.__aggregatable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="aggregatable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)


  def _get_collecting(self):
    """
    Getter method for collecting, mapped from YANG variable /lacp/interfaces/interface/members/member/state/collecting (boolean)

    YANG Description: If true, the participant is collecting incoming frames
on the link, otherwise false
    """
    return self.__collecting
      
  def _set_collecting(self, v, load=False):
    """
    Setter method for collecting, mapped from YANG variable /lacp/interfaces/interface/members/member/state/collecting (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_collecting is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_collecting() directly.

    YANG Description: If true, the participant is collecting incoming frames
on the link, otherwise false
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="collecting", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """collecting must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="collecting", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)""",
        })

    self.__collecting = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_collecting(self):
    self.__collecting = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="collecting", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)


  def _get_distributing(self):
    """
    Getter method for distributing, mapped from YANG variable /lacp/interfaces/interface/members/member/state/distributing (boolean)

    YANG Description: When true, the participant is distributing outgoing
frames; when false, distribution is disabled
    """
    return self.__distributing
      
  def _set_distributing(self, v, load=False):
    """
    Setter method for distributing, mapped from YANG variable /lacp/interfaces/interface/members/member/state/distributing (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_distributing is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_distributing() directly.

    YANG Description: When true, the participant is distributing outgoing
frames; when false, distribution is disabled
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="distributing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """distributing must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="distributing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)""",
        })

    self.__distributing = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_distributing(self):
    self.__distributing = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="distributing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='boolean', is_config=False)


  def _get_system_id(self):
    """
    Getter method for system_id, mapped from YANG variable /lacp/interfaces/interface/members/member/state/system_id (oc-yang:mac-address)

    YANG Description: MAC address that defines the local system ID for the
aggregate interface
    """
    return self.__system_id
      
  def _set_system_id(self, v, load=False):
    """
    Setter method for system_id, mapped from YANG variable /lacp/interfaces/interface/members/member/state/system_id (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_id() directly.

    YANG Description: MAC address that defines the local system ID for the
aggregate interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_id must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__system_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_id(self):
    self.__system_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="system-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)


  def _get_oper_key(self):
    """
    Getter method for oper_key, mapped from YANG variable /lacp/interfaces/interface/members/member/state/oper_key (uint16)

    YANG Description: Current operational value of the key for the aggregate
interface
    """
    return self.__oper_key
      
  def _set_oper_key(self, v, load=False):
    """
    Setter method for oper_key, mapped from YANG variable /lacp/interfaces/interface/members/member/state/oper_key (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_key() directly.

    YANG Description: Current operational value of the key for the aggregate
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="oper-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_key must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="oper-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)""",
        })

    self.__oper_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_key(self):
    self.__oper_key = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="oper-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)


  def _get_partner_id(self):
    """
    Getter method for partner_id, mapped from YANG variable /lacp/interfaces/interface/members/member/state/partner_id (oc-yang:mac-address)

    YANG Description: MAC address representing the protocol partner's interface
system ID
    """
    return self.__partner_id
      
  def _set_partner_id(self, v, load=False):
    """
    Setter method for partner_id, mapped from YANG variable /lacp/interfaces/interface/members/member/state/partner_id (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_partner_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_partner_id() directly.

    YANG Description: MAC address representing the protocol partner's interface
system ID
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="partner-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """partner_id must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="partner-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__partner_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_partner_id(self):
    self.__partner_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="partner-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-yang:mac-address', is_config=False)


  def _get_partner_key(self):
    """
    Getter method for partner_key, mapped from YANG variable /lacp/interfaces/interface/members/member/state/partner_key (uint16)

    YANG Description: Operational value of the protocol partner's key
    """
    return self.__partner_key
      
  def _set_partner_key(self, v, load=False):
    """
    Setter method for partner_key, mapped from YANG variable /lacp/interfaces/interface/members/member/state/partner_key (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_partner_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_partner_key() directly.

    YANG Description: Operational value of the protocol partner's key
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="partner-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """partner_key must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="partner-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)""",
        })

    self.__partner_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_partner_key(self):
    self.__partner_key = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="partner-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)


  def _get_port_num(self):
    """
    Getter method for port_num, mapped from YANG variable /lacp/interfaces/interface/members/member/state/port_num (uint16)

    YANG Description: Port number of the local (actor) aggregation member
    """
    return self.__port_num
      
  def _set_port_num(self, v, load=False):
    """
    Setter method for port_num, mapped from YANG variable /lacp/interfaces/interface/members/member/state/port_num (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_num is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_num() directly.

    YANG Description: Port number of the local (actor) aggregation member
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_num must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)""",
        })

    self.__port_num = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_num(self):
    self.__port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)


  def _get_partner_port_num(self):
    """
    Getter method for partner_port_num, mapped from YANG variable /lacp/interfaces/interface/members/member/state/partner_port_num (uint16)

    YANG Description: Port number of the partner (remote) port for this member
port
    """
    return self.__partner_port_num
      
  def _set_partner_port_num(self, v, load=False):
    """
    Setter method for partner_port_num, mapped from YANG variable /lacp/interfaces/interface/members/member/state/partner_port_num (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_partner_port_num is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_partner_port_num() directly.

    YANG Description: Port number of the partner (remote) port for this member
port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="partner-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """partner_port_num must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="partner-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)""",
        })

    self.__partner_port_num = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_partner_port_num(self):
    self.__partner_port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="partner-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='uint16', is_config=False)


  def _get_last_change(self):
    """
    Getter method for last_change, mapped from YANG variable /lacp/interfaces/interface/members/member/state/last_change (oc-types:timeticks64)

    YANG Description: The timestamp indicates the absolute time of the last state
change of a LACP timeout. The last state change of the LACP
timeout is defined as what is reported as the operating state
to the system. The state change is both a timeout event and
when the timeout event is no longer active. The value is the
timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_change
      
  def _set_last_change(self, v, load=False):
    """
    Setter method for last_change, mapped from YANG variable /lacp/interfaces/interface/members/member/state/last_change (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_change is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_change() directly.

    YANG Description: The timestamp indicates the absolute time of the last state
change of a LACP timeout. The last state change of the LACP
timeout is defined as what is reported as the operating state
to the system. The state change is both a timeout event and
when the timeout event is no longer active. The value is the
timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_change must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_change = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_change(self):
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='oc-types:timeticks64', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters (container)

    YANG Description: LACP protocol counters
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /lacp/interfaces/interface/members/member/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: LACP protocol counters
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_lacp__lacp_interfaces_interface_members_member_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_lacp__lacp_interfaces_interface_members_member_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_lacp__lacp_interfaces_interface_members_member_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=False)

  interface = __builtin__.property(_get_interface)
  activity = __builtin__.property(_get_activity)
  timeout = __builtin__.property(_get_timeout)
  synchronization = __builtin__.property(_get_synchronization)
  aggregatable = __builtin__.property(_get_aggregatable)
  collecting = __builtin__.property(_get_collecting)
  distributing = __builtin__.property(_get_distributing)
  system_id = __builtin__.property(_get_system_id)
  oper_key = __builtin__.property(_get_oper_key)
  partner_id = __builtin__.property(_get_partner_id)
  partner_key = __builtin__.property(_get_partner_key)
  port_num = __builtin__.property(_get_port_num)
  partner_port_num = __builtin__.property(_get_partner_port_num)
  last_change = __builtin__.property(_get_last_change)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('interface', interface), ('activity', activity), ('timeout', timeout), ('synchronization', synchronization), ('aggregatable', aggregatable), ('collecting', collecting), ('distributing', distributing), ('system_id', system_id), ('oper_key', oper_key), ('partner_id', partner_id), ('partner_key', partner_key), ('port_num', port_num), ('partner_port_num', partner_port_num), ('last_change', last_change), ('counters', counters), ])


class yc_member_openconfig_lacp__lacp_interfaces_interface_members_member(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/interfaces/interface/members/member. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of member interfaces and their associated status for
a LACP-controlled aggregate interface.  Member list is not
configurable here -- each interface indicates items
its participation in the LAG.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__state',)

  _yang_name = 'member'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_lacp__lacp_interfaces_interface_members_member_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'interfaces', 'interface', 'members', 'member']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /lacp/interfaces/interface/members/member/interface (leafref)

    YANG Description: Reference to aggregate member interface
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /lacp/interfaces/interface/members/member/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to aggregate member interface
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /lacp/interfaces/interface/members/member/state (container)

    YANG Description: Operational state data for aggregate members
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /lacp/interfaces/interface/members/member/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for aggregate members
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_lacp__lacp_interfaces_interface_members_member_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_lacp__lacp_interfaces_interface_members_member_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_lacp__lacp_interfaces_interface_members_member_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=False)

  interface = __builtin__.property(_get_interface)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('interface', interface), ('state', state), ])


class yc_members_openconfig_lacp__lacp_interfaces_interface_members(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/interfaces/interface/members. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of members interfaces of
the aggregate. This list is considered operational state
only so is labeled config false and has no config container
  """
  __slots__ = ('_path_helper', '_extmethods', '__member',)

  _yang_name = 'members'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__member = YANGDynClass(base=YANGListType("interface",yc_member_openconfig_lacp__lacp_interfaces_interface_members_member, yang_name="member", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface', extensions=None), is_container='list', yang_name="member", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'interfaces', 'interface', 'members']

  def _get_member(self):
    """
    Getter method for member, mapped from YANG variable /lacp/interfaces/interface/members/member (list)

    YANG Description: List of member interfaces and their associated status for
a LACP-controlled aggregate interface.  Member list is not
configurable here -- each interface indicates items
its participation in the LAG.
    """
    return self.__member
      
  def _set_member(self, v, load=False):
    """
    Setter method for member, mapped from YANG variable /lacp/interfaces/interface/members/member (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_member is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_member() directly.

    YANG Description: List of member interfaces and their associated status for
a LACP-controlled aggregate interface.  Member list is not
configurable here -- each interface indicates items
its participation in the LAG.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("interface",yc_member_openconfig_lacp__lacp_interfaces_interface_members_member, yang_name="member", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface', extensions=None), is_container='list', yang_name="member", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """member must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("interface",yc_member_openconfig_lacp__lacp_interfaces_interface_members_member, yang_name="member", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface', extensions=None), is_container='list', yang_name="member", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='list', is_config=False)""",
        })

    self.__member = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_member(self):
    self.__member = YANGDynClass(base=YANGListType("interface",yc_member_openconfig_lacp__lacp_interfaces_interface_members_member, yang_name="member", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='interface', extensions=None), is_container='list', yang_name="member", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='list', is_config=False)

  member = __builtin__.property(_get_member)


  _pyangbind_elements = OrderedDict([('member', member), ])


class yc_interface_openconfig_lacp__lacp_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of aggregate interfaces managed by LACP
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__members',)

  _yang_name = 'interface'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_lacp__lacp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_lacp__lacp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    self.__members = YANGDynClass(base=yc_members_openconfig_lacp__lacp_interfaces_interface_members, is_container='container', yang_name="members", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'interfaces', 'interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /lacp/interfaces/interface/name (leafref)

    YANG Description: Reference to the list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /lacp/interfaces/interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /lacp/interfaces/interface/config (container)

    YANG Description: Configuration data for each LACP aggregate interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /lacp/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for each LACP aggregate interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_lacp__lacp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_lacp__lacp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_lacp__lacp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /lacp/interfaces/interface/state (container)

    YANG Description: Operational state data for each LACP aggregate
interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /lacp/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for each LACP aggregate
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_lacp__lacp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_lacp__lacp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_lacp__lacp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)


  def _get_members(self):
    """
    Getter method for members, mapped from YANG variable /lacp/interfaces/interface/members (container)

    YANG Description: Enclosing container for the list of members interfaces of
the aggregate. This list is considered operational state
only so is labeled config false and has no config container
    """
    return self.__members
      
  def _set_members(self, v, load=False):
    """
    Setter method for members, mapped from YANG variable /lacp/interfaces/interface/members (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_members is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_members() directly.

    YANG Description: Enclosing container for the list of members interfaces of
the aggregate. This list is considered operational state
only so is labeled config false and has no config container
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_members_openconfig_lacp__lacp_interfaces_interface_members, is_container='container', yang_name="members", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """members must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_members_openconfig_lacp__lacp_interfaces_interface_members, is_container='container', yang_name="members", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)""",
        })

    self.__members = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_members(self):
    self.__members = YANGDynClass(base=yc_members_openconfig_lacp__lacp_interfaces_interface_members, is_container='container', yang_name="members", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  members = __builtin__.property(_get_members, _set_members)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('members', members), ])


class yc_interfaces_openconfig_lacp__lacp_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of LACP-enabled
interfaces
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_lacp__lacp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /lacp/interfaces/interface (list)

    YANG Description: List of aggregate interfaces managed by LACP
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /lacp/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of aggregate interfaces managed by LACP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_interface_openconfig_lacp__lacp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_interface_openconfig_lacp__lacp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_lacp__lacp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_lacp_openconfig_lacp__lacp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /lacp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration and operational state data for LACP protocol
operation on the aggregate interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__interfaces',)

  _yang_name = 'lacp'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_lacp__lacp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_lacp__lacp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_lacp__lacp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['lacp']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /lacp/config (container)

    YANG Description: Configuration data for LACP
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /lacp/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for LACP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_lacp__lacp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_lacp__lacp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_lacp__lacp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /lacp/state (container)

    YANG Description: Operational state data for LACP
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /lacp/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for LACP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_lacp__lacp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_lacp__lacp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_lacp__lacp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /lacp/interfaces (container)

    YANG Description: Enclosing container for the list of LACP-enabled
interfaces
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /lacp/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container for the list of LACP-enabled
interfaces
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_lacp__lacp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_lacp__lacp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_lacp__lacp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('interfaces', interfaces), ])


class openconfig_lacp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-lacp - based on the path /openconfig-lacp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module describes configuration and operational state
data for Link Aggregation Control Protocol (LACP) for
managing aggregate interfaces.   It works in conjunction with
the OpenConfig interfaces and aggregate interfaces models.
  """
  __slots__ = ('_path_helper', '_extmethods', '__lacp',)

  _yang_name = 'openconfig-lacp'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__lacp = YANGDynClass(base=yc_lacp_openconfig_lacp__lacp, is_container='container', yang_name="lacp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_lacp(self):
    """
    Getter method for lacp, mapped from YANG variable /lacp (container)

    YANG Description: Configuration and operational state data for LACP protocol
operation on the aggregate interface
    """
    return self.__lacp
      
  def _set_lacp(self, v, load=False):
    """
    Setter method for lacp, mapped from YANG variable /lacp (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lacp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lacp() directly.

    YANG Description: Configuration and operational state data for LACP protocol
operation on the aggregate interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_lacp_openconfig_lacp__lacp, is_container='container', yang_name="lacp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lacp must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_lacp_openconfig_lacp__lacp, is_container='container', yang_name="lacp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)""",
        })

    self.__lacp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lacp(self):
    self.__lacp = YANGDynClass(base=yc_lacp_openconfig_lacp__lacp, is_container='container', yang_name="lacp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/lacp', defining_module='openconfig-lacp', yang_type='container', is_config=True)

  lacp = __builtin__.property(_get_lacp, _set_lacp)


  _pyangbind_elements = OrderedDict([('lacp', lacp), ])


