// Code generated by "go generate gonum.org/v1/gonum/unit/constant”; DO NOT EDIT.

// Copyright ©2019 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package constant

import (
	"fmt"
	"testing"
)

func TestMagneticConstantFormat(t *testing.T) {
	t.Parallel()
	for _, test := range []struct {
		format string
		want   string
	}{
		{"%v", "1.2566370621238374e-06 A^2 s^4 kg^-1 m^-3"},
		{"%.1v", "1e-06 A^2 s^4 kg^-1 m^-3"},
		{"%50.1v", "                          1e-06 A^2 s^4 kg^-1 m^-3"},
		{"%50v", "         1.2566370621238374e-06 A^2 s^4 kg^-1 m^-3"},
		{"%1v", "1.2566370621238374e-06 A^2 s^4 kg^-1 m^-3"},
		{"%#v", "constant.magneticConstantUnits(1.2566370621238374e-06)"},
		{"%s", "%!s(constant.magneticConstantUnits=1.2566370621238374e-06 A^2 s^4 kg^-1 m^-3)"},
	} {
		got := fmt.Sprintf(test.format, MagneticConstant)
		if got != test.want {
			t.Errorf("Format %q: got: %q want: %q", test.format, got, test.want)
		}
	}
}
