/* Transitive Closure: definite datalog example */

:- import incr_assert_inval/1, incr_retractall_inval/1, incr_table_update/1 from increval.
:- import incr_assert/1, incr_retractall/1 from increval.

:- use_incremental_dynamic edge/2.
:- use_incremental_tabling reach/2.

test :-
	(check_ans(X,reach(1,X),[2,3,4]),
	 fail
	 ;
	 incr_assert(edge(4,5)),
	 check_ans(X,reach(1,X),[2,3,4,5]),
	 fail
	 ;
	 incr_retractall(edge(1,2)),
	 check_ans(X,reach(1,X),[3,4,5]),
	 fail
	 ;
	 incr_retractall(edge(1,3)),
	 check_ans(X,reach(1,X),[]),
	 fail
	 ;
	 true
	).

edge(1,2).
edge(2,4).
edge(1,3).
edge(3,4).

reach(X,Y):- edge(X,Y).
reach(X,Y):- edge(X,Z),reach(Z,Y).

check_ans(Var,Call,RightAnswers) :-
	findall(Var,Call,Answers),
	sort(Answers,SAnswers),
	(SAnswers == RightAnswers
	 ->	writeln('OK')
	 ;	writeln(error(SAnswers,RightAnswers))
	).			

/**:- reach(1,X).

:- incr_retractall_inval(edge(1,2)).
:- incr_table_update(_X).
**/

/*
:- incr_assert_inval(edge(1,2)).
:- incr_table_update(_X).
:- incr_retractall_inval(edge(1,2)).
:- incr_table_update(X).
:- incr_assert_inval(edge(1,2)).
:- incr_table_update(X).
:- incr_retractall_inval(edge(1,2)).
:- incr_table_update(X).
:- incr_assert_inval(edge(1,2)).
:- incr_table_update(X).
:- incr_retractall_inval(edge(1,2)).
:- incr_table_update(X).
:- incr_assert_inval(edge(1,2)).
:- incr_table_update(X).
:- incr_retractall_inval(edge(1,2)).
:- incr_table_update(X).
:- incr_assert_inval(edge(1,2)).
:- incr_table_update(X).

:- incr_retractall_inval(edge(2,4)).
:- incr_table_update(X).
:- incr_assert_inval(edge(2,4)).
:- incr_table_update(X).
:- incr_retractall_inval(edge(2,4)).
:- incr_table_update(X).
:- incr_assert_inval(edge(2,4)).
:- incr_table_update(X).
:- incr_retractall_inval(edge(2,4)).
:- incr_table_update(X).
:- incr_assert_inval(edge(2,4)).
:- incr_table_update(X).
:- incr_retractall_inval(edge(2,4)).
:- incr_table_update(X).
:- incr_assert_inval(edge(2,4)).
:- incr_table_update(X).
:- incr_retractall_inval(edge(2,4)).
:- incr_table_update(X).
:- incr_assert_inval(edge(2,4)).
:- incr_table_update(X).

*/


/* Sample Run 



XSB Version 2.7.1+ (CVS) of March 5, 2005
[i686-pc-linux-gnu; mode: optimal; engine: slg-wam; gc: indirection; scheduling: local]

| ?- [reach].
[Compiling ./reach]
[reach compiled, cpu time used: 0.0480 seconds]
[reach loaded]

yes
| ?- reach(1,X).

X = 4;

X = 3;

X = 2;

no
| ?- import incr_assert_inval/1, incr_retractall_inval/1, incr_table_update/1 from increval.

yes
| ?- incr_assert_inval(edge(4,5)), incr_assert_inval(edge(5,6)).

yes
| ?- incr_table_update(X). 

X = [reach(1,_h192),reach(3,_h204),reach(2,_h216),reach(4,_h228),reach(5,_h240),reach(6,_h252)];

no
| ?- reach(1,X).

X = 6;

X = 5;

X = 4;

X = 3;

X = 2;

no
| ?- incr_retractall_inval(edge(1,3)).

yes
| ?- incr_table_update(X).

X = [reach(1,_h156)];

no

| ?- reach(1,X).

X = 6;

X = 5;

X = 4;

X = 2;

no
| ?- halt.

End XSB (cputime 0.06 secs, elapsetime 62.64 secs)
dsaha@187-dhcp:~/y06/spring/cvsxsb/XSBv3/XSB/examples/incremental$ 


*/

/*
Incr_table_update(X) returns the calls that are changed in X. 


*/