#ifndef ATL_sGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,106,187,227,268,309,350,390,431,472,513,594,676,757,839,920,1002,1165,1328,1654,1980,2306,2632,3936,5240
 * N : 25,106,187,227,268,309,350,390,431,472,513,594,676,757,839,920,1002,1165,1328,1654,1980,2306,2632,3936,5240
 * NB : 1,1,11,11,12,12,15,15,16,16,18,18,19,19,20,20,22,22,23,23,24,24,27,27,28
 */
#define ATL_sGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 146) (nb_) = 1; \
   else if ((n_) < 247) (nb_) = 11; \
   else if ((n_) < 329) (nb_) = 12; \
   else if ((n_) < 410) (nb_) = 15; \
   else if ((n_) < 492) (nb_) = 16; \
   else if ((n_) < 635) (nb_) = 18; \
   else if ((n_) < 798) (nb_) = 19; \
   else if ((n_) < 961) (nb_) = 20; \
   else if ((n_) < 1246) (nb_) = 22; \
   else if ((n_) < 1817) (nb_) = 23; \
   else if ((n_) < 2469) (nb_) = 24; \
   else if ((n_) < 4588) (nb_) = 27; \
   else (nb_) = 28; \
}


#endif    /* end ifndef ATL_sGetNB_geqrf */
