#ifndef ATL_dtGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,257,490,723,956,1422,1655,1888,2354,2820,3286,3752,3985,4218,4451,4684,4917,5150,5383,5616,6548,7480
 * N : 25,257,490,723,956,1422,1655,1888,2354,2820,3286,3752,3985,4218,4451,4684,4917,5150,5383,5616,6548,7480
 * NB : 1,1,35,42,83,72,72,131,131,143,144,163,167,179,185,187,189,190,190,191,192,195
 */
#define ATL_dtGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 373) (nb_) = 1; \
   else if ((n_) < 606) (nb_) = 35; \
   else if ((n_) < 839) (nb_) = 42; \
   else if ((n_) < 1189) (nb_) = 83; \
   else if ((n_) < 1771) (nb_) = 72; \
   else if ((n_) < 2587) (nb_) = 131; \
   else if ((n_) < 3053) (nb_) = 143; \
   else if ((n_) < 3519) (nb_) = 144; \
   else if ((n_) < 3868) (nb_) = 163; \
   else if ((n_) < 4101) (nb_) = 167; \
   else if ((n_) < 4334) (nb_) = 179; \
   else if ((n_) < 4567) (nb_) = 185; \
   else if ((n_) < 4800) (nb_) = 187; \
   else if ((n_) < 5033) (nb_) = 189; \
   else if ((n_) < 5499) (nb_) = 190; \
   else if ((n_) < 6082) (nb_) = 191; \
   else if ((n_) < 7014) (nb_) = 192; \
   else (nb_) = 195; \
}


#endif    /* end ifndef ATL_dtGetNB_geqrf */
