/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

public class HeapDumper {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    public static final String HEAP_DUMP_EXTENSION = ".hprof";
    private static volatile HotSpotDiagnosticMXBean hotSpotDiagnosticMBean;

    public static void dumpHeap(File file, boolean live) throws ClassNotFoundException {
        if (file.exists()) {
            System.err.println("Cannot dump heap to '" + file + "' - file exists!");
            return;
        }
        try {
            HeapDumper.getHotSpotDiagnosticMBean().dumpHeap(file.getAbsolutePath(), live);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static HotSpotDiagnosticMXBean getHotSpotDiagnosticMBean() {
        if (hotSpotDiagnosticMBean == null) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                hotSpotDiagnosticMBean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return hotSpotDiagnosticMBean;
    }
}

