// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/actions/sdk/v2/interactionmodel/event_handler.proto

package interactionmodel

import (
	reflect "reflect"
	sync "sync"

	prompt "google.golang.org/genproto/googleapis/actions/sdk/v2/interactionmodel/prompt"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines a handler to be executed after an event. Examples of events are
// intent and condition based events in a scene.
type EventHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the webhook handler to call.
	WebhookHandler string `protobuf:"bytes,1,opt,name=webhook_handler,json=webhookHandler,proto3" json:"webhook_handler,omitempty"`
	// Prompts can either be inlined or referenced by name.
	//
	// Types that are assignable to Prompt:
	//	*EventHandler_StaticPrompt
	//	*EventHandler_StaticPromptName
	Prompt isEventHandler_Prompt `protobuf_oneof:"prompt"`
}

func (x *EventHandler) Reset() {
	*x = EventHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_event_handler_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventHandler) ProtoMessage() {}

func (x *EventHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_event_handler_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventHandler.ProtoReflect.Descriptor instead.
func (*EventHandler) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDescGZIP(), []int{0}
}

func (x *EventHandler) GetWebhookHandler() string {
	if x != nil {
		return x.WebhookHandler
	}
	return ""
}

func (m *EventHandler) GetPrompt() isEventHandler_Prompt {
	if m != nil {
		return m.Prompt
	}
	return nil
}

func (x *EventHandler) GetStaticPrompt() *prompt.StaticPrompt {
	if x, ok := x.GetPrompt().(*EventHandler_StaticPrompt); ok {
		return x.StaticPrompt
	}
	return nil
}

func (x *EventHandler) GetStaticPromptName() string {
	if x, ok := x.GetPrompt().(*EventHandler_StaticPromptName); ok {
		return x.StaticPromptName
	}
	return ""
}

type isEventHandler_Prompt interface {
	isEventHandler_Prompt()
}

type EventHandler_StaticPrompt struct {
	// Inlined static prompt. Can contain references to string resources in
	// bundles.
	StaticPrompt *prompt.StaticPrompt `protobuf:"bytes,2,opt,name=static_prompt,json=staticPrompt,proto3,oneof"`
}

type EventHandler_StaticPromptName struct {
	// Name of the static prompt to invoke.
	StaticPromptName string `protobuf:"bytes,3,opt,name=static_prompt_name,json=staticPromptName,proto3,oneof"`
}

func (*EventHandler_StaticPrompt) isEventHandler_Prompt() {}

func (*EventHandler_StaticPromptName) isEventHandler_Prompt() {}

var File_google_actions_sdk_v2_interactionmodel_event_handler_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b,
	0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x1a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd5, 0x01, 0x0a, 0x0c, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x72, 0x12, 0x62, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x70, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0x2e, 0x0a, 0x12, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f,
	0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x10, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x50, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x42,
	0x99, 0x01, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x11,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3b, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDescData = file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDesc
)

func file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDescData
}

var file_google_actions_sdk_v2_interactionmodel_event_handler_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_actions_sdk_v2_interactionmodel_event_handler_proto_goTypes = []interface{}{
	(*EventHandler)(nil),        // 0: google.actions.sdk.v2.interactionmodel.EventHandler
	(*prompt.StaticPrompt)(nil), // 1: google.actions.sdk.v2.interactionmodel.prompt.StaticPrompt
}
var file_google_actions_sdk_v2_interactionmodel_event_handler_proto_depIdxs = []int32{
	1, // 0: google.actions.sdk.v2.interactionmodel.EventHandler.static_prompt:type_name -> google.actions.sdk.v2.interactionmodel.prompt.StaticPrompt
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_interactionmodel_event_handler_proto_init() }
func file_google_actions_sdk_v2_interactionmodel_event_handler_proto_init() {
	if File_google_actions_sdk_v2_interactionmodel_event_handler_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_interactionmodel_event_handler_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*EventHandler_StaticPrompt)(nil),
		(*EventHandler_StaticPromptName)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_interactionmodel_event_handler_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_interactionmodel_event_handler_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_interactionmodel_event_handler_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_interactionmodel_event_handler_proto = out.File
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_rawDesc = nil
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_goTypes = nil
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_depIdxs = nil
}
