// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package doubleclickbidmanager provides access to the DoubleClick Bid Manager API.
//
// For product documentation, see: https://developers.google.com/bid-manager/
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/doubleclickbidmanager/v2"
//	...
//	ctx := context.Background()
//	doubleclickbidmanagerService, err := doubleclickbidmanager.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	doubleclickbidmanagerService, err := doubleclickbidmanager.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	doubleclickbidmanagerService, err := doubleclickbidmanager.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package doubleclickbidmanager // import "google.golang.org/api/doubleclickbidmanager/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "doubleclickbidmanager:v2"
const apiName = "doubleclickbidmanager"
const apiVersion = "v2"
const basePath = "https://doubleclickbidmanager.googleapis.com/v2/"
const mtlsBasePath = "https://doubleclickbidmanager.mtls.googleapis.com/v2/"

// OAuth2 scopes used by this API.
const (
	// View and manage your reports in DoubleClick Bid Manager
	DoubleclickbidmanagerScope = "https://www.googleapis.com/auth/doubleclickbidmanager"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/doubleclickbidmanager",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Queries = NewQueriesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Queries *QueriesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewQueriesService(s *Service) *QueriesService {
	rs := &QueriesService{s: s}
	rs.Reports = NewQueriesReportsService(s)
	return rs
}

type QueriesService struct {
	s *Service

	Reports *QueriesReportsService
}

func NewQueriesReportsService(s *Service) *QueriesReportsService {
	rs := &QueriesReportsService{s: s}
	return rs
}

type QueriesReportsService struct {
	s *Service
}

// ChannelGrouping: A channel grouping defines a set of rules that can
// be used to categorize events in a path report.
type ChannelGrouping struct {
	// FallbackName: The name to apply to an event that does not match any
	// of the rules in the channel grouping.
	FallbackName string `json:"fallbackName,omitempty"`

	// Name: Channel Grouping name.
	Name string `json:"name,omitempty"`

	// Rules: Rules within Channel Grouping. There is a limit of 100 rules
	// that can be set per channel grouping.
	Rules []*Rule `json:"rules,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FallbackName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FallbackName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ChannelGrouping) MarshalJSON() ([]byte, error) {
	type NoMethod ChannelGrouping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DataRange: Report data range.
type DataRange struct {
	// CustomEndDate: The ending date for the data that is shown in the
	// report. Note, `customEndDate` is required if `range` is
	// `CUSTOM_DATES` and ignored otherwise.
	CustomEndDate *Date `json:"customEndDate,omitempty"`

	// CustomStartDate: The starting data for the data that is shown in the
	// report. Note, `customStartDate` is required if `range` is
	// `CUSTOM_DATES` and ignored otherwise.
	CustomStartDate *Date `json:"customStartDate,omitempty"`

	// Range: Report data range used to generate the report.
	//
	// Possible values:
	//   "RANGE_UNSPECIFIED" - Default value when range is not specified or
	// is unknown in this version.
	//   "CUSTOM_DATES" - Custom range specified by custom_start_date and
	// custom_end_date fields.
	//   "CURRENT_DAY" - Current day.
	//   "PREVIOUS_DAY" - Previous day.
	//   "WEEK_TO_DATE" - All days, including the current day, since the
	// most recent Sunday.
	//   "MONTH_TO_DATE" - All days, including the current day, since the
	// start of the current month.
	//   "QUARTER_TO_DATE" - All days, including the current day, since the
	// start of the current quarter.
	//   "YEAR_TO_DATE" - All days, including the current day, since the
	// start of the current calendar year.
	//   "PREVIOUS_WEEK" - The previous completed week, beginning from
	// Sunday.
	//   "PREVIOUS_MONTH" - The previous completed calendar month.
	//   "PREVIOUS_QUARTER" - The previous completed quarter.
	//   "PREVIOUS_YEAR" - The previous completed calendar year.
	//   "LAST_7_DAYS" - The previous 7 days, excluding the current day.
	//   "LAST_30_DAYS" - The previous 30 days, excluding the current day.
	//   "LAST_90_DAYS" - The previous 90 days, excluding the current day.
	//   "LAST_365_DAYS" - The previous 365 days, excluding the current day.
	//   "ALL_TIME" - All time for which data is available, excluding the
	// current day.
	//   "LAST_14_DAYS" - The previous 14 days, excluding the current day.
	//   "LAST_60_DAYS" - The previous 60 days, excluding the current day.
	Range string `json:"range,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CustomEndDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomEndDate") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DataRange) MarshalJSON() ([]byte, error) {
	type NoMethod DataRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values. * A month and day, with a
// zero year (for example, an anniversary). * A year on its own, with a
// zero month and a zero day. * A year and month, with a zero day (for
// example, a credit card expiration date). Related types: *
// google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DisjunctiveMatchStatement: DisjunctiveMatchStatement that OR's all
// contained filters.
type DisjunctiveMatchStatement struct {
	// EventFilters: Filters. There is a limit of 100 filters that can be
	// set per disjunctive match statement.
	EventFilters []*EventFilter `json:"eventFilters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EventFilters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EventFilters") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DisjunctiveMatchStatement) MarshalJSON() ([]byte, error) {
	type NoMethod DisjunctiveMatchStatement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EventFilter: Defines the type of filter to be applied to the path, a
// DV360 event dimension filter.
type EventFilter struct {
	// DimensionFilter: Filter on a dimension.
	DimensionFilter *PathQueryOptionsFilter `json:"dimensionFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DimensionFilter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DimensionFilter") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EventFilter) MarshalJSON() ([]byte, error) {
	type NoMethod EventFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FilterPair: Filter used to match traffic data in your report.
type FilterPair struct {
	// Type: Filter type.
	Type string `json:"type,omitempty"`

	// Value: Filter value.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FilterPair) MarshalJSON() ([]byte, error) {
	type NoMethod FilterPair
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListQueriesResponse struct {
	// NextPageToken: A token, which can be sent as page_token to retrieve
	// the next page of queries. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Queries: The list of queries.
	Queries []*Query `json:"queries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListQueriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListReportsResponse struct {
	// NextPageToken: A token, which can be sent as page_token to retrieve
	// the next page of reports. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Reports: Retrieved reports.
	Reports []*Report `json:"reports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListReportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Options: Additional query options.
type Options struct {
	// IncludeOnlyTargetedUserLists: Set to true and filter your report by
	// `FILTER_INSERTION_ORDER` or `FILTER_LINE_ITEM` to include data for
	// audience lists specifically targeted by those items.
	IncludeOnlyTargetedUserLists bool `json:"includeOnlyTargetedUserLists,omitempty"`

	// PathQueryOptions: Options that contain Path Filters and Custom
	// Channel Groupings.
	PathQueryOptions *PathQueryOptions `json:"pathQueryOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IncludeOnlyTargetedUserLists") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "IncludeOnlyTargetedUserLists") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Options) MarshalJSON() ([]byte, error) {
	type NoMethod Options
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Parameters: Parameters of a query or report.
type Parameters struct {
	// Filters: Filters used to match traffic data in your report.
	Filters []*FilterPair `json:"filters,omitempty"`

	// GroupBys: Data is grouped by the filters listed in this field.
	GroupBys []string `json:"groupBys,omitempty"`

	// Metrics: Metrics to include as columns in your report.
	Metrics []string `json:"metrics,omitempty"`

	// Options: Additional query options.
	Options *Options `json:"options,omitempty"`

	// Type: The type of the report. The type of the report will dictate
	// what dimesions, filters, and metrics can be used. **Warning:** The
	// `AUDIENCE_COMPOSITION` report type will be deprecated in Display &
	// Video 360 on **June 8, 2023**. Once deprecated, you will no longer be
	// able to create new or retrieve existing Query and Report resources of
	// this type.
	//
	// Possible values:
	//   "REPORT_TYPE_UNSPECIFIED" - Default value when report type is not
	// specified or is unknown in this version.
	//   "STANDARD" - Standard report.
	//   "INVENTORY_AVAILABILITY" - Inventory Availability report.
	//   "AUDIENCE_COMPOSITION" - Audience Composition report. **Warning:**
	// This report type will be deprecated in Display & Video 360 on **June
	// 8, 2023**. Once deprecated, you will no longer be able to create new
	// or retrieve existing Query and Report resources of this type.
	//   "FLOODLIGHT" - Floodlight report.
	//   "YOUTUBE" - YouTube report.
	//   "GRP" - GRP report.
	//   "YOUTUBE_PROGRAMMATIC_GUARANTEED" - YouTube Programmatic Guaranteed
	// report.
	//   "REACH" - Reach report.
	//   "UNIQUE_REACH_AUDIENCE" - Unique Reach Audience report.
	//   "FULL_PATH" - Full Path report.
	//   "PATH_ATTRIBUTION" - Path Attribution report.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Parameters) MarshalJSON() ([]byte, error) {
	type NoMethod Parameters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PathFilter: Path filters specify which paths to include in a report.
// A path is the result of combining DV360 events based on User ID to
// create a workflow of users' actions. When a path filter is set, the
// resulting report will only include paths that match the specified
// event at the specified position. All other paths will be excluded.
type PathFilter struct {
	// EventFilters: Filter on an event to be applied to some part of the
	// path.
	EventFilters []*EventFilter `json:"eventFilters,omitempty"`

	// PathMatchPosition: The position of the path the filter should match
	// to (first, last, or any event in path).
	//
	// Possible values:
	//   "PATH_MATCH_POSITION_UNSPECIFIED" - Default value when path match
	// position is not specified or is unknown in this version.
	//   "ANY" - Any position in the path.
	//   "FIRST" - The first position in the path.
	//   "LAST" - The last position in the path.
	PathMatchPosition string `json:"pathMatchPosition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EventFilters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EventFilters") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PathFilter) MarshalJSON() ([]byte, error) {
	type NoMethod PathFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PathQueryOptions: Path Query Options for Report Options.
type PathQueryOptions struct {
	// ChannelGrouping: Custom Channel Groupings.
	ChannelGrouping *ChannelGrouping `json:"channelGrouping,omitempty"`

	// PathFilters: Path Filters. There is a limit of 100 path filters that
	// can be set per report.
	PathFilters []*PathFilter `json:"pathFilters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChannelGrouping") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChannelGrouping") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *PathQueryOptions) MarshalJSON() ([]byte, error) {
	type NoMethod PathQueryOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PathQueryOptionsFilter: Dimension filter on path events.
type PathQueryOptionsFilter struct {
	// Filter: Dimension the filter is applied to.
	Filter string `json:"filter,omitempty"`

	// Match: Match logic of the filter.
	//
	// Possible values:
	//   "UNKNOWN" - Default value when match is not specified or is unknown
	// in this version.
	//   "EXACT" - Matches a value exactly.
	//   "PARTIAL" - Matches a value partially.
	//   "BEGINS_WITH" - Begins with a value.
	//   "WILDCARD_EXPRESSION" - Matches a value, utilizing wildcard
	// character logic in the value.
	Match string `json:"match,omitempty"`

	// Values: Values to filter on.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PathQueryOptionsFilter) MarshalJSON() ([]byte, error) {
	type NoMethod PathQueryOptionsFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Query: Represents a query.
type Query struct {
	// Metadata: Query metadata.
	Metadata *QueryMetadata `json:"metadata,omitempty"`

	// Params: Query parameters.
	Params *Parameters `json:"params,omitempty"`

	// QueryId: Output only. Query ID.
	QueryId int64 `json:"queryId,omitempty,string"`

	// Schedule: Information on how often and when to run a query. If
	// `ONE_TIME` is set to the frequency field, the query will only be run
	// at the time of creation.
	Schedule *QuerySchedule `json:"schedule,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Metadata") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Query) MarshalJSON() ([]byte, error) {
	type NoMethod Query
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QueryMetadata: Query metadata.
type QueryMetadata struct {
	// DataRange: Range of report data. All reports will be based on the
	// same time zone as used by the advertiser.
	DataRange *DataRange `json:"dataRange,omitempty"`

	// Format: Format of the generated report.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Default value when format is not specified
	// or is unknown in this version.
	//   "CSV" - CSV.
	//   "XLSX" - Excel.
	Format string `json:"format,omitempty"`

	// SendNotification: Whether to send an email notification when a report
	// is ready. Defaults to false.
	SendNotification bool `json:"sendNotification,omitempty"`

	// ShareEmailAddress: List of email addresses which are sent email
	// notifications when the report is finished. Separate from
	// send_notification.
	ShareEmailAddress []string `json:"shareEmailAddress,omitempty"`

	// Title: Query title. It is used to name the reports generated from
	// this query.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataRange") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataRange") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QueryMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod QueryMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// QuerySchedule: Information on when and how frequently to run a query.
type QuerySchedule struct {
	// EndDate: Date to periodically run the query until. Not applicable to
	// `ONE_TIME` frequency.
	EndDate *Date `json:"endDate,omitempty"`

	// Frequency: How often the query is run.
	//
	// Possible values:
	//   "FREQUENCY_UNSPECIFIED" - Default value when frequency is not
	// specified or is unknown in this version.
	//   "ONE_TIME" - Only once.
	//   "DAILY" - Once a day.
	//   "WEEKLY" - Once a week.
	//   "SEMI_MONTHLY" - Twice a month.
	//   "MONTHLY" - Once a month.
	//   "QUARTERLY" - Once a quarter
	//   "YEARLY" - Once a year.
	Frequency string `json:"frequency,omitempty"`

	// NextRunTimezoneCode: Canonical timezone code for report generation
	// time. Defaults to `America/New_York`.
	NextRunTimezoneCode string `json:"nextRunTimezoneCode,omitempty"`

	// StartDate: When to start running the query. Not applicable to
	// `ONE_TIME` frequency.
	StartDate *Date `json:"startDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndDate") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *QuerySchedule) MarshalJSON() ([]byte, error) {
	type NoMethod QuerySchedule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Report: Represents a report.
type Report struct {
	// Key: Key used to identify a report.
	Key *ReportKey `json:"key,omitempty"`

	// Metadata: Report metadata.
	Metadata *ReportMetadata `json:"metadata,omitempty"`

	// Params: Report parameters.
	Params *Parameters `json:"params,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Report) MarshalJSON() ([]byte, error) {
	type NoMethod Report
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReportKey: Key used to identify a report.
type ReportKey struct {
	// QueryId: Output only. Query ID.
	QueryId int64 `json:"queryId,omitempty,string"`

	// ReportId: Output only. Report ID.
	ReportId int64 `json:"reportId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "QueryId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QueryId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReportKey) MarshalJSON() ([]byte, error) {
	type NoMethod ReportKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReportMetadata: Report metadata.
type ReportMetadata struct {
	// GoogleCloudStoragePath: Output only. The path to the location in
	// Google Cloud Storage where the report is stored.
	GoogleCloudStoragePath string `json:"googleCloudStoragePath,omitempty"`

	// ReportDataEndDate: The ending time for the data that is shown in the
	// report.
	ReportDataEndDate *Date `json:"reportDataEndDate,omitempty"`

	// ReportDataStartDate: The starting time for the data that is shown in
	// the report.
	ReportDataStartDate *Date `json:"reportDataStartDate,omitempty"`

	// Status: Report status.
	Status *ReportStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "GoogleCloudStoragePath") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GoogleCloudStoragePath")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ReportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ReportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ReportStatus: Report status.
type ReportStatus struct {
	// FinishTime: Output only. The time when this report either completed
	// successfully or failed.
	FinishTime string `json:"finishTime,omitempty"`

	// Format: The file type of the report.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Default value when format is not specified
	// or is unknown in this version.
	//   "CSV" - CSV.
	//   "XLSX" - Excel.
	Format string `json:"format,omitempty"`

	// State: Output only. The state of the report.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value when state is not specified or
	// is unknown in this version.
	//   "QUEUED" - The report is queued to run.
	//   "RUNNING" - The report is currently running.
	//   "DONE" - The report has finished running successfully.
	//   "FAILED" - The report has finished running in failure.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FinishTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FinishTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ReportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ReportStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Rule: A Rule defines a name, and a boolean expression in [conjunctive
// normal form]
// (http://mathworld.wolfram.com/ConjunctiveNormalForm.html){.external}
// that can be applied to a path event to determine if that name should
// be applied.
type Rule struct {
	// DisjunctiveMatchStatements: DisjunctiveMatchStatements within a Rule.
	// DisjunctiveMatchStatement OR's all contained filters.
	DisjunctiveMatchStatements []*DisjunctiveMatchStatement `json:"disjunctiveMatchStatements,omitempty"`

	// Name: Rule name.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DisjunctiveMatchStatements") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "DisjunctiveMatchStatements") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Rule) MarshalJSON() ([]byte, error) {
	type NoMethod Rule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RunQueryRequest: Request to run a stored query to generate a report.
type RunQueryRequest struct {
	// DataRange: Report data range used to generate the report. If
	// unspecified, the original parent query's data range is used.
	DataRange *DataRange `json:"dataRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataRange") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataRange") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RunQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RunQueryRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "doubleclickbidmanager.queries.create":

type QueriesCreateCall struct {
	s          *Service
	query      *Query
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a query.
func (r *QueriesService) Create(query *Query) *QueriesCreateCall {
	c := &QueriesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.query = query
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *QueriesCreateCall) Fields(s ...googleapi.Field) *QueriesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *QueriesCreateCall) Context(ctx context.Context) *QueriesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *QueriesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *QueriesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.query)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "queries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "doubleclickbidmanager.queries.create" call.
// Exactly one of *Query or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Query.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *QueriesCreateCall) Do(opts ...googleapi.CallOption) (*Query, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Query{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a query.",
	//   "flatPath": "queries",
	//   "httpMethod": "POST",
	//   "id": "doubleclickbidmanager.queries.create",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "queries",
	//   "request": {
	//     "$ref": "Query"
	//   },
	//   "response": {
	//     "$ref": "Query"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclickbidmanager"
	//   ]
	// }

}

// method id "doubleclickbidmanager.queries.delete":

type QueriesDeleteCall struct {
	s          *Service
	queryId    int64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a query as well as the associated reports.
//
// - queryId: ID of query to delete.
func (r *QueriesService) Delete(queryId int64) *QueriesDeleteCall {
	c := &QueriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.queryId = queryId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *QueriesDeleteCall) Fields(s ...googleapi.Field) *QueriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *QueriesDeleteCall) Context(ctx context.Context) *QueriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *QueriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *QueriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "queries/{queryId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"queryId": strconv.FormatInt(c.queryId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "doubleclickbidmanager.queries.delete" call.
func (c *QueriesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	return nil
	// {
	//   "description": "Deletes a query as well as the associated reports.",
	//   "flatPath": "queries/{queryId}",
	//   "httpMethod": "DELETE",
	//   "id": "doubleclickbidmanager.queries.delete",
	//   "parameterOrder": [
	//     "queryId"
	//   ],
	//   "parameters": {
	//     "queryId": {
	//       "description": "Required. ID of query to delete.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "queries/{queryId}",
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclickbidmanager"
	//   ]
	// }

}

// method id "doubleclickbidmanager.queries.get":

type QueriesGetCall struct {
	s            *Service
	queryId      int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a query.
//
// - queryId: ID of query to retrieve.
func (r *QueriesService) Get(queryId int64) *QueriesGetCall {
	c := &QueriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.queryId = queryId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *QueriesGetCall) Fields(s ...googleapi.Field) *QueriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *QueriesGetCall) IfNoneMatch(entityTag string) *QueriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *QueriesGetCall) Context(ctx context.Context) *QueriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *QueriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *QueriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "queries/{queryId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"queryId": strconv.FormatInt(c.queryId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "doubleclickbidmanager.queries.get" call.
// Exactly one of *Query or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Query.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *QueriesGetCall) Do(opts ...googleapi.CallOption) (*Query, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Query{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a query.",
	//   "flatPath": "queries/{queryId}",
	//   "httpMethod": "GET",
	//   "id": "doubleclickbidmanager.queries.get",
	//   "parameterOrder": [
	//     "queryId"
	//   ],
	//   "parameters": {
	//     "queryId": {
	//       "description": "Required. ID of query to retrieve.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "queries/{queryId}",
	//   "response": {
	//     "$ref": "Query"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclickbidmanager"
	//   ]
	// }

}

// method id "doubleclickbidmanager.queries.list":

type QueriesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists queries created by the current user.
func (r *QueriesService) List() *QueriesListCall {
	c := &QueriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// OrderBy sets the optional parameter "orderBy": Name of a field used
// to order results. The default sorting order is ascending. To specify
// descending order for a field, append a " desc" suffix. For example
// "metadata.title desc". Sorting is only supported for the following
// fields: * `queryId` * `metadata.title`
func (c *QueriesListCall) OrderBy(orderBy string) *QueriesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results per page. Must be between `1` and `100`. Defaults to `100` if
// unspecified.
func (c *QueriesListCall) PageSize(pageSize int64) *QueriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous list call. Provide this to retrieve the
// subsequent page of queries.
func (c *QueriesListCall) PageToken(pageToken string) *QueriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *QueriesListCall) Fields(s ...googleapi.Field) *QueriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *QueriesListCall) IfNoneMatch(entityTag string) *QueriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *QueriesListCall) Context(ctx context.Context) *QueriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *QueriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *QueriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "queries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "doubleclickbidmanager.queries.list" call.
// Exactly one of *ListQueriesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListQueriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *QueriesListCall) Do(opts ...googleapi.CallOption) (*ListQueriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListQueriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists queries created by the current user.",
	//   "flatPath": "queries",
	//   "httpMethod": "GET",
	//   "id": "doubleclickbidmanager.queries.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "orderBy": {
	//       "description": "Name of a field used to order results. The default sorting order is ascending. To specify descending order for a field, append a \" desc\" suffix. For example \"metadata.title desc\". Sorting is only supported for the following fields: * `queryId` * `metadata.title`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results per page. Must be between `1` and `100`. Defaults to `100` if unspecified.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous list call. Provide this to retrieve the subsequent page of queries.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "queries",
	//   "response": {
	//     "$ref": "ListQueriesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclickbidmanager"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *QueriesListCall) Pages(ctx context.Context, f func(*ListQueriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "doubleclickbidmanager.queries.run":

type QueriesRunCall struct {
	s               *Service
	queryId         int64
	runqueryrequest *RunQueryRequest
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Run: Runs a stored query to generate a report.
//
// - queryId: ID of query to run.
func (r *QueriesService) Run(queryId int64, runqueryrequest *RunQueryRequest) *QueriesRunCall {
	c := &QueriesRunCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.queryId = queryId
	c.runqueryrequest = runqueryrequest
	return c
}

// Synchronous sets the optional parameter "synchronous": Whether the
// query should be run synchronously. When true, this method will not
// return until the query has finished running. When false or not
// specified, this method will return immediately.
func (c *QueriesRunCall) Synchronous(synchronous bool) *QueriesRunCall {
	c.urlParams_.Set("synchronous", fmt.Sprint(synchronous))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *QueriesRunCall) Fields(s ...googleapi.Field) *QueriesRunCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *QueriesRunCall) Context(ctx context.Context) *QueriesRunCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *QueriesRunCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *QueriesRunCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.runqueryrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "queries/{queryId}:run")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"queryId": strconv.FormatInt(c.queryId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "doubleclickbidmanager.queries.run" call.
// Exactly one of *Report or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Report.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *QueriesRunCall) Do(opts ...googleapi.CallOption) (*Report, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Report{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Runs a stored query to generate a report.",
	//   "flatPath": "queries/{queryId}:run",
	//   "httpMethod": "POST",
	//   "id": "doubleclickbidmanager.queries.run",
	//   "parameterOrder": [
	//     "queryId"
	//   ],
	//   "parameters": {
	//     "queryId": {
	//       "description": "Required. ID of query to run.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "synchronous": {
	//       "description": "Whether the query should be run synchronously. When true, this method will not return until the query has finished running. When false or not specified, this method will return immediately.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "queries/{queryId}:run",
	//   "request": {
	//     "$ref": "RunQueryRequest"
	//   },
	//   "response": {
	//     "$ref": "Report"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclickbidmanager"
	//   ]
	// }

}

// method id "doubleclickbidmanager.queries.reports.get":

type QueriesReportsGetCall struct {
	s            *Service
	queryId      int64
	reportId     int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a report.
//
// - queryId: ID of the query the report is associated with.
// - reportId: ID of the report to retrieve.
func (r *QueriesReportsService) Get(queryId int64, reportId int64) *QueriesReportsGetCall {
	c := &QueriesReportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.queryId = queryId
	c.reportId = reportId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *QueriesReportsGetCall) Fields(s ...googleapi.Field) *QueriesReportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *QueriesReportsGetCall) IfNoneMatch(entityTag string) *QueriesReportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *QueriesReportsGetCall) Context(ctx context.Context) *QueriesReportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *QueriesReportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *QueriesReportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "queries/{queryId}/reports/{reportId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"queryId":  strconv.FormatInt(c.queryId, 10),
		"reportId": strconv.FormatInt(c.reportId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "doubleclickbidmanager.queries.reports.get" call.
// Exactly one of *Report or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Report.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *QueriesReportsGetCall) Do(opts ...googleapi.CallOption) (*Report, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Report{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a report.",
	//   "flatPath": "queries/{queryId}/reports/{reportId}",
	//   "httpMethod": "GET",
	//   "id": "doubleclickbidmanager.queries.reports.get",
	//   "parameterOrder": [
	//     "queryId",
	//     "reportId"
	//   ],
	//   "parameters": {
	//     "queryId": {
	//       "description": "Required. ID of the query the report is associated with.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "reportId": {
	//       "description": "Required. ID of the report to retrieve.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "queries/{queryId}/reports/{reportId}",
	//   "response": {
	//     "$ref": "Report"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclickbidmanager"
	//   ]
	// }

}

// method id "doubleclickbidmanager.queries.reports.list":

type QueriesReportsListCall struct {
	s            *Service
	queryId      int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists reports associated with a query.
//
// - queryId: ID of the query with which the reports are associated.
func (r *QueriesReportsService) List(queryId int64) *QueriesReportsListCall {
	c := &QueriesReportsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.queryId = queryId
	return c
}

// OrderBy sets the optional parameter "orderBy": Name of a field used
// to order results. The default sorting order is ascending. To specify
// descending order for a field, append a " desc" suffix. For example
// "key.reportId desc". Sorting is only supported for the following
// fields: * `key.reportId`
func (c *QueriesReportsListCall) OrderBy(orderBy string) *QueriesReportsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results per page. Must be between `1` and `100`. Defaults to `100` if
// unspecified.
func (c *QueriesReportsListCall) PageSize(pageSize int64) *QueriesReportsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous list call. Provide this to retrieve the
// subsequent page of reports.
func (c *QueriesReportsListCall) PageToken(pageToken string) *QueriesReportsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *QueriesReportsListCall) Fields(s ...googleapi.Field) *QueriesReportsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *QueriesReportsListCall) IfNoneMatch(entityTag string) *QueriesReportsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *QueriesReportsListCall) Context(ctx context.Context) *QueriesReportsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *QueriesReportsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *QueriesReportsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "queries/{queryId}/reports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"queryId": strconv.FormatInt(c.queryId, 10),
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "doubleclickbidmanager.queries.reports.list" call.
// Exactly one of *ListReportsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListReportsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *QueriesReportsListCall) Do(opts ...googleapi.CallOption) (*ListReportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListReportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists reports associated with a query.",
	//   "flatPath": "queries/{queryId}/reports",
	//   "httpMethod": "GET",
	//   "id": "doubleclickbidmanager.queries.reports.list",
	//   "parameterOrder": [
	//     "queryId"
	//   ],
	//   "parameters": {
	//     "orderBy": {
	//       "description": "Name of a field used to order results. The default sorting order is ascending. To specify descending order for a field, append a \" desc\" suffix. For example \"key.reportId desc\". Sorting is only supported for the following fields: * `key.reportId`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results per page. Must be between `1` and `100`. Defaults to `100` if unspecified.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous list call. Provide this to retrieve the subsequent page of reports.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "queryId": {
	//       "description": "Required. ID of the query with which the reports are associated.",
	//       "format": "int64",
	//       "location": "path",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "queries/{queryId}/reports",
	//   "response": {
	//     "$ref": "ListReportsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/doubleclickbidmanager"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *QueriesReportsListCall) Pages(ctx context.Context, f func(*ListReportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
