// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/dataproc/logging/autoscaler_log.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The Autoscaler state.
type AutoscalerState int32

const (
	AutoscalerState_AUTOSCALER_STATE_UNSPECIFIED AutoscalerState = 0
	// The Autoscaler is sleeping and waiting for the next update.
	AutoscalerState_COOLDOWN AutoscalerState = 1
	// The Autoscaler is in the process of calculating its recommendation on
	// whether to scale the cluster, and if so, how to autoscale.
	AutoscalerState_RECOMMENDING AutoscalerState = 6
	// The Autoscaler is scaling the cluster.
	AutoscalerState_SCALING AutoscalerState = 2
	// The Autoscaler has stopped.
	AutoscalerState_STOPPED AutoscalerState = 3
	// The Autoscaler has failed.
	AutoscalerState_FAILED AutoscalerState = 4
	// The Autoscaler is initializing.
	AutoscalerState_INITIALIZING AutoscalerState = 5
)

// Enum value maps for AutoscalerState.
var (
	AutoscalerState_name = map[int32]string{
		0: "AUTOSCALER_STATE_UNSPECIFIED",
		1: "COOLDOWN",
		6: "RECOMMENDING",
		2: "SCALING",
		3: "STOPPED",
		4: "FAILED",
		5: "INITIALIZING",
	}
	AutoscalerState_value = map[string]int32{
		"AUTOSCALER_STATE_UNSPECIFIED": 0,
		"COOLDOWN":                     1,
		"RECOMMENDING":                 6,
		"SCALING":                      2,
		"STOPPED":                      3,
		"FAILED":                       4,
		"INITIALIZING":                 5,
	}
)

func (x AutoscalerState) Enum() *AutoscalerState {
	p := new(AutoscalerState)
	*p = x
	return p
}

func (x AutoscalerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalerState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_enumTypes[0].Descriptor()
}

func (AutoscalerState) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_logging_autoscaler_log_proto_enumTypes[0]
}

func (x AutoscalerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalerState.Descriptor instead.
func (AutoscalerState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP(), []int{0}
}

// The Autoscaling decision type.
type ScalingDecisionType int32

const (
	ScalingDecisionType_SCALING_DECISION_TYPE_UNSPECIFIED ScalingDecisionType = 0
	// Increase the number of primary and/or secondary workers.
	ScalingDecisionType_SCALE_UP ScalingDecisionType = 1
	// Decrease the number of primary and/or secondary workers.
	ScalingDecisionType_SCALE_DOWN ScalingDecisionType = 2
	// Not changing the number of primary or secondary workers.
	ScalingDecisionType_NO_SCALE ScalingDecisionType = 3
	// Scale the primary and secondary worker groups in different directions.
	ScalingDecisionType_MIXED ScalingDecisionType = 4
)

// Enum value maps for ScalingDecisionType.
var (
	ScalingDecisionType_name = map[int32]string{
		0: "SCALING_DECISION_TYPE_UNSPECIFIED",
		1: "SCALE_UP",
		2: "SCALE_DOWN",
		3: "NO_SCALE",
		4: "MIXED",
	}
	ScalingDecisionType_value = map[string]int32{
		"SCALING_DECISION_TYPE_UNSPECIFIED": 0,
		"SCALE_UP":                          1,
		"SCALE_DOWN":                        2,
		"NO_SCALE":                          3,
		"MIXED":                             4,
	}
)

func (x ScalingDecisionType) Enum() *ScalingDecisionType {
	p := new(ScalingDecisionType)
	*p = x
	return p
}

func (x ScalingDecisionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScalingDecisionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_enumTypes[1].Descriptor()
}

func (ScalingDecisionType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_logging_autoscaler_log_proto_enumTypes[1]
}

func (x ScalingDecisionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ScalingDecisionType.Descriptor instead.
func (ScalingDecisionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP(), []int{1}
}

type ConstrainingFactor int32

const (
	ConstrainingFactor_CONSTRAINING_FACTOR_UNSPECIFIED ConstrainingFactor = 0
	// The project does not have sufficient regional, global, and or preemptible
	// quota to allocate a new VM.
	ConstrainingFactor_SCALING_CAPPED_DUE_TO_LACK_OF_QUOTA ConstrainingFactor = 1
	// All worker groups have reached maximum size. This message will not be
	// issued if one group reached maximum size, but workers were able to be
	// allocated to another group.
	ConstrainingFactor_REACHED_MAXIMUM_CLUSTER_SIZE ConstrainingFactor = 2
	// All worker groups have reached minimum size. This message will not be
	// issued if workers were able to be removed from another group that had not
	// reached minimum size.
	ConstrainingFactor_REACHED_MINIMUM_CLUSTER_SIZE ConstrainingFactor = 3
)

// Enum value maps for ConstrainingFactor.
var (
	ConstrainingFactor_name = map[int32]string{
		0: "CONSTRAINING_FACTOR_UNSPECIFIED",
		1: "SCALING_CAPPED_DUE_TO_LACK_OF_QUOTA",
		2: "REACHED_MAXIMUM_CLUSTER_SIZE",
		3: "REACHED_MINIMUM_CLUSTER_SIZE",
	}
	ConstrainingFactor_value = map[string]int32{
		"CONSTRAINING_FACTOR_UNSPECIFIED":     0,
		"SCALING_CAPPED_DUE_TO_LACK_OF_QUOTA": 1,
		"REACHED_MAXIMUM_CLUSTER_SIZE":        2,
		"REACHED_MINIMUM_CLUSTER_SIZE":        3,
	}
)

func (x ConstrainingFactor) Enum() *ConstrainingFactor {
	p := new(ConstrainingFactor)
	*p = x
	return p
}

func (x ConstrainingFactor) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConstrainingFactor) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_enumTypes[2].Descriptor()
}

func (ConstrainingFactor) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_logging_autoscaler_log_proto_enumTypes[2]
}

func (x ConstrainingFactor) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConstrainingFactor.Descriptor instead.
func (ConstrainingFactor) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP(), []int{2}
}

// The short version of cluster configuration for Cloud logging.
type ClusterSize struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of primary workers in the cluster.
	PrimaryWorkerCount int32 `protobuf:"varint,1,opt,name=primary_worker_count,json=primaryWorkerCount,proto3" json:"primary_worker_count,omitempty"`
	// The number of secondary workers in the cluster.
	SecondaryWorkerCount int32 `protobuf:"varint,2,opt,name=secondary_worker_count,json=secondaryWorkerCount,proto3" json:"secondary_worker_count,omitempty"`
}

func (x *ClusterSize) Reset() {
	*x = ClusterSize{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterSize) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterSize) ProtoMessage() {}

func (x *ClusterSize) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterSize.ProtoReflect.Descriptor instead.
func (*ClusterSize) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP(), []int{0}
}

func (x *ClusterSize) GetPrimaryWorkerCount() int32 {
	if x != nil {
		return x.PrimaryWorkerCount
	}
	return 0
}

func (x *ClusterSize) GetSecondaryWorkerCount() int32 {
	if x != nil {
		return x.SecondaryWorkerCount
	}
	return 0
}

// The main proto that will be converted to JSON format and then written to
// Logging.
type AutoscalerLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current Autoscaler status.
	Status *AutoscalerStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Optional. The autoscaling recommendation including its inputs, outputs,
	// scaling decision, and detailed explanation.
	Recommendation *AutoscalerRecommendation `protobuf:"bytes,2,opt,name=recommendation,proto3" json:"recommendation,omitempty"`
}

func (x *AutoscalerLog) Reset() {
	*x = AutoscalerLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalerLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalerLog) ProtoMessage() {}

func (x *AutoscalerLog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalerLog.ProtoReflect.Descriptor instead.
func (*AutoscalerLog) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP(), []int{1}
}

func (x *AutoscalerLog) GetStatus() *AutoscalerStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *AutoscalerLog) GetRecommendation() *AutoscalerRecommendation {
	if x != nil {
		return x.Recommendation
	}
	return nil
}

// The Autoscaler's status, including its state and other details.
type AutoscalerStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The high-level Autoscaler state.
	State AutoscalerState `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataproc.logging.AutoscalerState" json:"state,omitempty"`
	// The detailed description of Autoscaler status.
	Details string `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
	// The cluster update operation ID.
	UpdateClusterOperationId string `protobuf:"bytes,3,opt,name=update_cluster_operation_id,json=updateClusterOperationId,proto3" json:"update_cluster_operation_id,omitempty"`
	// Error message from an Autoscaler exception, if any.
	Error string `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *AutoscalerStatus) Reset() {
	*x = AutoscalerStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalerStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalerStatus) ProtoMessage() {}

func (x *AutoscalerStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalerStatus.ProtoReflect.Descriptor instead.
func (*AutoscalerStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP(), []int{2}
}

func (x *AutoscalerStatus) GetState() AutoscalerState {
	if x != nil {
		return x.State
	}
	return AutoscalerState_AUTOSCALER_STATE_UNSPECIFIED
}

func (x *AutoscalerStatus) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

func (x *AutoscalerStatus) GetUpdateClusterOperationId() string {
	if x != nil {
		return x.UpdateClusterOperationId
	}
	return ""
}

func (x *AutoscalerStatus) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// The inputs, outputs, and detailed explanation of the Autoscaling
// recommendation.
type AutoscalerRecommendation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The autoscaling algorithm inputs.
	Inputs *AutoscalerRecommendation_Inputs `protobuf:"bytes,1,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// The algorithm outputs for the recommended cluster size.
	Outputs *AutoscalerRecommendation_Outputs `protobuf:"bytes,2,opt,name=outputs,proto3" json:"outputs,omitempty"`
}

func (x *AutoscalerRecommendation) Reset() {
	*x = AutoscalerRecommendation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalerRecommendation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalerRecommendation) ProtoMessage() {}

func (x *AutoscalerRecommendation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalerRecommendation.ProtoReflect.Descriptor instead.
func (*AutoscalerRecommendation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP(), []int{3}
}

func (x *AutoscalerRecommendation) GetInputs() *AutoscalerRecommendation_Inputs {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *AutoscalerRecommendation) GetOutputs() *AutoscalerRecommendation_Outputs {
	if x != nil {
		return x.Outputs
	}
	return nil
}

// The input values for the Autoscaling recommendation alogirthm.
type AutoscalerRecommendation_Inputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metrics collected by the Dataproc agent running on the cluster.
	// For example, {"avg-yarn-pending-memory": "1040 MB"}
	ClusterMetrics map[string]string `protobuf:"bytes,1,rep,name=cluster_metrics,json=clusterMetrics,proto3" json:"cluster_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The cluster configuration before updating the cluster.
	CurrentClusterSize *ClusterSize `protobuf:"bytes,2,opt,name=current_cluster_size,json=currentClusterSize,proto3" json:"current_cluster_size,omitempty"`
	// The minimum worker counts for each instance group.
	MinWorkerCounts *ClusterSize `protobuf:"bytes,3,opt,name=min_worker_counts,json=minWorkerCounts,proto3" json:"min_worker_counts,omitempty"`
	// The maximum worker counts for each instance group.
	MaxWorkerCounts *ClusterSize `protobuf:"bytes,4,opt,name=max_worker_counts,json=maxWorkerCounts,proto3" json:"max_worker_counts,omitempty"`
}

func (x *AutoscalerRecommendation_Inputs) Reset() {
	*x = AutoscalerRecommendation_Inputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalerRecommendation_Inputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalerRecommendation_Inputs) ProtoMessage() {}

func (x *AutoscalerRecommendation_Inputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalerRecommendation_Inputs.ProtoReflect.Descriptor instead.
func (*AutoscalerRecommendation_Inputs) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP(), []int{3, 0}
}

func (x *AutoscalerRecommendation_Inputs) GetClusterMetrics() map[string]string {
	if x != nil {
		return x.ClusterMetrics
	}
	return nil
}

func (x *AutoscalerRecommendation_Inputs) GetCurrentClusterSize() *ClusterSize {
	if x != nil {
		return x.CurrentClusterSize
	}
	return nil
}

func (x *AutoscalerRecommendation_Inputs) GetMinWorkerCounts() *ClusterSize {
	if x != nil {
		return x.MinWorkerCounts
	}
	return nil
}

func (x *AutoscalerRecommendation_Inputs) GetMaxWorkerCounts() *ClusterSize {
	if x != nil {
		return x.MaxWorkerCounts
	}
	return nil
}

// Autoscaler recommendations.
type AutoscalerRecommendation_Outputs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The high-level autoscaling decision, such as SCALE_UP, SCALE_DOWN,
	// NO_OP.
	Decision ScalingDecisionType `protobuf:"varint,1,opt,name=decision,proto3,enum=google.cloud.dataproc.logging.ScalingDecisionType" json:"decision,omitempty"`
	// The recommended cluster size.
	RecommendedClusterSize *ClusterSize `protobuf:"bytes,2,opt,name=recommended_cluster_size,json=recommendedClusterSize,proto3" json:"recommended_cluster_size,omitempty"`
	// The graceful decommission timeout for downscaling operations.
	GracefulDecommissionTimeout *durationpb.Duration `protobuf:"bytes,3,opt,name=graceful_decommission_timeout,json=gracefulDecommissionTimeout,proto3" json:"graceful_decommission_timeout,omitempty"`
	// Reasons why the Autoscaler didn't add or remove more workers.
	ConstraintsReached []ConstrainingFactor `protobuf:"varint,4,rep,packed,name=constraints_reached,json=constraintsReached,proto3,enum=google.cloud.dataproc.logging.ConstrainingFactor" json:"constraints_reached,omitempty"`
	// Less significant recommendations that are not included in the
	// `AutoscalerStatus.details` message.
	AdditionalRecommendationDetails []string `protobuf:"bytes,5,rep,name=additional_recommendation_details,json=additionalRecommendationDetails,proto3" json:"additional_recommendation_details,omitempty"`
	// A unique id for this recommendation that should be included when opening
	// a support ticket.
	RecommendationId string `protobuf:"bytes,6,opt,name=recommendation_id,json=recommendationId,proto3" json:"recommendation_id,omitempty"`
}

func (x *AutoscalerRecommendation_Outputs) Reset() {
	*x = AutoscalerRecommendation_Outputs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalerRecommendation_Outputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalerRecommendation_Outputs) ProtoMessage() {}

func (x *AutoscalerRecommendation_Outputs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalerRecommendation_Outputs.ProtoReflect.Descriptor instead.
func (*AutoscalerRecommendation_Outputs) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP(), []int{3, 1}
}

func (x *AutoscalerRecommendation_Outputs) GetDecision() ScalingDecisionType {
	if x != nil {
		return x.Decision
	}
	return ScalingDecisionType_SCALING_DECISION_TYPE_UNSPECIFIED
}

func (x *AutoscalerRecommendation_Outputs) GetRecommendedClusterSize() *ClusterSize {
	if x != nil {
		return x.RecommendedClusterSize
	}
	return nil
}

func (x *AutoscalerRecommendation_Outputs) GetGracefulDecommissionTimeout() *durationpb.Duration {
	if x != nil {
		return x.GracefulDecommissionTimeout
	}
	return nil
}

func (x *AutoscalerRecommendation_Outputs) GetConstraintsReached() []ConstrainingFactor {
	if x != nil {
		return x.ConstraintsReached
	}
	return nil
}

func (x *AutoscalerRecommendation_Outputs) GetAdditionalRecommendationDetails() []string {
	if x != nil {
		return x.AdditionalRecommendationDetails
	}
	return nil
}

func (x *AutoscalerRecommendation_Outputs) GetRecommendationId() string {
	if x != nil {
		return x.RecommendationId
	}
	return ""
}

var File_google_cloud_dataproc_logging_autoscaler_log_proto protoreflect.FileDescriptor

var file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x75, 0x0a, 0x0b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xb9, 0x01, 0x0a, 0x0d, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x12, 0x47, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5f, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc7, 0x01, 0x0a, 0x10, 0x41, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x44, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x18, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x22, 0xa4, 0x09, 0x0a, 0x18, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a,
	0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x52, 0x06, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x59, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65,
	0x72, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x1a, 0xd6, 0x03, 0x0a, 0x06, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x7b, 0x0a, 0x0f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x5c, 0x0a, 0x14, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x69,
	0x7a, 0x65, 0x52, 0x12, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x56, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x5f, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x0f, 0x6d,
	0x69, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x56,
	0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x1a, 0x41, 0x0a, 0x13, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xfb, 0x03, 0x0a, 0x07, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x4e, 0x0a, 0x08, 0x64, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x44,
	0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x65, 0x63,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x18, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53,
	0x69, 0x7a, 0x65, 0x52, 0x16, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x5d, 0x0a, 0x1d, 0x67,
	0x72, 0x61, 0x63, 0x65, 0x66, 0x75, 0x6c, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1b, 0x67,
	0x72, 0x61, 0x63, 0x65, 0x66, 0x75, 0x6c, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x62, 0x0a, 0x13, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x61, 0x63, 0x68, 0x65, 0x64, 0x12, 0x4a,
	0x0a, 0x21, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1f, 0x61, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x2a, 0x8b, 0x01, 0x0a, 0x0f, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x41,
	0x55, 0x54, 0x4f, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x4f, 0x4f, 0x4c, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x52,
	0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x0b, 0x0a,
	0x07, 0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54,
	0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a,
	0x49, 0x4e, 0x47, 0x10, 0x05, 0x2a, 0x73, 0x0a, 0x13, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x44, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21,
	0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x43, 0x49, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x5f, 0x55, 0x50, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x5f, 0x44, 0x4f, 0x57, 0x4e, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x10, 0x03, 0x12,
	0x09, 0x0a, 0x05, 0x4d, 0x49, 0x58, 0x45, 0x44, 0x10, 0x04, 0x2a, 0xa6, 0x01, 0x0a, 0x12, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x23, 0x0a, 0x1f, 0x43, 0x4f, 0x4e, 0x53, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e,
	0x47, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x27, 0x0a, 0x23, 0x53, 0x43, 0x41, 0x4c, 0x49, 0x4e,
	0x47, 0x5f, 0x43, 0x41, 0x50, 0x50, 0x45, 0x44, 0x5f, 0x44, 0x55, 0x45, 0x5f, 0x54, 0x4f, 0x5f,
	0x4c, 0x41, 0x43, 0x4b, 0x5f, 0x4f, 0x46, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x10, 0x01, 0x12,
	0x20, 0x0a, 0x1c, 0x52, 0x45, 0x41, 0x43, 0x48, 0x45, 0x44, 0x5f, 0x4d, 0x41, 0x58, 0x49, 0x4d,
	0x55, 0x4d, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x10,
	0x02, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x41, 0x43, 0x48, 0x45, 0x44, 0x5f, 0x4d, 0x49, 0x4e,
	0x49, 0x4d, 0x55, 0x4d, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a,
	0x45, 0x10, 0x03, 0x42, 0x6b, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescOnce sync.Once
	file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescData = file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDesc
)

func file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescGZIP() []byte {
	file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescData)
	})
	return file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDescData
}

var file_google_cloud_dataproc_logging_autoscaler_log_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_dataproc_logging_autoscaler_log_proto_goTypes = []interface{}{
	(AutoscalerState)(0),                     // 0: google.cloud.dataproc.logging.AutoscalerState
	(ScalingDecisionType)(0),                 // 1: google.cloud.dataproc.logging.ScalingDecisionType
	(ConstrainingFactor)(0),                  // 2: google.cloud.dataproc.logging.ConstrainingFactor
	(*ClusterSize)(nil),                      // 3: google.cloud.dataproc.logging.ClusterSize
	(*AutoscalerLog)(nil),                    // 4: google.cloud.dataproc.logging.AutoscalerLog
	(*AutoscalerStatus)(nil),                 // 5: google.cloud.dataproc.logging.AutoscalerStatus
	(*AutoscalerRecommendation)(nil),         // 6: google.cloud.dataproc.logging.AutoscalerRecommendation
	(*AutoscalerRecommendation_Inputs)(nil),  // 7: google.cloud.dataproc.logging.AutoscalerRecommendation.Inputs
	(*AutoscalerRecommendation_Outputs)(nil), // 8: google.cloud.dataproc.logging.AutoscalerRecommendation.Outputs
	nil,                                      // 9: google.cloud.dataproc.logging.AutoscalerRecommendation.Inputs.ClusterMetricsEntry
	(*durationpb.Duration)(nil),              // 10: google.protobuf.Duration
}
var file_google_cloud_dataproc_logging_autoscaler_log_proto_depIdxs = []int32{
	5,  // 0: google.cloud.dataproc.logging.AutoscalerLog.status:type_name -> google.cloud.dataproc.logging.AutoscalerStatus
	6,  // 1: google.cloud.dataproc.logging.AutoscalerLog.recommendation:type_name -> google.cloud.dataproc.logging.AutoscalerRecommendation
	0,  // 2: google.cloud.dataproc.logging.AutoscalerStatus.state:type_name -> google.cloud.dataproc.logging.AutoscalerState
	7,  // 3: google.cloud.dataproc.logging.AutoscalerRecommendation.inputs:type_name -> google.cloud.dataproc.logging.AutoscalerRecommendation.Inputs
	8,  // 4: google.cloud.dataproc.logging.AutoscalerRecommendation.outputs:type_name -> google.cloud.dataproc.logging.AutoscalerRecommendation.Outputs
	9,  // 5: google.cloud.dataproc.logging.AutoscalerRecommendation.Inputs.cluster_metrics:type_name -> google.cloud.dataproc.logging.AutoscalerRecommendation.Inputs.ClusterMetricsEntry
	3,  // 6: google.cloud.dataproc.logging.AutoscalerRecommendation.Inputs.current_cluster_size:type_name -> google.cloud.dataproc.logging.ClusterSize
	3,  // 7: google.cloud.dataproc.logging.AutoscalerRecommendation.Inputs.min_worker_counts:type_name -> google.cloud.dataproc.logging.ClusterSize
	3,  // 8: google.cloud.dataproc.logging.AutoscalerRecommendation.Inputs.max_worker_counts:type_name -> google.cloud.dataproc.logging.ClusterSize
	1,  // 9: google.cloud.dataproc.logging.AutoscalerRecommendation.Outputs.decision:type_name -> google.cloud.dataproc.logging.ScalingDecisionType
	3,  // 10: google.cloud.dataproc.logging.AutoscalerRecommendation.Outputs.recommended_cluster_size:type_name -> google.cloud.dataproc.logging.ClusterSize
	10, // 11: google.cloud.dataproc.logging.AutoscalerRecommendation.Outputs.graceful_decommission_timeout:type_name -> google.protobuf.Duration
	2,  // 12: google.cloud.dataproc.logging.AutoscalerRecommendation.Outputs.constraints_reached:type_name -> google.cloud.dataproc.logging.ConstrainingFactor
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_dataproc_logging_autoscaler_log_proto_init() }
func file_google_cloud_dataproc_logging_autoscaler_log_proto_init() {
	if File_google_cloud_dataproc_logging_autoscaler_log_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterSize); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoscalerLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoscalerStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoscalerRecommendation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoscalerRecommendation_Inputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoscalerRecommendation_Outputs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataproc_logging_autoscaler_log_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataproc_logging_autoscaler_log_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataproc_logging_autoscaler_log_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataproc_logging_autoscaler_log_proto_msgTypes,
	}.Build()
	File_google_cloud_dataproc_logging_autoscaler_log_proto = out.File
	file_google_cloud_dataproc_logging_autoscaler_log_proto_rawDesc = nil
	file_google_cloud_dataproc_logging_autoscaler_log_proto_goTypes = nil
	file_google_cloud_dataproc_logging_autoscaler_log_proto_depIdxs = nil
}
