package cataloger

import (
	"slices"

	"github.com/anchore/syft/syft/artifact"
	"github.com/anchore/syft/syft/pkg"
)

var (
	osCatalogerTypes = []pkg.Type{
		pkg.AlpmPkg,
		pkg.ApkPkg,
		pkg.DebPkg,
		pkg.NixPkg,
		pkg.PortagePkg,
		pkg.RpmPkg,
	}
	binaryCatalogerTypes = []pkg.Type{
		pkg.BinaryPkg,
	}
)

// ExcludeBinaryByFileOwnershipOverlap will remove packages from a collection given the following properties are true
// 1) the relationship between packages is OwnershipByFileOverlap
// 2) the parent is an "os" package
// 3) the child is a synthetic package generated by the binary cataloger
// 4) the package names are identical
// This was implemented as a way to help resolve: https://github.com/anchore/syft/issues/931
func ExcludeBinaryByFileOwnershipOverlap(r artifact.Relationship, c *pkg.Collection) bool {
	if artifact.OwnershipByFileOverlapRelationship != r.Type {
		return false
	}

	parent := c.Package(r.From.ID())
	if parent == nil {
		return false
	}

	parentInExclusion := slices.Contains(osCatalogerTypes, parent.Type)
	if !parentInExclusion {
		return false
	}

	child := c.Package(r.To.ID())
	if child == nil {
		return false
	}

	return slices.Contains(binaryCatalogerTypes, child.Type)
}
