// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package simspaceweaver

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshot for more information on using the CreateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSnapshotRequest method.
//	req, resp := client.CreateSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/CreateSnapshot
func (c *SimSpaceWeaver) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/createsnapshot",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &CreateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateSnapshot API operation for AWS SimSpace Weaver.
//
// Creates a snapshot of the specified simulation. A snapshot is a file that
// contains simulation state data at a specific time. The state data saved in
// a snapshot includes entity data from the State Fabric, the simulation configuration
// specified in the schema, and the clock tick number. You can use the snapshot
// to initialize a new simulation. For more information about snapshots, see
// Snapshots (https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html)
// in the SimSpace Weaver User Guide.
//
// You specify a Destination when you create a snapshot. The Destination is
// the name of an Amazon S3 bucket and an optional ObjectKeyPrefix. The ObjectKeyPrefix
// is usually the name of a folder in the bucket. SimSpace Weaver creates a
// snapshot folder inside the Destination and places the snapshot file there.
//
// The snapshot file is an Amazon S3 object. It has an object key with the form:
// object-key-prefix/snapshot/simulation-name-YYMMdd-HHmm-ss.zip, where:
//
//   - YY is the 2-digit year
//
//   - MM is the 2-digit month
//
//   - dd is the 2-digit day of the month
//
//   - HH is the 2-digit hour (24-hour clock)
//
//   - mm is the 2-digit minutes
//
//   - ss is the 2-digit seconds
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/CreateSnapshot
func (c *SimSpaceWeaver) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppRequest method.
//	req, resp := client.DeleteAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteApp
func (c *SimSpaceWeaver) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "DELETE",
		HTTPPath:   "/deleteapp",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApp API operation for AWS SimSpace Weaver.
//
// Deletes the instance of the given custom app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation DeleteApp for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteApp
func (c *SimSpaceWeaver) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSimulation = "DeleteSimulation"

// DeleteSimulationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSimulation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSimulation for more information on using the DeleteSimulation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSimulationRequest method.
//	req, resp := client.DeleteSimulationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteSimulation
func (c *SimSpaceWeaver) DeleteSimulationRequest(input *DeleteSimulationInput) (req *request.Request, output *DeleteSimulationOutput) {
	op := &request.Operation{
		Name:       opDeleteSimulation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/deletesimulation",
	}

	if input == nil {
		input = &DeleteSimulationInput{}
	}

	output = &DeleteSimulationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSimulation API operation for AWS SimSpace Weaver.
//
// Deletes all SimSpace Weaver resources assigned to the given simulation.
//
// Your simulation uses resources in other Amazon Web Services. This API operation
// doesn't delete resources in other Amazon Web Services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation DeleteSimulation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DeleteSimulation
func (c *SimSpaceWeaver) DeleteSimulation(input *DeleteSimulationInput) (*DeleteSimulationOutput, error) {
	req, out := c.DeleteSimulationRequest(input)
	return out, req.Send()
}

// DeleteSimulationWithContext is the same as DeleteSimulation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSimulation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) DeleteSimulationWithContext(ctx aws.Context, input *DeleteSimulationInput, opts ...request.Option) (*DeleteSimulationOutput, error) {
	req, out := c.DeleteSimulationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApp = "DescribeApp"

// DescribeAppRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApp for more information on using the DescribeApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppRequest method.
//	req, resp := client.DescribeAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeApp
func (c *SimSpaceWeaver) DescribeAppRequest(input *DescribeAppInput) (req *request.Request, output *DescribeAppOutput) {
	op := &request.Operation{
		Name:       opDescribeApp,
		HTTPMethod: "GET",
		HTTPPath:   "/describeapp",
	}

	if input == nil {
		input = &DescribeAppInput{}
	}

	output = &DescribeAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApp API operation for AWS SimSpace Weaver.
//
// Returns the state of the given custom app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation DescribeApp for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeApp
func (c *SimSpaceWeaver) DescribeApp(input *DescribeAppInput) (*DescribeAppOutput, error) {
	req, out := c.DescribeAppRequest(input)
	return out, req.Send()
}

// DescribeAppWithContext is the same as DescribeApp with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) DescribeAppWithContext(ctx aws.Context, input *DescribeAppInput, opts ...request.Option) (*DescribeAppOutput, error) {
	req, out := c.DescribeAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSimulation = "DescribeSimulation"

// DescribeSimulationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSimulation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSimulation for more information on using the DescribeSimulation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSimulationRequest method.
//	req, resp := client.DescribeSimulationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeSimulation
func (c *SimSpaceWeaver) DescribeSimulationRequest(input *DescribeSimulationInput) (req *request.Request, output *DescribeSimulationOutput) {
	op := &request.Operation{
		Name:       opDescribeSimulation,
		HTTPMethod: "GET",
		HTTPPath:   "/describesimulation",
	}

	if input == nil {
		input = &DescribeSimulationInput{}
	}

	output = &DescribeSimulationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSimulation API operation for AWS SimSpace Weaver.
//
// Returns the current state of the given simulation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation DescribeSimulation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/DescribeSimulation
func (c *SimSpaceWeaver) DescribeSimulation(input *DescribeSimulationInput) (*DescribeSimulationOutput, error) {
	req, out := c.DescribeSimulationRequest(input)
	return out, req.Send()
}

// DescribeSimulationWithContext is the same as DescribeSimulation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSimulation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) DescribeSimulationWithContext(ctx aws.Context, input *DescribeSimulationInput, opts ...request.Option) (*DescribeSimulationOutput, error) {
	req, out := c.DescribeSimulationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApps = "ListApps"

// ListAppsRequest generates a "aws/request.Request" representing the
// client's request for the ListApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApps for more information on using the ListApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppsRequest method.
//	req, resp := client.ListAppsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps
func (c *SimSpaceWeaver) ListAppsRequest(input *ListAppsInput) (req *request.Request, output *ListAppsOutput) {
	op := &request.Operation{
		Name:       opListApps,
		HTTPMethod: "GET",
		HTTPPath:   "/listapps",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppsInput{}
	}

	output = &ListAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApps API operation for AWS SimSpace Weaver.
//
// Lists all custom apps or service apps for the given simulation and domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation ListApps for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListApps
func (c *SimSpaceWeaver) ListApps(input *ListAppsInput) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	return out, req.Send()
}

// ListAppsWithContext is the same as ListApps with the addition of
// the ability to pass a context and additional request options.
//
// See ListApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) ListAppsWithContext(ctx aws.Context, input *ListAppsInput, opts ...request.Option) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppsPages iterates over the pages of a ListApps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApps operation.
//	pageNum := 0
//	err := client.ListAppsPages(params,
//	    func(page *simspaceweaver.ListAppsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SimSpaceWeaver) ListAppsPages(input *ListAppsInput, fn func(*ListAppsOutput, bool) bool) error {
	return c.ListAppsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppsPagesWithContext same as ListAppsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) ListAppsPagesWithContext(ctx aws.Context, input *ListAppsInput, fn func(*ListAppsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSimulations = "ListSimulations"

// ListSimulationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSimulations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSimulations for more information on using the ListSimulations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSimulationsRequest method.
//	req, resp := client.ListSimulationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations
func (c *SimSpaceWeaver) ListSimulationsRequest(input *ListSimulationsInput) (req *request.Request, output *ListSimulationsOutput) {
	op := &request.Operation{
		Name:       opListSimulations,
		HTTPMethod: "GET",
		HTTPPath:   "/listsimulations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSimulationsInput{}
	}

	output = &ListSimulationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSimulations API operation for AWS SimSpace Weaver.
//
// Lists the SimSpace Weaver simulations in the Amazon Web Services account
// used to make the API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation ListSimulations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListSimulations
func (c *SimSpaceWeaver) ListSimulations(input *ListSimulationsInput) (*ListSimulationsOutput, error) {
	req, out := c.ListSimulationsRequest(input)
	return out, req.Send()
}

// ListSimulationsWithContext is the same as ListSimulations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSimulations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) ListSimulationsWithContext(ctx aws.Context, input *ListSimulationsInput, opts ...request.Option) (*ListSimulationsOutput, error) {
	req, out := c.ListSimulationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSimulationsPages iterates over the pages of a ListSimulations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSimulations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSimulations operation.
//	pageNum := 0
//	err := client.ListSimulationsPages(params,
//	    func(page *simspaceweaver.ListSimulationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SimSpaceWeaver) ListSimulationsPages(input *ListSimulationsInput, fn func(*ListSimulationsOutput, bool) bool) error {
	return c.ListSimulationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSimulationsPagesWithContext same as ListSimulationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) ListSimulationsPagesWithContext(ctx aws.Context, input *ListSimulationsInput, fn func(*ListSimulationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSimulationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSimulationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSimulationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListTagsForResource
func (c *SimSpaceWeaver) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS SimSpace Weaver.
//
// Lists all tags on a SimSpace Weaver resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/ListTagsForResource
func (c *SimSpaceWeaver) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartApp = "StartApp"

// StartAppRequest generates a "aws/request.Request" representing the
// client's request for the StartApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartApp for more information on using the StartApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAppRequest method.
//	req, resp := client.StartAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartApp
func (c *SimSpaceWeaver) StartAppRequest(input *StartAppInput) (req *request.Request, output *StartAppOutput) {
	op := &request.Operation{
		Name:       opStartApp,
		HTTPMethod: "POST",
		HTTPPath:   "/startapp",
	}

	if input == nil {
		input = &StartAppInput{}
	}

	output = &StartAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartApp API operation for AWS SimSpace Weaver.
//
// Starts a custom app with the configuration specified in the simulation schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation StartApp for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartApp
func (c *SimSpaceWeaver) StartApp(input *StartAppInput) (*StartAppOutput, error) {
	req, out := c.StartAppRequest(input)
	return out, req.Send()
}

// StartAppWithContext is the same as StartApp with the addition of
// the ability to pass a context and additional request options.
//
// See StartApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) StartAppWithContext(ctx aws.Context, input *StartAppInput, opts ...request.Option) (*StartAppOutput, error) {
	req, out := c.StartAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartClock = "StartClock"

// StartClockRequest generates a "aws/request.Request" representing the
// client's request for the StartClock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartClock for more information on using the StartClock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartClockRequest method.
//	req, resp := client.StartClockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartClock
func (c *SimSpaceWeaver) StartClockRequest(input *StartClockInput) (req *request.Request, output *StartClockOutput) {
	op := &request.Operation{
		Name:       opStartClock,
		HTTPMethod: "POST",
		HTTPPath:   "/startclock",
	}

	if input == nil {
		input = &StartClockInput{}
	}

	output = &StartClockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartClock API operation for AWS SimSpace Weaver.
//
// Starts the simulation clock.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation StartClock for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartClock
func (c *SimSpaceWeaver) StartClock(input *StartClockInput) (*StartClockOutput, error) {
	req, out := c.StartClockRequest(input)
	return out, req.Send()
}

// StartClockWithContext is the same as StartClock with the addition of
// the ability to pass a context and additional request options.
//
// See StartClock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) StartClockWithContext(ctx aws.Context, input *StartClockInput, opts ...request.Option) (*StartClockOutput, error) {
	req, out := c.StartClockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSimulation = "StartSimulation"

// StartSimulationRequest generates a "aws/request.Request" representing the
// client's request for the StartSimulation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSimulation for more information on using the StartSimulation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartSimulationRequest method.
//	req, resp := client.StartSimulationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartSimulation
func (c *SimSpaceWeaver) StartSimulationRequest(input *StartSimulationInput) (req *request.Request, output *StartSimulationOutput) {
	op := &request.Operation{
		Name:       opStartSimulation,
		HTTPMethod: "POST",
		HTTPPath:   "/startsimulation",
	}

	if input == nil {
		input = &StartSimulationInput{}
	}

	output = &StartSimulationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSimulation API operation for AWS SimSpace Weaver.
//
// Starts a simulation with the given name. You must choose to start your simulation
// from a schema or from a snapshot. For more information about the schema,
// see the schema reference (https://docs.aws.amazon.com/simspaceweaver/latest/userguide/schema-reference.html)
// in the SimSpace Weaver User Guide. For more information about snapshots,
// see Snapshots (https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_snapshots.html)
// in the SimSpace Weaver User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation StartSimulation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StartSimulation
func (c *SimSpaceWeaver) StartSimulation(input *StartSimulationInput) (*StartSimulationOutput, error) {
	req, out := c.StartSimulationRequest(input)
	return out, req.Send()
}

// StartSimulationWithContext is the same as StartSimulation with the addition of
// the ability to pass a context and additional request options.
//
// See StartSimulation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) StartSimulationWithContext(ctx aws.Context, input *StartSimulationInput, opts ...request.Option) (*StartSimulationOutput, error) {
	req, out := c.StartSimulationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopApp = "StopApp"

// StopAppRequest generates a "aws/request.Request" representing the
// client's request for the StopApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopApp for more information on using the StopApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopAppRequest method.
//	req, resp := client.StopAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopApp
func (c *SimSpaceWeaver) StopAppRequest(input *StopAppInput) (req *request.Request, output *StopAppOutput) {
	op := &request.Operation{
		Name:       opStopApp,
		HTTPMethod: "POST",
		HTTPPath:   "/stopapp",
	}

	if input == nil {
		input = &StopAppInput{}
	}

	output = &StopAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopApp API operation for AWS SimSpace Weaver.
//
// Stops the given custom app and shuts down all of its allocated compute resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation StopApp for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopApp
func (c *SimSpaceWeaver) StopApp(input *StopAppInput) (*StopAppOutput, error) {
	req, out := c.StopAppRequest(input)
	return out, req.Send()
}

// StopAppWithContext is the same as StopApp with the addition of
// the ability to pass a context and additional request options.
//
// See StopApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) StopAppWithContext(ctx aws.Context, input *StopAppInput, opts ...request.Option) (*StopAppOutput, error) {
	req, out := c.StopAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopClock = "StopClock"

// StopClockRequest generates a "aws/request.Request" representing the
// client's request for the StopClock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopClock for more information on using the StopClock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopClockRequest method.
//	req, resp := client.StopClockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopClock
func (c *SimSpaceWeaver) StopClockRequest(input *StopClockInput) (req *request.Request, output *StopClockOutput) {
	op := &request.Operation{
		Name:       opStopClock,
		HTTPMethod: "POST",
		HTTPPath:   "/stopclock",
	}

	if input == nil {
		input = &StopClockInput{}
	}

	output = &StopClockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopClock API operation for AWS SimSpace Weaver.
//
// Stops the simulation clock.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation StopClock for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopClock
func (c *SimSpaceWeaver) StopClock(input *StopClockInput) (*StopClockOutput, error) {
	req, out := c.StopClockRequest(input)
	return out, req.Send()
}

// StopClockWithContext is the same as StopClock with the addition of
// the ability to pass a context and additional request options.
//
// See StopClock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) StopClockWithContext(ctx aws.Context, input *StopClockInput, opts ...request.Option) (*StopClockOutput, error) {
	req, out := c.StopClockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopSimulation = "StopSimulation"

// StopSimulationRequest generates a "aws/request.Request" representing the
// client's request for the StopSimulation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopSimulation for more information on using the StopSimulation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopSimulationRequest method.
//	req, resp := client.StopSimulationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopSimulation
func (c *SimSpaceWeaver) StopSimulationRequest(input *StopSimulationInput) (req *request.Request, output *StopSimulationOutput) {
	op := &request.Operation{
		Name:       opStopSimulation,
		HTTPMethod: "POST",
		HTTPPath:   "/stopsimulation",
	}

	if input == nil {
		input = &StopSimulationInput{}
	}

	output = &StopSimulationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopSimulation API operation for AWS SimSpace Weaver.
//
// Stops the given simulation.
//
// You can't restart a simulation after you stop it. If you want to restart
// a simulation, then you must stop it, delete it, and start a new instance
// of it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation StopSimulation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - InternalServerException
//
//   - AccessDeniedException
//
//   - ValidationException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/StopSimulation
func (c *SimSpaceWeaver) StopSimulation(input *StopSimulationInput) (*StopSimulationOutput, error) {
	req, out := c.StopSimulationRequest(input)
	return out, req.Send()
}

// StopSimulationWithContext is the same as StopSimulation with the addition of
// the ability to pass a context and additional request options.
//
// See StopSimulation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) StopSimulationWithContext(ctx aws.Context, input *StopSimulationInput, opts ...request.Option) (*StopSimulationOutput, error) {
	req, out := c.StopSimulationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/TagResource
func (c *SimSpaceWeaver) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS SimSpace Weaver.
//
// Adds tags to a SimSpace Weaver resource. For more information about tags,
// see Tagging Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - TooManyTagsException
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/TagResource
func (c *SimSpaceWeaver) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/UntagResource
func (c *SimSpaceWeaver) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS SimSpace Weaver.
//
// Removes tags from a SimSpace Weaver resource. For more information about
// tags, see Tagging Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SimSpace Weaver's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/simspaceweaver-2022-10-28/UntagResource
func (c *SimSpaceWeaver) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimSpaceWeaver) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon CloudWatch Logs log group for the simulation. For more information
// about log groups, see Working with log groups and log streams (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html)
// in the Amazon CloudWatch Logs User Guide.
type CloudWatchLogsLogGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log group for
	// the simulation. For more information about ARNs, see Amazon Resource Names
	// (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference. For more information about
	// log groups, see Working with log groups and log streams (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html)
	// in the Amazon CloudWatch Logs User Guide.
	LogGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsLogGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogsLogGroup) GoString() string {
	return s.String()
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *CloudWatchLogsLogGroup) SetLogGroupArn(v string) *CloudWatchLogsLogGroup {
	s.LogGroupArn = &v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket and optional folder (object key prefix) where SimSpace
	// Weaver creates the snapshot file.
	//
	// The Amazon S3 bucket must be in the same Amazon Web Services Region as the
	// simulation.
	//
	// Destination is a required field
	Destination *S3Destination `type:"structure" required:"true"`

	// The name of the simulation.
	//
	// Simulation is a required field
	Simulation *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *CreateSnapshotInput) SetDestination(v *S3Destination) *CreateSnapshotInput {
	s.Destination = v
	return s
}

// SetSimulation sets the Simulation field's value.
func (s *CreateSnapshotInput) SetSimulation(v string) *CreateSnapshotInput {
	s.Simulation = &v
	return s
}

type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

type DeleteAppInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the app.
	//
	// App is a required field
	App *string `location:"querystring" locationName:"app" min:"1" type:"string" required:"true"`

	// The name of the domain of the app.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the simulation of the app.
	//
	// Simulation is a required field
	Simulation *string `location:"querystring" locationName:"simulation" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInput"}
	if s.App == nil {
		invalidParams.Add(request.NewErrParamRequired("App"))
	}
	if s.App != nil && len(*s.App) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("App", 1))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApp sets the App field's value.
func (s *DeleteAppInput) SetApp(v string) *DeleteAppInput {
	s.App = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DeleteAppInput) SetDomain(v string) *DeleteAppInput {
	s.Domain = &v
	return s
}

// SetSimulation sets the Simulation field's value.
func (s *DeleteAppInput) SetSimulation(v string) *DeleteAppInput {
	s.Simulation = &v
	return s
}

type DeleteAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

type DeleteSimulationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the simulation.
	//
	// Simulation is a required field
	Simulation *string `location:"querystring" locationName:"simulation" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSimulationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSimulationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSimulationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSimulationInput"}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSimulation sets the Simulation field's value.
func (s *DeleteSimulationInput) SetSimulation(v string) *DeleteSimulationInput {
	s.Simulation = &v
	return s
}

type DeleteSimulationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSimulationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSimulationOutput) GoString() string {
	return s.String()
}

type DescribeAppInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the app.
	//
	// App is a required field
	App *string `location:"querystring" locationName:"app" min:"1" type:"string" required:"true"`

	// The name of the domain of the app.
	//
	// Domain is a required field
	Domain *string `location:"querystring" locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the simulation of the app.
	//
	// Simulation is a required field
	Simulation *string `location:"querystring" locationName:"simulation" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAppInput"}
	if s.App == nil {
		invalidParams.Add(request.NewErrParamRequired("App"))
	}
	if s.App != nil && len(*s.App) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("App", 1))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApp sets the App field's value.
func (s *DescribeAppInput) SetApp(v string) *DescribeAppInput {
	s.App = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribeAppInput) SetDomain(v string) *DescribeAppInput {
	s.Domain = &v
	return s
}

// SetSimulation sets the Simulation field's value.
func (s *DescribeAppInput) SetSimulation(v string) *DescribeAppInput {
	s.Simulation = &v
	return s
}

type DescribeAppOutput struct {
	_ struct{} `type:"structure"`

	// The description of the app.
	Description *string `type:"string"`

	// The name of the domain of the app.
	Domain *string `min:"1" type:"string"`

	// Information about the network endpoint for the custom app. You can use the
	// endpoint to connect to the custom app.
	EndpointInfo *SimulationAppEndpointInfo `type:"structure"`

	// Options that apply when the app starts. These options override default behavior.
	LaunchOverrides *LaunchOverrides `type:"structure"`

	// The name of the app.
	Name *string `min:"1" type:"string"`

	// The name of the simulation of the app.
	Simulation *string `min:"1" type:"string"`

	// The current lifecycle state of the custom app.
	Status *string `type:"string" enum:"SimulationAppStatus"`

	// The desired lifecycle state of the custom app.
	TargetStatus *string `type:"string" enum:"SimulationAppTargetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAppOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DescribeAppOutput) SetDescription(v string) *DescribeAppOutput {
	s.Description = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribeAppOutput) SetDomain(v string) *DescribeAppOutput {
	s.Domain = &v
	return s
}

// SetEndpointInfo sets the EndpointInfo field's value.
func (s *DescribeAppOutput) SetEndpointInfo(v *SimulationAppEndpointInfo) *DescribeAppOutput {
	s.EndpointInfo = v
	return s
}

// SetLaunchOverrides sets the LaunchOverrides field's value.
func (s *DescribeAppOutput) SetLaunchOverrides(v *LaunchOverrides) *DescribeAppOutput {
	s.LaunchOverrides = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeAppOutput) SetName(v string) *DescribeAppOutput {
	s.Name = &v
	return s
}

// SetSimulation sets the Simulation field's value.
func (s *DescribeAppOutput) SetSimulation(v string) *DescribeAppOutput {
	s.Simulation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAppOutput) SetStatus(v string) *DescribeAppOutput {
	s.Status = &v
	return s
}

// SetTargetStatus sets the TargetStatus field's value.
func (s *DescribeAppOutput) SetTargetStatus(v string) *DescribeAppOutput {
	s.TargetStatus = &v
	return s
}

type DescribeSimulationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the simulation.
	//
	// Simulation is a required field
	Simulation *string `location:"querystring" locationName:"simulation" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSimulationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSimulationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSimulationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSimulationInput"}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSimulation sets the Simulation field's value.
func (s *DescribeSimulationInput) SetSimulation(v string) *DescribeSimulationInput {
	s.Simulation = &v
	return s
}

type DescribeSimulationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation. For more information about
	// ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	Arn *string `type:"string"`

	// The time when the simulation was created, expressed as the number of seconds
	// and milliseconds in UTC since the Unix epoch (0:0:0.000, January 1, 1970).
	CreationTime *time.Time `type:"timestamp"`

	// The description of the simulation.
	Description *string `type:"string"`

	// A universally unique identifier (UUID) for this simulation.
	ExecutionId *string `min:"36" type:"string"`

	// A collection of additional state information, such as domain and clock configuration.
	LiveSimulationState *LiveSimulationState `type:"structure"`

	// Settings that control how SimSpace Weaver handles your simulation log data.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`

	// The maximum running time of the simulation, specified as a number of minutes
	// (m or M), hours (h or H), or days (d or D). The simulation stops when it
	// reaches this limit. The maximum value is 14D, or its equivalent in the other
	// units. The default value is 14D. A value equivalent to 0 makes the simulation
	// immediately transition to Stopping as soon as it reaches Started.
	MaximumDuration *string `min:"2" type:"string"`

	// The name of the simulation.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role that the simulation assumes to perform actions. For more information
	// about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference. For more information about
	// IAM roles, see IAM roles (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html)
	// in the Identity and Access Management User Guide.
	RoleArn *string `type:"string"`

	// An error message that SimSpace Weaver returns only if there is a problem
	// with the simulation schema.
	//
	// Deprecated: SchemaError is no longer used, check StartError instead.
	SchemaError *string `deprecated:"true" type:"string"`

	// The location of the simulation schema in Amazon Simple Storage Service (Amazon
	// S3). For more information about Amazon S3, see the Amazon Simple Storage
	// Service User Guide (https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
	SchemaS3Location *S3Location `type:"structure"`

	// A location in Amazon Simple Storage Service (Amazon S3) where SimSpace Weaver
	// stores simulation data, such as your app .zip files and schema file. For
	// more information about Amazon S3, see the Amazon Simple Storage Service User
	// Guide (https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
	SnapshotS3Location *S3Location `type:"structure"`

	// An error message that SimSpace Weaver returns only if a problem occurs when
	// the simulation is in the STARTING state.
	StartError *string `type:"string"`

	// The current lifecycle state of the simulation.
	Status *string `type:"string" enum:"SimulationStatus"`

	// The desired lifecycle state of the simulation.
	TargetStatus *string `type:"string" enum:"SimulationTargetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSimulationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSimulationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeSimulationOutput) SetArn(v string) *DescribeSimulationOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeSimulationOutput) SetCreationTime(v time.Time) *DescribeSimulationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeSimulationOutput) SetDescription(v string) *DescribeSimulationOutput {
	s.Description = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *DescribeSimulationOutput) SetExecutionId(v string) *DescribeSimulationOutput {
	s.ExecutionId = &v
	return s
}

// SetLiveSimulationState sets the LiveSimulationState field's value.
func (s *DescribeSimulationOutput) SetLiveSimulationState(v *LiveSimulationState) *DescribeSimulationOutput {
	s.LiveSimulationState = v
	return s
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *DescribeSimulationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *DescribeSimulationOutput {
	s.LoggingConfiguration = v
	return s
}

// SetMaximumDuration sets the MaximumDuration field's value.
func (s *DescribeSimulationOutput) SetMaximumDuration(v string) *DescribeSimulationOutput {
	s.MaximumDuration = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeSimulationOutput) SetName(v string) *DescribeSimulationOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeSimulationOutput) SetRoleArn(v string) *DescribeSimulationOutput {
	s.RoleArn = &v
	return s
}

// SetSchemaError sets the SchemaError field's value.
func (s *DescribeSimulationOutput) SetSchemaError(v string) *DescribeSimulationOutput {
	s.SchemaError = &v
	return s
}

// SetSchemaS3Location sets the SchemaS3Location field's value.
func (s *DescribeSimulationOutput) SetSchemaS3Location(v *S3Location) *DescribeSimulationOutput {
	s.SchemaS3Location = v
	return s
}

// SetSnapshotS3Location sets the SnapshotS3Location field's value.
func (s *DescribeSimulationOutput) SetSnapshotS3Location(v *S3Location) *DescribeSimulationOutput {
	s.SnapshotS3Location = v
	return s
}

// SetStartError sets the StartError field's value.
func (s *DescribeSimulationOutput) SetStartError(v string) *DescribeSimulationOutput {
	s.StartError = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeSimulationOutput) SetStatus(v string) *DescribeSimulationOutput {
	s.Status = &v
	return s
}

// SetTargetStatus sets the TargetStatus field's value.
func (s *DescribeSimulationOutput) SetTargetStatus(v string) *DescribeSimulationOutput {
	s.TargetStatus = &v
	return s
}

// A collection of app instances that run the same executable app code and have
// the same launch options and commands.
//
// For more information about domains, see Key concepts: Domains (https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains)
// in the SimSpace Weaver User Guide.
type Domain struct {
	_ struct{} `type:"structure"`

	// The type of lifecycle management for apps in the domain. Indicates whether
	// apps in this domain are managed (SimSpace Weaver starts and stops the apps)
	// or unmanaged (you must start and stop the apps).
	//
	// Lifecycle types
	//
	//    * PerWorker – Managed: SimSpace Weaver starts one app on each worker.
	//
	//    * BySpatialSubdivision – Managed: SimSpace Weaver starts one app for
	//    each spatial partition.
	//
	//    * ByRequest – Unmanaged: You use the StartApp API to start the apps
	//    and use the StopApp API to stop the apps.
	Lifecycle *string `type:"string" enum:"LifecycleManagementStrategy"`

	// The name of the domain.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Domain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Domain) GoString() string {
	return s.String()
}

// SetLifecycle sets the Lifecycle field's value.
func (s *Domain) SetLifecycle(v string) *Domain {
	s.Lifecycle = &v
	return s
}

// SetName sets the Name field's value.
func (s *Domain) SetName(v string) *Domain {
	s.Name = &v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Options that apply when the app starts. These options override default behavior.
type LaunchOverrides struct {
	_ struct{} `type:"structure"`

	// App launch commands and command line parameters that override the launch
	// command configured in the simulation schema.
	LaunchCommands []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchOverrides) GoString() string {
	return s.String()
}

// SetLaunchCommands sets the LaunchCommands field's value.
func (s *LaunchOverrides) SetLaunchCommands(v []*string) *LaunchOverrides {
	s.LaunchCommands = v
	return s
}

type ListAppsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the domain that you want to list apps for.
	Domain *string `location:"querystring" locationName:"domain" min:"1" type:"string"`

	// The maximum number of apps to list.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If SimSpace Weaver returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the simulation that you want to list apps for.
	//
	// Simulation is a required field
	Simulation *string `location:"querystring" locationName:"simulation" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppsInput"}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *ListAppsInput) SetDomain(v string) *ListAppsInput {
	s.Domain = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppsInput) SetMaxResults(v int64) *ListAppsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsInput) SetNextToken(v string) *ListAppsInput {
	s.NextToken = &v
	return s
}

// SetSimulation sets the Simulation field's value.
func (s *ListAppsInput) SetSimulation(v string) *ListAppsInput {
	s.Simulation = &v
	return s
}

type ListAppsOutput struct {
	_ struct{} `type:"structure"`

	// The list of apps for the given simulation and domain.
	Apps []*SimulationAppMetadata `type:"list"`

	// If SimSpace Weaver returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAppsOutput) GoString() string {
	return s.String()
}

// SetApps sets the Apps field's value.
func (s *ListAppsOutput) SetApps(v []*SimulationAppMetadata) *ListAppsOutput {
	s.Apps = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsOutput) SetNextToken(v string) *ListAppsOutput {
	s.NextToken = &v
	return s
}

type ListSimulationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of simulations to list.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If SimSpace Weaver returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSimulationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSimulationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSimulationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSimulationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSimulationsInput) SetMaxResults(v int64) *ListSimulationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSimulationsInput) SetNextToken(v string) *ListSimulationsInput {
	s.NextToken = &v
	return s
}

type ListSimulationsOutput struct {
	_ struct{} `type:"structure"`

	// If SimSpace Weaver returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `type:"string"`

	// The list of simulations.
	Simulations []*SimulationMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSimulationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSimulationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSimulationsOutput) SetNextToken(v string) *ListSimulationsOutput {
	s.NextToken = &v
	return s
}

// SetSimulations sets the Simulations field's value.
func (s *ListSimulationsOutput) SetSimulations(v []*SimulationMetadata) *ListSimulationsOutput {
	s.Simulations = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource. For more information about
	// ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags for the resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A collection of additional state information, such as domain and clock configuration.
type LiveSimulationState struct {
	_ struct{} `type:"structure"`

	// A list of simulation clocks.
	//
	// At this time, a simulation has only one clock.
	Clocks []*SimulationClock `type:"list"`

	// A list of domains for the simulation. For more information about domains,
	// see Key concepts: Domains (https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains)
	// in the SimSpace Weaver User Guide.
	Domains []*Domain `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveSimulationState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LiveSimulationState) GoString() string {
	return s.String()
}

// SetClocks sets the Clocks field's value.
func (s *LiveSimulationState) SetClocks(v []*SimulationClock) *LiveSimulationState {
	s.Clocks = v
	return s
}

// SetDomains sets the Domains field's value.
func (s *LiveSimulationState) SetDomains(v []*Domain) *LiveSimulationState {
	s.Domains = v
	return s
}

// The location where SimSpace Weaver sends simulation log data.
type LogDestination struct {
	_ struct{} `type:"structure"`

	// An Amazon CloudWatch Logs log group that stores simulation log data. For
	// more information about log groups, see Working with log groups and log streams
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html)
	// in the Amazon CloudWatch Logs User Guide.
	CloudWatchLogsLogGroup *CloudWatchLogsLogGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDestination) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroup sets the CloudWatchLogsLogGroup field's value.
func (s *LogDestination) SetCloudWatchLogsLogGroup(v *CloudWatchLogsLogGroup) *LogDestination {
	s.CloudWatchLogsLogGroup = v
	return s
}

// The logging configuration for a simulation.
type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of the locations where SimSpace Weaver sends simulation log data.
	Destinations []*LogDestination `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfiguration) GoString() string {
	return s.String()
}

// SetDestinations sets the Destinations field's value.
func (s *LoggingConfiguration) SetDestinations(v []*LogDestination) *LoggingConfiguration {
	s.Destinations = v
	return s
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An Amazon S3 bucket and optional folder (object key prefix) where SimSpace
// Weaver creates a file.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// The name of an Amazon S3 bucket. For more information about buckets, see
	// Creating, configuring, and working with Amazon S3 buckets (https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html)
	// in the Amazon Simple Storage Service User Guide.
	BucketName *string `min:"3" type:"string"`

	// A string prefix for an Amazon S3 object key. It's usually a folder name.
	// For more information about folders in Amazon S3, see Organizing objects in
	// the Amazon S3 console using folders (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html)
	// in the Amazon Simple Storage Service User Guide.
	ObjectKeyPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Destination"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Destination) SetBucketName(v string) *S3Destination {
	s.BucketName = &v
	return s
}

// SetObjectKeyPrefix sets the ObjectKeyPrefix field's value.
func (s *S3Destination) SetObjectKeyPrefix(v string) *S3Destination {
	s.ObjectKeyPrefix = &v
	return s
}

// A location in Amazon Simple Storage Service (Amazon S3) where SimSpace Weaver
// stores simulation data, such as your app .zip files and schema file. For
// more information about Amazon S3, see the Amazon Simple Storage Service User
// Guide (https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
type S3Location struct {
	_ struct{} `type:"structure"`

	// The name of an Amazon S3 bucket. For more information about buckets, see
	// Creating, configuring, and working with Amazon S3 buckets (https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-buckets-s3.html)
	// in the Amazon Simple Storage Service User Guide.
	BucketName *string `min:"3" type:"string"`

	// The key name of an object in Amazon S3. For more information about Amazon
	// S3 objects and object keys, see Uploading, downloading, and working with
	// objects in Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/userguide/uploading-downloading-objects.html)
	// in the Amazon Simple Storage Service User Guide.
	ObjectKey *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.ObjectKey != nil && len(*s.ObjectKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Location) SetBucketName(v string) *S3Location {
	s.BucketName = &v
	return s
}

// SetObjectKey sets the ObjectKey field's value.
func (s *S3Location) SetObjectKey(v string) *S3Location {
	s.ObjectKey = &v
	return s
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the network endpoint that you can use to connect to your
// custom or service app. For more information about SimSpace Weaver apps, see
// Key concepts: Apps (https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_apps)
// in the SimSpace Weaver User Guide..
type SimulationAppEndpointInfo struct {
	_ struct{} `type:"structure"`

	// The IP address of the app. SimSpace Weaver dynamically assigns this IP address
	// when the app starts.
	Address *string `min:"1" type:"string"`

	// The inbound TCP/UDP port numbers of the app. The combination of an IP address
	// and a port number form a network endpoint.
	IngressPortMappings []*SimulationAppPortMapping `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationAppEndpointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationAppEndpointInfo) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *SimulationAppEndpointInfo) SetAddress(v string) *SimulationAppEndpointInfo {
	s.Address = &v
	return s
}

// SetIngressPortMappings sets the IngressPortMappings field's value.
func (s *SimulationAppEndpointInfo) SetIngressPortMappings(v []*SimulationAppPortMapping) *SimulationAppEndpointInfo {
	s.IngressPortMappings = v
	return s
}

// A collection of metadata about the app.
type SimulationAppMetadata struct {
	_ struct{} `type:"structure"`

	// The domain of the app. For more information about domains, see Key concepts:
	// Domains (https://docs.aws.amazon.com/simspaceweaver/latest/userguide/what-is_key-concepts.html#what-is_key-concepts_domains)
	// in the SimSpace Weaver User Guide.
	Domain *string `min:"1" type:"string"`

	// The name of the app.
	Name *string `min:"1" type:"string"`

	// The name of the simulation of the app.
	Simulation *string `min:"1" type:"string"`

	// The current status of the app.
	Status *string `type:"string" enum:"SimulationAppStatus"`

	// The desired status of the app.
	TargetStatus *string `type:"string" enum:"SimulationAppTargetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationAppMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationAppMetadata) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *SimulationAppMetadata) SetDomain(v string) *SimulationAppMetadata {
	s.Domain = &v
	return s
}

// SetName sets the Name field's value.
func (s *SimulationAppMetadata) SetName(v string) *SimulationAppMetadata {
	s.Name = &v
	return s
}

// SetSimulation sets the Simulation field's value.
func (s *SimulationAppMetadata) SetSimulation(v string) *SimulationAppMetadata {
	s.Simulation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SimulationAppMetadata) SetStatus(v string) *SimulationAppMetadata {
	s.Status = &v
	return s
}

// SetTargetStatus sets the TargetStatus field's value.
func (s *SimulationAppMetadata) SetTargetStatus(v string) *SimulationAppMetadata {
	s.TargetStatus = &v
	return s
}

// A collection of TCP/UDP ports for a custom or service app.
type SimulationAppPortMapping struct {
	_ struct{} `type:"structure"`

	// The TCP/UDP port number of the running app. SimSpace Weaver dynamically assigns
	// this port number when the app starts. SimSpace Weaver maps the Declared port
	// to the Actual port. Clients connect to the app using the app's IP address
	// and the Actual port number.
	Actual *int64 `type:"integer"`

	// The TCP/UDP port number of the app, declared in the simulation schema. SimSpace
	// Weaver maps the Declared port to the Actual port. The source code for the
	// app should bind to the Declared port.
	Declared *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationAppPortMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationAppPortMapping) GoString() string {
	return s.String()
}

// SetActual sets the Actual field's value.
func (s *SimulationAppPortMapping) SetActual(v int64) *SimulationAppPortMapping {
	s.Actual = &v
	return s
}

// SetDeclared sets the Declared field's value.
func (s *SimulationAppPortMapping) SetDeclared(v int64) *SimulationAppPortMapping {
	s.Declared = &v
	return s
}

// Status information about the simulation clock.
type SimulationClock struct {
	_ struct{} `type:"structure"`

	// The current status of the simulation clock.
	Status *string `type:"string" enum:"ClockStatus"`

	// The desired status of the simulation clock.
	TargetStatus *string `type:"string" enum:"ClockTargetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationClock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationClock) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *SimulationClock) SetStatus(v string) *SimulationClock {
	s.Status = &v
	return s
}

// SetTargetStatus sets the TargetStatus field's value.
func (s *SimulationClock) SetTargetStatus(v string) *SimulationClock {
	s.TargetStatus = &v
	return s
}

// A collection of data about the simulation.
type SimulationMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation. For more information about
	// ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	Arn *string `type:"string"`

	// The time when the simulation was created, expressed as the number of seconds
	// and milliseconds in UTC since the Unix epoch (0:0:0.000, January 1, 1970).
	CreationTime *time.Time `type:"timestamp"`

	// The name of the simulation.
	Name *string `min:"1" type:"string"`

	// The current status of the simulation.
	Status *string `type:"string" enum:"SimulationStatus"`

	// The desired status of the simulation.
	TargetStatus *string `type:"string" enum:"SimulationTargetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SimulationMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SimulationMetadata) SetArn(v string) *SimulationMetadata {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *SimulationMetadata) SetCreationTime(v time.Time) *SimulationMetadata {
	s.CreationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *SimulationMetadata) SetName(v string) *SimulationMetadata {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SimulationMetadata) SetStatus(v string) *SimulationMetadata {
	s.Status = &v
	return s
}

// SetTargetStatus sets the TargetStatus field's value.
func (s *SimulationMetadata) SetTargetStatus(v string) *SimulationMetadata {
	s.TargetStatus = &v
	return s
}

type StartAppInput struct {
	_ struct{} `type:"structure"`

	// A value that you provide to ensure that repeated calls to this API operation
	// using the same parameters complete only once. A ClientToken is also known
	// as an idempotency token. A ClientToken expires after 24 hours.
	//
	// ClientToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartAppInput's
	// String and GoString methods.
	ClientToken *string `min:"32" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The description of the app.
	Description *string `type:"string"`

	// The name of the domain of the app.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// Options that apply when the app starts. These options override default behavior.
	LaunchOverrides *LaunchOverrides `type:"structure"`

	// The name of the app.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The name of the simulation of the app.
	//
	// Simulation is a required field
	Simulation *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAppInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 32))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartAppInput) SetClientToken(v string) *StartAppInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartAppInput) SetDescription(v string) *StartAppInput {
	s.Description = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *StartAppInput) SetDomain(v string) *StartAppInput {
	s.Domain = &v
	return s
}

// SetLaunchOverrides sets the LaunchOverrides field's value.
func (s *StartAppInput) SetLaunchOverrides(v *LaunchOverrides) *StartAppInput {
	s.LaunchOverrides = v
	return s
}

// SetName sets the Name field's value.
func (s *StartAppInput) SetName(v string) *StartAppInput {
	s.Name = &v
	return s
}

// SetSimulation sets the Simulation field's value.
func (s *StartAppInput) SetSimulation(v string) *StartAppInput {
	s.Simulation = &v
	return s
}

type StartAppOutput struct {
	_ struct{} `type:"structure"`

	// The name of the domain of the app.
	Domain *string `min:"1" type:"string"`

	// The name of the app.
	Name *string `min:"1" type:"string"`

	// The name of the simulation of the app.
	Simulation *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAppOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *StartAppOutput) SetDomain(v string) *StartAppOutput {
	s.Domain = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartAppOutput) SetName(v string) *StartAppOutput {
	s.Name = &v
	return s
}

// SetSimulation sets the Simulation field's value.
func (s *StartAppOutput) SetSimulation(v string) *StartAppOutput {
	s.Simulation = &v
	return s
}

type StartClockInput struct {
	_ struct{} `type:"structure"`

	// The name of the simulation.
	//
	// Simulation is a required field
	Simulation *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartClockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartClockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartClockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartClockInput"}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSimulation sets the Simulation field's value.
func (s *StartClockInput) SetSimulation(v string) *StartClockInput {
	s.Simulation = &v
	return s
}

type StartClockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartClockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartClockOutput) GoString() string {
	return s.String()
}

type StartSimulationInput struct {
	_ struct{} `type:"structure"`

	// A value that you provide to ensure that repeated calls to this API operation
	// using the same parameters complete only once. A ClientToken is also known
	// as an idempotency token. A ClientToken expires after 24 hours.
	//
	// ClientToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartSimulationInput's
	// String and GoString methods.
	ClientToken *string `min:"32" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The description of the simulation.
	Description *string `type:"string"`

	// The maximum running time of the simulation, specified as a number of minutes
	// (m or M), hours (h or H), or days (d or D). The simulation stops when it
	// reaches this limit. The maximum value is 14D, or its equivalent in the other
	// units. The default value is 14D. A value equivalent to 0 makes the simulation
	// immediately transition to Stopping as soon as it reaches Started.
	MaximumDuration *string `min:"2" type:"string"`

	// The name of the simulation.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
	// role that the simulation assumes to perform actions. For more information
	// about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference. For more information about
	// IAM roles, see IAM roles (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html)
	// in the Identity and Access Management User Guide.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The location of the simulation schema in Amazon Simple Storage Service (Amazon
	// S3). For more information about Amazon S3, see the Amazon Simple Storage
	// Service User Guide (https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
	//
	// Provide a SchemaS3Location to start your simulation from a schema.
	//
	// If you provide a SchemaS3Location then you can't provide a SnapshotS3Location.
	SchemaS3Location *S3Location `type:"structure"`

	// The location of the snapshot .zip file in Amazon Simple Storage Service (Amazon
	// S3). For more information about Amazon S3, see the Amazon Simple Storage
	// Service User Guide (https://docs.aws.amazon.com/AmazonS3/latest/userguide/Welcome.html).
	//
	// Provide a SnapshotS3Location to start your simulation from a snapshot.
	//
	// The Amazon S3 bucket must be in the same Amazon Web Services Region as the
	// simulation.
	//
	// If you provide a SnapshotS3Location then you can't provide a SchemaS3Location.
	SnapshotS3Location *S3Location `type:"structure"`

	// A list of tags for the simulation. For more information about tags, see Tagging
	// Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSimulationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSimulationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSimulationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSimulationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 32))
	}
	if s.MaximumDuration != nil && len(*s.MaximumDuration) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MaximumDuration", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.SchemaS3Location != nil {
		if err := s.SchemaS3Location.Validate(); err != nil {
			invalidParams.AddNested("SchemaS3Location", err.(request.ErrInvalidParams))
		}
	}
	if s.SnapshotS3Location != nil {
		if err := s.SnapshotS3Location.Validate(); err != nil {
			invalidParams.AddNested("SnapshotS3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartSimulationInput) SetClientToken(v string) *StartSimulationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartSimulationInput) SetDescription(v string) *StartSimulationInput {
	s.Description = &v
	return s
}

// SetMaximumDuration sets the MaximumDuration field's value.
func (s *StartSimulationInput) SetMaximumDuration(v string) *StartSimulationInput {
	s.MaximumDuration = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartSimulationInput) SetName(v string) *StartSimulationInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartSimulationInput) SetRoleArn(v string) *StartSimulationInput {
	s.RoleArn = &v
	return s
}

// SetSchemaS3Location sets the SchemaS3Location field's value.
func (s *StartSimulationInput) SetSchemaS3Location(v *S3Location) *StartSimulationInput {
	s.SchemaS3Location = v
	return s
}

// SetSnapshotS3Location sets the SnapshotS3Location field's value.
func (s *StartSimulationInput) SetSnapshotS3Location(v *S3Location) *StartSimulationInput {
	s.SnapshotS3Location = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartSimulationInput) SetTags(v map[string]*string) *StartSimulationInput {
	s.Tags = v
	return s
}

type StartSimulationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation. For more information about
	// ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	Arn *string `type:"string"`

	// The time when the simulation was created, expressed as the number of seconds
	// and milliseconds in UTC since the Unix epoch (0:0:0.000, January 1, 1970).
	CreationTime *time.Time `type:"timestamp"`

	// A universally unique identifier (UUID) for this simulation.
	ExecutionId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSimulationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSimulationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartSimulationOutput) SetArn(v string) *StartSimulationOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *StartSimulationOutput) SetCreationTime(v time.Time) *StartSimulationOutput {
	s.CreationTime = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *StartSimulationOutput) SetExecutionId(v string) *StartSimulationOutput {
	s.ExecutionId = &v
	return s
}

type StopAppInput struct {
	_ struct{} `type:"structure"`

	// The name of the app.
	//
	// App is a required field
	App *string `min:"1" type:"string" required:"true"`

	// The name of the domain of the app.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// The name of the simulation of the app.
	//
	// Simulation is a required field
	Simulation *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopAppInput"}
	if s.App == nil {
		invalidParams.Add(request.NewErrParamRequired("App"))
	}
	if s.App != nil && len(*s.App) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("App", 1))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApp sets the App field's value.
func (s *StopAppInput) SetApp(v string) *StopAppInput {
	s.App = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *StopAppInput) SetDomain(v string) *StopAppInput {
	s.Domain = &v
	return s
}

// SetSimulation sets the Simulation field's value.
func (s *StopAppInput) SetSimulation(v string) *StopAppInput {
	s.Simulation = &v
	return s
}

type StopAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopAppOutput) GoString() string {
	return s.String()
}

type StopClockInput struct {
	_ struct{} `type:"structure"`

	// The name of the simulation.
	//
	// Simulation is a required field
	Simulation *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopClockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopClockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopClockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopClockInput"}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSimulation sets the Simulation field's value.
func (s *StopClockInput) SetSimulation(v string) *StopClockInput {
	s.Simulation = &v
	return s
}

type StopClockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopClockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopClockOutput) GoString() string {
	return s.String()
}

type StopSimulationInput struct {
	_ struct{} `type:"structure"`

	// The name of the simulation.
	//
	// Simulation is a required field
	Simulation *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSimulationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSimulationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopSimulationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopSimulationInput"}
	if s.Simulation == nil {
		invalidParams.Add(request.NewErrParamRequired("Simulation"))
	}
	if s.Simulation != nil && len(*s.Simulation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Simulation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSimulation sets the Simulation field's value.
func (s *StopSimulationInput) SetSimulation(v string) *StopSimulationInput {
	s.Simulation = &v
	return s
}

type StopSimulationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSimulationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSimulationOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to add tags
	// to. For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// A list of tags to apply to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource that you want to remove tags
	// from. For more information about ARNs, see Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// A list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ClockStatusUnknown is a ClockStatus enum value
	ClockStatusUnknown = "UNKNOWN"

	// ClockStatusStarting is a ClockStatus enum value
	ClockStatusStarting = "STARTING"

	// ClockStatusStarted is a ClockStatus enum value
	ClockStatusStarted = "STARTED"

	// ClockStatusStopping is a ClockStatus enum value
	ClockStatusStopping = "STOPPING"

	// ClockStatusStopped is a ClockStatus enum value
	ClockStatusStopped = "STOPPED"
)

// ClockStatus_Values returns all elements of the ClockStatus enum
func ClockStatus_Values() []string {
	return []string{
		ClockStatusUnknown,
		ClockStatusStarting,
		ClockStatusStarted,
		ClockStatusStopping,
		ClockStatusStopped,
	}
}

const (
	// ClockTargetStatusUnknown is a ClockTargetStatus enum value
	ClockTargetStatusUnknown = "UNKNOWN"

	// ClockTargetStatusStarted is a ClockTargetStatus enum value
	ClockTargetStatusStarted = "STARTED"

	// ClockTargetStatusStopped is a ClockTargetStatus enum value
	ClockTargetStatusStopped = "STOPPED"
)

// ClockTargetStatus_Values returns all elements of the ClockTargetStatus enum
func ClockTargetStatus_Values() []string {
	return []string{
		ClockTargetStatusUnknown,
		ClockTargetStatusStarted,
		ClockTargetStatusStopped,
	}
}

const (
	// LifecycleManagementStrategyUnknown is a LifecycleManagementStrategy enum value
	LifecycleManagementStrategyUnknown = "Unknown"

	// LifecycleManagementStrategyPerWorker is a LifecycleManagementStrategy enum value
	LifecycleManagementStrategyPerWorker = "PerWorker"

	// LifecycleManagementStrategyBySpatialSubdivision is a LifecycleManagementStrategy enum value
	LifecycleManagementStrategyBySpatialSubdivision = "BySpatialSubdivision"

	// LifecycleManagementStrategyByRequest is a LifecycleManagementStrategy enum value
	LifecycleManagementStrategyByRequest = "ByRequest"
)

// LifecycleManagementStrategy_Values returns all elements of the LifecycleManagementStrategy enum
func LifecycleManagementStrategy_Values() []string {
	return []string{
		LifecycleManagementStrategyUnknown,
		LifecycleManagementStrategyPerWorker,
		LifecycleManagementStrategyBySpatialSubdivision,
		LifecycleManagementStrategyByRequest,
	}
}

const (
	// SimulationAppStatusStarting is a SimulationAppStatus enum value
	SimulationAppStatusStarting = "STARTING"

	// SimulationAppStatusStarted is a SimulationAppStatus enum value
	SimulationAppStatusStarted = "STARTED"

	// SimulationAppStatusStopping is a SimulationAppStatus enum value
	SimulationAppStatusStopping = "STOPPING"

	// SimulationAppStatusStopped is a SimulationAppStatus enum value
	SimulationAppStatusStopped = "STOPPED"

	// SimulationAppStatusError is a SimulationAppStatus enum value
	SimulationAppStatusError = "ERROR"

	// SimulationAppStatusUnknown is a SimulationAppStatus enum value
	SimulationAppStatusUnknown = "UNKNOWN"
)

// SimulationAppStatus_Values returns all elements of the SimulationAppStatus enum
func SimulationAppStatus_Values() []string {
	return []string{
		SimulationAppStatusStarting,
		SimulationAppStatusStarted,
		SimulationAppStatusStopping,
		SimulationAppStatusStopped,
		SimulationAppStatusError,
		SimulationAppStatusUnknown,
	}
}

const (
	// SimulationAppTargetStatusUnknown is a SimulationAppTargetStatus enum value
	SimulationAppTargetStatusUnknown = "UNKNOWN"

	// SimulationAppTargetStatusStarted is a SimulationAppTargetStatus enum value
	SimulationAppTargetStatusStarted = "STARTED"

	// SimulationAppTargetStatusStopped is a SimulationAppTargetStatus enum value
	SimulationAppTargetStatusStopped = "STOPPED"
)

// SimulationAppTargetStatus_Values returns all elements of the SimulationAppTargetStatus enum
func SimulationAppTargetStatus_Values() []string {
	return []string{
		SimulationAppTargetStatusUnknown,
		SimulationAppTargetStatusStarted,
		SimulationAppTargetStatusStopped,
	}
}

const (
	// SimulationStatusUnknown is a SimulationStatus enum value
	SimulationStatusUnknown = "UNKNOWN"

	// SimulationStatusStarting is a SimulationStatus enum value
	SimulationStatusStarting = "STARTING"

	// SimulationStatusStarted is a SimulationStatus enum value
	SimulationStatusStarted = "STARTED"

	// SimulationStatusStopping is a SimulationStatus enum value
	SimulationStatusStopping = "STOPPING"

	// SimulationStatusStopped is a SimulationStatus enum value
	SimulationStatusStopped = "STOPPED"

	// SimulationStatusFailed is a SimulationStatus enum value
	SimulationStatusFailed = "FAILED"

	// SimulationStatusDeleting is a SimulationStatus enum value
	SimulationStatusDeleting = "DELETING"

	// SimulationStatusDeleted is a SimulationStatus enum value
	SimulationStatusDeleted = "DELETED"

	// SimulationStatusSnapshotInProgress is a SimulationStatus enum value
	SimulationStatusSnapshotInProgress = "SNAPSHOT_IN_PROGRESS"
)

// SimulationStatus_Values returns all elements of the SimulationStatus enum
func SimulationStatus_Values() []string {
	return []string{
		SimulationStatusUnknown,
		SimulationStatusStarting,
		SimulationStatusStarted,
		SimulationStatusStopping,
		SimulationStatusStopped,
		SimulationStatusFailed,
		SimulationStatusDeleting,
		SimulationStatusDeleted,
		SimulationStatusSnapshotInProgress,
	}
}

const (
	// SimulationTargetStatusUnknown is a SimulationTargetStatus enum value
	SimulationTargetStatusUnknown = "UNKNOWN"

	// SimulationTargetStatusStarted is a SimulationTargetStatus enum value
	SimulationTargetStatusStarted = "STARTED"

	// SimulationTargetStatusStopped is a SimulationTargetStatus enum value
	SimulationTargetStatusStopped = "STOPPED"

	// SimulationTargetStatusDeleted is a SimulationTargetStatus enum value
	SimulationTargetStatusDeleted = "DELETED"
)

// SimulationTargetStatus_Values returns all elements of the SimulationTargetStatus enum
func SimulationTargetStatus_Values() []string {
	return []string{
		SimulationTargetStatusUnknown,
		SimulationTargetStatusStarted,
		SimulationTargetStatusStopped,
		SimulationTargetStatusDeleted,
	}
}
