// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sesv2"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Used to convert a dedicated IP pool to a different scaling mode.
// This example converts a dedicated IP pool from STANDARD to MANAGED.
func ExampleSESV2_PutDedicatedIpPoolScalingAttributes_shared00() {
	svc := sesv2.New(session.New())
	input := &sesv2.PutDedicatedIpPoolScalingAttributesInput{
		PoolName:    aws.String("sample-ses-pool"),
		ScalingMode: aws.String("MANAGED"),
	}

	result, err := svc.PutDedicatedIpPoolScalingAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case sesv2.ErrCodeNotFoundException:
				fmt.Println(sesv2.ErrCodeNotFoundException, aerr.Error())
			case sesv2.ErrCodeConcurrentModificationException:
				fmt.Println(sesv2.ErrCodeConcurrentModificationException, aerr.Error())
			case sesv2.ErrCodeTooManyRequestsException:
				fmt.Println(sesv2.ErrCodeTooManyRequestsException, aerr.Error())
			case sesv2.ErrCodeBadRequestException:
				fmt.Println(sesv2.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
