// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package healthlake

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateFHIRDatastore = "CreateFHIRDatastore"

// CreateFHIRDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateFHIRDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFHIRDatastore for more information on using the CreateFHIRDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFHIRDatastoreRequest method.
//	req, resp := client.CreateFHIRDatastoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/CreateFHIRDatastore
func (c *HealthLake) CreateFHIRDatastoreRequest(input *CreateFHIRDatastoreInput) (req *request.Request, output *CreateFHIRDatastoreOutput) {
	op := &request.Operation{
		Name:       opCreateFHIRDatastore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFHIRDatastoreInput{}
	}

	output = &CreateFHIRDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFHIRDatastore API operation for Amazon HealthLake.
//
// Creates a Data Store that can ingest and export FHIR formatted data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation CreateFHIRDatastore for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - AccessDeniedException
//     Access is denied. Your account is not authorized to perform this operation.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/CreateFHIRDatastore
func (c *HealthLake) CreateFHIRDatastore(input *CreateFHIRDatastoreInput) (*CreateFHIRDatastoreOutput, error) {
	req, out := c.CreateFHIRDatastoreRequest(input)
	return out, req.Send()
}

// CreateFHIRDatastoreWithContext is the same as CreateFHIRDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFHIRDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) CreateFHIRDatastoreWithContext(ctx aws.Context, input *CreateFHIRDatastoreInput, opts ...request.Option) (*CreateFHIRDatastoreOutput, error) {
	req, out := c.CreateFHIRDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFHIRDatastore = "DeleteFHIRDatastore"

// DeleteFHIRDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFHIRDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFHIRDatastore for more information on using the DeleteFHIRDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFHIRDatastoreRequest method.
//	req, resp := client.DeleteFHIRDatastoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DeleteFHIRDatastore
func (c *HealthLake) DeleteFHIRDatastoreRequest(input *DeleteFHIRDatastoreInput) (req *request.Request, output *DeleteFHIRDatastoreOutput) {
	op := &request.Operation{
		Name:       opDeleteFHIRDatastore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFHIRDatastoreInput{}
	}

	output = &DeleteFHIRDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFHIRDatastore API operation for Amazon HealthLake.
//
// Deletes a Data Store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation DeleteFHIRDatastore for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Access is denied. Your account is not authorized to perform this operation.
//
//   - ConflictException
//     The Data Store is in a transition state and the user requested action can
//     not be performed.
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DeleteFHIRDatastore
func (c *HealthLake) DeleteFHIRDatastore(input *DeleteFHIRDatastoreInput) (*DeleteFHIRDatastoreOutput, error) {
	req, out := c.DeleteFHIRDatastoreRequest(input)
	return out, req.Send()
}

// DeleteFHIRDatastoreWithContext is the same as DeleteFHIRDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFHIRDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) DeleteFHIRDatastoreWithContext(ctx aws.Context, input *DeleteFHIRDatastoreInput, opts ...request.Option) (*DeleteFHIRDatastoreOutput, error) {
	req, out := c.DeleteFHIRDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFHIRDatastore = "DescribeFHIRDatastore"

// DescribeFHIRDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFHIRDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFHIRDatastore for more information on using the DescribeFHIRDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFHIRDatastoreRequest method.
//	req, resp := client.DescribeFHIRDatastoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRDatastore
func (c *HealthLake) DescribeFHIRDatastoreRequest(input *DescribeFHIRDatastoreInput) (req *request.Request, output *DescribeFHIRDatastoreOutput) {
	op := &request.Operation{
		Name:       opDescribeFHIRDatastore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFHIRDatastoreInput{}
	}

	output = &DescribeFHIRDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFHIRDatastore API operation for Amazon HealthLake.
//
// Gets the properties associated with the FHIR Data Store, including the Data
// Store ID, Data Store ARN, Data Store name, Data Store status, created at,
// Data Store type version, and Data Store endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation DescribeFHIRDatastore for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRDatastore
func (c *HealthLake) DescribeFHIRDatastore(input *DescribeFHIRDatastoreInput) (*DescribeFHIRDatastoreOutput, error) {
	req, out := c.DescribeFHIRDatastoreRequest(input)
	return out, req.Send()
}

// DescribeFHIRDatastoreWithContext is the same as DescribeFHIRDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFHIRDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) DescribeFHIRDatastoreWithContext(ctx aws.Context, input *DescribeFHIRDatastoreInput, opts ...request.Option) (*DescribeFHIRDatastoreOutput, error) {
	req, out := c.DescribeFHIRDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFHIRExportJob = "DescribeFHIRExportJob"

// DescribeFHIRExportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFHIRExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFHIRExportJob for more information on using the DescribeFHIRExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFHIRExportJobRequest method.
//	req, resp := client.DescribeFHIRExportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRExportJob
func (c *HealthLake) DescribeFHIRExportJobRequest(input *DescribeFHIRExportJobInput) (req *request.Request, output *DescribeFHIRExportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeFHIRExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFHIRExportJobInput{}
	}

	output = &DescribeFHIRExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFHIRExportJob API operation for Amazon HealthLake.
//
// Displays the properties of a FHIR export job, including the ID, ARN, name,
// and the status of the job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation DescribeFHIRExportJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRExportJob
func (c *HealthLake) DescribeFHIRExportJob(input *DescribeFHIRExportJobInput) (*DescribeFHIRExportJobOutput, error) {
	req, out := c.DescribeFHIRExportJobRequest(input)
	return out, req.Send()
}

// DescribeFHIRExportJobWithContext is the same as DescribeFHIRExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFHIRExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) DescribeFHIRExportJobWithContext(ctx aws.Context, input *DescribeFHIRExportJobInput, opts ...request.Option) (*DescribeFHIRExportJobOutput, error) {
	req, out := c.DescribeFHIRExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFHIRImportJob = "DescribeFHIRImportJob"

// DescribeFHIRImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFHIRImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFHIRImportJob for more information on using the DescribeFHIRImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFHIRImportJobRequest method.
//	req, resp := client.DescribeFHIRImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRImportJob
func (c *HealthLake) DescribeFHIRImportJobRequest(input *DescribeFHIRImportJobInput) (req *request.Request, output *DescribeFHIRImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeFHIRImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFHIRImportJobInput{}
	}

	output = &DescribeFHIRImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFHIRImportJob API operation for Amazon HealthLake.
//
// Displays the properties of a FHIR import job, including the ID, ARN, name,
// and the status of the job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation DescribeFHIRImportJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRImportJob
func (c *HealthLake) DescribeFHIRImportJob(input *DescribeFHIRImportJobInput) (*DescribeFHIRImportJobOutput, error) {
	req, out := c.DescribeFHIRImportJobRequest(input)
	return out, req.Send()
}

// DescribeFHIRImportJobWithContext is the same as DescribeFHIRImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFHIRImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) DescribeFHIRImportJobWithContext(ctx aws.Context, input *DescribeFHIRImportJobInput, opts ...request.Option) (*DescribeFHIRImportJobOutput, error) {
	req, out := c.DescribeFHIRImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFHIRDatastores = "ListFHIRDatastores"

// ListFHIRDatastoresRequest generates a "aws/request.Request" representing the
// client's request for the ListFHIRDatastores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFHIRDatastores for more information on using the ListFHIRDatastores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFHIRDatastoresRequest method.
//	req, resp := client.ListFHIRDatastoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores
func (c *HealthLake) ListFHIRDatastoresRequest(input *ListFHIRDatastoresInput) (req *request.Request, output *ListFHIRDatastoresOutput) {
	op := &request.Operation{
		Name:       opListFHIRDatastores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFHIRDatastoresInput{}
	}

	output = &ListFHIRDatastoresOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFHIRDatastores API operation for Amazon HealthLake.
//
// Lists all FHIR Data Stores that are in the user’s account, regardless of
// Data Store status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation ListFHIRDatastores for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores
func (c *HealthLake) ListFHIRDatastores(input *ListFHIRDatastoresInput) (*ListFHIRDatastoresOutput, error) {
	req, out := c.ListFHIRDatastoresRequest(input)
	return out, req.Send()
}

// ListFHIRDatastoresWithContext is the same as ListFHIRDatastores with the addition of
// the ability to pass a context and additional request options.
//
// See ListFHIRDatastores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) ListFHIRDatastoresWithContext(ctx aws.Context, input *ListFHIRDatastoresInput, opts ...request.Option) (*ListFHIRDatastoresOutput, error) {
	req, out := c.ListFHIRDatastoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFHIRDatastoresPages iterates over the pages of a ListFHIRDatastores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFHIRDatastores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFHIRDatastores operation.
//	pageNum := 0
//	err := client.ListFHIRDatastoresPages(params,
//	    func(page *healthlake.ListFHIRDatastoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *HealthLake) ListFHIRDatastoresPages(input *ListFHIRDatastoresInput, fn func(*ListFHIRDatastoresOutput, bool) bool) error {
	return c.ListFHIRDatastoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFHIRDatastoresPagesWithContext same as ListFHIRDatastoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) ListFHIRDatastoresPagesWithContext(ctx aws.Context, input *ListFHIRDatastoresInput, fn func(*ListFHIRDatastoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFHIRDatastoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFHIRDatastoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFHIRDatastoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFHIRExportJobs = "ListFHIRExportJobs"

// ListFHIRExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListFHIRExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFHIRExportJobs for more information on using the ListFHIRExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFHIRExportJobsRequest method.
//	req, resp := client.ListFHIRExportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRExportJobs
func (c *HealthLake) ListFHIRExportJobsRequest(input *ListFHIRExportJobsInput) (req *request.Request, output *ListFHIRExportJobsOutput) {
	op := &request.Operation{
		Name:       opListFHIRExportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFHIRExportJobsInput{}
	}

	output = &ListFHIRExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFHIRExportJobs API operation for Amazon HealthLake.
//
// Lists all FHIR export jobs associated with an account and their statuses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation ListFHIRExportJobs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
//   - AccessDeniedException
//     Access is denied. Your account is not authorized to perform this operation.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRExportJobs
func (c *HealthLake) ListFHIRExportJobs(input *ListFHIRExportJobsInput) (*ListFHIRExportJobsOutput, error) {
	req, out := c.ListFHIRExportJobsRequest(input)
	return out, req.Send()
}

// ListFHIRExportJobsWithContext is the same as ListFHIRExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListFHIRExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) ListFHIRExportJobsWithContext(ctx aws.Context, input *ListFHIRExportJobsInput, opts ...request.Option) (*ListFHIRExportJobsOutput, error) {
	req, out := c.ListFHIRExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFHIRExportJobsPages iterates over the pages of a ListFHIRExportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFHIRExportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFHIRExportJobs operation.
//	pageNum := 0
//	err := client.ListFHIRExportJobsPages(params,
//	    func(page *healthlake.ListFHIRExportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *HealthLake) ListFHIRExportJobsPages(input *ListFHIRExportJobsInput, fn func(*ListFHIRExportJobsOutput, bool) bool) error {
	return c.ListFHIRExportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFHIRExportJobsPagesWithContext same as ListFHIRExportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) ListFHIRExportJobsPagesWithContext(ctx aws.Context, input *ListFHIRExportJobsInput, fn func(*ListFHIRExportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFHIRExportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFHIRExportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFHIRExportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFHIRImportJobs = "ListFHIRImportJobs"

// ListFHIRImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListFHIRImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFHIRImportJobs for more information on using the ListFHIRImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFHIRImportJobsRequest method.
//	req, resp := client.ListFHIRImportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRImportJobs
func (c *HealthLake) ListFHIRImportJobsRequest(input *ListFHIRImportJobsInput) (req *request.Request, output *ListFHIRImportJobsOutput) {
	op := &request.Operation{
		Name:       opListFHIRImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFHIRImportJobsInput{}
	}

	output = &ListFHIRImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFHIRImportJobs API operation for Amazon HealthLake.
//
// Lists all FHIR import jobs associated with an account and their statuses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation ListFHIRImportJobs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
//   - AccessDeniedException
//     Access is denied. Your account is not authorized to perform this operation.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRImportJobs
func (c *HealthLake) ListFHIRImportJobs(input *ListFHIRImportJobsInput) (*ListFHIRImportJobsOutput, error) {
	req, out := c.ListFHIRImportJobsRequest(input)
	return out, req.Send()
}

// ListFHIRImportJobsWithContext is the same as ListFHIRImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListFHIRImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) ListFHIRImportJobsWithContext(ctx aws.Context, input *ListFHIRImportJobsInput, opts ...request.Option) (*ListFHIRImportJobsOutput, error) {
	req, out := c.ListFHIRImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFHIRImportJobsPages iterates over the pages of a ListFHIRImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFHIRImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFHIRImportJobs operation.
//	pageNum := 0
//	err := client.ListFHIRImportJobsPages(params,
//	    func(page *healthlake.ListFHIRImportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *HealthLake) ListFHIRImportJobsPages(input *ListFHIRImportJobsInput, fn func(*ListFHIRImportJobsOutput, bool) bool) error {
	return c.ListFHIRImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFHIRImportJobsPagesWithContext same as ListFHIRImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) ListFHIRImportJobsPagesWithContext(ctx aws.Context, input *ListFHIRImportJobsInput, fn func(*ListFHIRImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFHIRImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFHIRImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFHIRImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListTagsForResource
func (c *HealthLake) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon HealthLake.
//
// Returns a list of all existing tags associated with a Data Store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListTagsForResource
func (c *HealthLake) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFHIRExportJob = "StartFHIRExportJob"

// StartFHIRExportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartFHIRExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFHIRExportJob for more information on using the StartFHIRExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartFHIRExportJobRequest method.
//	req, resp := client.StartFHIRExportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRExportJob
func (c *HealthLake) StartFHIRExportJobRequest(input *StartFHIRExportJobInput) (req *request.Request, output *StartFHIRExportJobOutput) {
	op := &request.Operation{
		Name:       opStartFHIRExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFHIRExportJobInput{}
	}

	output = &StartFHIRExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFHIRExportJob API operation for Amazon HealthLake.
//
// Begins a FHIR export job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation StartFHIRExportJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - AccessDeniedException
//     Access is denied. Your account is not authorized to perform this operation.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRExportJob
func (c *HealthLake) StartFHIRExportJob(input *StartFHIRExportJobInput) (*StartFHIRExportJobOutput, error) {
	req, out := c.StartFHIRExportJobRequest(input)
	return out, req.Send()
}

// StartFHIRExportJobWithContext is the same as StartFHIRExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartFHIRExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) StartFHIRExportJobWithContext(ctx aws.Context, input *StartFHIRExportJobInput, opts ...request.Option) (*StartFHIRExportJobOutput, error) {
	req, out := c.StartFHIRExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFHIRImportJob = "StartFHIRImportJob"

// StartFHIRImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartFHIRImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFHIRImportJob for more information on using the StartFHIRImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartFHIRImportJobRequest method.
//	req, resp := client.StartFHIRImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRImportJob
func (c *HealthLake) StartFHIRImportJobRequest(input *StartFHIRImportJobInput) (req *request.Request, output *StartFHIRImportJobOutput) {
	op := &request.Operation{
		Name:       opStartFHIRImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFHIRImportJobInput{}
	}

	output = &StartFHIRImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFHIRImportJob API operation for Amazon HealthLake.
//
// Begins a FHIR Import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation StartFHIRImportJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ThrottlingException
//     The user has exceeded their maximum number of allowed calls to the given
//     API.
//
//   - AccessDeniedException
//     Access is denied. Your account is not authorized to perform this operation.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
//   - InternalServerException
//     Unknown error occurs in the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRImportJob
func (c *HealthLake) StartFHIRImportJob(input *StartFHIRImportJobInput) (*StartFHIRImportJobOutput, error) {
	req, out := c.StartFHIRImportJobRequest(input)
	return out, req.Send()
}

// StartFHIRImportJobWithContext is the same as StartFHIRImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartFHIRImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) StartFHIRImportJobWithContext(ctx aws.Context, input *StartFHIRImportJobInput, opts ...request.Option) (*StartFHIRImportJobOutput, error) {
	req, out := c.StartFHIRImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/TagResource
func (c *HealthLake) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon HealthLake.
//
// Adds a user specified key and value tag to a Data Store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/TagResource
func (c *HealthLake) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/UntagResource
func (c *HealthLake) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon HealthLake.
//
// Removes tags from a Data Store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon HealthLake's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The user input parameter was invalid.
//
//   - ResourceNotFoundException
//     The requested Data Store was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/UntagResource
func (c *HealthLake) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HealthLake) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access is denied. Your account is not authorized to perform this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Data Store is in a transition state and the user requested action can
// not be performed.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateFHIRDatastoreInput struct {
	_ struct{} `type:"structure"`

	// Optional user provided token used for ensuring idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The user generated name for the Data Store.
	DatastoreName *string `min:"1" type:"string"`

	// The FHIR version of the Data Store. The only supported version is R4.
	//
	// DatastoreTypeVersion is a required field
	DatastoreTypeVersion *string `type:"string" required:"true" enum:"FHIRVersion"`

	// The configuration of the identity provider that you want to use for your
	// Data Store.
	IdentityProviderConfiguration *IdentityProviderConfiguration `type:"structure"`

	// Optional parameter to preload data upon creation of the Data Store. Currently,
	// the only supported preloaded data is synthetic data generated from Synthea.
	PreloadDataConfig *PreloadDataConfig `type:"structure"`

	// The server-side encryption key configuration for a customer provided encryption
	// key specified for creating a Data Store.
	SseConfiguration *SseConfiguration `type:"structure"`

	// Resource tags that are applied to a Data Store when it is created.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFHIRDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFHIRDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFHIRDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFHIRDatastoreInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}
	if s.DatastoreTypeVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreTypeVersion"))
	}
	if s.IdentityProviderConfiguration != nil {
		if err := s.IdentityProviderConfiguration.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PreloadDataConfig != nil {
		if err := s.PreloadDataConfig.Validate(); err != nil {
			invalidParams.AddNested("PreloadDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.SseConfiguration != nil {
		if err := s.SseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SseConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFHIRDatastoreInput) SetClientToken(v string) *CreateFHIRDatastoreInput {
	s.ClientToken = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *CreateFHIRDatastoreInput) SetDatastoreName(v string) *CreateFHIRDatastoreInput {
	s.DatastoreName = &v
	return s
}

// SetDatastoreTypeVersion sets the DatastoreTypeVersion field's value.
func (s *CreateFHIRDatastoreInput) SetDatastoreTypeVersion(v string) *CreateFHIRDatastoreInput {
	s.DatastoreTypeVersion = &v
	return s
}

// SetIdentityProviderConfiguration sets the IdentityProviderConfiguration field's value.
func (s *CreateFHIRDatastoreInput) SetIdentityProviderConfiguration(v *IdentityProviderConfiguration) *CreateFHIRDatastoreInput {
	s.IdentityProviderConfiguration = v
	return s
}

// SetPreloadDataConfig sets the PreloadDataConfig field's value.
func (s *CreateFHIRDatastoreInput) SetPreloadDataConfig(v *PreloadDataConfig) *CreateFHIRDatastoreInput {
	s.PreloadDataConfig = v
	return s
}

// SetSseConfiguration sets the SseConfiguration field's value.
func (s *CreateFHIRDatastoreInput) SetSseConfiguration(v *SseConfiguration) *CreateFHIRDatastoreInput {
	s.SseConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFHIRDatastoreInput) SetTags(v []*Tag) *CreateFHIRDatastoreInput {
	s.Tags = v
	return s
}

type CreateFHIRDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// The Data Store ARN is generated during the creation of the Data Store and
	// can be found in the output from the initial Data Store creation call.
	//
	// DatastoreArn is a required field
	DatastoreArn *string `type:"string" required:"true"`

	// The AWS endpoint for the created Data Store.
	//
	// DatastoreEndpoint is a required field
	DatastoreEndpoint *string `min:"1" type:"string" required:"true"`

	// The AWS-generated Data Store id. This id is in the output from the initial
	// Data Store creation call.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The status of the FHIR Data Store. Possible statuses are ‘CREATING’,
	// ‘ACTIVE’, ‘DELETING’, ‘DELETED’.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `type:"string" required:"true" enum:"DatastoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFHIRDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFHIRDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreArn sets the DatastoreArn field's value.
func (s *CreateFHIRDatastoreOutput) SetDatastoreArn(v string) *CreateFHIRDatastoreOutput {
	s.DatastoreArn = &v
	return s
}

// SetDatastoreEndpoint sets the DatastoreEndpoint field's value.
func (s *CreateFHIRDatastoreOutput) SetDatastoreEndpoint(v string) *CreateFHIRDatastoreOutput {
	s.DatastoreEndpoint = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *CreateFHIRDatastoreOutput) SetDatastoreId(v string) *CreateFHIRDatastoreOutput {
	s.DatastoreId = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *CreateFHIRDatastoreOutput) SetDatastoreStatus(v string) *CreateFHIRDatastoreOutput {
	s.DatastoreStatus = &v
	return s
}

// The filters applied to Data Store query.
type DatastoreFilter struct {
	_ struct{} `type:"structure"`

	// A filter that allows the user to set cutoff dates for records. All Data Stores
	// created after the specified date will be included in the results.
	CreatedAfter *time.Time `type:"timestamp"`

	// A filter that allows the user to set cutoff dates for records. All Data Stores
	// created before the specified date will be included in the results.
	CreatedBefore *time.Time `type:"timestamp"`

	// Allows the user to filter Data Store results by name.
	DatastoreName *string `min:"1" type:"string"`

	// Allows the user to filter Data Store results by status.
	DatastoreStatus *string `type:"string" enum:"DatastoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatastoreFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatastoreFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatastoreFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatastoreFilter"}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *DatastoreFilter) SetCreatedAfter(v time.Time) *DatastoreFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *DatastoreFilter) SetCreatedBefore(v time.Time) *DatastoreFilter {
	s.CreatedBefore = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DatastoreFilter) SetDatastoreName(v string) *DatastoreFilter {
	s.DatastoreName = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *DatastoreFilter) SetDatastoreStatus(v string) *DatastoreFilter {
	s.DatastoreStatus = &v
	return s
}

// Displays the properties of the Data Store, including the ID, ARN, name, and
// the status of the Data Store.
type DatastoreProperties struct {
	_ struct{} `type:"structure"`

	// The time that a Data Store was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name used in the creation of the Data Store.
	//
	// DatastoreArn is a required field
	DatastoreArn *string `type:"string" required:"true"`

	// The AWS endpoint for the Data Store. Each Data Store will have it's own endpoint
	// with Data Store ID in the endpoint URL.
	//
	// DatastoreEndpoint is a required field
	DatastoreEndpoint *string `type:"string" required:"true"`

	// The AWS-generated ID number for the Data Store.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The user-generated name for the Data Store.
	DatastoreName *string `min:"1" type:"string"`

	// The status of the Data Store. Possible statuses are 'CREATING', 'ACTIVE',
	// 'DELETING', or 'DELETED'.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `type:"string" required:"true" enum:"DatastoreStatus"`

	// The FHIR version. Only R4 version data is supported.
	//
	// DatastoreTypeVersion is a required field
	DatastoreTypeVersion *string `type:"string" required:"true" enum:"FHIRVersion"`

	// The identity provider that you selected when you created the Data Store.
	IdentityProviderConfiguration *IdentityProviderConfiguration `type:"structure"`

	// The preloaded data configuration for the Data Store. Only data preloaded
	// from Synthea is supported.
	PreloadDataConfig *PreloadDataConfig `type:"structure"`

	// The server-side encryption key configuration for a customer provided encryption
	// key (CMK).
	SseConfiguration *SseConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatastoreProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatastoreProperties) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DatastoreProperties) SetCreatedAt(v time.Time) *DatastoreProperties {
	s.CreatedAt = &v
	return s
}

// SetDatastoreArn sets the DatastoreArn field's value.
func (s *DatastoreProperties) SetDatastoreArn(v string) *DatastoreProperties {
	s.DatastoreArn = &v
	return s
}

// SetDatastoreEndpoint sets the DatastoreEndpoint field's value.
func (s *DatastoreProperties) SetDatastoreEndpoint(v string) *DatastoreProperties {
	s.DatastoreEndpoint = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DatastoreProperties) SetDatastoreId(v string) *DatastoreProperties {
	s.DatastoreId = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DatastoreProperties) SetDatastoreName(v string) *DatastoreProperties {
	s.DatastoreName = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *DatastoreProperties) SetDatastoreStatus(v string) *DatastoreProperties {
	s.DatastoreStatus = &v
	return s
}

// SetDatastoreTypeVersion sets the DatastoreTypeVersion field's value.
func (s *DatastoreProperties) SetDatastoreTypeVersion(v string) *DatastoreProperties {
	s.DatastoreTypeVersion = &v
	return s
}

// SetIdentityProviderConfiguration sets the IdentityProviderConfiguration field's value.
func (s *DatastoreProperties) SetIdentityProviderConfiguration(v *IdentityProviderConfiguration) *DatastoreProperties {
	s.IdentityProviderConfiguration = v
	return s
}

// SetPreloadDataConfig sets the PreloadDataConfig field's value.
func (s *DatastoreProperties) SetPreloadDataConfig(v *PreloadDataConfig) *DatastoreProperties {
	s.PreloadDataConfig = v
	return s
}

// SetSseConfiguration sets the SseConfiguration field's value.
func (s *DatastoreProperties) SetSseConfiguration(v *SseConfiguration) *DatastoreProperties {
	s.SseConfiguration = v
	return s
}

type DeleteFHIRDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The AWS-generated ID for the Data Store to be deleted.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFHIRDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFHIRDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFHIRDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFHIRDatastoreInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DeleteFHIRDatastoreInput) SetDatastoreId(v string) *DeleteFHIRDatastoreInput {
	s.DatastoreId = &v
	return s
}

type DeleteFHIRDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.
	//
	// DatastoreArn is a required field
	DatastoreArn *string `type:"string" required:"true"`

	// The AWS endpoint for the Data Store the user has requested to be deleted.
	//
	// DatastoreEndpoint is a required field
	DatastoreEndpoint *string `min:"1" type:"string" required:"true"`

	// The AWS-generated ID for the Data Store to be deleted.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The status of the Data Store that the user has requested to be deleted.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `type:"string" required:"true" enum:"DatastoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFHIRDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFHIRDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreArn sets the DatastoreArn field's value.
func (s *DeleteFHIRDatastoreOutput) SetDatastoreArn(v string) *DeleteFHIRDatastoreOutput {
	s.DatastoreArn = &v
	return s
}

// SetDatastoreEndpoint sets the DatastoreEndpoint field's value.
func (s *DeleteFHIRDatastoreOutput) SetDatastoreEndpoint(v string) *DeleteFHIRDatastoreOutput {
	s.DatastoreEndpoint = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DeleteFHIRDatastoreOutput) SetDatastoreId(v string) *DeleteFHIRDatastoreOutput {
	s.DatastoreId = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *DeleteFHIRDatastoreOutput) SetDatastoreStatus(v string) *DeleteFHIRDatastoreOutput {
	s.DatastoreStatus = &v
	return s
}

type DescribeFHIRDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The AWS-generated Data Store ID.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFHIRDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFHIRDatastoreInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DescribeFHIRDatastoreInput) SetDatastoreId(v string) *DescribeFHIRDatastoreInput {
	s.DatastoreId = &v
	return s
}

type DescribeFHIRDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// All properties associated with a Data Store, including the Data Store ID,
	// Data Store ARN, Data Store name, Data Store status, created at, Data Store
	// type version, and Data Store endpoint.
	//
	// DatastoreProperties is a required field
	DatastoreProperties *DatastoreProperties `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreProperties sets the DatastoreProperties field's value.
func (s *DescribeFHIRDatastoreOutput) SetDatastoreProperties(v *DatastoreProperties) *DescribeFHIRDatastoreOutput {
	s.DatastoreProperties = v
	return s
}

type DescribeFHIRExportJobInput struct {
	_ struct{} `type:"structure"`

	// The AWS generated ID for the Data Store from which files are being exported
	// from for an export job.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The AWS generated ID for an export job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFHIRExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFHIRExportJobInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DescribeFHIRExportJobInput) SetDatastoreId(v string) *DescribeFHIRExportJobInput {
	s.DatastoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeFHIRExportJobInput) SetJobId(v string) *DescribeFHIRExportJobInput {
	s.JobId = &v
	return s
}

type DescribeFHIRExportJobOutput struct {
	_ struct{} `type:"structure"`

	// Displays the properties of the export job, including the ID, Arn, Name, and
	// the status of the job.
	//
	// ExportJobProperties is a required field
	ExportJobProperties *ExportJobProperties `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRExportJobOutput) GoString() string {
	return s.String()
}

// SetExportJobProperties sets the ExportJobProperties field's value.
func (s *DescribeFHIRExportJobOutput) SetExportJobProperties(v *ExportJobProperties) *DescribeFHIRExportJobOutput {
	s.ExportJobProperties = v
	return s
}

type DescribeFHIRImportJobInput struct {
	_ struct{} `type:"structure"`

	// The AWS-generated ID of the Data Store.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The AWS-generated job ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFHIRImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFHIRImportJobInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DescribeFHIRImportJobInput) SetDatastoreId(v string) *DescribeFHIRImportJobInput {
	s.DatastoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeFHIRImportJobInput) SetJobId(v string) *DescribeFHIRImportJobInput {
	s.JobId = &v
	return s
}

type DescribeFHIRImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the Import job request, including the ID, ARN, name, and
	// the status of the job.
	//
	// ImportJobProperties is a required field
	ImportJobProperties *ImportJobProperties `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFHIRImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobProperties sets the ImportJobProperties field's value.
func (s *DescribeFHIRImportJobOutput) SetImportJobProperties(v *ImportJobProperties) *DescribeFHIRImportJobOutput {
	s.ImportJobProperties = v
	return s
}

// The properties of a FHIR export job, including the ID, ARN, name, and the
// status of the job.
type ExportJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name used during the initiation of the job.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The AWS generated ID for the Data Store from which files are being exported
	// for an export job.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The time an export job completed.
	EndTime *time.Time `type:"timestamp"`

	// The AWS generated ID for an export job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user generated name for an export job.
	JobName *string `min:"1" type:"string"`

	// The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS,
	// COMPLETED, or FAILED.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`

	// An explanation of any errors that may have occurred during the export job.
	Message *string `min:"1" type:"string"`

	// The output data configuration that was supplied when the export job was created.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The time an export job was initiated.
	//
	// SubmitTime is a required field
	SubmitTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *ExportJobProperties) SetDataAccessRoleArn(v string) *ExportJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *ExportJobProperties) SetDatastoreId(v string) *ExportJobProperties {
	s.DatastoreId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ExportJobProperties) SetEndTime(v time.Time) *ExportJobProperties {
	s.EndTime = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ExportJobProperties) SetJobId(v string) *ExportJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ExportJobProperties) SetJobName(v string) *ExportJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ExportJobProperties) SetJobStatus(v string) *ExportJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ExportJobProperties) SetMessage(v string) *ExportJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *ExportJobProperties) SetOutputDataConfig(v *OutputDataConfig) *ExportJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *ExportJobProperties) SetSubmitTime(v time.Time) *ExportJobProperties {
	s.SubmitTime = &v
	return s
}

// The identity provider configuration that you gave when the Data Store was
// created.
type IdentityProviderConfiguration struct {
	_ struct{} `type:"structure"`

	// The authorization strategy that you selected when you created the Data Store.
	//
	// AuthorizationStrategy is a required field
	AuthorizationStrategy *string `type:"string" required:"true" enum:"AuthorizationStrategy"`

	// If you enabled fine-grained authorization when you created the Data Store.
	FineGrainedAuthorizationEnabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the Lambda function that you want to use
	// to decode the access token created by the authorization server.
	IdpLambdaArn *string `min:"49" type:"string"`

	// The JSON metadata elements that you want to use in your identity provider
	// configuration. Required elements are listed based on the launch specification
	// of the SMART application. For more information on all possible elements,
	// see Metadata (https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata)
	// in SMART's App Launch specification.
	//
	// authorization_endpoint: The URL to the OAuth2 authorization endpoint.
	//
	// grant_types_supported: An array of grant types that are supported at the
	// token endpoint. You must provide at least one grant type option. Valid options
	// are authorization_code and client_credentials.
	//
	// token_endpoint: The URL to the OAuth2 token endpoint.
	//
	// capabilities: An array of strings of the SMART capabilities that the authorization
	// server supports.
	//
	// code_challenge_methods_supported: An array of strings of supported PKCE code
	// challenge methods. You must include the S256 method in the array of PKCE
	// code challenge methods.
	Metadata *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdentityProviderConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdentityProviderConfiguration"}
	if s.AuthorizationStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizationStrategy"))
	}
	if s.IdpLambdaArn != nil && len(*s.IdpLambdaArn) < 49 {
		invalidParams.Add(request.NewErrParamMinLen("IdpLambdaArn", 49))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationStrategy sets the AuthorizationStrategy field's value.
func (s *IdentityProviderConfiguration) SetAuthorizationStrategy(v string) *IdentityProviderConfiguration {
	s.AuthorizationStrategy = &v
	return s
}

// SetFineGrainedAuthorizationEnabled sets the FineGrainedAuthorizationEnabled field's value.
func (s *IdentityProviderConfiguration) SetFineGrainedAuthorizationEnabled(v bool) *IdentityProviderConfiguration {
	s.FineGrainedAuthorizationEnabled = &v
	return s
}

// SetIdpLambdaArn sets the IdpLambdaArn field's value.
func (s *IdentityProviderConfiguration) SetIdpLambdaArn(v string) *IdentityProviderConfiguration {
	s.IdpLambdaArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *IdentityProviderConfiguration) SetMetadata(v string) *IdentityProviderConfiguration {
	s.Metadata = &v
	return s
}

// Displays the properties of the import job, including the ID, Arn, Name, and
// the status of the Data Store.
type ImportJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon HealthLake access to your
	// input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The datastore id used when the Import job was created.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The time that the Import job was completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that was supplied when the Import job was created.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The AWS-generated id number for the Import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user-generated name for an Import job.
	JobName *string `min:"1" type:"string"`

	// The output data configuration that was supplied when the export job was created.
	JobOutputDataConfig *OutputDataConfig `type:"structure"`

	// The job status for an Import job. Possible statuses are SUBMITTED, IN_PROGRESS,
	// COMPLETED_WITH_ERRORS, COMPLETED, FAILED.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`

	// An explanation of any errors that may have occurred during the FHIR import
	// job.
	Message *string `min:"1" type:"string"`

	// The time that the Import job was submitted for processing.
	//
	// SubmitTime is a required field
	SubmitTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *ImportJobProperties) SetDataAccessRoleArn(v string) *ImportJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *ImportJobProperties) SetDatastoreId(v string) *ImportJobProperties {
	s.DatastoreId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ImportJobProperties) SetEndTime(v time.Time) *ImportJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *ImportJobProperties) SetInputDataConfig(v *InputDataConfig) *ImportJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ImportJobProperties) SetJobId(v string) *ImportJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ImportJobProperties) SetJobName(v string) *ImportJobProperties {
	s.JobName = &v
	return s
}

// SetJobOutputDataConfig sets the JobOutputDataConfig field's value.
func (s *ImportJobProperties) SetJobOutputDataConfig(v *OutputDataConfig) *ImportJobProperties {
	s.JobOutputDataConfig = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ImportJobProperties) SetJobStatus(v string) *ImportJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ImportJobProperties) SetMessage(v string) *ImportJobProperties {
	s.Message = &v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *ImportJobProperties) SetSubmitTime(v time.Time) *ImportJobProperties {
	s.SubmitTime = &v
	return s
}

// The input properties for an import job.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3Uri is the user specified S3 location of the FHIR data to be imported
	// into Amazon HealthLake.
	S3Uri *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) GoString() string {
	return s.String()
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// Unknown error occurs in the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The customer-managed-key(CMK) used when creating a Data Store. If a customer
// owned key is not specified, an AWS owned key will be used for encryption.
type KmsEncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The type of customer-managed-key(CMK) used for encyrption. The two types
	// of supported CMKs are customer owned CMKs and AWS owned CMKs.
	//
	// CmkType is a required field
	CmkType *string `type:"string" required:"true" enum:"CmkType"`

	// The KMS encryption key id/alias used to encrypt the Data Store contents at
	// rest.
	KmsKeyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsEncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KmsEncryptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KmsEncryptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KmsEncryptionConfig"}
	if s.CmkType == nil {
		invalidParams.Add(request.NewErrParamRequired("CmkType"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCmkType sets the CmkType field's value.
func (s *KmsEncryptionConfig) SetCmkType(v string) *KmsEncryptionConfig {
	s.CmkType = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *KmsEncryptionConfig) SetKmsKeyId(v string) *KmsEncryptionConfig {
	s.KmsKeyId = &v
	return s
}

type ListFHIRDatastoresInput struct {
	_ struct{} `type:"structure"`

	// Lists all filters associated with a FHIR Data Store request.
	Filter *DatastoreFilter `type:"structure"`

	// The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest
	// call.
	MaxResults *int64 `min:"1" type:"integer"`

	// Fetches the next page of Data Stores when results are paginated.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRDatastoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRDatastoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFHIRDatastoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFHIRDatastoresInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListFHIRDatastoresInput) SetFilter(v *DatastoreFilter) *ListFHIRDatastoresInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFHIRDatastoresInput) SetMaxResults(v int64) *ListFHIRDatastoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFHIRDatastoresInput) SetNextToken(v string) *ListFHIRDatastoresInput {
	s.NextToken = &v
	return s
}

type ListFHIRDatastoresOutput struct {
	_ struct{} `type:"structure"`

	// All properties associated with the listed Data Stores.
	//
	// DatastorePropertiesList is a required field
	DatastorePropertiesList []*DatastoreProperties `type:"list" required:"true"`

	// Pagination token that can be used to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRDatastoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRDatastoresOutput) GoString() string {
	return s.String()
}

// SetDatastorePropertiesList sets the DatastorePropertiesList field's value.
func (s *ListFHIRDatastoresOutput) SetDatastorePropertiesList(v []*DatastoreProperties) *ListFHIRDatastoresOutput {
	s.DatastorePropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFHIRDatastoresOutput) SetNextToken(v string) *ListFHIRDatastoresOutput {
	s.NextToken = &v
	return s
}

type ListFHIRExportJobsInput struct {
	_ struct{} `type:"structure"`

	// This parameter limits the response to the export job with the specified Data
	// Store ID.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// This parameter limits the response to the export job with the specified job
	// name.
	JobName *string `min:"1" type:"string"`

	// This parameter limits the response to the export jobs with the specified
	// job status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// This parameter limits the number of results returned for a ListFHIRExportJobs
	// to a maximum quantity specified by the user.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token used to identify the next page of results to return for
	// a ListFHIRExportJobs query.
	NextToken *string `type:"string"`

	// This parameter limits the response to FHIR export jobs submitted after a
	// user specified date.
	SubmittedAfter *time.Time `type:"timestamp"`

	// This parameter limits the response to FHIR export jobs submitted before a
	// user specified date.
	SubmittedBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFHIRExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFHIRExportJobsInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *ListFHIRExportJobsInput) SetDatastoreId(v string) *ListFHIRExportJobsInput {
	s.DatastoreId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ListFHIRExportJobsInput) SetJobName(v string) *ListFHIRExportJobsInput {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ListFHIRExportJobsInput) SetJobStatus(v string) *ListFHIRExportJobsInput {
	s.JobStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFHIRExportJobsInput) SetMaxResults(v int64) *ListFHIRExportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFHIRExportJobsInput) SetNextToken(v string) *ListFHIRExportJobsInput {
	s.NextToken = &v
	return s
}

// SetSubmittedAfter sets the SubmittedAfter field's value.
func (s *ListFHIRExportJobsInput) SetSubmittedAfter(v time.Time) *ListFHIRExportJobsInput {
	s.SubmittedAfter = &v
	return s
}

// SetSubmittedBefore sets the SubmittedBefore field's value.
func (s *ListFHIRExportJobsInput) SetSubmittedBefore(v time.Time) *ListFHIRExportJobsInput {
	s.SubmittedBefore = &v
	return s
}

type ListFHIRExportJobsOutput struct {
	_ struct{} `type:"structure"`

	// The properties of listed FHIR export jobs, including the ID, ARN, name, and
	// the status of the job.
	//
	// ExportJobPropertiesList is a required field
	ExportJobPropertiesList []*ExportJobProperties `type:"list" required:"true"`

	// A pagination token used to identify the next page of results to return for
	// a ListFHIRExportJobs query.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRExportJobsOutput) GoString() string {
	return s.String()
}

// SetExportJobPropertiesList sets the ExportJobPropertiesList field's value.
func (s *ListFHIRExportJobsOutput) SetExportJobPropertiesList(v []*ExportJobProperties) *ListFHIRExportJobsOutput {
	s.ExportJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFHIRExportJobsOutput) SetNextToken(v string) *ListFHIRExportJobsOutput {
	s.NextToken = &v
	return s
}

type ListFHIRImportJobsInput struct {
	_ struct{} `type:"structure"`

	// This parameter limits the response to the import job with the specified Data
	// Store ID.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// This parameter limits the response to the import job with the specified job
	// name.
	JobName *string `min:"1" type:"string"`

	// This parameter limits the response to the import job with the specified job
	// status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// This parameter limits the number of results returned for a ListFHIRImportJobs
	// to a maximum quantity specified by the user.
	MaxResults *int64 `min:"1" type:"integer"`

	// A pagination token used to identify the next page of results to return for
	// a ListFHIRImportJobs query.
	NextToken *string `type:"string"`

	// This parameter limits the response to FHIR import jobs submitted after a
	// user specified date.
	SubmittedAfter *time.Time `type:"timestamp"`

	// This parameter limits the response to FHIR import jobs submitted before a
	// user specified date.
	SubmittedBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFHIRImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFHIRImportJobsInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *ListFHIRImportJobsInput) SetDatastoreId(v string) *ListFHIRImportJobsInput {
	s.DatastoreId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ListFHIRImportJobsInput) SetJobName(v string) *ListFHIRImportJobsInput {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ListFHIRImportJobsInput) SetJobStatus(v string) *ListFHIRImportJobsInput {
	s.JobStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFHIRImportJobsInput) SetMaxResults(v int64) *ListFHIRImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFHIRImportJobsInput) SetNextToken(v string) *ListFHIRImportJobsInput {
	s.NextToken = &v
	return s
}

// SetSubmittedAfter sets the SubmittedAfter field's value.
func (s *ListFHIRImportJobsInput) SetSubmittedAfter(v time.Time) *ListFHIRImportJobsInput {
	s.SubmittedAfter = &v
	return s
}

// SetSubmittedBefore sets the SubmittedBefore field's value.
func (s *ListFHIRImportJobsInput) SetSubmittedBefore(v time.Time) *ListFHIRImportJobsInput {
	s.SubmittedBefore = &v
	return s
}

type ListFHIRImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// The properties of a listed FHIR import jobs, including the ID, ARN, name,
	// and the status of the job.
	//
	// ImportJobPropertiesList is a required field
	ImportJobPropertiesList []*ImportJobProperties `type:"list" required:"true"`

	// A pagination token used to identify the next page of results to return for
	// a ListFHIRImportJobs query.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFHIRImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobPropertiesList sets the ImportJobPropertiesList field's value.
func (s *ListFHIRImportJobsOutput) SetImportJobPropertiesList(v []*ImportJobProperties) *ListFHIRImportJobsOutput {
	s.ImportJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFHIRImportJobsOutput) SetNextToken(v string) *ListFHIRImportJobsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name(ARN) of the Data Store for which tags are being
	// added.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of tags associated with a Data Store.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The output data configuration that was supplied when the export job was created.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The output data configuration that was supplied when the export job was created.
	S3Configuration *S3Configuration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *OutputDataConfig) SetS3Configuration(v *S3Configuration) *OutputDataConfig {
	s.S3Configuration = v
	return s
}

// The input properties for the preloaded Data Store. Only data preloaded from
// Synthea is supported.
type PreloadDataConfig struct {
	_ struct{} `type:"structure"`

	// The type of preloaded data. Only Synthea preloaded data is supported.
	//
	// PreloadDataType is a required field
	PreloadDataType *string `type:"string" required:"true" enum:"PreloadDataType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreloadDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreloadDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PreloadDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PreloadDataConfig"}
	if s.PreloadDataType == nil {
		invalidParams.Add(request.NewErrParamRequired("PreloadDataType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPreloadDataType sets the PreloadDataType field's value.
func (s *PreloadDataConfig) SetPreloadDataType(v string) *PreloadDataConfig {
	s.PreloadDataType = &v
	return s
}

// The requested Data Store was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration of the S3 bucket for either an import or export job. This
// includes assigning permissions for access.
type S3Configuration struct {
	_ struct{} `type:"structure"`

	// The KMS key ID used to access the S3 bucket.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `min:"1" type:"string" required:"true"`

	// The S3Uri is the user specified S3 location of the FHIR data to be imported
	// into Amazon HealthLake.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Configuration"}
	if s.KmsKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKeyId"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *S3Configuration) SetKmsKeyId(v string) *S3Configuration {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *S3Configuration) SetS3Uri(v string) *S3Configuration {
	s.S3Uri = &v
	return s
}

// The server-side encryption key configuration for a customer provided encryption
// key.
type SseConfiguration struct {
	_ struct{} `type:"structure"`

	// The KMS encryption configuration used to provide details for data encryption.
	//
	// KmsEncryptionConfig is a required field
	KmsEncryptionConfig *KmsEncryptionConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SseConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SseConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SseConfiguration"}
	if s.KmsEncryptionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsEncryptionConfig"))
	}
	if s.KmsEncryptionConfig != nil {
		if err := s.KmsEncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("KmsEncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsEncryptionConfig sets the KmsEncryptionConfig field's value.
func (s *SseConfiguration) SetKmsEncryptionConfig(v *KmsEncryptionConfig) *SseConfiguration {
	s.KmsEncryptionConfig = v
	return s
}

type StartFHIRExportJobInput struct {
	_ struct{} `type:"structure"`

	// An optional user provided token used for ensuring idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name used during the initiation of the job.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The AWS generated ID for the Data Store from which files are being exported
	// for an export job.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The user generated name for an export job.
	JobName *string `min:"1" type:"string"`

	// The output data configuration that was supplied when the export job was created.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFHIRExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFHIRExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFHIRExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFHIRExportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartFHIRExportJobInput) SetClientToken(v string) *StartFHIRExportJobInput {
	s.ClientToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartFHIRExportJobInput) SetDataAccessRoleArn(v string) *StartFHIRExportJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *StartFHIRExportJobInput) SetDatastoreId(v string) *StartFHIRExportJobInput {
	s.DatastoreId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartFHIRExportJobInput) SetJobName(v string) *StartFHIRExportJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartFHIRExportJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartFHIRExportJobInput {
	s.OutputDataConfig = v
	return s
}

type StartFHIRExportJobOutput struct {
	_ struct{} `type:"structure"`

	// The AWS generated ID for the Data Store from which files are being exported
	// for an export job.
	DatastoreId *string `min:"1" type:"string"`

	// The AWS generated ID for an export job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS,
	// COMPLETED, or FAILED.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFHIRExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFHIRExportJobOutput) GoString() string {
	return s.String()
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *StartFHIRExportJobOutput) SetDatastoreId(v string) *StartFHIRExportJobOutput {
	s.DatastoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartFHIRExportJobOutput) SetJobId(v string) *StartFHIRExportJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartFHIRExportJobOutput) SetJobStatus(v string) *StartFHIRExportJobOutput {
	s.JobStatus = &v
	return s
}

type StartFHIRImportJobInput struct {
	_ struct{} `type:"structure"`

	// Optional user provided token used for ensuring idempotency.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The AWS-generated Data Store ID.
	//
	// DatastoreId is a required field
	DatastoreId *string `min:"1" type:"string" required:"true"`

	// The input properties of the FHIR Import job in the StartFHIRImport job request.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The name of the FHIR Import job in the StartFHIRImport job request.
	JobName *string `min:"1" type:"string"`

	// The output data configuration that was supplied when the export job was created.
	//
	// JobOutputDataConfig is a required field
	JobOutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFHIRImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFHIRImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFHIRImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFHIRImportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.JobOutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("JobOutputDataConfig"))
	}
	if s.JobOutputDataConfig != nil {
		if err := s.JobOutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("JobOutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartFHIRImportJobInput) SetClientToken(v string) *StartFHIRImportJobInput {
	s.ClientToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartFHIRImportJobInput) SetDataAccessRoleArn(v string) *StartFHIRImportJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *StartFHIRImportJobInput) SetDatastoreId(v string) *StartFHIRImportJobInput {
	s.DatastoreId = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartFHIRImportJobInput) SetInputDataConfig(v *InputDataConfig) *StartFHIRImportJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartFHIRImportJobInput) SetJobName(v string) *StartFHIRImportJobInput {
	s.JobName = &v
	return s
}

// SetJobOutputDataConfig sets the JobOutputDataConfig field's value.
func (s *StartFHIRImportJobInput) SetJobOutputDataConfig(v *OutputDataConfig) *StartFHIRImportJobInput {
	s.JobOutputDataConfig = v
	return s
}

type StartFHIRImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The AWS-generated Data Store ID.
	DatastoreId *string `min:"1" type:"string"`

	// The AWS-generated job ID.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The status of an import job.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFHIRImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFHIRImportJobOutput) GoString() string {
	return s.String()
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *StartFHIRImportJobOutput) SetDatastoreId(v string) *StartFHIRImportJobOutput {
	s.DatastoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartFHIRImportJobOutput) SetJobId(v string) *StartFHIRImportJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartFHIRImportJobOutput) SetJobStatus(v string) *StartFHIRImportJobOutput {
	s.JobStatus = &v
	return s
}

// A tag is a label consisting of a user-defined key and value. The form for
// tags is {"Key", "Value"}
type Tag struct {
	_ struct{} `type:"structure"`

	// The key portion of a tag. Tag keys are case sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value portion of a tag. Tag values are case sensitive.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data
	// Store which tags are being added to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The user specified key and value pair tags being added to a Data Store.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The user has exceeded their maximum number of allowed calls to the given
// API.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// "The Amazon Resource Name(ARN) of the Data Store for which tags are being
	// removed
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The keys for the tags to be removed from the Healthlake Data Store.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The user input parameter was invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AuthorizationStrategySmartOnFhirV1 is a AuthorizationStrategy enum value
	AuthorizationStrategySmartOnFhirV1 = "SMART_ON_FHIR_V1"

	// AuthorizationStrategyAwsAuth is a AuthorizationStrategy enum value
	AuthorizationStrategyAwsAuth = "AWS_AUTH"
)

// AuthorizationStrategy_Values returns all elements of the AuthorizationStrategy enum
func AuthorizationStrategy_Values() []string {
	return []string{
		AuthorizationStrategySmartOnFhirV1,
		AuthorizationStrategyAwsAuth,
	}
}

const (
	// CmkTypeCustomerManagedKmsKey is a CmkType enum value
	CmkTypeCustomerManagedKmsKey = "CUSTOMER_MANAGED_KMS_KEY"

	// CmkTypeAwsOwnedKmsKey is a CmkType enum value
	CmkTypeAwsOwnedKmsKey = "AWS_OWNED_KMS_KEY"
)

// CmkType_Values returns all elements of the CmkType enum
func CmkType_Values() []string {
	return []string{
		CmkTypeCustomerManagedKmsKey,
		CmkTypeAwsOwnedKmsKey,
	}
}

const (
	// DatastoreStatusCreating is a DatastoreStatus enum value
	DatastoreStatusCreating = "CREATING"

	// DatastoreStatusActive is a DatastoreStatus enum value
	DatastoreStatusActive = "ACTIVE"

	// DatastoreStatusDeleting is a DatastoreStatus enum value
	DatastoreStatusDeleting = "DELETING"

	// DatastoreStatusDeleted is a DatastoreStatus enum value
	DatastoreStatusDeleted = "DELETED"
)

// DatastoreStatus_Values returns all elements of the DatastoreStatus enum
func DatastoreStatus_Values() []string {
	return []string{
		DatastoreStatusCreating,
		DatastoreStatusActive,
		DatastoreStatusDeleting,
		DatastoreStatusDeleted,
	}
}

const (
	// FHIRVersionR4 is a FHIRVersion enum value
	FHIRVersionR4 = "R4"
)

// FHIRVersion_Values returns all elements of the FHIRVersion enum
func FHIRVersion_Values() []string {
	return []string{
		FHIRVersionR4,
	}
}

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompletedWithErrors is a JobStatus enum value
	JobStatusCompletedWithErrors = "COMPLETED_WITH_ERRORS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusCancelSubmitted is a JobStatus enum value
	JobStatusCancelSubmitted = "CANCEL_SUBMITTED"

	// JobStatusCancelInProgress is a JobStatus enum value
	JobStatusCancelInProgress = "CANCEL_IN_PROGRESS"

	// JobStatusCancelCompleted is a JobStatus enum value
	JobStatusCancelCompleted = "CANCEL_COMPLETED"

	// JobStatusCancelFailed is a JobStatus enum value
	JobStatusCancelFailed = "CANCEL_FAILED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusSubmitted,
		JobStatusInProgress,
		JobStatusCompletedWithErrors,
		JobStatusCompleted,
		JobStatusFailed,
		JobStatusCancelSubmitted,
		JobStatusCancelInProgress,
		JobStatusCancelCompleted,
		JobStatusCancelFailed,
	}
}

const (
	// PreloadDataTypeSynthea is a PreloadDataType enum value
	PreloadDataTypeSynthea = "SYNTHEA"
)

// PreloadDataType_Values returns all elements of the PreloadDataType enum
func PreloadDataType_Values() []string {
	return []string{
		PreloadDataTypeSynthea,
	}
}
