// Code generated by help.awk. DO NOT EDIT.
// GENERATED FILE DO NOT EDIT

package parser

var helpMessages = map[string]HelpMessageBody{
	//line sql.y: 1079
	`ALTER`: {
		//line sql.y: 1080
		Category: hGroup,
		//line sql.y: 1081
		Text: `ALTER TABLE, ALTER INDEX, ALTER VIEW, ALTER SEQUENCE, ALTER DATABASE, ALTER USER
`,
	},
	//line sql.y: 1095
	`ALTER TABLE`: {
		ShortDescription: `change the definition of a table`,
		//line sql.y: 1096
		Category: hDDL,
		//line sql.y: 1097
		Text: `
ALTER TABLE [IF EXISTS] <tablename> <command> [, ...]

Commands:
  ALTER TABLE ... ADD [COLUMN] [IF NOT EXISTS] <colname> <type> [<qualifiers...>]
  ALTER TABLE ... ADD <constraint>
  ALTER TABLE ... DROP [COLUMN] [IF EXISTS] <colname> [RESTRICT | CASCADE]
  ALTER TABLE ... DROP CONSTRAINT [IF EXISTS] <constraintname> [RESTRICT | CASCADE]
  ALTER TABLE ... ALTER [COLUMN] <colname> {SET DEFAULT <expr> | DROP DEFAULT}
  ALTER TABLE ... ALTER [COLUMN] <colname> DROP NOT NULL
  ALTER TABLE ... ALTER [COLUMN] <colname> DROP STORED
  ALTER TABLE ... ALTER [COLUMN] <colname> [SET DATA] TYPE <type> [COLLATE <collation>]
  ALTER TABLE ... RENAME TO <newname>
  ALTER TABLE ... RENAME [COLUMN] <colname> TO <newname>
  ALTER TABLE ... VALIDATE CONSTRAINT <constraintname>
  ALTER TABLE ... SPLIT AT <selectclause>
  ALTER TABLE ... SCATTER [ FROM ( <exprs...> ) TO ( <exprs...> ) ]
  ALTER TABLE ... INJECT STATISTICS ...  (experimental)
  ALTER TABLE ... PARTITION BY RANGE ( <name...> ) ( <rangespec> )
  ALTER TABLE ... PARTITION BY LIST ( <name...> ) ( <listspec> )
  ALTER TABLE ... PARTITION BY NOTHING
  ALTER TABLE ... CONFIGURE ZONE <zoneconfig>
  ALTER PARTITION ... OF TABLE ... CONFIGURE ZONE <zoneconfig>

Column qualifiers:
  [CONSTRAINT <constraintname>] {NULL | NOT NULL | UNIQUE | PRIMARY KEY | CHECK (<expr>) | DEFAULT <expr>}
  FAMILY <familyname>, CREATE [IF NOT EXISTS] FAMILY [<familyname>]
  REFERENCES <tablename> [( <colnames...> )]
  COLLATE <collationname>

Zone configurations:
  DISCARD
  USING <var> = <expr> [, ...]
  { TO | = } <expr>

`,
		//line sql.y: 1132
		SeeAlso: `WEBDOCS/alter-table.html
`,
	},
	//line sql.y: 1146
	`ALTER VIEW`: {
		ShortDescription: `change the definition of a view`,
		//line sql.y: 1147
		Category: hDDL,
		//line sql.y: 1148
		Text: `
ALTER VIEW [IF EXISTS] <name> RENAME TO <newname>
`,
		//line sql.y: 1150
		SeeAlso: `WEBDOCS/alter-view.html
`,
	},
	//line sql.y: 1157
	`ALTER SEQUENCE`: {
		ShortDescription: `change the definition of a sequence`,
		//line sql.y: 1158
		Category: hDDL,
		//line sql.y: 1159
		Text: `
ALTER SEQUENCE [IF EXISTS] <name>
  [INCREMENT <increment>]
  [MINVALUE <minvalue> | NO MINVALUE]
  [MAXVALUE <maxvalue> | NO MAXVALUE]
  [START <start>]
  [[NO] CYCLE]
ALTER SEQUENCE [IF EXISTS] <name> RENAME TO <newname>
`,
	},
	//line sql.y: 1182
	`ALTER USER`: {
		ShortDescription: `change user properties`,
		//line sql.y: 1183
		Category: hPriv,
		//line sql.y: 1184
		Text: `
ALTER USER [IF EXISTS] <name> WITH PASSWORD <password>
`,
		//line sql.y: 1186
		SeeAlso: `CREATE USER
`,
	},
	//line sql.y: 1191
	`ALTER DATABASE`: {
		ShortDescription: `change the definition of a database`,
		//line sql.y: 1192
		Category: hDDL,
		//line sql.y: 1193
		Text: `
ALTER DATABASE <name> RENAME TO <newname>
`,
		//line sql.y: 1195
		SeeAlso: `WEBDOCS/alter-database.html
`,
	},
	//line sql.y: 1203
	`ALTER RANGE`: {
		ShortDescription: `change the parameters of a range`,
		//line sql.y: 1204
		Category: hDDL,
		//line sql.y: 1205
		Text: `
ALTER RANGE <zonename> <command>

Commands:
  ALTER RANGE ... CONFIGURE ZONE <zoneconfig>

Zone configurations:
  DISCARD
  USING <var> = <expr> [, ...]
  { TO | = } <expr>

`,
		//line sql.y: 1216
		SeeAlso: `ALTER TABLE
`,
	},
	//line sql.y: 1221
	`ALTER INDEX`: {
		ShortDescription: `change the definition of an index`,
		//line sql.y: 1222
		Category: hDDL,
		//line sql.y: 1223
		Text: `
ALTER INDEX [IF EXISTS] <idxname> <command>

Commands:
  ALTER INDEX ... RENAME TO <newname>
  ALTER INDEX ... SPLIT AT <selectclause>
  ALTER INDEX ... SCATTER [ FROM ( <exprs...> ) TO ( <exprs...> ) ]

`,
		//line sql.y: 1231
		SeeAlso: `WEBDOCS/alter-index.html
`,
	},
	//line sql.y: 1605
	`BACKUP`: {
		ShortDescription: `back up data to external storage`,
		//line sql.y: 1606
		Category: hCCL,
		//line sql.y: 1607
		Text: `
BACKUP <targets...> TO <location...>
       [ AS OF SYSTEM TIME <expr> ]
       [ INCREMENTAL FROM <location...> ]
       [ WITH <option> [= <value>] [, ...] ]

Targets:
   TABLE <pattern> [, ...]
   DATABASE <databasename> [, ...]

Location:
   "[scheme]://[host]/[path to backup]?[parameters]"

Options:
   INTO_DB
   SKIP_MISSING_FOREIGN_KEYS

`,
		//line sql.y: 1624
		SeeAlso: `RESTORE, WEBDOCS/backup.html
`,
	},
	//line sql.y: 1632
	`RESTORE`: {
		ShortDescription: `restore data from external storage`,
		//line sql.y: 1633
		Category: hCCL,
		//line sql.y: 1634
		Text: `
RESTORE <targets...> FROM <location...>
        [ AS OF SYSTEM TIME <expr> ]
        [ WITH <option> [= <value>] [, ...] ]

Targets:
   TABLE <pattern> [, ...]
   DATABASE <databasename> [, ...]

Locations:
   "[scheme]://[host]/[path to backup]?[parameters]"

Options:
   INTO_DB
   SKIP_MISSING_FOREIGN_KEYS

`,
		//line sql.y: 1650
		SeeAlso: `BACKUP, WEBDOCS/restore.html
`,
	},
	//line sql.y: 1668
	`IMPORT`: {
		ShortDescription: `load data from file in a distributed manner`,
		//line sql.y: 1669
		Category: hCCL,
		//line sql.y: 1670
		Text: `
-- Import both schema and table data:
IMPORT [ TABLE <tablename> FROM ]
       <format> <datafile>
       [ WITH <option> [= <value>] [, ...] ]

-- Import using specific schema, use only table data from external file:
IMPORT TABLE <tablename>
       { ( <elements> ) | CREATE USING <schemafile> }
       <format>
       DATA ( <datafile> [, ...] )
       [ WITH <option> [= <value>] [, ...] ]

Formats:
   CSV
   MYSQLOUTFILE
   MYSQLDUMP (mysqldump's SQL output)
   PGCOPY
   PGDUMP

Options:
   distributed = '...'
   sstsize = '...'
   temp = '...'
   delimiter = '...'      [CSV, PGCOPY-specific]
   nullif = '...'         [CSV, PGCOPY-specific]
   comment = '...'        [CSV-specific]

`,
		//line sql.y: 1698
		SeeAlso: `CREATE TABLE
`,
	},
	//line sql.y: 1728
	`EXPORT`: {
		ShortDescription: `export data to file in a distributed manner`,
		//line sql.y: 1729
		Category: hCCL,
		//line sql.y: 1730
		Text: `
EXPORT INTO <format> (<datafile> [WITH <option> [= value] [,...]]) FROM <query>

Formats:
   CSV

Options:
   delimiter = '...'   [CSV-specific]

`,
		//line sql.y: 1739
		SeeAlso: `SELECT
`,
	},
	//line sql.y: 1829
	`CANCEL`: {
		//line sql.y: 1830
		Category: hGroup,
		//line sql.y: 1831
		Text: `CANCEL JOBS, CANCEL QUERIES, CANCEL SESSIONS
`,
	},
	//line sql.y: 1838
	`CANCEL JOBS`: {
		ShortDescription: `cancel background jobs`,
		//line sql.y: 1839
		Category: hMisc,
		//line sql.y: 1840
		Text: `
CANCEL JOBS <selectclause>
CANCEL JOB <jobid>
`,
		//line sql.y: 1843
		SeeAlso: `SHOW JOBS, PAUSE JOBS, RESUME JOBS
`,
	},
	//line sql.y: 1861
	`CANCEL QUERIES`: {
		ShortDescription: `cancel running queries`,
		//line sql.y: 1862
		Category: hMisc,
		//line sql.y: 1863
		Text: `
CANCEL QUERIES [IF EXISTS] <selectclause>
CANCEL QUERY [IF EXISTS] <expr>
`,
		//line sql.y: 1866
		SeeAlso: `SHOW QUERIES
`,
	},
	//line sql.y: 1897
	`CANCEL SESSIONS`: {
		ShortDescription: `cancel open sessions`,
		//line sql.y: 1898
		Category: hMisc,
		//line sql.y: 1899
		Text: `
CANCEL SESSIONS [IF EXISTS] <selectclause>
CANCEL SESSION [IF EXISTS] <sessionid>
`,
		//line sql.y: 1902
		SeeAlso: `SHOW SESSIONS
`,
	},
	//line sql.y: 1951
	`CREATE`: {
		//line sql.y: 1952
		Category: hGroup,
		//line sql.y: 1953
		Text: `
CREATE DATABASE, CREATE TABLE, CREATE INDEX, CREATE TABLE AS,
CREATE USER, CREATE VIEW, CREATE SEQUENCE, CREATE STATISTICS,
CREATE ROLE
`,
	},
	//line sql.y: 2034
	`CREATE STATISTICS`: {
		ShortDescription: `create a new table statistic (experimental)`,
		//line sql.y: 2035
		Category: hExperimental,
		//line sql.y: 2036
		Text: `
CREATE STATISTICS <statisticname>
  ON <colname> [, ...]
  FROM <tablename>
`,
	},
	//line sql.y: 2094
	`DELETE`: {
		ShortDescription: `delete rows from a table`,
		//line sql.y: 2095
		Category: hDML,
		//line sql.y: 2096
		Text: `DELETE FROM <tablename> [WHERE <expr>]
              [ORDER BY <exprs...>]
              [LIMIT <expr>]
              [RETURNING <exprs...>]
`,
		//line sql.y: 2100
		SeeAlso: `WEBDOCS/delete.html
`,
	},
	//line sql.y: 2115
	`DISCARD`: {
		ShortDescription: `reset the session to its initial state`,
		//line sql.y: 2116
		Category: hCfg,
		//line sql.y: 2117
		Text: `DISCARD ALL
`,
	},
	//line sql.y: 2129
	`DROP`: {
		//line sql.y: 2130
		Category: hGroup,
		//line sql.y: 2131
		Text: `
DROP DATABASE, DROP INDEX, DROP TABLE, DROP VIEW, DROP SEQUENCE,
DROP USER, DROP ROLE
`,
	},
	//line sql.y: 2148
	`DROP VIEW`: {
		ShortDescription: `remove a view`,
		//line sql.y: 2149
		Category: hDDL,
		//line sql.y: 2150
		Text: `DROP VIEW [IF EXISTS] <tablename> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 2151
		SeeAlso: `WEBDOCS/drop-index.html
`,
	},
	//line sql.y: 2163
	`DROP SEQUENCE`: {
		ShortDescription: `remove a sequence`,
		//line sql.y: 2164
		Category: hDDL,
		//line sql.y: 2165
		Text: `DROP SEQUENCE [IF EXISTS] <sequenceName> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 2166
		SeeAlso: `DROP
`,
	},
	//line sql.y: 2178
	`DROP TABLE`: {
		ShortDescription: `remove a table`,
		//line sql.y: 2179
		Category: hDDL,
		//line sql.y: 2180
		Text: `DROP TABLE [IF EXISTS] <tablename> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 2181
		SeeAlso: `WEBDOCS/drop-table.html
`,
	},
	//line sql.y: 2193
	`DROP INDEX`: {
		ShortDescription: `remove an index`,
		//line sql.y: 2194
		Category: hDDL,
		//line sql.y: 2195
		Text: `DROP INDEX [IF EXISTS] <idxname> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 2196
		SeeAlso: `WEBDOCS/drop-index.html
`,
	},
	//line sql.y: 2216
	`DROP DATABASE`: {
		ShortDescription: `remove a database`,
		//line sql.y: 2217
		Category: hDDL,
		//line sql.y: 2218
		Text: `DROP DATABASE [IF EXISTS] <databasename> [CASCADE | RESTRICT]
`,
		//line sql.y: 2219
		SeeAlso: `WEBDOCS/drop-database.html
`,
	},
	//line sql.y: 2239
	`DROP USER`: {
		ShortDescription: `remove a user`,
		//line sql.y: 2240
		Category: hPriv,
		//line sql.y: 2241
		Text: `DROP USER [IF EXISTS] <user> [, ...]
`,
		//line sql.y: 2242
		SeeAlso: `CREATE USER, SHOW USERS
`,
	},
	//line sql.y: 2254
	`DROP ROLE`: {
		ShortDescription: `remove a role`,
		//line sql.y: 2255
		Category: hPriv,
		//line sql.y: 2256
		Text: `DROP ROLE [IF EXISTS] <role> [, ...]
`,
		//line sql.y: 2257
		SeeAlso: `CREATE ROLE, SHOW ROLES
`,
	},
	//line sql.y: 2279
	`EXPLAIN`: {
		ShortDescription: `show the logical plan of a query`,
		//line sql.y: 2280
		Category: hMisc,
		//line sql.y: 2281
		Text: `
EXPLAIN <statement>
EXPLAIN ([PLAN ,] <planoptions...> ) <statement>
EXPLAIN [ANALYZE] (DISTSQL) <statement>
EXPLAIN ANALYZE [(DISTSQL)] <statement>

Explainable statements:
    SELECT, CREATE, DROP, ALTER, INSERT, UPSERT, UPDATE, DELETE,
    SHOW, EXPLAIN

Plan options:
    TYPES, VERBOSE, OPT

`,
		//line sql.y: 2294
		SeeAlso: `WEBDOCS/explain.html
`,
	},
	//line sql.y: 2354
	`PREPARE`: {
		ShortDescription: `prepare a statement for later execution`,
		//line sql.y: 2355
		Category: hMisc,
		//line sql.y: 2356
		Text: `PREPARE <name> [ ( <types...> ) ] AS <query>
`,
		//line sql.y: 2357
		SeeAlso: `EXECUTE, DEALLOCATE, DISCARD
`,
	},
	//line sql.y: 2379
	`EXECUTE`: {
		ShortDescription: `execute a statement prepared previously`,
		//line sql.y: 2380
		Category: hMisc,
		//line sql.y: 2381
		Text: `EXECUTE <name> [ ( <exprs...> ) ]
`,
		//line sql.y: 2382
		SeeAlso: `PREPARE, DEALLOCATE, DISCARD
`,
	},
	//line sql.y: 2403
	`DEALLOCATE`: {
		ShortDescription: `remove a prepared statement`,
		//line sql.y: 2404
		Category: hMisc,
		//line sql.y: 2405
		Text: `DEALLOCATE [PREPARE] { <name> | ALL }
`,
		//line sql.y: 2406
		SeeAlso: `PREPARE, EXECUTE, DISCARD
`,
	},
	//line sql.y: 2426
	`GRANT`: {
		ShortDescription: `define access privileges and role memberships`,
		//line sql.y: 2427
		Category: hPriv,
		//line sql.y: 2428
		Text: `
Grant privileges:
  GRANT {ALL | <privileges...> } ON <targets...> TO <grantees...>
Grant role membership (CCL only):
  GRANT <roles...> TO <grantees...> [WITH ADMIN OPTION]

Privileges:
  CREATE, DROP, GRANT, SELECT, INSERT, DELETE, UPDATE

Targets:
  DATABASE <databasename> [, ...]
  [TABLE] [<databasename> .] { <tablename> | * } [, ...]

`,
		//line sql.y: 2441
		SeeAlso: `REVOKE, WEBDOCS/grant.html
`,
	},
	//line sql.y: 2457
	`REVOKE`: {
		ShortDescription: `remove access privileges and role memberships`,
		//line sql.y: 2458
		Category: hPriv,
		//line sql.y: 2459
		Text: `
Revoke privileges:
  REVOKE {ALL | <privileges...> } ON <targets...> FROM <grantees...>
Revoke role membership (CCL only):
  REVOKE [ADMIN OPTION FOR] <roles...> FROM <grantees...>

Privileges:
  CREATE, DROP, GRANT, SELECT, INSERT, DELETE, UPDATE

Targets:
  DATABASE <databasename> [, <databasename>]...
  [TABLE] [<databasename> .] { <tablename> | * } [, ...]

`,
		//line sql.y: 2472
		SeeAlso: `GRANT, WEBDOCS/revoke.html
`,
	},
	//line sql.y: 2527
	`RESET`: {
		ShortDescription: `reset a session variable to its default value`,
		//line sql.y: 2528
		Category: hCfg,
		//line sql.y: 2529
		Text: `RESET [SESSION] <var>
`,
		//line sql.y: 2530
		SeeAlso: `RESET CLUSTER SETTING, WEBDOCS/set-vars.html
`,
	},
	//line sql.y: 2542
	`RESET CLUSTER SETTING`: {
		ShortDescription: `reset a cluster setting to its default value`,
		//line sql.y: 2543
		Category: hCfg,
		//line sql.y: 2544
		Text: `RESET CLUSTER SETTING <var>
`,
		//line sql.y: 2545
		SeeAlso: `SET CLUSTER SETTING, RESET
`,
	},
	//line sql.y: 2554
	`USE`: {
		ShortDescription: `set the current database`,
		//line sql.y: 2555
		Category: hCfg,
		//line sql.y: 2556
		Text: `USE <dbname>

"USE <dbname>" is an alias for "SET [SESSION] database = <dbname>".
`,
		//line sql.y: 2559
		SeeAlso: `SET SESSION, WEBDOCS/set-vars.html
`,
	},
	//line sql.y: 2580
	`SCRUB`: {
		ShortDescription: `run checks against databases or tables`,
		//line sql.y: 2581
		Category: hExperimental,
		//line sql.y: 2582
		Text: `
EXPERIMENTAL SCRUB TABLE <table> ...
EXPERIMENTAL SCRUB DATABASE <database>

The various checks that ca be run with SCRUB includes:
  - Physical table data (encoding)
  - Secondary index integrity
  - Constraint integrity (NOT NULL, CHECK, FOREIGN KEY, UNIQUE)
`,
		//line sql.y: 2590
		SeeAlso: `SCRUB TABLE, SCRUB DATABASE
`,
	},
	//line sql.y: 2596
	`SCRUB DATABASE`: {
		ShortDescription: `run scrub checks on a database`,
		//line sql.y: 2597
		Category: hExperimental,
		//line sql.y: 2598
		Text: `
EXPERIMENTAL SCRUB DATABASE <database>
                            [AS OF SYSTEM TIME <expr>]

All scrub checks will be run on the database. This includes:
  - Physical table data (encoding)
  - Secondary index integrity
  - Constraint integrity (NOT NULL, CHECK, FOREIGN KEY, UNIQUE)
`,
		//line sql.y: 2606
		SeeAlso: `SCRUB TABLE, SCRUB
`,
	},
	//line sql.y: 2614
	`SCRUB TABLE`: {
		ShortDescription: `run scrub checks on a table`,
		//line sql.y: 2615
		Category: hExperimental,
		//line sql.y: 2616
		Text: `
SCRUB TABLE <tablename>
            [AS OF SYSTEM TIME <expr>]
            [WITH OPTIONS <option> [, ...]]

Options:
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS INDEX ALL
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS INDEX (<index>...)
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS CONSTRAINT ALL
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS CONSTRAINT (<constraint>...)
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS PHYSICAL
`,
		//line sql.y: 2627
		SeeAlso: `SCRUB DATABASE, SRUB
`,
	},
	//line sql.y: 2682
	`SET CLUSTER SETTING`: {
		ShortDescription: `change a cluster setting`,
		//line sql.y: 2683
		Category: hCfg,
		//line sql.y: 2684
		Text: `SET CLUSTER SETTING <var> { TO | = } <value>
`,
		//line sql.y: 2685
		SeeAlso: `SHOW CLUSTER SETTING, RESET CLUSTER SETTING, SET SESSION,
WEBDOCS/cluster-settings.html
`,
	},
	//line sql.y: 2706
	`SET SESSION`: {
		ShortDescription: `change a session variable`,
		//line sql.y: 2707
		Category: hCfg,
		//line sql.y: 2708
		Text: `
SET [SESSION] <var> { TO | = } <values...>
SET [SESSION] TIME ZONE <tz>
SET [SESSION] CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL { SNAPSHOT | SERIALIZABLE }
SET [SESSION] TRACING { TO | = } { on | off | cluster | local | kv | results } [,...]

`,
		//line sql.y: 2714
		SeeAlso: `SHOW SESSION, RESET, DISCARD, SHOW, SET CLUSTER SETTING, SET TRANSACTION,
WEBDOCS/set-vars.html
`,
	},
	//line sql.y: 2731
	`SET TRANSACTION`: {
		ShortDescription: `configure the transaction settings`,
		//line sql.y: 2732
		Category: hTxn,
		//line sql.y: 2733
		Text: `
SET [SESSION] TRANSACTION <txnparameters...>

Transaction parameters:
   ISOLATION LEVEL { SNAPSHOT | SERIALIZABLE }
   PRIORITY { LOW | NORMAL | HIGH }

`,
		//line sql.y: 2740
		SeeAlso: `SHOW TRANSACTION, SET SESSION,
WEBDOCS/set-transaction.html
`,
	},
	//line sql.y: 2908
	`SHOW`: {
		//line sql.y: 2909
		Category: hGroup,
		//line sql.y: 2910
		Text: `
SHOW BACKUP, SHOW CLUSTER SETTING, SHOW COLUMNS, SHOW CONSTRAINTS,
SHOW CREATE, SHOW DATABASES, SHOW HISTOGRAM, SHOW INDEXES, SHOW JOBS,
SHOW QUERIES, SHOW ROLES, SHOW SESSION, SHOW SESSIONS, SHOW STATISTICS,
SHOW SYNTAX, SHOW TABLES, SHOW TRACE SHOW TRANSACTION, SHOW USERS
`,
	},
	//line sql.y: 2942
	`SHOW SESSION`: {
		ShortDescription: `display session variables`,
		//line sql.y: 2943
		Category: hCfg,
		//line sql.y: 2944
		Text: `SHOW [SESSION] { <var> | ALL }
`,
		//line sql.y: 2945
		SeeAlso: `WEBDOCS/show-vars.html
`,
	},
	//line sql.y: 2966
	`SHOW STATISTICS`: {
		ShortDescription: `display table statistics (experimental)`,
		//line sql.y: 2967
		Category: hExperimental,
		//line sql.y: 2968
		Text: `SHOW STATISTICS [USING JSON] FOR TABLE <table_name>

Returns the available statistics for a table.
The statistics can include a histogram ID, which can
be used with SHOW HISTOGRAM.
If USING JSON is specified, the statistics and histograms
are encoded in JSON format.
`,
		//line sql.y: 2975
		SeeAlso: `SHOW HISTOGRAM
`,
	},
	//line sql.y: 2989
	`SHOW HISTOGRAM`: {
		ShortDescription: `display histogram (experimental)`,
		//line sql.y: 2990
		Category: hExperimental,
		//line sql.y: 2991
		Text: `SHOW HISTOGRAM <histogram_id>

Returns the data in the histogram with the
given ID (as returned by SHOW STATISTICS).
`,
		//line sql.y: 2995
		SeeAlso: `SHOW STATISTICS
`,
	},
	//line sql.y: 3009
	`SHOW BACKUP`: {
		ShortDescription: `list backup contents`,
		//line sql.y: 3010
		Category: hCCL,
		//line sql.y: 3011
		Text: `SHOW BACKUP [FILES|RANGES] <location>
`,
		//line sql.y: 3012
		SeeAlso: `WEBDOCS/show-backup.html
`,
	},
	//line sql.y: 3039
	`SHOW CLUSTER SETTING`: {
		ShortDescription: `display cluster settings`,
		//line sql.y: 3040
		Category: hCfg,
		//line sql.y: 3041
		Text: `
SHOW CLUSTER SETTING <var>
SHOW ALL CLUSTER SETTINGS
`,
		//line sql.y: 3044
		SeeAlso: `WEBDOCS/cluster-settings.html
`,
	},
	//line sql.y: 3061
	`SHOW COLUMNS`: {
		ShortDescription: `list columns in relation`,
		//line sql.y: 3062
		Category: hDDL,
		//line sql.y: 3063
		Text: `SHOW COLUMNS FROM <tablename>
`,
		//line sql.y: 3064
		SeeAlso: `WEBDOCS/show-columns.html
`,
	},
	//line sql.y: 3072
	`SHOW DATABASES`: {
		ShortDescription: `list databases`,
		//line sql.y: 3073
		Category: hDDL,
		//line sql.y: 3074
		Text: `SHOW DATABASES
`,
		//line sql.y: 3075
		SeeAlso: `WEBDOCS/show-databases.html
`,
	},
	//line sql.y: 3083
	`SHOW GRANTS`: {
		ShortDescription: `list grants`,
		//line sql.y: 3084
		Category: hPriv,
		//line sql.y: 3085
		Text: `
Show privilege grants:
  SHOW GRANTS [ON <targets...>] [FOR <users...>]
Show role grants:
  SHOW GRANTS ON ROLE [<roles...>] [FOR <grantees...>]

`,
		//line sql.y: 3091
		SeeAlso: `WEBDOCS/show-grants.html
`,
	},
	//line sql.y: 3104
	`SHOW INDEXES`: {
		ShortDescription: `list indexes`,
		//line sql.y: 3105
		Category: hDDL,
		//line sql.y: 3106
		Text: `SHOW INDEXES FROM <tablename>
`,
		//line sql.y: 3107
		SeeAlso: `WEBDOCS/show-index.html
`,
	},
	//line sql.y: 3125
	`SHOW CONSTRAINTS`: {
		ShortDescription: `list constraints`,
		//line sql.y: 3126
		Category: hDDL,
		//line sql.y: 3127
		Text: `SHOW CONSTRAINTS FROM <tablename>
`,
		//line sql.y: 3128
		SeeAlso: `WEBDOCS/show-constraints.html
`,
	},
	//line sql.y: 3141
	`SHOW QUERIES`: {
		ShortDescription: `list running queries`,
		//line sql.y: 3142
		Category: hMisc,
		//line sql.y: 3143
		Text: `SHOW [CLUSTER | LOCAL] QUERIES
`,
		//line sql.y: 3144
		SeeAlso: `CANCEL QUERIES
`,
	},
	//line sql.y: 3160
	`SHOW JOBS`: {
		ShortDescription: `list background jobs`,
		//line sql.y: 3161
		Category: hMisc,
		//line sql.y: 3162
		Text: `SHOW JOBS
`,
		//line sql.y: 3163
		SeeAlso: `CANCEL JOBS, PAUSE JOBS, RESUME JOBS
`,
	},
	//line sql.y: 3171
	`SHOW TRACE`: {
		ShortDescription: `display an execution trace`,
		//line sql.y: 3172
		Category: hMisc,
		//line sql.y: 3173
		Text: `
SHOW [COMPACT] [KV] TRACE FOR SESSION
`,
		//line sql.y: 3175
		SeeAlso: `EXPLAIN
`,
	},
	//line sql.y: 3198
	`SHOW SESSIONS`: {
		ShortDescription: `list open client sessions`,
		//line sql.y: 3199
		Category: hMisc,
		//line sql.y: 3200
		Text: `SHOW [CLUSTER | LOCAL] SESSIONS
`,
		//line sql.y: 3201
		SeeAlso: `CANCEL SESSIONS
`,
	},
	//line sql.y: 3217
	`SHOW TABLES`: {
		ShortDescription: `list tables`,
		//line sql.y: 3218
		Category: hDDL,
		//line sql.y: 3219
		Text: `SHOW TABLES [FROM <databasename> [ . <schemaname> ] ]
`,
		//line sql.y: 3220
		SeeAlso: `WEBDOCS/show-tables.html
`,
	},
	//line sql.y: 3246
	`SHOW SCHEMAS`: {
		ShortDescription: `list schemas`,
		//line sql.y: 3247
		Category: hDDL,
		//line sql.y: 3248
		Text: `SHOW SCHEMAS [FROM <databasename> ]
`,
	},
	//line sql.y: 3260
	`SHOW SYNTAX`: {
		ShortDescription: `analyze SQL syntax`,
		//line sql.y: 3261
		Category: hMisc,
		//line sql.y: 3262
		Text: `SHOW SYNTAX <string>
`,
	},
	//line sql.y: 3271
	`SHOW TRANSACTION`: {
		ShortDescription: `display current transaction properties`,
		//line sql.y: 3272
		Category: hCfg,
		//line sql.y: 3273
		Text: `SHOW TRANSACTION {ISOLATION LEVEL | PRIORITY | STATUS}
`,
		//line sql.y: 3274
		SeeAlso: `WEBDOCS/show-transaction.html
`,
	},
	//line sql.y: 3293
	`SHOW CREATE`: {
		ShortDescription: `display the CREATE statement for a table, sequence or view`,
		//line sql.y: 3294
		Category: hDDL,
		//line sql.y: 3295
		Text: `SHOW CREATE [ TABLE | SEQUENCE | VIEW ] <tablename>
`,
		//line sql.y: 3296
		SeeAlso: `WEBDOCS/show-create-table.html
`,
	},
	//line sql.y: 3314
	`SHOW USERS`: {
		ShortDescription: `list defined users`,
		//line sql.y: 3315
		Category: hPriv,
		//line sql.y: 3316
		Text: `SHOW USERS
`,
		//line sql.y: 3317
		SeeAlso: `CREATE USER, DROP USER, WEBDOCS/show-users.html
`,
	},
	//line sql.y: 3325
	`SHOW ROLES`: {
		ShortDescription: `list defined roles`,
		//line sql.y: 3326
		Category: hPriv,
		//line sql.y: 3327
		Text: `SHOW ROLES
`,
		//line sql.y: 3328
		SeeAlso: `CREATE ROLE, DROP ROLE
`,
	},
	//line sql.y: 3373
	`SHOW RANGES`: {
		ShortDescription: `list ranges`,
		//line sql.y: 3374
		Category: hMisc,
		//line sql.y: 3375
		Text: `
SHOW EXPERIMENTAL_RANGES FROM TABLE <tablename>
SHOW EXPERIMENTAL_RANGES FROM INDEX [ <tablename> @ ] <indexname>
`,
	},
	//line sql.y: 3611
	`PAUSE JOBS`: {
		ShortDescription: `pause background jobs`,
		//line sql.y: 3612
		Category: hMisc,
		//line sql.y: 3613
		Text: `
PAUSE JOBS <selectclause>
PAUSE JOB <jobid>
`,
		//line sql.y: 3616
		SeeAlso: `SHOW JOBS, CANCEL JOBS, RESUME JOBS
`,
	},
	//line sql.y: 3633
	`CREATE TABLE`: {
		ShortDescription: `create a new table`,
		//line sql.y: 3634
		Category: hDDL,
		//line sql.y: 3635
		Text: `
CREATE TABLE [IF NOT EXISTS] <tablename> ( <elements...> ) [<interleave>]
CREATE TABLE [IF NOT EXISTS] <tablename> [( <colnames...> )] AS <source>

Table elements:
   <name> <type> [<qualifiers...>]
   [UNIQUE | INVERTED] INDEX [<name>] ( <colname> [ASC | DESC] [, ...] )
                           [STORING ( <colnames...> )] [<interleave>]
   FAMILY [<name>] ( <colnames...> )
   [CONSTRAINT <name>] <constraint>

Table constraints:
   PRIMARY KEY ( <colnames...> )
   FOREIGN KEY ( <colnames...> ) REFERENCES <tablename> [( <colnames...> )] [ON DELETE {NO ACTION | RESTRICT}] [ON UPDATE {NO ACTION | RESTRICT}]
   UNIQUE ( <colnames... ) [STORING ( <colnames...> )] [<interleave>]
   CHECK ( <expr> )

Column qualifiers:
  [CONSTRAINT <constraintname>] {NULL | NOT NULL | UNIQUE | PRIMARY KEY | CHECK (<expr>) | DEFAULT <expr>}
  FAMILY <familyname>, CREATE [IF NOT EXISTS] FAMILY [<familyname>]
  REFERENCES <tablename> [( <colnames...> )] [ON DELETE {NO ACTION | RESTRICT}] [ON UPDATE {NO ACTION | RESTRICT}]
  COLLATE <collationname>
  AS ( <expr> ) STORED

Interleave clause:
   INTERLEAVE IN PARENT <tablename> ( <colnames...> ) [CASCADE | RESTRICT]

`,
		//line sql.y: 3662
		SeeAlso: `SHOW TABLES, CREATE VIEW, SHOW CREATE,
WEBDOCS/create-table.html
WEBDOCS/create-table-as.html
`,
	},
	//line sql.y: 4232
	`CREATE SEQUENCE`: {
		ShortDescription: `create a new sequence`,
		//line sql.y: 4233
		Category: hDDL,
		//line sql.y: 4234
		Text: `
CREATE SEQUENCE <seqname>
  [INCREMENT <increment>]
  [MINVALUE <minvalue> | NO MINVALUE]
  [MAXVALUE <maxvalue> | NO MAXVALUE]
  [START [WITH] <start>]
  [CACHE <cache>]
  [NO CYCLE]
  [VIRTUAL]

`,
		//line sql.y: 4244
		SeeAlso: `CREATE TABLE
`,
	},
	//line sql.y: 4298
	`TRUNCATE`: {
		ShortDescription: `empty one or more tables`,
		//line sql.y: 4299
		Category: hDML,
		//line sql.y: 4300
		Text: `TRUNCATE [TABLE] <tablename> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 4301
		SeeAlso: `WEBDOCS/truncate.html
`,
	},
	//line sql.y: 4309
	`CREATE USER`: {
		ShortDescription: `define a new user`,
		//line sql.y: 4310
		Category: hPriv,
		//line sql.y: 4311
		Text: `CREATE USER [IF NOT EXISTS] <name> [ [WITH] PASSWORD <passwd> ]
`,
		//line sql.y: 4312
		SeeAlso: `DROP USER, SHOW USERS, WEBDOCS/create-user.html
`,
	},
	//line sql.y: 4334
	`CREATE ROLE`: {
		ShortDescription: `define a new role`,
		//line sql.y: 4335
		Category: hPriv,
		//line sql.y: 4336
		Text: `CREATE ROLE [IF NOT EXISTS] <name>
`,
		//line sql.y: 4337
		SeeAlso: `DROP ROLE, SHOW ROLES
`,
	},
	//line sql.y: 4355
	`CREATE VIEW`: {
		ShortDescription: `create a new view`,
		//line sql.y: 4356
		Category: hDDL,
		//line sql.y: 4357
		Text: `CREATE VIEW <viewname> [( <colnames...> )] AS <source>
`,
		//line sql.y: 4358
		SeeAlso: `CREATE TABLE, SHOW CREATE, WEBDOCS/create-view.html
`,
	},
	//line sql.y: 4391
	`CREATE INDEX`: {
		ShortDescription: `create a new index`,
		//line sql.y: 4392
		Category: hDDL,
		//line sql.y: 4393
		Text: `
CREATE [UNIQUE | INVERTED] INDEX [IF NOT EXISTS] [<idxname>]
       ON <tablename> ( <colname> [ASC | DESC] [, ...] )
       [STORING ( <colnames...> )] [<interleave>]

Interleave clause:
   INTERLEAVE IN PARENT <tablename> ( <colnames...> ) [CASCADE | RESTRICT]

`,
		//line sql.y: 4401
		SeeAlso: `CREATE TABLE, SHOW INDEXES, SHOW CREATE,
WEBDOCS/create-index.html
`,
	},
	//line sql.y: 4615
	`RELEASE`: {
		ShortDescription: `complete a retryable block`,
		//line sql.y: 4616
		Category: hTxn,
		//line sql.y: 4617
		Text: `RELEASE [SAVEPOINT] cockroach_restart
`,
		//line sql.y: 4618
		SeeAlso: `SAVEPOINT, WEBDOCS/savepoint.html
`,
	},
	//line sql.y: 4626
	`RESUME JOBS`: {
		ShortDescription: `resume background jobs`,
		//line sql.y: 4627
		Category: hMisc,
		//line sql.y: 4628
		Text: `
RESUME JOBS <selectclause>
RESUME JOB <jobid>
`,
		//line sql.y: 4631
		SeeAlso: `SHOW JOBS, CANCEL JOBS, PAUSE JOBS
`,
	},
	//line sql.y: 4648
	`SAVEPOINT`: {
		ShortDescription: `start a retryable block`,
		//line sql.y: 4649
		Category: hTxn,
		//line sql.y: 4650
		Text: `SAVEPOINT cockroach_restart
`,
		//line sql.y: 4651
		SeeAlso: `RELEASE, WEBDOCS/savepoint.html
`,
	},
	//line sql.y: 4666
	`BEGIN`: {
		ShortDescription: `start a transaction`,
		//line sql.y: 4667
		Category: hTxn,
		//line sql.y: 4668
		Text: `
BEGIN [TRANSACTION] [ <txnparameter> [[,] ...] ]
START TRANSACTION [ <txnparameter> [[,] ...] ]

Transaction parameters:
   ISOLATION LEVEL { SNAPSHOT | SERIALIZABLE }
   PRIORITY { LOW | NORMAL | HIGH }

`,
		//line sql.y: 4676
		SeeAlso: `COMMIT, ROLLBACK, WEBDOCS/begin-transaction.html
`,
	},
	//line sql.y: 4689
	`COMMIT`: {
		ShortDescription: `commit the current transaction`,
		//line sql.y: 4690
		Category: hTxn,
		//line sql.y: 4691
		Text: `
COMMIT [TRANSACTION]
END [TRANSACTION]
`,
		//line sql.y: 4694
		SeeAlso: `BEGIN, ROLLBACK, WEBDOCS/commit-transaction.html
`,
	},
	//line sql.y: 4718
	`ROLLBACK`: {
		ShortDescription: `abort the current transaction`,
		//line sql.y: 4719
		Category: hTxn,
		//line sql.y: 4720
		Text: `ROLLBACK [TRANSACTION] [TO [SAVEPOINT] cockroach_restart]
`,
		//line sql.y: 4721
		SeeAlso: `BEGIN, COMMIT, SAVEPOINT, WEBDOCS/rollback-transaction.html
`,
	},
	//line sql.y: 4834
	`CREATE DATABASE`: {
		ShortDescription: `create a new database`,
		//line sql.y: 4835
		Category: hDDL,
		//line sql.y: 4836
		Text: `CREATE DATABASE [IF NOT EXISTS] <name>
`,
		//line sql.y: 4837
		SeeAlso: `WEBDOCS/create-database.html
`,
	},
	//line sql.y: 4906
	`INSERT`: {
		ShortDescription: `create new rows in a table`,
		//line sql.y: 4907
		Category: hDML,
		//line sql.y: 4908
		Text: `
INSERT INTO <tablename> [[AS] <name>] [( <colnames...> )]
       <selectclause>
       [ON CONFLICT [( <colnames...> )] {DO UPDATE SET ... [WHERE <expr>] | DO NOTHING}]
       [RETURNING <exprs...>]
`,
		//line sql.y: 4913
		SeeAlso: `UPSERT, UPDATE, DELETE, WEBDOCS/insert.html
`,
	},
	//line sql.y: 4932
	`UPSERT`: {
		ShortDescription: `create or replace rows in a table`,
		//line sql.y: 4933
		Category: hDML,
		//line sql.y: 4934
		Text: `
UPSERT INTO <tablename> [AS <name>] [( <colnames...> )]
       <selectclause>
       [RETURNING <exprs...>]
`,
		//line sql.y: 4938
		SeeAlso: `INSERT, UPDATE, DELETE, WEBDOCS/upsert.html
`,
	},
	//line sql.y: 5043
	`UPDATE`: {
		ShortDescription: `update rows of a table`,
		//line sql.y: 5044
		Category: hDML,
		//line sql.y: 5045
		Text: `
UPDATE <tablename> [[AS] <name>]
       SET ...
       [WHERE <expr>]
       [ORDER BY <exprs...>]
       [LIMIT <expr>]
       [RETURNING <exprs...>]
`,
		//line sql.y: 5052
		SeeAlso: `INSERT, UPSERT, DELETE, WEBDOCS/update.html
`,
	},
	//line sql.y: 5226
	`<SELECTCLAUSE>`: {
		ShortDescription: `access tabular data`,
		//line sql.y: 5227
		Category: hDML,
		//line sql.y: 5228
		Text: `
Select clause:
  TABLE <tablename>
  VALUES ( <exprs...> ) [ , ... ]
  SELECT ... [ { INTERSECT | UNION | EXCEPT } [ ALL | DISTINCT ] <selectclause> ]
`,
	},
	//line sql.y: 5239
	`SELECT`: {
		ShortDescription: `retrieve rows from a data source and compute a result`,
		//line sql.y: 5240
		Category: hDML,
		//line sql.y: 5241
		Text: `
SELECT [DISTINCT [ ON ( <expr> [ , ... ] ) ] ]
       { <expr> [[AS] <name>] | [ [<dbname>.] <tablename>. ] * } [, ...]
       [ FROM <source> ]
       [ WHERE <expr> ]
       [ GROUP BY <expr> [ , ... ] ]
       [ HAVING <expr> ]
       [ WINDOW <name> AS ( <definition> ) ]
       [ { UNION | INTERSECT | EXCEPT } [ ALL | DISTINCT ] <selectclause> ]
       [ ORDER BY <expr> [ ASC | DESC ] [, ...] ]
       [ LIMIT { <expr> | ALL } ]
       [ OFFSET <expr> [ ROW | ROWS ] ]
`,
		//line sql.y: 5253
		SeeAlso: `WEBDOCS/select-clause.html
`,
	},
	//line sql.y: 5328
	`TABLE`: {
		ShortDescription: `select an entire table`,
		//line sql.y: 5329
		Category: hDML,
		//line sql.y: 5330
		Text: `TABLE <tablename>
`,
		//line sql.y: 5331
		SeeAlso: `SELECT, VALUES, WEBDOCS/table-expressions.html
`,
	},
	//line sql.y: 5604
	`VALUES`: {
		ShortDescription: `select a given set of values`,
		//line sql.y: 5605
		Category: hDML,
		//line sql.y: 5606
		Text: `VALUES ( <exprs...> ) [, ...]
`,
		//line sql.y: 5607
		SeeAlso: `SELECT, TABLE, WEBDOCS/table-expressions.html
`,
	},
	//line sql.y: 5712
	`<SOURCE>`: {
		ShortDescription: `define a data source for SELECT`,
		//line sql.y: 5713
		Category: hDML,
		//line sql.y: 5714
		Text: `
Data sources:
  <tablename> [ @ { <idxname> | <indexhint> } ]
  <tablefunc> ( <exprs...> )
  ( { <selectclause> | <source> } )
  <source> [AS] <alias> [( <colnames...> )]
  <source> { [INNER] | { LEFT | RIGHT | FULL } [OUTER] } JOIN <source> ON <expr>
  <source> { [INNER] | { LEFT | RIGHT | FULL } [OUTER] } JOIN <source> USING ( <colnames...> )
  <source> NATURAL { [INNER] | { LEFT | RIGHT | FULL } [OUTER] } JOIN <source>
  <source> CROSS JOIN <source>
  <source> WITH ORDINALITY
  '[' EXPLAIN ... ']'
  '[' SHOW ... ']'

Index flags:
  '{' FORCE_INDEX = <idxname> [, ...] '}'
  '{' NO_INDEX_JOIN [, ...] '}'

`,
		//line sql.y: 5732
		SeeAlso: `WEBDOCS/table-expressions.html
`,
	},
}
