// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: jobs/jobspb/jobs.proto

/*
	Package jobspb is a generated protocol buffer package.

	It is generated from these files:
		jobs/jobspb/jobs.proto

	It has these top-level messages:
		Lease
		BackupDetails
		BackupProgress
		RestoreDetails
		RestoreProgress
		ImportDetails
		ImportProgress
		ResumeSpanList
		SchemaChangeDetails
		SchemaChangeProgress
		ChangefeedTarget
		ChangefeedDetails
		ResolvedSpan
		ChangefeedProgress
		Payload
		Progress
*/
package jobspb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb2 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_sql_sqlbase1 "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import github_com_cockroachdb_cockroach_pkg_sql_sqlbase "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"

import sortkeys "github.com/gogo/protobuf/sortkeys"
import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Type int32

const (
	TypeUnspecified  Type = 0
	TypeBackup       Type = 1
	TypeRestore      Type = 2
	TypeSchemaChange Type = 3
	TypeImport       Type = 4
	TypeChangefeed   Type = 5
)

var Type_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "BACKUP",
	2: "RESTORE",
	3: "SCHEMA_CHANGE",
	4: "IMPORT",
	5: "CHANGEFEED",
}
var Type_value = map[string]int32{
	"UNSPECIFIED":   0,
	"BACKUP":        1,
	"RESTORE":       2,
	"SCHEMA_CHANGE": 3,
	"IMPORT":        4,
	"CHANGEFEED":    5,
}

func (Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorJobs, []int{0} }

type Lease struct {
	// The ID of the node that holds the lease.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// The epoch of the lease holder's node liveness entry.
	Epoch int64 `protobuf:"varint,2,opt,name=epoch,proto3" json:"epoch,omitempty"`
}

func (m *Lease) Reset()                    { *m = Lease{} }
func (m *Lease) String() string            { return proto.CompactTextString(m) }
func (*Lease) ProtoMessage()               {}
func (*Lease) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{0} }

type BackupDetails struct {
	StartTime        cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime" json:"start_time"`
	EndTime          cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time"`
	URI              string                       `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	BackupDescriptor []byte                       `protobuf:"bytes,4,opt,name=backup_descriptor,json=backupDescriptor,proto3" json:"backup_descriptor,omitempty"`
}

func (m *BackupDetails) Reset()                    { *m = BackupDetails{} }
func (m *BackupDetails) String() string            { return proto.CompactTextString(m) }
func (*BackupDetails) ProtoMessage()               {}
func (*BackupDetails) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{1} }

type BackupProgress struct {
}

func (m *BackupProgress) Reset()                    { *m = BackupProgress{} }
func (m *BackupProgress) String() string            { return proto.CompactTextString(m) }
func (*BackupProgress) ProtoMessage()               {}
func (*BackupProgress) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{2} }

type RestoreDetails struct {
	EndTime       cockroach_util_hlc.Timestamp                                                         `protobuf:"bytes,4,opt,name=end_time,json=endTime" json:"end_time"`
	TableRewrites map[github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID]*RestoreDetails_TableRewrite `protobuf:"bytes,2,rep,name=table_rewrites,json=tableRewrites,castkey=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"table_rewrites,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	URIs          []string                                                                             `protobuf:"bytes,3,rep,name=uris" json:"uris,omitempty"`
	TableDescs    []*cockroach_sql_sqlbase1.TableDescriptor                                            `protobuf:"bytes,5,rep,name=table_descs,json=tableDescs" json:"table_descs,omitempty"`
	OverrideDB    string                                                                               `protobuf:"bytes,6,opt,name=override_db,json=overrideDb,proto3" json:"override_db,omitempty"`
}

func (m *RestoreDetails) Reset()                    { *m = RestoreDetails{} }
func (m *RestoreDetails) String() string            { return proto.CompactTextString(m) }
func (*RestoreDetails) ProtoMessage()               {}
func (*RestoreDetails) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{3} }

type RestoreDetails_TableRewrite struct {
	TableID  github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"table_id,omitempty"`
	ParentID github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID `protobuf:"varint,2,opt,name=parent_id,json=parentId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"parent_id,omitempty"`
}

func (m *RestoreDetails_TableRewrite) Reset()         { *m = RestoreDetails_TableRewrite{} }
func (m *RestoreDetails_TableRewrite) String() string { return proto.CompactTextString(m) }
func (*RestoreDetails_TableRewrite) ProtoMessage()    {}
func (*RestoreDetails_TableRewrite) Descriptor() ([]byte, []int) {
	return fileDescriptorJobs, []int{3, 0}
}

type RestoreProgress struct {
	HighWater []byte `protobuf:"bytes,1,opt,name=high_water,json=highWater,proto3" json:"high_water,omitempty"`
}

func (m *RestoreProgress) Reset()                    { *m = RestoreProgress{} }
func (m *RestoreProgress) String() string            { return proto.CompactTextString(m) }
func (*RestoreProgress) ProtoMessage()               {}
func (*RestoreProgress) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{4} }

type ImportDetails struct {
	Tables     []ImportDetails_Table                               `protobuf:"bytes,1,rep,name=tables" json:"tables"`
	URIs       []string                                            `protobuf:"bytes,2,rep,name=uris" json:"uris,omitempty"`
	Format     cockroach_roachpb2.IOFileFormat                     `protobuf:"bytes,3,opt,name=format" json:"format"`
	SSTSize    int64                                               `protobuf:"varint,4,opt,name=sst_size,json=sstSize,proto3" json:"sst_size,omitempty"`
	Oversample int64                                               `protobuf:"varint,9,opt,name=oversample,proto3" json:"oversample,omitempty"`
	SkipFKs    bool                                                `protobuf:"varint,10,opt,name=skip_fks,json=skipFks,proto3" json:"skip_fks,omitempty"`
	Walltime   int64                                               `protobuf:"varint,5,opt,name=walltime,proto3" json:"walltime,omitempty"`
	ParentID   github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID `protobuf:"varint,6,opt,name=parent_id,json=parentId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"parent_id,omitempty"`
	BackupPath string                                              `protobuf:"bytes,7,opt,name=backup_path,json=backupPath,proto3" json:"backup_path,omitempty"`
	// samples is a sampling of cockroach KV keys generated from the input data.
	// It is populated with the sampling phase's results. These must be
	// used if a job is resumed to guarantee that AddSSTable will not attempt
	// to add ranges with an old split point within them.
	Samples [][]byte `protobuf:"bytes,8,rep,name=samples" json:"samples,omitempty"`
}

func (m *ImportDetails) Reset()                    { *m = ImportDetails{} }
func (m *ImportDetails) String() string            { return proto.CompactTextString(m) }
func (*ImportDetails) ProtoMessage()               {}
func (*ImportDetails) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{5} }

type ImportDetails_Table struct {
	Desc   *cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,1,opt,name=desc" json:"desc,omitempty"`
	Name   string                                  `protobuf:"bytes,18,opt,name=name,proto3" json:"name,omitempty"`
	SeqVal int64                                   `protobuf:"varint,19,opt,name=seq_val,json=seqVal,proto3" json:"seq_val,omitempty"`
}

func (m *ImportDetails_Table) Reset()                    { *m = ImportDetails_Table{} }
func (m *ImportDetails_Table) String() string            { return proto.CompactTextString(m) }
func (*ImportDetails_Table) ProtoMessage()               {}
func (*ImportDetails_Table) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{5, 0} }

type ImportProgress struct {
	SamplingProgress []float32 `protobuf:"fixed32,1,rep,packed,name=sampling_progress,json=samplingProgress" json:"sampling_progress,omitempty"`
	ReadProgress     []float32 `protobuf:"fixed32,2,rep,packed,name=read_progress,json=readProgress" json:"read_progress,omitempty"`
	WriteProgress    []float32 `protobuf:"fixed32,3,rep,packed,name=write_progress,json=writeProgress" json:"write_progress,omitempty"`
	// The spans of split keys which have had their SSTable's generated.
	// This allows us to skip the shuffle stage for already-completed
	// spans when resuming an import job.
	SpanProgress []cockroach_roachpb1.Span `protobuf:"bytes,4,rep,name=span_progress,json=spanProgress" json:"span_progress"`
}

func (m *ImportProgress) Reset()                    { *m = ImportProgress{} }
func (m *ImportProgress) String() string            { return proto.CompactTextString(m) }
func (*ImportProgress) ProtoMessage()               {}
func (*ImportProgress) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{6} }

type ResumeSpanList struct {
	ResumeSpans []cockroach_roachpb1.Span `protobuf:"bytes,1,rep,name=resume_spans,json=resumeSpans" json:"resume_spans"`
}

func (m *ResumeSpanList) Reset()                    { *m = ResumeSpanList{} }
func (m *ResumeSpanList) String() string            { return proto.CompactTextString(m) }
func (*ResumeSpanList) ProtoMessage()               {}
func (*ResumeSpanList) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{7} }

type SchemaChangeDetails struct {
	// A schema change can involve running multiple processors backfilling
	// or deleting data. They occasionally checkpoint Spans so that the
	// processing can resume in the event of a node failure. The spans are
	// non-overlapping contiguous areas of the KV space that still need to
	// be processed. The index represents the index of a mutation in a
	// mutation list containing mutations for the same mutationID.
	ResumeSpanList []ResumeSpanList `protobuf:"bytes,2,rep,name=resume_span_list,json=resumeSpanList" json:"resume_span_list"`
}

func (m *SchemaChangeDetails) Reset()                    { *m = SchemaChangeDetails{} }
func (m *SchemaChangeDetails) String() string            { return proto.CompactTextString(m) }
func (*SchemaChangeDetails) ProtoMessage()               {}
func (*SchemaChangeDetails) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{8} }

type SchemaChangeProgress struct {
}

func (m *SchemaChangeProgress) Reset()                    { *m = SchemaChangeProgress{} }
func (m *SchemaChangeProgress) String() string            { return proto.CompactTextString(m) }
func (*SchemaChangeProgress) ProtoMessage()               {}
func (*SchemaChangeProgress) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{9} }

type ChangefeedTarget struct {
	StatementTimeName string `protobuf:"bytes,1,opt,name=statement_time_name,json=statementTimeName,proto3" json:"statement_time_name,omitempty"`
}

func (m *ChangefeedTarget) Reset()                    { *m = ChangefeedTarget{} }
func (m *ChangefeedTarget) String() string            { return proto.CompactTextString(m) }
func (*ChangefeedTarget) ProtoMessage()               {}
func (*ChangefeedTarget) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{10} }

type ChangefeedDetails struct {
	// Targets contains the user-specified tables and databases to watch, mapping
	// the descriptor id to the name at the time of changefeed creating. There is
	// a 1:1 correspondance between unique targets in the original sql query and
	// entries in this map.
	//
	// - A watched table is stored here under its table id
	// - TODO(dan): A watched database is stored here under its database id
	// - TODO(dan): A db.* expansion is treated identicially to watching the
	//   database
	//
	// Note that the TODOs mean this field currently is guaranteed to only hold
	// table ids and a cluster version check will be added when this changes.
	//
	// The names at resolution time are included so that table and database
	// renames can be detected. They are also used to construct an error message
	// if the descriptor id no longer exists when the jobs is unpaused (which can
	// happen if it was dropped or truncated).
	Targets       ChangefeedTargets            `protobuf:"bytes,6,rep,name=targets,casttype=ChangefeedTargets,castkey=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"targets" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	SinkURI       string                       `protobuf:"bytes,3,opt,name=sink_uri,json=sinkUri,proto3" json:"sink_uri,omitempty"`
	Opts          map[string]string            `protobuf:"bytes,4,rep,name=opts" json:"opts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	StatementTime cockroach_util_hlc.Timestamp `protobuf:"bytes,7,opt,name=statement_time,json=statementTime" json:"statement_time"`
}

func (m *ChangefeedDetails) Reset()                    { *m = ChangefeedDetails{} }
func (m *ChangefeedDetails) String() string            { return proto.CompactTextString(m) }
func (*ChangefeedDetails) ProtoMessage()               {}
func (*ChangefeedDetails) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{11} }

type ResolvedSpan struct {
	Span      cockroach_roachpb1.Span      `protobuf:"bytes,1,opt,name=span" json:"span"`
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *ResolvedSpan) Reset()                    { *m = ResolvedSpan{} }
func (m *ResolvedSpan) String() string            { return proto.CompactTextString(m) }
func (*ResolvedSpan) ProtoMessage()               {}
func (*ResolvedSpan) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{12} }

type ChangefeedProgress struct {
	ResolvedSpans []ResolvedSpan `protobuf:"bytes,2,rep,name=resolved_spans,json=resolvedSpans" json:"resolved_spans"`
}

func (m *ChangefeedProgress) Reset()                    { *m = ChangefeedProgress{} }
func (m *ChangefeedProgress) String() string            { return proto.CompactTextString(m) }
func (*ChangefeedProgress) ProtoMessage()               {}
func (*ChangefeedProgress) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{13} }

type Payload struct {
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	Username    string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// For consistency with the SQL timestamp type, which has microsecond
	// precision, we avoid the timestamp.Timestamp WKT, which has nanosecond
	// precision, and use microsecond integers directly.
	StartedMicros  int64                                                 `protobuf:"varint,3,opt,name=started_micros,json=startedMicros,proto3" json:"started_micros,omitempty"`
	FinishedMicros int64                                                 `protobuf:"varint,4,opt,name=finished_micros,json=finishedMicros,proto3" json:"finished_micros,omitempty"`
	DescriptorIDs  []github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID `protobuf:"varint,6,rep,packed,name=descriptor_ids,json=descriptorIds,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"descriptor_ids,omitempty"`
	Error          string                                                `protobuf:"bytes,8,opt,name=error,proto3" json:"error,omitempty"`
	// ID 9 is intentionally reserved for lease information.
	Lease *Lease `protobuf:"bytes,9,opt,name=lease" json:"lease,omitempty"`
	// Types that are valid to be assigned to Details:
	//	*Payload_Backup
	//	*Payload_Restore
	//	*Payload_SchemaChange
	//	*Payload_Import
	//	*Payload_Changefeed
	Details isPayload_Details `protobuf_oneof:"details"`
}

func (m *Payload) Reset()                    { *m = Payload{} }
func (m *Payload) String() string            { return proto.CompactTextString(m) }
func (*Payload) ProtoMessage()               {}
func (*Payload) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{14} }

type isPayload_Details interface {
	isPayload_Details()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Payload_Backup struct {
	Backup *BackupDetails `protobuf:"bytes,10,opt,name=backup,oneof"`
}
type Payload_Restore struct {
	Restore *RestoreDetails `protobuf:"bytes,11,opt,name=restore,oneof"`
}
type Payload_SchemaChange struct {
	SchemaChange *SchemaChangeDetails `protobuf:"bytes,12,opt,name=schemaChange,oneof"`
}
type Payload_Import struct {
	Import *ImportDetails `protobuf:"bytes,13,opt,name=import,oneof"`
}
type Payload_Changefeed struct {
	Changefeed *ChangefeedDetails `protobuf:"bytes,14,opt,name=changefeed,oneof"`
}

func (*Payload_Backup) isPayload_Details()       {}
func (*Payload_Restore) isPayload_Details()      {}
func (*Payload_SchemaChange) isPayload_Details() {}
func (*Payload_Import) isPayload_Details()       {}
func (*Payload_Changefeed) isPayload_Details()   {}

func (m *Payload) GetDetails() isPayload_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *Payload) GetBackup() *BackupDetails {
	if x, ok := m.GetDetails().(*Payload_Backup); ok {
		return x.Backup
	}
	return nil
}

func (m *Payload) GetRestore() *RestoreDetails {
	if x, ok := m.GetDetails().(*Payload_Restore); ok {
		return x.Restore
	}
	return nil
}

func (m *Payload) GetSchemaChange() *SchemaChangeDetails {
	if x, ok := m.GetDetails().(*Payload_SchemaChange); ok {
		return x.SchemaChange
	}
	return nil
}

func (m *Payload) GetImport() *ImportDetails {
	if x, ok := m.GetDetails().(*Payload_Import); ok {
		return x.Import
	}
	return nil
}

func (m *Payload) GetChangefeed() *ChangefeedDetails {
	if x, ok := m.GetDetails().(*Payload_Changefeed); ok {
		return x.Changefeed
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Payload) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Payload_OneofMarshaler, _Payload_OneofUnmarshaler, _Payload_OneofSizer, []interface{}{
		(*Payload_Backup)(nil),
		(*Payload_Restore)(nil),
		(*Payload_SchemaChange)(nil),
		(*Payload_Import)(nil),
		(*Payload_Changefeed)(nil),
	}
}

func _Payload_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Payload)
	// details
	switch x := m.Details.(type) {
	case *Payload_Backup:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Backup); err != nil {
			return err
		}
	case *Payload_Restore:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Restore); err != nil {
			return err
		}
	case *Payload_SchemaChange:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SchemaChange); err != nil {
			return err
		}
	case *Payload_Import:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Import); err != nil {
			return err
		}
	case *Payload_Changefeed:
		_ = b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Changefeed); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Payload.Details has unexpected type %T", x)
	}
	return nil
}

func _Payload_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Payload)
	switch tag {
	case 10: // details.backup
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BackupDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Payload_Backup{msg}
		return true, err
	case 11: // details.restore
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RestoreDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Payload_Restore{msg}
		return true, err
	case 12: // details.schemaChange
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SchemaChangeDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Payload_SchemaChange{msg}
		return true, err
	case 13: // details.import
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ImportDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Payload_Import{msg}
		return true, err
	case 14: // details.changefeed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ChangefeedDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Payload_Changefeed{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Payload_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Payload)
	// details
	switch x := m.Details.(type) {
	case *Payload_Backup:
		s := proto.Size(x.Backup)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Payload_Restore:
		s := proto.Size(x.Restore)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Payload_SchemaChange:
		s := proto.Size(x.SchemaChange)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Payload_Import:
		s := proto.Size(x.Import)
		n += proto.SizeVarint(13<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Payload_Changefeed:
		s := proto.Size(x.Changefeed)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Progress struct {
	// Types that are valid to be assigned to Progress:
	//	*Progress_FractionCompleted
	//	*Progress_HighWater
	Progress       isProgress_Progress `protobuf_oneof:"progress"`
	ModifiedMicros int64               `protobuf:"varint,2,opt,name=modified_micros,json=modifiedMicros,proto3" json:"modified_micros,omitempty"`
	// Types that are valid to be assigned to Details:
	//	*Progress_Backup
	//	*Progress_Restore
	//	*Progress_SchemaChange
	//	*Progress_Import
	//	*Progress_Changefeed
	Details isProgress_Details `protobuf_oneof:"details"`
}

func (m *Progress) Reset()                    { *m = Progress{} }
func (m *Progress) String() string            { return proto.CompactTextString(m) }
func (*Progress) ProtoMessage()               {}
func (*Progress) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{15} }

type isProgress_Progress interface {
	isProgress_Progress()
	MarshalTo([]byte) (int, error)
	Size() int
}
type isProgress_Details interface {
	isProgress_Details()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Progress_FractionCompleted struct {
	FractionCompleted float32 `protobuf:"fixed32,1,opt,name=fraction_completed,json=fractionCompleted,proto3,oneof"`
}
type Progress_HighWater struct {
	HighWater *cockroach_util_hlc.Timestamp `protobuf:"bytes,3,opt,name=high_water,json=highWater,oneof"`
}
type Progress_Backup struct {
	Backup *BackupProgress `protobuf:"bytes,10,opt,name=backup,oneof"`
}
type Progress_Restore struct {
	Restore *RestoreProgress `protobuf:"bytes,11,opt,name=restore,oneof"`
}
type Progress_SchemaChange struct {
	SchemaChange *SchemaChangeProgress `protobuf:"bytes,12,opt,name=schemaChange,oneof"`
}
type Progress_Import struct {
	Import *ImportProgress `protobuf:"bytes,13,opt,name=import,oneof"`
}
type Progress_Changefeed struct {
	Changefeed *ChangefeedProgress `protobuf:"bytes,14,opt,name=changefeed,oneof"`
}

func (*Progress_FractionCompleted) isProgress_Progress() {}
func (*Progress_HighWater) isProgress_Progress()         {}
func (*Progress_Backup) isProgress_Details()             {}
func (*Progress_Restore) isProgress_Details()            {}
func (*Progress_SchemaChange) isProgress_Details()       {}
func (*Progress_Import) isProgress_Details()             {}
func (*Progress_Changefeed) isProgress_Details()         {}

func (m *Progress) GetProgress() isProgress_Progress {
	if m != nil {
		return m.Progress
	}
	return nil
}
func (m *Progress) GetDetails() isProgress_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *Progress) GetFractionCompleted() float32 {
	if x, ok := m.GetProgress().(*Progress_FractionCompleted); ok {
		return x.FractionCompleted
	}
	return 0
}

func (m *Progress) GetHighWater() *cockroach_util_hlc.Timestamp {
	if x, ok := m.GetProgress().(*Progress_HighWater); ok {
		return x.HighWater
	}
	return nil
}

func (m *Progress) GetBackup() *BackupProgress {
	if x, ok := m.GetDetails().(*Progress_Backup); ok {
		return x.Backup
	}
	return nil
}

func (m *Progress) GetRestore() *RestoreProgress {
	if x, ok := m.GetDetails().(*Progress_Restore); ok {
		return x.Restore
	}
	return nil
}

func (m *Progress) GetSchemaChange() *SchemaChangeProgress {
	if x, ok := m.GetDetails().(*Progress_SchemaChange); ok {
		return x.SchemaChange
	}
	return nil
}

func (m *Progress) GetImport() *ImportProgress {
	if x, ok := m.GetDetails().(*Progress_Import); ok {
		return x.Import
	}
	return nil
}

func (m *Progress) GetChangefeed() *ChangefeedProgress {
	if x, ok := m.GetDetails().(*Progress_Changefeed); ok {
		return x.Changefeed
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Progress) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Progress_OneofMarshaler, _Progress_OneofUnmarshaler, _Progress_OneofSizer, []interface{}{
		(*Progress_FractionCompleted)(nil),
		(*Progress_HighWater)(nil),
		(*Progress_Backup)(nil),
		(*Progress_Restore)(nil),
		(*Progress_SchemaChange)(nil),
		(*Progress_Import)(nil),
		(*Progress_Changefeed)(nil),
	}
}

func _Progress_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Progress)
	// progress
	switch x := m.Progress.(type) {
	case *Progress_FractionCompleted:
		_ = b.EncodeVarint(1<<3 | proto.WireFixed32)
		_ = b.EncodeFixed32(uint64(math.Float32bits(x.FractionCompleted)))
	case *Progress_HighWater:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HighWater); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Progress.Progress has unexpected type %T", x)
	}
	// details
	switch x := m.Details.(type) {
	case *Progress_Backup:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Backup); err != nil {
			return err
		}
	case *Progress_Restore:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Restore); err != nil {
			return err
		}
	case *Progress_SchemaChange:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SchemaChange); err != nil {
			return err
		}
	case *Progress_Import:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Import); err != nil {
			return err
		}
	case *Progress_Changefeed:
		_ = b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Changefeed); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Progress.Details has unexpected type %T", x)
	}
	return nil
}

func _Progress_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Progress)
	switch tag {
	case 1: // progress.fraction_completed
		if wire != proto.WireFixed32 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed32()
		m.Progress = &Progress_FractionCompleted{math.Float32frombits(uint32(x))}
		return true, err
	case 3: // progress.high_water
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(cockroach_util_hlc.Timestamp)
		err := b.DecodeMessage(msg)
		m.Progress = &Progress_HighWater{msg}
		return true, err
	case 10: // details.backup
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BackupProgress)
		err := b.DecodeMessage(msg)
		m.Details = &Progress_Backup{msg}
		return true, err
	case 11: // details.restore
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RestoreProgress)
		err := b.DecodeMessage(msg)
		m.Details = &Progress_Restore{msg}
		return true, err
	case 12: // details.schemaChange
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SchemaChangeProgress)
		err := b.DecodeMessage(msg)
		m.Details = &Progress_SchemaChange{msg}
		return true, err
	case 13: // details.import
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ImportProgress)
		err := b.DecodeMessage(msg)
		m.Details = &Progress_Import{msg}
		return true, err
	case 14: // details.changefeed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ChangefeedProgress)
		err := b.DecodeMessage(msg)
		m.Details = &Progress_Changefeed{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Progress_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Progress)
	// progress
	switch x := m.Progress.(type) {
	case *Progress_FractionCompleted:
		n += proto.SizeVarint(1<<3 | proto.WireFixed32)
		n += 4
	case *Progress_HighWater:
		s := proto.Size(x.HighWater)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// details
	switch x := m.Details.(type) {
	case *Progress_Backup:
		s := proto.Size(x.Backup)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Progress_Restore:
		s := proto.Size(x.Restore)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Progress_SchemaChange:
		s := proto.Size(x.SchemaChange)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Progress_Import:
		s := proto.Size(x.Import)
		n += proto.SizeVarint(13<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Progress_Changefeed:
		s := proto.Size(x.Changefeed)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*Lease)(nil), "cockroach.sql.jobs.jobspb.Lease")
	proto.RegisterType((*BackupDetails)(nil), "cockroach.sql.jobs.jobspb.BackupDetails")
	proto.RegisterType((*BackupProgress)(nil), "cockroach.sql.jobs.jobspb.BackupProgress")
	proto.RegisterType((*RestoreDetails)(nil), "cockroach.sql.jobs.jobspb.RestoreDetails")
	proto.RegisterType((*RestoreDetails_TableRewrite)(nil), "cockroach.sql.jobs.jobspb.RestoreDetails.TableRewrite")
	proto.RegisterType((*RestoreProgress)(nil), "cockroach.sql.jobs.jobspb.RestoreProgress")
	proto.RegisterType((*ImportDetails)(nil), "cockroach.sql.jobs.jobspb.ImportDetails")
	proto.RegisterType((*ImportDetails_Table)(nil), "cockroach.sql.jobs.jobspb.ImportDetails.Table")
	proto.RegisterType((*ImportProgress)(nil), "cockroach.sql.jobs.jobspb.ImportProgress")
	proto.RegisterType((*ResumeSpanList)(nil), "cockroach.sql.jobs.jobspb.ResumeSpanList")
	proto.RegisterType((*SchemaChangeDetails)(nil), "cockroach.sql.jobs.jobspb.SchemaChangeDetails")
	proto.RegisterType((*SchemaChangeProgress)(nil), "cockroach.sql.jobs.jobspb.SchemaChangeProgress")
	proto.RegisterType((*ChangefeedTarget)(nil), "cockroach.sql.jobs.jobspb.ChangefeedTarget")
	proto.RegisterType((*ChangefeedDetails)(nil), "cockroach.sql.jobs.jobspb.ChangefeedDetails")
	proto.RegisterType((*ResolvedSpan)(nil), "cockroach.sql.jobs.jobspb.ResolvedSpan")
	proto.RegisterType((*ChangefeedProgress)(nil), "cockroach.sql.jobs.jobspb.ChangefeedProgress")
	proto.RegisterType((*Payload)(nil), "cockroach.sql.jobs.jobspb.Payload")
	proto.RegisterType((*Progress)(nil), "cockroach.sql.jobs.jobspb.Progress")
	proto.RegisterEnum("cockroach.sql.jobs.jobspb.Type", Type_name, Type_value)
}
func (this *Lease) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Lease)
	if !ok {
		that2, ok := that.(Lease)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NodeID != that1.NodeID {
		return false
	}
	if this.Epoch != that1.Epoch {
		return false
	}
	return true
}
func (m *Lease) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Lease) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.NodeID))
	}
	if m.Epoch != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Epoch))
	}
	return i, nil
}

func (m *BackupDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintJobs(dAtA, i, uint64(m.StartTime.Size()))
	n1, err := m.StartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x12
	i++
	i = encodeVarintJobs(dAtA, i, uint64(m.EndTime.Size()))
	n2, err := m.EndTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.URI) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.URI)))
		i += copy(dAtA[i:], m.URI)
	}
	if len(m.BackupDescriptor) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.BackupDescriptor)))
		i += copy(dAtA[i:], m.BackupDescriptor)
	}
	return i, nil
}

func (m *BackupProgress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupProgress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RestoreDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RestoreDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TableRewrites) > 0 {
		keysForTableRewrites := make([]uint32, 0, len(m.TableRewrites))
		for k := range m.TableRewrites {
			keysForTableRewrites = append(keysForTableRewrites, uint32(k))
		}
		sortkeys.Uint32s(keysForTableRewrites)
		for _, k := range keysForTableRewrites {
			dAtA[i] = 0x12
			i++
			v := m.TableRewrites[github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovJobs(uint64(msgSize))
			}
			mapSize := 1 + sovJobs(uint64(k)) + msgSize
			i = encodeVarintJobs(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintJobs(dAtA, i, uint64(k))
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintJobs(dAtA, i, uint64(v.Size()))
				n3, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n3
			}
		}
	}
	if len(m.URIs) > 0 {
		for _, s := range m.URIs {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintJobs(dAtA, i, uint64(m.EndTime.Size()))
	n4, err := m.EndTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if len(m.TableDescs) > 0 {
		for _, msg := range m.TableDescs {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintJobs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OverrideDB) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.OverrideDB)))
		i += copy(dAtA[i:], m.OverrideDB)
	}
	return i, nil
}

func (m *RestoreDetails_TableRewrite) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RestoreDetails_TableRewrite) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TableID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.TableID))
	}
	if m.ParentID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.ParentID))
	}
	return i, nil
}

func (m *RestoreProgress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RestoreProgress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HighWater) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.HighWater)))
		i += copy(dAtA[i:], m.HighWater)
	}
	return i, nil
}

func (m *ImportDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tables) > 0 {
		for _, msg := range m.Tables {
			dAtA[i] = 0xa
			i++
			i = encodeVarintJobs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.URIs) > 0 {
		for _, s := range m.URIs {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintJobs(dAtA, i, uint64(m.Format.Size()))
	n5, err := m.Format.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if m.SSTSize != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.SSTSize))
	}
	if m.Walltime != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Walltime))
	}
	if m.ParentID != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.ParentID))
	}
	if len(m.BackupPath) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.BackupPath)))
		i += copy(dAtA[i:], m.BackupPath)
	}
	if len(m.Samples) > 0 {
		for _, b := range m.Samples {
			dAtA[i] = 0x42
			i++
			i = encodeVarintJobs(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	if m.Oversample != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Oversample))
	}
	if m.SkipFKs {
		dAtA[i] = 0x50
		i++
		if m.SkipFKs {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *ImportDetails_Table) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportDetails_Table) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Desc != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Desc.Size()))
		n6, err := m.Desc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.SeqVal != 0 {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.SeqVal))
	}
	return i, nil
}

func (m *ImportProgress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportProgress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SamplingProgress) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.SamplingProgress)*4))
		for _, num := range m.SamplingProgress {
			f7 := math.Float32bits(float32(num))
			binary.LittleEndian.PutUint32(dAtA[i:], uint32(f7))
			i += 4
		}
	}
	if len(m.ReadProgress) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.ReadProgress)*4))
		for _, num := range m.ReadProgress {
			f8 := math.Float32bits(float32(num))
			binary.LittleEndian.PutUint32(dAtA[i:], uint32(f8))
			i += 4
		}
	}
	if len(m.WriteProgress) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.WriteProgress)*4))
		for _, num := range m.WriteProgress {
			f9 := math.Float32bits(float32(num))
			binary.LittleEndian.PutUint32(dAtA[i:], uint32(f9))
			i += 4
		}
	}
	if len(m.SpanProgress) > 0 {
		for _, msg := range m.SpanProgress {
			dAtA[i] = 0x22
			i++
			i = encodeVarintJobs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ResumeSpanList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResumeSpanList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ResumeSpans) > 0 {
		for _, msg := range m.ResumeSpans {
			dAtA[i] = 0xa
			i++
			i = encodeVarintJobs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SchemaChangeDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SchemaChangeDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ResumeSpanList) > 0 {
		for _, msg := range m.ResumeSpanList {
			dAtA[i] = 0x12
			i++
			i = encodeVarintJobs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SchemaChangeProgress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SchemaChangeProgress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ChangefeedTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangefeedTarget) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StatementTimeName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.StatementTimeName)))
		i += copy(dAtA[i:], m.StatementTimeName)
	}
	return i, nil
}

func (m *ChangefeedDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangefeedDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SinkURI) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.SinkURI)))
		i += copy(dAtA[i:], m.SinkURI)
	}
	if len(m.Opts) > 0 {
		keysForOpts := make([]string, 0, len(m.Opts))
		for k := range m.Opts {
			keysForOpts = append(keysForOpts, string(k))
		}
		sortkeys.Strings(keysForOpts)
		for _, k := range keysForOpts {
			dAtA[i] = 0x22
			i++
			v := m.Opts[string(k)]
			mapSize := 1 + len(k) + sovJobs(uint64(len(k))) + 1 + len(v) + sovJobs(uint64(len(v)))
			i = encodeVarintJobs(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintJobs(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintJobs(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Targets) > 0 {
		keysForTargets := make([]uint32, 0, len(m.Targets))
		for k := range m.Targets {
			keysForTargets = append(keysForTargets, uint32(k))
		}
		sortkeys.Uint32s(keysForTargets)
		for _, k := range keysForTargets {
			dAtA[i] = 0x32
			i++
			v := m.Targets[github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovJobs(uint64(msgSize))
			}
			mapSize := 1 + sovJobs(uint64(k)) + msgSize
			i = encodeVarintJobs(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintJobs(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintJobs(dAtA, i, uint64((&v).Size()))
			n10, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n10
		}
	}
	dAtA[i] = 0x3a
	i++
	i = encodeVarintJobs(dAtA, i, uint64(m.StatementTime.Size()))
	n11, err := m.StatementTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func (m *ResolvedSpan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolvedSpan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintJobs(dAtA, i, uint64(m.Span.Size()))
	n12, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	dAtA[i] = 0x12
	i++
	i = encodeVarintJobs(dAtA, i, uint64(m.Timestamp.Size()))
	n13, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	return i, nil
}

func (m *ChangefeedProgress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangefeedProgress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ResolvedSpans) > 0 {
		for _, msg := range m.ResolvedSpans {
			dAtA[i] = 0x12
			i++
			i = encodeVarintJobs(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Payload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Payload) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Description) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.Username) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	if m.StartedMicros != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.StartedMicros))
	}
	if m.FinishedMicros != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.FinishedMicros))
	}
	if len(m.DescriptorIDs) > 0 {
		dAtA15 := make([]byte, len(m.DescriptorIDs)*10)
		var j14 int
		for _, num := range m.DescriptorIDs {
			for num >= 1<<7 {
				dAtA15[j14] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j14++
			}
			dAtA15[j14] = uint8(num)
			j14++
		}
		dAtA[i] = 0x32
		i++
		i = encodeVarintJobs(dAtA, i, uint64(j14))
		i += copy(dAtA[i:], dAtA15[:j14])
	}
	if len(m.Error) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.Error)))
		i += copy(dAtA[i:], m.Error)
	}
	if m.Lease != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Lease.Size()))
		n16, err := m.Lease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.Details != nil {
		nn17, err := m.Details.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn17
	}
	return i, nil
}

func (m *Payload_Backup) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Backup != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Backup.Size()))
		n18, err := m.Backup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}
func (m *Payload_Restore) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Restore != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Restore.Size()))
		n19, err := m.Restore.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}
func (m *Payload_SchemaChange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SchemaChange != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.SchemaChange.Size()))
		n20, err := m.SchemaChange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	return i, nil
}
func (m *Payload_Import) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Import != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Import.Size()))
		n21, err := m.Import.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	return i, nil
}
func (m *Payload_Changefeed) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Changefeed != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Changefeed.Size()))
		n22, err := m.Changefeed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	return i, nil
}
func (m *Progress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Progress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Progress != nil {
		nn23, err := m.Progress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn23
	}
	if m.ModifiedMicros != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.ModifiedMicros))
	}
	if m.Details != nil {
		nn24, err := m.Details.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn24
	}
	return i, nil
}

func (m *Progress_FractionCompleted) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xd
	i++
	binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.FractionCompleted))))
	i += 4
	return i, nil
}
func (m *Progress_HighWater) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HighWater != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.HighWater.Size()))
		n25, err := m.HighWater.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	return i, nil
}
func (m *Progress_Backup) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Backup != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Backup.Size()))
		n26, err := m.Backup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	return i, nil
}
func (m *Progress_Restore) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Restore != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Restore.Size()))
		n27, err := m.Restore.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	return i, nil
}
func (m *Progress_SchemaChange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SchemaChange != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.SchemaChange.Size()))
		n28, err := m.SchemaChange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	return i, nil
}
func (m *Progress_Import) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Import != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Import.Size()))
		n29, err := m.Import.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	return i, nil
}
func (m *Progress_Changefeed) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Changefeed != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Changefeed.Size()))
		n30, err := m.Changefeed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	return i, nil
}
func encodeVarintJobs(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Lease) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovJobs(uint64(m.NodeID))
	}
	if m.Epoch != 0 {
		n += 1 + sovJobs(uint64(m.Epoch))
	}
	return n
}

func (m *BackupDetails) Size() (n int) {
	var l int
	_ = l
	l = m.StartTime.Size()
	n += 1 + l + sovJobs(uint64(l))
	l = m.EndTime.Size()
	n += 1 + l + sovJobs(uint64(l))
	l = len(m.URI)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	l = len(m.BackupDescriptor)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}

func (m *BackupProgress) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *RestoreDetails) Size() (n int) {
	var l int
	_ = l
	if len(m.TableRewrites) > 0 {
		for k, v := range m.TableRewrites {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovJobs(uint64(l))
			}
			mapEntrySize := 1 + sovJobs(uint64(k)) + l
			n += mapEntrySize + 1 + sovJobs(uint64(mapEntrySize))
		}
	}
	if len(m.URIs) > 0 {
		for _, s := range m.URIs {
			l = len(s)
			n += 1 + l + sovJobs(uint64(l))
		}
	}
	l = m.EndTime.Size()
	n += 1 + l + sovJobs(uint64(l))
	if len(m.TableDescs) > 0 {
		for _, e := range m.TableDescs {
			l = e.Size()
			n += 1 + l + sovJobs(uint64(l))
		}
	}
	l = len(m.OverrideDB)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}

func (m *RestoreDetails_TableRewrite) Size() (n int) {
	var l int
	_ = l
	if m.TableID != 0 {
		n += 1 + sovJobs(uint64(m.TableID))
	}
	if m.ParentID != 0 {
		n += 1 + sovJobs(uint64(m.ParentID))
	}
	return n
}

func (m *RestoreProgress) Size() (n int) {
	var l int
	_ = l
	l = len(m.HighWater)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}

func (m *ImportDetails) Size() (n int) {
	var l int
	_ = l
	if len(m.Tables) > 0 {
		for _, e := range m.Tables {
			l = e.Size()
			n += 1 + l + sovJobs(uint64(l))
		}
	}
	if len(m.URIs) > 0 {
		for _, s := range m.URIs {
			l = len(s)
			n += 1 + l + sovJobs(uint64(l))
		}
	}
	l = m.Format.Size()
	n += 1 + l + sovJobs(uint64(l))
	if m.SSTSize != 0 {
		n += 1 + sovJobs(uint64(m.SSTSize))
	}
	if m.Walltime != 0 {
		n += 1 + sovJobs(uint64(m.Walltime))
	}
	if m.ParentID != 0 {
		n += 1 + sovJobs(uint64(m.ParentID))
	}
	l = len(m.BackupPath)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	if len(m.Samples) > 0 {
		for _, b := range m.Samples {
			l = len(b)
			n += 1 + l + sovJobs(uint64(l))
		}
	}
	if m.Oversample != 0 {
		n += 1 + sovJobs(uint64(m.Oversample))
	}
	if m.SkipFKs {
		n += 2
	}
	return n
}

func (m *ImportDetails_Table) Size() (n int) {
	var l int
	_ = l
	if m.Desc != nil {
		l = m.Desc.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 2 + l + sovJobs(uint64(l))
	}
	if m.SeqVal != 0 {
		n += 2 + sovJobs(uint64(m.SeqVal))
	}
	return n
}

func (m *ImportProgress) Size() (n int) {
	var l int
	_ = l
	if len(m.SamplingProgress) > 0 {
		n += 1 + sovJobs(uint64(len(m.SamplingProgress)*4)) + len(m.SamplingProgress)*4
	}
	if len(m.ReadProgress) > 0 {
		n += 1 + sovJobs(uint64(len(m.ReadProgress)*4)) + len(m.ReadProgress)*4
	}
	if len(m.WriteProgress) > 0 {
		n += 1 + sovJobs(uint64(len(m.WriteProgress)*4)) + len(m.WriteProgress)*4
	}
	if len(m.SpanProgress) > 0 {
		for _, e := range m.SpanProgress {
			l = e.Size()
			n += 1 + l + sovJobs(uint64(l))
		}
	}
	return n
}

func (m *ResumeSpanList) Size() (n int) {
	var l int
	_ = l
	if len(m.ResumeSpans) > 0 {
		for _, e := range m.ResumeSpans {
			l = e.Size()
			n += 1 + l + sovJobs(uint64(l))
		}
	}
	return n
}

func (m *SchemaChangeDetails) Size() (n int) {
	var l int
	_ = l
	if len(m.ResumeSpanList) > 0 {
		for _, e := range m.ResumeSpanList {
			l = e.Size()
			n += 1 + l + sovJobs(uint64(l))
		}
	}
	return n
}

func (m *SchemaChangeProgress) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ChangefeedTarget) Size() (n int) {
	var l int
	_ = l
	l = len(m.StatementTimeName)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}

func (m *ChangefeedDetails) Size() (n int) {
	var l int
	_ = l
	l = len(m.SinkURI)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	if len(m.Opts) > 0 {
		for k, v := range m.Opts {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovJobs(uint64(len(k))) + 1 + len(v) + sovJobs(uint64(len(v)))
			n += mapEntrySize + 1 + sovJobs(uint64(mapEntrySize))
		}
	}
	if len(m.Targets) > 0 {
		for k, v := range m.Targets {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovJobs(uint64(k)) + 1 + l + sovJobs(uint64(l))
			n += mapEntrySize + 1 + sovJobs(uint64(mapEntrySize))
		}
	}
	l = m.StatementTime.Size()
	n += 1 + l + sovJobs(uint64(l))
	return n
}

func (m *ResolvedSpan) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovJobs(uint64(l))
	l = m.Timestamp.Size()
	n += 1 + l + sovJobs(uint64(l))
	return n
}

func (m *ChangefeedProgress) Size() (n int) {
	var l int
	_ = l
	if len(m.ResolvedSpans) > 0 {
		for _, e := range m.ResolvedSpans {
			l = e.Size()
			n += 1 + l + sovJobs(uint64(l))
		}
	}
	return n
}

func (m *Payload) Size() (n int) {
	var l int
	_ = l
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	if m.StartedMicros != 0 {
		n += 1 + sovJobs(uint64(m.StartedMicros))
	}
	if m.FinishedMicros != 0 {
		n += 1 + sovJobs(uint64(m.FinishedMicros))
	}
	if len(m.DescriptorIDs) > 0 {
		l = 0
		for _, e := range m.DescriptorIDs {
			l += sovJobs(uint64(e))
		}
		n += 1 + sovJobs(uint64(l)) + l
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	if m.Lease != nil {
		l = m.Lease.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	if m.Details != nil {
		n += m.Details.Size()
	}
	return n
}

func (m *Payload_Backup) Size() (n int) {
	var l int
	_ = l
	if m.Backup != nil {
		l = m.Backup.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Payload_Restore) Size() (n int) {
	var l int
	_ = l
	if m.Restore != nil {
		l = m.Restore.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Payload_SchemaChange) Size() (n int) {
	var l int
	_ = l
	if m.SchemaChange != nil {
		l = m.SchemaChange.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Payload_Import) Size() (n int) {
	var l int
	_ = l
	if m.Import != nil {
		l = m.Import.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Payload_Changefeed) Size() (n int) {
	var l int
	_ = l
	if m.Changefeed != nil {
		l = m.Changefeed.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Progress) Size() (n int) {
	var l int
	_ = l
	if m.Progress != nil {
		n += m.Progress.Size()
	}
	if m.ModifiedMicros != 0 {
		n += 1 + sovJobs(uint64(m.ModifiedMicros))
	}
	if m.Details != nil {
		n += m.Details.Size()
	}
	return n
}

func (m *Progress_FractionCompleted) Size() (n int) {
	var l int
	_ = l
	n += 5
	return n
}
func (m *Progress_HighWater) Size() (n int) {
	var l int
	_ = l
	if m.HighWater != nil {
		l = m.HighWater.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Progress_Backup) Size() (n int) {
	var l int
	_ = l
	if m.Backup != nil {
		l = m.Backup.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Progress_Restore) Size() (n int) {
	var l int
	_ = l
	if m.Restore != nil {
		l = m.Restore.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Progress_SchemaChange) Size() (n int) {
	var l int
	_ = l
	if m.SchemaChange != nil {
		l = m.SchemaChange.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Progress_Import) Size() (n int) {
	var l int
	_ = l
	if m.Import != nil {
		l = m.Import.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *Progress_Changefeed) Size() (n int) {
	var l int
	_ = l
	if m.Changefeed != nil {
		l = m.Changefeed.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}

func sovJobs(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozJobs(x uint64) (n int) {
	return sovJobs(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Lease) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Lease: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Lease: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			m.Epoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Epoch |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupDescriptor", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BackupDescriptor = append(m.BackupDescriptor[:0], dAtA[iNdEx:postIndex]...)
			if m.BackupDescriptor == nil {
				m.BackupDescriptor = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupProgress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupProgress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupProgress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RestoreDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RestoreDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RestoreDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableRewrites", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TableRewrites == nil {
				m.TableRewrites = make(map[github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID]*RestoreDetails_TableRewrite)
			}
			var mapkey uint32
			var mapvalue *RestoreDetails_TableRewrite
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowJobs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowJobs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthJobs
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthJobs
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &RestoreDetails_TableRewrite{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipJobs(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthJobs
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TableRewrites[github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(mapkey)] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URIs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URIs = append(m.URIs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableDescs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TableDescs = append(m.TableDescs, &cockroach_sql_sqlbase1.TableDescriptor{})
			if err := m.TableDescs[len(m.TableDescs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverrideDB", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OverrideDB = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RestoreDetails_TableRewrite) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableRewrite: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableRewrite: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableID", wireType)
			}
			m.TableID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TableID |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentID", wireType)
			}
			m.ParentID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParentID |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RestoreProgress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RestoreProgress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RestoreProgress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighWater", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HighWater = append(m.HighWater[:0], dAtA[iNdEx:postIndex]...)
			if m.HighWater == nil {
				m.HighWater = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tables = append(m.Tables, ImportDetails_Table{})
			if err := m.Tables[len(m.Tables)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URIs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URIs = append(m.URIs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Format", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Format.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SSTSize", wireType)
			}
			m.SSTSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SSTSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Walltime", wireType)
			}
			m.Walltime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Walltime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentID", wireType)
			}
			m.ParentID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParentID |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BackupPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Samples", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Samples = append(m.Samples, make([]byte, postIndex-iNdEx))
			copy(m.Samples[len(m.Samples)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Oversample", wireType)
			}
			m.Oversample = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Oversample |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipFKs", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipFKs = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportDetails_Table) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Table: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Table: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Desc == nil {
				m.Desc = &cockroach_sql_sqlbase1.TableDescriptor{}
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeqVal", wireType)
			}
			m.SeqVal = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeqVal |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportProgress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportProgress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportProgress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 5 {
				var v uint32
				if (iNdEx + 4) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
				iNdEx += 4
				v2 := float32(math.Float32frombits(v))
				m.SamplingProgress = append(m.SamplingProgress, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthJobs
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					if (iNdEx + 4) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
					iNdEx += 4
					v2 := float32(math.Float32frombits(v))
					m.SamplingProgress = append(m.SamplingProgress, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SamplingProgress", wireType)
			}
		case 2:
			if wireType == 5 {
				var v uint32
				if (iNdEx + 4) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
				iNdEx += 4
				v2 := float32(math.Float32frombits(v))
				m.ReadProgress = append(m.ReadProgress, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthJobs
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					if (iNdEx + 4) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
					iNdEx += 4
					v2 := float32(math.Float32frombits(v))
					m.ReadProgress = append(m.ReadProgress, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadProgress", wireType)
			}
		case 3:
			if wireType == 5 {
				var v uint32
				if (iNdEx + 4) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
				iNdEx += 4
				v2 := float32(math.Float32frombits(v))
				m.WriteProgress = append(m.WriteProgress, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthJobs
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					if (iNdEx + 4) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
					iNdEx += 4
					v2 := float32(math.Float32frombits(v))
					m.WriteProgress = append(m.WriteProgress, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteProgress", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanProgress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanProgress = append(m.SpanProgress, cockroach_roachpb1.Span{})
			if err := m.SpanProgress[len(m.SpanProgress)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResumeSpanList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResumeSpanList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResumeSpanList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResumeSpans = append(m.ResumeSpans, cockroach_roachpb1.Span{})
			if err := m.ResumeSpans[len(m.ResumeSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SchemaChangeDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SchemaChangeDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SchemaChangeDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeSpanList", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResumeSpanList = append(m.ResumeSpanList, ResumeSpanList{})
			if err := m.ResumeSpanList[len(m.ResumeSpanList)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SchemaChangeProgress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SchemaChangeProgress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SchemaChangeProgress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangefeedTarget) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangefeedTarget: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangefeedTarget: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatementTimeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatementTimeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangefeedDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangefeedDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangefeedDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinkURI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SinkURI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Opts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Opts == nil {
				m.Opts = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowJobs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthJobs
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowJobs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthJobs
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipJobs(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthJobs
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Opts[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Targets == nil {
				m.Targets = make(ChangefeedTargets)
			}
			var mapkey uint32
			mapvalue := &ChangefeedTarget{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowJobs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowJobs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthJobs
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthJobs
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ChangefeedTarget{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipJobs(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthJobs
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Targets[github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(mapkey)] = *mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatementTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StatementTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolvedSpan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolvedSpan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolvedSpan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangefeedProgress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangefeedProgress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangefeedProgress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResolvedSpans = append(m.ResolvedSpans, ResolvedSpan{})
			if err := m.ResolvedSpans[len(m.ResolvedSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Payload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Payload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Payload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedMicros", wireType)
			}
			m.StartedMicros = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedMicros |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinishedMicros", wireType)
			}
			m.FinishedMicros = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FinishedMicros |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.DescriptorIDs = append(m.DescriptorIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthJobs
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowJobs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.DescriptorIDs = append(m.DescriptorIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorIDs", wireType)
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lease == nil {
				m.Lease = &Lease{}
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Backup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BackupDetails{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Payload_Backup{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RestoreDetails{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Payload_Restore{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaChange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SchemaChangeDetails{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Payload_SchemaChange{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Import", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ImportDetails{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Payload_Import{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Changefeed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ChangefeedDetails{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Payload_Changefeed{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Progress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Progress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Progress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field FractionCompleted", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Progress = &Progress_FractionCompleted{float32(math.Float32frombits(v))}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModifiedMicros", wireType)
			}
			m.ModifiedMicros = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ModifiedMicros |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighWater", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &cockroach_util_hlc.Timestamp{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Progress = &Progress_HighWater{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Backup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BackupProgress{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Progress_Backup{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RestoreProgress{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Progress_Restore{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaChange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SchemaChangeProgress{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Progress_SchemaChange{v}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Import", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ImportProgress{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Progress_Import{v}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Changefeed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ChangefeedProgress{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &Progress_Changefeed{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipJobs(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthJobs
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipJobs(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthJobs = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowJobs   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("jobs/jobspb/jobs.proto", fileDescriptorJobs) }

var fileDescriptorJobs = []byte{
	// 1939 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x5f, 0x6f, 0xe3, 0x58,
	0x15, 0x8f, 0x13, 0x27, 0x76, 0x4e, 0xfe, 0xd4, 0xbd, 0x33, 0xda, 0xf5, 0x46, 0xb3, 0x4d, 0x14,
	0x60, 0xa7, 0xb3, 0xc3, 0x26, 0xd0, 0x95, 0x76, 0x61, 0x04, 0x2b, 0x9a, 0x36, 0xdd, 0xc4, 0x3b,
	0xd3, 0x56, 0x6e, 0x0b, 0x62, 0x25, 0x14, 0x9c, 0xf8, 0x36, 0x31, 0x71, 0x62, 0xd7, 0xd7, 0xe9,
	0x30, 0xfb, 0x82, 0x84, 0x78, 0x40, 0x7d, 0xe2, 0x03, 0x50, 0x09, 0x09, 0x90, 0x78, 0xe3, 0x09,
	0x3e, 0xc3, 0xbc, 0x20, 0xf6, 0x91, 0x15, 0x52, 0x80, 0xf0, 0xc2, 0x67, 0xd8, 0x27, 0x74, 0xef,
	0xf5, 0xbf, 0x74, 0x4a, 0x9b, 0xa9, 0xc4, 0xcb, 0x4c, 0x7c, 0xee, 0x39, 0xbf, 0x7b, 0xce, 0xf1,
	0xef, 0xfc, 0x71, 0xe1, 0x8d, 0x9f, 0x38, 0x7d, 0xd2, 0xa4, 0xff, 0xb8, 0x7d, 0xf6, 0x5f, 0xc3,
	0xf5, 0x1c, 0xdf, 0x41, 0x6f, 0x0d, 0x9c, 0xc1, 0xd8, 0x73, 0x8c, 0xc1, 0xa8, 0x41, 0xce, 0xec,
	0x06, 0x3b, 0xe1, 0x5a, 0x95, 0xfb, 0x43, 0x67, 0xe8, 0x30, 0xad, 0x26, 0xfd, 0xc5, 0x0d, 0x2a,
	0x88, 0x29, 0xbb, 0xfd, 0xa6, 0x69, 0xf8, 0x46, 0x20, 0x53, 0x43, 0x99, 0xe5, 0xbc, 0x77, 0xea,
	0x78, 0x13, 0xc3, 0x0f, 0xe0, 0x2b, 0x0f, 0xc8, 0x99, 0xdd, 0x24, 0x67, 0x76, 0xdf, 0x20, 0xb8,
	0x49, 0x7c, 0x6f, 0x36, 0xf0, 0x67, 0x1e, 0x36, 0x43, 0xbb, 0x99, 0x6f, 0xd9, 0xcd, 0x91, 0x3d,
	0x68, 0xfa, 0xd6, 0x04, 0x13, 0xdf, 0x98, 0xb8, 0xfc, 0xa4, 0xfe, 0x33, 0xc8, 0x3e, 0xc5, 0x06,
	0xc1, 0xe8, 0x53, 0x90, 0xa6, 0x8e, 0x89, 0x7b, 0x96, 0xa9, 0x0a, 0x35, 0x61, 0xb3, 0xd4, 0xda,
	0x5e, 0xcc, 0xab, 0xb9, 0x7d, 0xc7, 0xc4, 0xdd, 0xdd, 0x2f, 0xe7, 0xd5, 0xf7, 0x87, 0x96, 0x3f,
	0x9a, 0xf5, 0x1b, 0x03, 0x67, 0xd2, 0x8c, 0x22, 0x31, 0xfb, 0xf1, 0xef, 0xa6, 0x3b, 0x1e, 0x36,
	0x03, 0xf7, 0x1a, 0xdc, 0x4c, 0xcf, 0x51, 0xc4, 0xae, 0x89, 0xee, 0x43, 0x16, 0xbb, 0xce, 0x60,
	0xa4, 0xa6, 0x6b, 0xc2, 0x66, 0x46, 0xe7, 0x0f, 0x4f, 0xc4, 0xff, 0xfc, 0xa6, 0x2a, 0xd4, 0xff,
	0x2e, 0x40, 0xa9, 0x65, 0x0c, 0xc6, 0x33, 0x77, 0x17, 0xfb, 0x86, 0x65, 0x13, 0xd4, 0x02, 0x20,
	0xbe, 0xe1, 0xf9, 0x3d, 0xea, 0x2b, 0x73, 0xa6, 0xb0, 0xf5, 0x76, 0x23, 0x4e, 0x1f, 0x8d, 0xa5,
	0x31, 0xb2, 0x07, 0x8d, 0xe3, 0x30, 0x96, 0x96, 0xf8, 0x72, 0x5e, 0x4d, 0xe9, 0x79, 0x66, 0x46,
	0xa5, 0xe8, 0x23, 0x90, 0xf1, 0xd4, 0xe4, 0x08, 0xe9, 0xd5, 0x11, 0x24, 0x3c, 0x35, 0x99, 0xfd,
	0x5b, 0x90, 0x99, 0x79, 0x96, 0x9a, 0xa9, 0x09, 0x9b, 0xf9, 0x96, 0xb4, 0x98, 0x57, 0x33, 0x27,
	0x7a, 0x57, 0xa7, 0x32, 0xf4, 0x18, 0xd6, 0xfb, 0xcc, 0xdf, 0x9e, 0x89, 0xc9, 0xc0, 0xb3, 0x5c,
	0xdf, 0xf1, 0x54, 0xb1, 0x26, 0x6c, 0x16, 0x75, 0xa5, 0x1f, 0x04, 0x12, 0xca, 0xeb, 0x0a, 0x94,
	0x79, 0x70, 0x87, 0x9e, 0x33, 0xf4, 0x30, 0x21, 0xf5, 0x2f, 0xb2, 0x50, 0xd6, 0x31, 0xf1, 0x1d,
	0x0f, 0x87, 0x01, 0xff, 0x5a, 0x80, 0xb2, 0x6f, 0xf4, 0x6d, 0xdc, 0xf3, 0xf0, 0x73, 0xcf, 0xf2,
	0x31, 0x51, 0xd3, 0xb5, 0xcc, 0x66, 0x61, 0xeb, 0x3b, 0x8d, 0xff, 0x49, 0x9a, 0xc6, 0x32, 0x46,
	0xe3, 0x98, 0xda, 0xeb, 0x81, 0x79, 0x7b, 0xea, 0x7b, 0x2f, 0x5a, 0x1f, 0xfe, 0xfc, 0x1f, 0x2b,
	0xbe, 0xb6, 0x04, 0x77, 0x1a, 0xdd, 0x5d, 0xbd, 0xe4, 0x27, 0xc1, 0xd0, 0x03, 0x10, 0x67, 0x9e,
	0x45, 0xd4, 0x4c, 0x2d, 0xb3, 0x99, 0x6f, 0xc9, 0x8b, 0x79, 0x55, 0x3c, 0xd1, 0xbb, 0x44, 0x67,
	0xd2, 0xa5, 0x4c, 0x8b, 0x77, 0xc8, 0xf4, 0xc7, 0x50, 0xe0, 0xb1, 0xd3, 0x6c, 0x12, 0x35, 0xcb,
	0x02, 0x7f, 0xe7, 0x4a, 0xe0, 0xa1, 0x73, 0x2c, 0xca, 0x38, 0xbd, 0x3a, 0xf8, 0xa1, 0x80, 0xa0,
	0x26, 0x14, 0x9c, 0x73, 0xec, 0x79, 0x96, 0x89, 0x7b, 0x66, 0x5f, 0xcd, 0xb1, 0x57, 0x57, 0x5e,
	0xcc, 0xab, 0x70, 0x10, 0x88, 0x77, 0x5b, 0x3a, 0x84, 0x2a, 0xbb, 0xfd, 0xca, 0x5f, 0x05, 0x28,
	0x26, 0xd3, 0x86, 0x7e, 0x04, 0x32, 0x77, 0x25, 0xaa, 0x81, 0xd6, 0x62, 0x5e, 0x95, 0x98, 0xce,
	0x6b, 0x14, 0xc1, 0x95, 0x6c, 0x4a, 0x0c, 0xb3, 0x6b, 0xa2, 0x1f, 0x43, 0xde, 0x35, 0x3c, 0x3c,
	0xf5, 0x29, 0x7e, 0x9a, 0xe1, 0xef, 0x2c, 0xe6, 0x55, 0xf9, 0x90, 0x09, 0xef, 0x7e, 0x81, 0xcc,
	0x51, 0xbb, 0x66, 0xe5, 0xa7, 0x80, 0x5e, 0xe5, 0x01, 0x52, 0x20, 0x33, 0xc6, 0x2f, 0x78, 0x44,
	0x3a, 0xfd, 0x89, 0x9e, 0x42, 0xf6, 0xdc, 0xb0, 0x67, 0x61, 0x69, 0x7c, 0x70, 0x37, 0x9a, 0xe9,
	0x1c, 0xe4, 0x49, 0xfa, 0x5b, 0x82, 0x26, 0xca, 0x82, 0x92, 0xae, 0x7f, 0x03, 0xd6, 0x02, 0xfd,
	0x90, 0xee, 0xe8, 0x6d, 0x80, 0x91, 0x35, 0x1c, 0xf5, 0x9e, 0x1b, 0x3e, 0xf6, 0x98, 0x0f, 0x45,
	0x3d, 0x4f, 0x25, 0x3f, 0xa0, 0x82, 0xfa, 0x9f, 0xb3, 0x50, 0xea, 0x4e, 0x5c, 0xc7, 0xf3, 0xc3,
	0x62, 0x78, 0x0a, 0x39, 0x96, 0x30, 0xa2, 0x0a, 0x8c, 0x0a, 0x8d, 0x1b, 0x9c, 0x5b, 0xb2, 0xe4,
	0xbe, 0x05, 0xf4, 0x0a, 0x30, 0x22, 0xee, 0xa6, 0xaf, 0xe5, 0xee, 0x77, 0x21, 0xc7, 0xbb, 0x28,
	0x2b, 0xf4, 0xc2, 0x56, 0x35, 0x71, 0x57, 0xd8, 0xca, 0xba, 0x07, 0x7b, 0x96, 0x8d, 0xf7, 0x98,
	0x5a, 0x08, 0xce, 0x8d, 0xd0, 0x3b, 0x20, 0x13, 0xe2, 0xf7, 0x88, 0xf5, 0x19, 0xa7, 0x7e, 0xa6,
	0x55, 0xa0, 0x7c, 0x39, 0x3a, 0x3a, 0x3e, 0xb2, 0x3e, 0xc3, 0xba, 0x44, 0x88, 0x4f, 0x7f, 0xa0,
	0x0a, 0xc8, 0xcf, 0x0d, 0xdb, 0x66, 0x25, 0x92, 0x65, 0x1d, 0x30, 0x7a, 0x5e, 0x26, 0x45, 0xee,
	0xff, 0x40, 0x0a, 0x54, 0x85, 0x42, 0xd0, 0xaf, 0x5c, 0xc3, 0x1f, 0xa9, 0x12, 0xad, 0x0b, 0x1d,
	0xb8, 0xe8, 0xd0, 0xf0, 0x47, 0x48, 0x05, 0x89, 0x18, 0x13, 0x97, 0xa6, 0x5c, 0xae, 0x65, 0x36,
	0x8b, 0x7a, 0xf8, 0x88, 0x36, 0x80, 0xd5, 0x0b, 0x7f, 0x54, 0xf3, 0xcc, 0xf5, 0x84, 0x84, 0x25,
	0x60, 0x6c, 0xb9, 0xbd, 0xd3, 0x31, 0x51, 0xa1, 0x26, 0x6c, 0xca, 0x41, 0x02, 0xc6, 0x96, 0xbb,
	0xf7, 0x09, 0xd1, 0x25, 0x7a, 0xb8, 0x37, 0x26, 0x95, 0xcf, 0x05, 0xc8, 0xb2, 0xb7, 0x83, 0x9e,
	0x80, 0x48, 0xeb, 0x3c, 0xe8, 0xea, 0xab, 0x96, 0x39, 0xb3, 0x41, 0x08, 0xc4, 0xa9, 0x31, 0xc1,
	0x2a, 0x62, 0x11, 0xb0, 0xdf, 0xe8, 0x4d, 0x90, 0x08, 0x3e, 0xeb, 0x9d, 0x1b, 0xb6, 0x7a, 0x8f,
	0xb9, 0x97, 0x23, 0xf8, 0xec, 0xfb, 0x86, 0xad, 0x89, 0x72, 0x5a, 0xc9, 0x68, 0xa2, 0x9c, 0x51,
	0x44, 0x4d, 0x94, 0x45, 0x25, 0xab, 0x89, 0x72, 0x56, 0xc9, 0x69, 0xa2, 0x9c, 0x53, 0x24, 0x4d,
	0x94, 0x25, 0x45, 0xd6, 0x44, 0x59, 0x56, 0xf2, 0x9a, 0x28, 0xe7, 0x15, 0xd0, 0x44, 0x19, 0x94,
	0x82, 0x26, 0xca, 0x05, 0xa5, 0xa8, 0x89, 0x72, 0x51, 0x29, 0x69, 0xa2, 0x5c, 0x52, 0xca, 0x9a,
	0x28, 0x97, 0x95, 0x35, 0x4d, 0x94, 0xd7, 0x14, 0x45, 0x13, 0x65, 0x45, 0x59, 0xd7, 0x44, 0x79,
	0x5d, 0x41, 0xf5, 0xbf, 0x08, 0x50, 0xe6, 0xf4, 0x8b, 0xa8, 0xfe, 0x18, 0xd6, 0x59, 0x5e, 0xac,
	0xe9, 0xb0, 0xe7, 0x06, 0x42, 0x46, 0xe2, 0xb4, 0xae, 0x84, 0x07, 0x91, 0xf2, 0x57, 0xa0, 0xe4,
	0x61, 0xc3, 0x8c, 0x15, 0xd3, 0x4c, 0xb1, 0x48, 0x85, 0x91, 0xd2, 0xd7, 0xa0, 0xcc, 0x2a, 0x2d,
	0xd6, 0xca, 0x30, 0xad, 0x12, 0x93, 0x46, 0x6a, 0x2d, 0x28, 0x11, 0xd7, 0x98, 0xc6, 0x5a, 0x22,
	0xab, 0x9c, 0x37, 0xaf, 0x61, 0xf3, 0x91, 0x6b, 0x4c, 0x03, 0x16, 0x17, 0xa9, 0x4d, 0x34, 0x96,
	0x74, 0x36, 0x95, 0x66, 0x13, 0x4c, 0x35, 0x9e, 0x5a, 0xc4, 0x47, 0xdf, 0x83, 0xa2, 0xc7, 0x24,
	0x3d, 0xaa, 0x18, 0x96, 0xe3, 0x2d, 0xa0, 0x05, 0x2f, 0x02, 0x21, 0xf5, 0x73, 0xb8, 0x77, 0x34,
	0x18, 0xe1, 0x89, 0xb1, 0x33, 0x32, 0xa6, 0xc3, 0x68, 0xdc, 0xfd, 0x10, 0x94, 0x04, 0x70, 0xcf,
	0xb6, 0x88, 0x1f, 0xcc, 0xbb, 0x47, 0x37, 0x37, 0xa2, 0x84, 0x77, 0xc1, 0x75, 0x65, 0x6f, 0x49,
	0x1a, 0xb4, 0xa1, 0x37, 0xe0, 0x7e, 0xf2, 0xde, 0x28, 0xc6, 0x16, 0x28, 0x5c, 0x72, 0x8a, 0xb1,
	0x79, 0x6c, 0x78, 0x43, 0xec, 0xa3, 0x06, 0xdc, 0x23, 0xbe, 0xe1, 0xe3, 0x09, 0x2d, 0x41, 0x5a,
	0x91, 0x3d, 0xc6, 0x31, 0x81, 0x71, 0x6c, 0x3d, 0x3a, 0xa2, 0xa3, 0x6a, 0xdf, 0x98, 0xe0, 0xfa,
	0x1f, 0x45, 0x58, 0x8f, 0x41, 0xc2, 0x90, 0x68, 0x21, 0x58, 0xd3, 0x71, 0x2f, 0xde, 0x19, 0x78,
	0x21, 0x58, 0xd3, 0x31, 0xdd, 0x1b, 0x24, 0x7a, 0x78, 0xe2, 0x59, 0x48, 0x03, 0xd1, 0x71, 0xfd,
	0xf0, 0x05, 0xdd, 0xd4, 0x77, 0x5f, 0xb9, 0xa3, 0x71, 0xe0, 0xfa, 0xbc, 0xa1, 0xeb, 0x0c, 0x03,
	0xfd, 0x5e, 0x00, 0xc9, 0x67, 0x41, 0x10, 0x35, 0xc7, 0xf0, 0xbe, 0xfd, 0x5a, 0x78, 0x3c, 0x01,
	0xc1, 0xae, 0x70, 0x48, 0xd3, 0xf9, 0xe5, 0xbc, 0xba, 0x7e, 0x35, 0x41, 0xe4, 0xae, 0x4b, 0x44,
	0xe8, 0x1b, 0xd2, 0xa0, 0xbc, 0x9c, 0x61, 0xd6, 0x82, 0x56, 0x5c, 0x13, 0x4a, 0x4b, 0x6f, 0xa0,
	0x32, 0xa4, 0x13, 0x3b, 0x76, 0xfb, 0x9a, 0xd1, 0xb6, 0xbd, 0x3c, 0xda, 0x1e, 0xaf, 0x94, 0x12,
	0x8e, 0x99, 0x98, 0x67, 0x95, 0x0f, 0x21, 0x1f, 0xe5, 0x3b, 0x79, 0x4b, 0x9e, 0xdf, 0x72, 0x3f,
	0x79, 0x4b, 0xfe, 0x95, 0x41, 0x18, 0x75, 0x9f, 0xac, 0x92, 0xab, 0xff, 0x42, 0x80, 0xa2, 0x8e,
	0x89, 0x63, 0x9f, 0x63, 0x93, 0x12, 0x15, 0x7d, 0x13, 0x44, 0x4a, 0xfc, 0xa0, 0x07, 0xde, 0x52,
	0x50, 0x4c, 0x15, 0x6d, 0x43, 0x3e, 0x5a, 0xdc, 0x5f, 0x67, 0x9f, 0x8d, 0xad, 0xea, 0x2e, 0xa0,
	0x38, 0xe0, 0xa8, 0x75, 0x1c, 0x03, 0x2d, 0x21, 0xe6, 0x5b, 0x50, 0xe6, 0xbc, 0x12, 0x1f, 0xde,
	0x5c, 0x89, 0x51, 0x30, 0xe1, 0x6b, 0xf2, 0x12, 0x32, 0x12, 0x94, 0xe1, 0x22, 0x0b, 0xd2, 0xa1,
	0xf1, 0xc2, 0x76, 0x0c, 0x13, 0xd5, 0xa0, 0x10, 0x6e, 0xcb, 0x96, 0x33, 0x0d, 0x52, 0x99, 0x14,
	0xd1, 0x21, 0x39, 0x23, 0xd8, 0x63, 0xd5, 0xc7, 0xb3, 0x1a, 0x3d, 0xd3, 0x3e, 0xc8, 0x56, 0x7b,
	0x6c, 0xf6, 0x26, 0xd6, 0xc0, 0x73, 0x08, 0x2b, 0xb2, 0x0c, 0x63, 0x07, 0x95, 0x3e, 0x63, 0x42,
	0xf4, 0x10, 0xd6, 0x4e, 0xad, 0xa9, 0x45, 0x46, 0xb1, 0x1e, 0x1b, 0xcb, 0x7a, 0x39, 0x14, 0x07,
	0x8a, 0x0e, 0x94, 0xe3, 0xdd, 0xbd, 0x67, 0x99, 0xbc, 0x80, 0x4a, 0xad, 0xce, 0x62, 0x5e, 0x2d,
	0xc5, 0x73, 0xa7, 0xbb, 0x4b, 0xee, 0x3a, 0x7e, 0x4b, 0x31, 0x7e, 0xd7, 0x24, 0xec, 0x03, 0xc8,
	0xf3, 0x1c, 0x4f, 0x95, 0x39, 0x5f, 0xd8, 0x03, 0xfa, 0x00, 0xb2, 0x36, 0xfd, 0xf6, 0x62, 0x93,
	0xb5, 0xb0, 0x55, 0xbb, 0x21, 0xe7, 0xec, 0x1b, 0x4d, 0xe7, 0xea, 0xa8, 0x05, 0x39, 0x3e, 0xbe,
	0xd9, 0xd0, 0x2d, 0x6c, 0x6d, 0xde, 0x60, 0xb8, 0xf4, 0x69, 0xd5, 0x49, 0xe9, 0x81, 0x25, 0x6a,
	0x83, 0xe4, 0xf1, 0x55, 0x4d, 0x2d, 0x30, 0x90, 0x47, 0x2b, 0x2f, 0x81, 0x9d, 0x94, 0x1e, 0xda,
	0xa2, 0x63, 0x28, 0x92, 0x44, 0xab, 0x55, 0x8b, 0x0c, 0xeb, 0xa6, 0x9d, 0xed, 0x9a, 0x89, 0xd0,
	0xa1, 0xc3, 0x28, 0x21, 0xa6, 0x01, 0x5a, 0x6c, 0xb6, 0xaa, 0xa5, 0x5b, 0x03, 0x5c, 0xda, 0x01,
	0x69, 0x80, 0xdc, 0x12, 0xed, 0x03, 0x0c, 0x22, 0xbe, 0xab, 0x65, 0x86, 0xf3, 0xf5, 0xd7, 0x69,
	0x90, 0x9d, 0x94, 0x9e, 0x40, 0x68, 0xe5, 0x41, 0x32, 0xf9, 0x41, 0xb4, 0x49, 0x48, 0x8a, 0x5c,
	0xff, 0x93, 0x08, 0x72, 0x54, 0x4d, 0x4d, 0x40, 0xa7, 0x9e, 0x31, 0xa0, 0x7c, 0xee, 0x0d, 0x1c,
	0xba, 0x22, 0xf9, 0x98, 0x7f, 0x4a, 0xa4, 0x3b, 0x29, 0x7d, 0x3d, 0x3c, 0xdb, 0x09, 0x8f, 0x28,
	0x63, 0x27, 0x8e, 0x69, 0x9d, 0x5a, 0x31, 0x63, 0xf9, 0x27, 0x72, 0x39, 0x14, 0x07, 0x8c, 0xfd,
	0x68, 0x69, 0x8d, 0xce, 0xac, 0xd0, 0x01, 0x3a, 0xa9, 0xc4, 0x9e, 0x8d, 0x76, 0xae, 0x50, 0xe6,
	0xd1, 0xad, 0x94, 0x09, 0x83, 0xea, 0x08, 0x11, 0x67, 0xf6, 0xae, 0x72, 0xe6, 0xdd, 0xdb, 0x39,
	0x93, 0x80, 0x89, 0x48, 0x73, 0x72, 0x2d, 0x69, 0x9a, 0x2b, 0x92, 0x26, 0x81, 0xb8, 0xcc, 0x9a,
	0x9d, 0x2b, 0xac, 0x79, 0x74, 0x2b, 0x6b, 0x92, 0x31, 0x06, 0xb4, 0x39, 0xb8, 0x86, 0x36, 0xef,
	0xad, 0x44, 0x9b, 0x04, 0x58, 0x92, 0x37, 0x00, 0x72, 0xb8, 0x97, 0x25, 0x38, 0xf4, 0xee, 0x17,
	0x02, 0x88, 0xc7, 0x2f, 0x5c, 0x8c, 0xbe, 0x0a, 0x85, 0x93, 0xfd, 0xa3, 0xc3, 0xf6, 0x4e, 0x77,
	0xaf, 0xdb, 0xde, 0x55, 0x52, 0x95, 0x7b, 0x17, 0x97, 0xb5, 0x35, 0x7a, 0x74, 0x32, 0x25, 0x2e,
	0x1e, 0x30, 0x16, 0xa0, 0x0a, 0xe4, 0x5a, 0xdb, 0x3b, 0x9f, 0x9c, 0x1c, 0x2a, 0x42, 0xa5, 0x7c,
	0x71, 0x59, 0x03, 0xaa, 0xc0, 0x5f, 0x14, 0x7a, 0x00, 0x92, 0xde, 0x3e, 0x3a, 0x3e, 0xd0, 0xdb,
	0x4a, 0xba, 0xb2, 0x76, 0x71, 0x59, 0x2b, 0xd0, 0xc3, 0x20, 0xff, 0xe8, 0x21, 0x94, 0x8e, 0x76,
	0x3a, 0xed, 0x67, 0xdb, 0xbd, 0x9d, 0xce, 0xf6, 0xfe, 0xc7, 0x6d, 0x25, 0x53, 0xb9, 0x7f, 0x71,
	0x59, 0x53, 0xa8, 0x4e, 0x32, 0xad, 0xf4, 0x8a, 0xee, 0xb3, 0xc3, 0x03, 0xfd, 0x58, 0x11, 0xe3,
	0x2b, 0x78, 0x9e, 0x50, 0x1d, 0x80, 0x5b, 0xef, 0xb5, 0xdb, 0xbb, 0x4a, 0xb6, 0x82, 0x2e, 0x2e,
	0x6b, 0x65, 0x7a, 0x1e, 0x87, 0x5f, 0x91, 0x7f, 0xf9, 0xdb, 0x8d, 0xd4, 0x1f, 0x7e, 0xb7, 0x91,
	0x6a, 0xd5, 0x5e, 0xfe, 0x6b, 0x23, 0xf5, 0x72, 0xb1, 0x21, 0x7c, 0xbe, 0xd8, 0x10, 0xfe, 0xb6,
	0xd8, 0x10, 0xfe, 0xb9, 0xd8, 0x10, 0x7e, 0xf5, 0xef, 0x8d, 0xd4, 0xa7, 0x39, 0x9e, 0xb5, 0x7e,
	0x8e, 0xfd, 0xf1, 0xe9, 0xfd, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x80, 0x6a, 0xfb, 0x29, 0x2d,
	0x13, 0x00, 0x00,
}
