// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package policytroubleshooter provides access to the Policy Troubleshooter API.
//
// For product documentation, see: https://cloud.google.com/iam/
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/policytroubleshooter/v1beta"
//	...
//	ctx := context.Background()
//	policytroubleshooterService, err := policytroubleshooter.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	policytroubleshooterService, err := policytroubleshooter.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	policytroubleshooterService, err := policytroubleshooter.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package policytroubleshooter // import "google.golang.org/api/policytroubleshooter/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "policytroubleshooter:v1beta"
const apiName = "policytroubleshooter"
const apiVersion = "v1beta"
const basePath = "https://policytroubleshooter.googleapis.com/"
const mtlsBasePath = "https://policytroubleshooter.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Iam = NewIamService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Iam *IamService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewIamService(s *Service) *IamService {
	rs := &IamService{s: s}
	return rs
}

type IamService struct {
	s *Service
}

// GoogleCloudPolicytroubleshooterV1betaAccessTuple: Information about
// the member, resource, and permission to check.
type GoogleCloudPolicytroubleshooterV1betaAccessTuple struct {
	// FullResourceName: Required. The full resource name that identifies
	// the resource. For example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/inst
	// ances/my-instance`. For examples of full resource names for Google
	// Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `json:"fullResourceName,omitempty"`

	// Permission: Required. The IAM permission to check for the specified
	// member and resource. For a complete list of IAM permissions, see
	// https://cloud.google.com/iam/help/permissions/reference. For a
	// complete list of predefined IAM roles and the permissions in each
	// role, see https://cloud.google.com/iam/help/roles/reference.
	Permission string `json:"permission,omitempty"`

	// Principal: Required. The member, or principal, whose access you want
	// to check, in the form of the email address that represents that
	// member. For example, `alice@example.com` or
	// `my-service-account@my-project.iam.gserviceaccount.com`. The member
	// must be a Google Account or a service account. Other types of members
	// are not supported.
	Principal string `json:"principal,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullResourceName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaAccessTuple) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaAccessTuple
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaBindingExplanation: Details
// about how a binding in a policy affects a member's ability to use a
// permission.
type GoogleCloudPolicytroubleshooterV1betaBindingExplanation struct {
	// Access: Indicates whether _this binding_ provides the specified
	// permission to the specified member for the specified resource. This
	// field does _not_ indicate whether the member actually has the
	// permission for the resource. There might be another binding that
	// overrides this binding. To determine whether the member actually has
	// the permission, use the `access` field in the
	// TroubleshootIamPolicyResponse.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Reserved for future use.
	//   "GRANTED" - The member has the permission.
	//   "NOT_GRANTED" - The member does not have the permission.
	//   "UNKNOWN_CONDITIONAL" - The member has the permission only if a
	// condition expression evaluates to `true`.
	//   "UNKNOWN_INFO_DENIED" - The sender of the request does not have
	// access to all of the policies that Policy Troubleshooter needs to
	// evaluate.
	Access string `json:"access,omitempty"`

	// Condition: A condition expression that prevents access unless the
	// expression evaluates to `true`. To learn about IAM Conditions, see
	// https://cloud.google.com/iam/help/conditions/overview.
	Condition *GoogleTypeExpr `json:"condition,omitempty"`

	// Memberships: Indicates whether each member in the binding includes
	// the member specified in the request, either directly or indirectly.
	// Each key identifies a member in the binding, and each value indicates
	// whether the member in the binding includes the member in the request.
	// For example, suppose that a binding includes the following members: *
	// `user:alice@example.com` * `group:product-eng@example.com` You want
	// to troubleshoot access for `user:bob@example.com`. This user is a
	// member of the group `group:product-eng@example.com`. For the first
	// member in the binding, the key is `user:alice@example.com`, and the
	// `membership` field in the value is set to `MEMBERSHIP_NOT_INCLUDED`.
	// For the second member in the binding, the key is
	// `group:product-eng@example.com`, and the `membership` field in the
	// value is set to `MEMBERSHIP_INCLUDED`.
	Memberships map[string]GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership `json:"memberships,omitempty"`

	// Relevance: The relevance of this binding to the overall determination
	// for the entire policy.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Reserved for future use.
	//   "NORMAL" - The data point has a limited effect on the result.
	// Changing the data point is unlikely to affect the overall
	// determination.
	//   "HIGH" - The data point has a strong effect on the result. Changing
	// the data point is likely to affect the overall determination.
	Relevance string `json:"relevance,omitempty"`

	// Role: The role that this binding grants. For example,
	// `roles/compute.serviceAgent`. For a complete list of predefined IAM
	// roles, as well as the permissions in each role, see
	// https://cloud.google.com/iam/help/roles/reference.
	Role string `json:"role,omitempty"`

	// RolePermission: Indicates whether the role granted by this binding
	// contains the specified permission.
	//
	// Possible values:
	//   "ROLE_PERMISSION_UNSPECIFIED" - Reserved for future use.
	//   "ROLE_PERMISSION_INCLUDED" - The permission is included in the
	// role.
	//   "ROLE_PERMISSION_NOT_INCLUDED" - The permission is not included in
	// the role.
	//   "ROLE_PERMISSION_UNKNOWN_INFO_DENIED" - The sender of the request
	// is not allowed to access the binding.
	RolePermission string `json:"rolePermission,omitempty"`

	// RolePermissionRelevance: The relevance of the permission's existence,
	// or nonexistence, in the role to the overall determination for the
	// entire policy.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Reserved for future use.
	//   "NORMAL" - The data point has a limited effect on the result.
	// Changing the data point is unlikely to affect the overall
	// determination.
	//   "HIGH" - The data point has a strong effect on the result. Changing
	// the data point is likely to affect the overall determination.
	RolePermissionRelevance string `json:"rolePermissionRelevance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaBindingExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaBindingExplanation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMember
// ship: Details about whether the binding includes the member.
type GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership struct {
	// Membership: Indicates whether the binding includes the member.
	//
	// Possible values:
	//   "MEMBERSHIP_UNSPECIFIED" - Reserved for future use.
	//   "MEMBERSHIP_INCLUDED" - The binding includes the member. The member
	// can be included directly or indirectly. For example: * A member is
	// included directly if that member is listed in the binding. * A member
	// is included indirectly if that member is in a Google group or G Suite
	// domain that is listed in the binding.
	//   "MEMBERSHIP_NOT_INCLUDED" - The binding does not include the
	// member.
	//   "MEMBERSHIP_UNKNOWN_INFO_DENIED" - The sender of the request is not
	// allowed to access the binding.
	//   "MEMBERSHIP_UNKNOWN_UNSUPPORTED" - The member is an unsupported
	// type. Only Google Accounts and service accounts are supported.
	Membership string `json:"membership,omitempty"`

	// Relevance: The relevance of the member's status to the overall
	// determination for the binding.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Reserved for future use.
	//   "NORMAL" - The data point has a limited effect on the result.
	// Changing the data point is unlikely to affect the overall
	// determination.
	//   "HIGH" - The data point has a strong effect on the result. Changing
	// the data point is likely to affect the overall determination.
	Relevance string `json:"relevance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Membership") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaExplainedPolicy: Details about
// how a specific IAM Policy contributed to the access check.
type GoogleCloudPolicytroubleshooterV1betaExplainedPolicy struct {
	// Access: Indicates whether _this policy_ provides the specified
	// permission to the specified member for the specified resource. This
	// field does _not_ indicate whether the member actually has the
	// permission for the resource. There might be another policy that
	// overrides this policy. To determine whether the member actually has
	// the permission, use the `access` field in the
	// TroubleshootIamPolicyResponse.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Reserved for future use.
	//   "GRANTED" - The member has the permission.
	//   "NOT_GRANTED" - The member does not have the permission.
	//   "UNKNOWN_CONDITIONAL" - The member has the permission only if a
	// condition expression evaluates to `true`.
	//   "UNKNOWN_INFO_DENIED" - The sender of the request does not have
	// access to all of the policies that Policy Troubleshooter needs to
	// evaluate.
	Access string `json:"access,omitempty"`

	// BindingExplanations: Details about how each binding in the policy
	// affects the member's ability, or inability, to use the permission for
	// the resource. If the sender of the request does not have access to
	// the policy, this field is omitted.
	BindingExplanations []*GoogleCloudPolicytroubleshooterV1betaBindingExplanation `json:"bindingExplanations,omitempty"`

	// FullResourceName: The full resource name that identifies the
	// resource. For example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/inst
	// ances/my-instance`. If the sender of the request does not have access
	// to the policy, this field is omitted. For examples of full resource
	// names for Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `json:"fullResourceName,omitempty"`

	// Policy: The IAM policy attached to the resource. If the sender of the
	// request does not have access to the policy, this field is empty.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`

	// Relevance: The relevance of this policy to the overall determination
	// in the TroubleshootIamPolicyResponse. If the sender of the request
	// does not have access to the policy, this field is omitted.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Reserved for future use.
	//   "NORMAL" - The data point has a limited effect on the result.
	// Changing the data point is unlikely to affect the overall
	// determination.
	//   "HIGH" - The data point has a strong effect on the result. Changing
	// the data point is likely to affect the overall determination.
	Relevance string `json:"relevance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaExplainedPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaExplainedPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest:
// Request for TroubleshootIamPolicy.
type GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest struct {
	// AccessTuple: The information to use for checking whether a member has
	// a permission for a resource.
	AccessTuple *GoogleCloudPolicytroubleshooterV1betaAccessTuple `json:"accessTuple,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessTuple") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessTuple") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse:
// Response for TroubleshootIamPolicy.
type GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse struct {
	// Access: Indicates whether the member has the specified permission for
	// the specified resource, based on evaluating all of the applicable
	// policies.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Reserved for future use.
	//   "GRANTED" - The member has the permission.
	//   "NOT_GRANTED" - The member does not have the permission.
	//   "UNKNOWN_CONDITIONAL" - The member has the permission only if a
	// condition expression evaluates to `true`.
	//   "UNKNOWN_INFO_DENIED" - The sender of the request does not have
	// access to all of the policies that Policy Troubleshooter needs to
	// evaluate.
	Access string `json:"access,omitempty"`

	// ExplainedPolicies: List of IAM policies that were evaluated to check
	// the member's permissions, with annotations to indicate how each
	// policy contributed to the final result. The list of policies can
	// include the policy for the resource itself. It can also include
	// policies that are inherited from higher levels of the resource
	// hierarchy, including the organization, the folder, and the project.
	// To learn more about the resource hierarchy, see
	// https://cloud.google.com/iam/help/resource-hierarchy.
	ExplainedPolicies []*GoogleCloudPolicytroubleshooterV1betaExplainedPolicy `json:"explainedPolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a
// service. The configuration determines which permission types are
// logged, and what identities, if any, are exempted from logging. An
// AuditConfig must have one or more AuditLogConfigs. If there are
// AuditConfigs for both `allServices` and a specific service, the union
// of the two AuditConfigs is used for that service: the log_types
// specified in each AuditConfig are enabled, and the exempted_members
// in each AuditLogConfig are exempted. Example Policy with multiple
// AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members":
// [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, {
// "log_type": "ADMIN_READ" } ] }, { "service":
// "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
// "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
// "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy
// enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts
// `jose@example.com` from DATA_READ logging, and `aliya@example.com`
// from DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of
	// permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`

	// Service: Specifies a service that will be enabled for audit logging.
	// For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
	// `allServices` is a special value that covers all services.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLogConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a
// type of permissions. Example: { "audit_log_configs": [ { "log_type":
// "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, {
// "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and
// 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ
// logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging
	// for this type of permission. Follows the same format of
	// Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExemptedMembers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates `members`, or principals, with a
// `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the
	// current request. If the condition evaluates to `false`, then this
	// binding does not apply to the current request. However, a different
	// role binding might grant the same role to one or more of the
	// principals in this binding. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`

	// Members: Specifies the principals requesting access for a Google
	// Cloud resource. `members` can have the following values: *
	// `allUsers`: A special identifier that represents anyone who is on the
	// internet; with or without a Google account. *
	// `allAuthenticatedUsers`: A special identifier that represents anyone
	// who is authenticated with a Google account or a service account. Does
	// not include identities that come from external identity providers
	// (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address
	// that represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
	//  An identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`.
	// * `group:{emailid}`: An email address that represents a Google group.
	// For example, `admins@example.com`. * `domain:{domain}`: The G Suite
	// domain (primary) that represents all the users of that domain. For
	// example, `google.com` or `example.com`. *
	// `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently
	// deleted. For example, `alice@example.com?uid=123456789012345678901`.
	// If the user is recovered, this value reverts to `user:{emailid}` and
	// the recovered user retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`:
	// An email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is
	// recovered, this value reverts to `group:{emailid}` and the recovered
	// group retains the role in the binding.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to the list of `members`, or principals.
	// For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: An Identity and Access Management (IAM) policy,
// which specifies access controls for Google Cloud resources. A
// `Policy` is a collection of `bindings`. A `binding` binds one or more
// `members`, or principals, to a single `role`. Principals can be user
// accounts, service accounts, Google groups, and domains (such as G
// Suite). A `role` is a named list of permissions; each `role` can be
// an IAM predefined role or a user-created custom role. For some types
// of Google Cloud resources, a `binding` can also specify a
// `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can
// add constraints based on attributes of the request, the resource, or
// both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
// **JSON example:** { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com",
// "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, {
// "role": "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ],
// "etag": "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com -
// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
// roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access
// after Sep 2020 expression: request.time <
// timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3
// For a description of IAM and its features, see the IAM documentation
// (https://cloud.google.com/iam/docs/).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this
	// policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`

	// Bindings: Associates a list of `members`, or principals, with a
	// `role`. Optionally, may specify a `condition` that determines how and
	// when the `bindings` are applied. Each of the `bindings` must contain
	// at least one principal. The `bindings` in a `Policy` can refer to up
	// to 1,500 principals; up to 250 of these principals can be Google
	// groups. Each occurrence of a principal counts towards these limits.
	// For example, if the `bindings` grant 50 different roles to
	// `user:alice@example.com`, and not to any other principal, then you
	// can add another 1,450 principals to the `bindings` in the `Policy`.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`

	// Etag: `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a policy from overwriting each
	// other. It is strongly suggested that systems make use of the `etag`
	// in the read-modify-write cycle to perform policy updates in order to
	// avoid race conditions: An `etag` is returned in the response to
	// `getIamPolicy`, and systems are expected to put that etag in the
	// request to `setIamPolicy` to ensure that their change will be applied
	// to the same version of the policy. **Important:** If you use IAM
	// Conditions, you must include the `etag` field whenever you call
	// `setIamPolicy`. If you omit this field, then IAM allows you to
	// overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`

	// Version: Specifies the format of the policy. Valid values are `0`,
	// `1`, and `3`. Requests that specify an invalid value are rejected.
	// Any operation that affects conditional role bindings must specify
	// version `3`. This requirement applies to the following operations: *
	// Getting a policy that includes a conditional role binding * Adding a
	// conditional role binding to a policy * Changing a conditional role
	// binding in a policy * Removing any role binding, with or without a
	// condition, from a policy that includes conditions **Important:** If
	// you use IAM Conditions, you must include the `etag` field whenever
	// you call `setIamPolicy`. If you omit this field, then IAM allows you
	// to overwrite a version `3` policy with a version `1` policy, and all
	// of the conditions in the version `3` policy are lost. If a policy
	// does not include any conditions, operations on that policy may
	// specify any valid version or leave the field unset. To learn which
	// resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common
// Expression Language (CEL) syntax. CEL is a C-like expression
// language. The syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec. Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "policytroubleshooter.iam.troubleshoot":

type IamTroubleshootCall struct {
	s                                                                 *Service
	googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// Troubleshoot: Checks whether a member has a specific permission for a
// specific resource, and explains why the member does or does not have
// that permission.
func (r *IamService) Troubleshoot(googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest) *IamTroubleshootCall {
	c := &IamTroubleshootCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest = googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *IamTroubleshootCall) Fields(s ...googleapi.Field) *IamTroubleshootCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *IamTroubleshootCall) Context(ctx context.Context) *IamTroubleshootCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *IamTroubleshootCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IamTroubleshootCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/iam:troubleshoot")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policytroubleshooter.iam.troubleshoot" call.
// Exactly one of
// *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse.Se
// rverResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *IamTroubleshootCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Checks whether a member has a specific permission for a specific resource, and explains why the member does or does not have that permission.",
	//   "flatPath": "v1beta/iam:troubleshoot",
	//   "httpMethod": "POST",
	//   "id": "policytroubleshooter.iam.troubleshoot",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1beta/iam:troubleshoot",
	//   "request": {
	//     "$ref": "GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
