/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.parquet.ParquetRuntimeException;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

class DirectCodecFactory
extends CodecFactory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DirectCodecFactory.class);
    private final ByteBufferAllocator allocator;
    private static final Class<?> DIRECT_DECOMPRESSION_CODEC_CLASS;
    private static final Method DECOMPRESS_METHOD;
    private static final Method CREATE_DIRECT_DECOMPRESSOR_METHOD;

    DirectCodecFactory(Configuration config, ByteBufferAllocator allocator, int pageSize) {
        super(config, pageSize);
        Preconditions.checkNotNull((Object)allocator, (String)"allocator");
        Preconditions.checkState((boolean)allocator.isDirect(), (String)"A %s requires a direct buffer allocator be provided.", (Object[])new Object[]{this.getClass().getSimpleName()});
        this.allocator = allocator;
    }

    private ByteBuffer ensure(ByteBuffer buffer, int size) {
        if (buffer == null) {
            buffer = this.allocator.allocate(size);
        } else if (buffer.capacity() >= size) {
            buffer.clear();
        } else {
            this.release(buffer);
            buffer = this.allocator.allocate(size);
        }
        return buffer;
    }

    ByteBuffer release(ByteBuffer buffer) {
        if (buffer != null) {
            this.allocator.release(buffer);
        }
        return null;
    }

    @Override
    protected CodecFactory.BytesCompressor createCompressor(CompressionCodecName codecName) {
        CompressionCodec codec = this.getCodec(codecName);
        if (codec == null) {
            return new NoopCompressor();
        }
        if (codecName == CompressionCodecName.SNAPPY) {
            return new SnappyCompressor();
        }
        return new CodecFactory.HeapBytesCompressor(codecName);
    }

    @Override
    protected CodecFactory.BytesDecompressor createDecompressor(CompressionCodecName codecName) {
        CompressionCodec codec = this.getCodec(codecName);
        if (codec == null) {
            return new NoopDecompressor();
        }
        if (codecName == CompressionCodecName.SNAPPY) {
            return new SnappyDecompressor();
        }
        if (DirectCodecPool.INSTANCE.codec(codec).supportsDirectDecompression()) {
            return new FullDirectDecompressor(codecName);
        }
        return new IndirectDecompressor(codec);
    }

    @Override
    public void close() {
        this.release();
    }

    static {
        Class<?> tempClass = null;
        Method tempCreateMethod = null;
        Method tempDecompressMethod = null;
        try {
            tempClass = Class.forName("org.apache.hadoop.io.compress.DirectDecompressionCodec");
            tempCreateMethod = tempClass.getMethod("createDirectDecompressor", new Class[0]);
            tempDecompressMethod = tempClass.getMethod("decompress", ByteBuffer.class, ByteBuffer.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        DIRECT_DECOMPRESSION_CODEC_CLASS = tempClass;
        CREATE_DIRECT_DECOMPRESSOR_METHOD = tempCreateMethod;
        DECOMPRESS_METHOD = tempDecompressMethod;
    }

    static class DirectCodecPool {
        public static final DirectCodecPool INSTANCE = new DirectCodecPool();
        private final Map<CompressionCodec, CodecPool> codecs = Collections.synchronizedMap(new HashMap());
        private final Map<Class<?>, GenericObjectPool> directDePools = Collections.synchronizedMap(new HashMap());
        private final Map<Class<?>, GenericObjectPool> dePools = Collections.synchronizedMap(new HashMap());
        private final Map<Class<?>, GenericObjectPool> cPools = Collections.synchronizedMap(new HashMap());

        private DirectCodecPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CodecPool codec(CompressionCodec codec) {
            CodecPool pools = this.codecs.get(codec);
            if (pools == null) {
                DirectCodecPool directCodecPool = this;
                synchronized (directCodecPool) {
                    pools = this.codecs.get(codec);
                    if (pools == null) {
                        pools = new CodecPool(codec);
                        this.codecs.put(codec, pools);
                    }
                }
            }
            return pools;
        }

        private void returnToPool(Object obj, Map<Class<?>, GenericObjectPool> pools) {
            try {
                GenericObjectPool pool = pools.get(obj.getClass());
                if (pool == null) {
                    throw new IllegalStateException("Received unexpected compressor or decompressor, cannot be returned to any available pool: " + obj.getClass().getSimpleName());
                }
                pool.returnObject(obj);
            }
            catch (Exception e) {
                throw new ParquetCompressionCodecException(e);
            }
        }

        public <T> T borrow(GenericObjectPool pool) {
            try {
                return (T)pool.borrowObject();
            }
            catch (Exception e) {
                throw new ParquetCompressionCodecException(e);
            }
        }

        public void returnCompressor(Compressor compressor) {
            this.returnToPool(compressor, this.cPools);
        }

        public void returnDecompressor(Decompressor decompressor) {
            this.returnToPool(decompressor, this.dePools);
        }

        public void returnDirectDecompressor(Object decompressor) {
            this.returnToPool(decompressor, this.directDePools);
        }

        public static class ParquetCompressionCodecException
        extends ParquetRuntimeException {
            public ParquetCompressionCodecException() {
            }

            public ParquetCompressionCodecException(String message, Throwable cause) {
                super(message, cause);
            }

            public ParquetCompressionCodecException(String message) {
                super(message);
            }

            public ParquetCompressionCodecException(Throwable cause) {
            }
        }

        public class CodecPool {
            private final GenericObjectPool compressorPool;
            private final GenericObjectPool decompressorPool;
            private final GenericObjectPool directDecompressorPool;
            private final boolean supportDirectDecompressor;
            private static final String BYTE_BUF_IMPL_NOT_FOUND_MSG = "Unable to find ByteBuffer based %s for codec %s, will use a byte array based implementation instead.";

            private CodecPool(final CompressionCodec codec) {
                try {
                    boolean supportDirectDecompressor = codec.getClass() == DIRECT_DECOMPRESSION_CODEC_CLASS;
                    this.compressorPool = new GenericObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory(){

                        public Object makeObject() throws Exception {
                            return codec.createCompressor();
                        }
                    }, Integer.MAX_VALUE);
                    Object com = this.compressorPool.borrowObject();
                    if (com != null) {
                        DirectCodecPool.this.cPools.put(com.getClass(), this.compressorPool);
                        this.compressorPool.returnObject(com);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format(BYTE_BUF_IMPL_NOT_FOUND_MSG, "compressor", codec.getClass().getName()));
                    }
                    this.decompressorPool = new GenericObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory(){

                        public Object makeObject() throws Exception {
                            return codec.createDecompressor();
                        }
                    }, Integer.MAX_VALUE);
                    Object decom = this.decompressorPool.borrowObject();
                    if (decom != null) {
                        DirectCodecPool.this.dePools.put(decom.getClass(), this.decompressorPool);
                        this.decompressorPool.returnObject(decom);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format(BYTE_BUF_IMPL_NOT_FOUND_MSG, "decompressor", codec.getClass().getName()));
                    }
                    if (supportDirectDecompressor) {
                        this.directDecompressorPool = new GenericObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory(){

                            public Object makeObject() throws Exception {
                                return CREATE_DIRECT_DECOMPRESSOR_METHOD.invoke((Object)DIRECT_DECOMPRESSION_CODEC_CLASS, new Object[0]);
                            }
                        }, Integer.MAX_VALUE);
                        Object ddecom = this.directDecompressorPool.borrowObject();
                        if (ddecom != null) {
                            DirectCodecPool.this.directDePools.put(ddecom.getClass(), this.directDecompressorPool);
                            this.directDecompressorPool.returnObject(ddecom);
                        } else {
                            supportDirectDecompressor = false;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(String.format(BYTE_BUF_IMPL_NOT_FOUND_MSG, "compressor", codec.getClass().getName()));
                            }
                        }
                    } else {
                        this.directDecompressorPool = null;
                    }
                    this.supportDirectDecompressor = supportDirectDecompressor;
                }
                catch (Exception e) {
                    throw new ParquetCompressionCodecException("Error creating compression codec pool.", e);
                }
            }

            public Object borrowDirectDecompressor() {
                Preconditions.checkArgument((boolean)this.supportDirectDecompressor, (String)"Tried to get a direct Decompressor from a non-direct codec.");
                try {
                    return this.directDecompressorPool.borrowObject();
                }
                catch (Exception e) {
                    throw new ParquetCompressionCodecException(e);
                }
            }

            public boolean supportsDirectDecompression() {
                return this.supportDirectDecompressor;
            }

            public Decompressor borrowDecompressor() {
                return (Decompressor)DirectCodecPool.this.borrow(this.decompressorPool);
            }

            public Compressor borrowCompressor() {
                return (Compressor)DirectCodecPool.this.borrow(this.compressorPool);
            }
        }
    }

    public static class NoopCompressor
    extends CodecFactory.BytesCompressor {
        @Override
        public BytesInput compress(BytesInput bytes) throws IOException {
            return bytes;
        }

        @Override
        public CompressionCodecName getCodecName() {
            return CompressionCodecName.UNCOMPRESSED;
        }

        @Override
        public void release() {
        }
    }

    public class SnappyCompressor
    extends CodecFactory.BytesCompressor {
        private ByteBuffer incoming;
        private ByteBuffer outgoing;

        @Override
        public BytesInput compress(BytesInput bytes) throws IOException {
            int size;
            int maxOutputSize = Snappy.maxCompressedLength((int)((int)bytes.size()));
            ByteBuffer bufferIn = bytes.toByteBuffer();
            this.outgoing = DirectCodecFactory.this.ensure(this.outgoing, maxOutputSize);
            if (bufferIn.isDirect()) {
                size = Snappy.compress((ByteBuffer)bufferIn, (ByteBuffer)this.outgoing);
            } else {
                this.incoming = DirectCodecFactory.this.ensure(this.incoming, (int)bytes.size());
                this.incoming.put(bufferIn);
                this.incoming.flip();
                size = Snappy.compress((ByteBuffer)this.incoming, (ByteBuffer)this.outgoing);
            }
            this.outgoing.limit(size);
            return BytesInput.from((ByteBuffer[])new ByteBuffer[]{this.outgoing});
        }

        @Override
        public CompressionCodecName getCodecName() {
            return CompressionCodecName.SNAPPY;
        }

        @Override
        public void release() {
            this.outgoing = DirectCodecFactory.this.release(this.outgoing);
            this.incoming = DirectCodecFactory.this.release(this.incoming);
        }
    }

    public class SnappyDecompressor
    extends CodecFactory.BytesDecompressor {
        private CodecFactory.HeapBytesDecompressor extraDecompressor;

        public SnappyDecompressor() {
            this.extraDecompressor = new CodecFactory.HeapBytesDecompressor(CompressionCodecName.SNAPPY);
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
            return this.extraDecompressor.decompress(bytes, uncompressedSize);
        }

        @Override
        public void decompress(ByteBuffer src, int compressedSize, ByteBuffer dst, int uncompressedSize) throws IOException {
            dst.clear();
            int size = Snappy.uncompress((ByteBuffer)src, (ByteBuffer)dst);
            dst.limit(size);
        }

        @Override
        public void release() {
        }
    }

    public class NoopDecompressor
    extends CodecFactory.BytesDecompressor {
        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int uncompressedSize) throws IOException {
            Preconditions.checkArgument((compressedSize == uncompressedSize ? 1 : 0) != 0, (String)"Non-compressed data did not have matching compressed and uncompressed sizes.");
            output.clear();
            output.put((ByteBuffer)input.duplicate().position(0).limit(compressedSize));
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
            return bytes;
        }

        @Override
        public void release() {
        }
    }

    public class FullDirectDecompressor
    extends CodecFactory.BytesDecompressor {
        private final Object decompressor;
        private CodecFactory.HeapBytesDecompressor extraDecompressor;

        public FullDirectDecompressor(CompressionCodecName codecName) {
            CompressionCodec codec = DirectCodecFactory.this.getCodec(codecName);
            this.decompressor = DirectCodecPool.INSTANCE.codec(codec).borrowDirectDecompressor();
            this.extraDecompressor = new CodecFactory.HeapBytesDecompressor(codecName);
        }

        @Override
        public BytesInput decompress(BytesInput compressedBytes, int uncompressedSize) throws IOException {
            return this.extraDecompressor.decompress(compressedBytes, uncompressedSize);
        }

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int uncompressedSize) throws IOException {
            output.clear();
            try {
                DECOMPRESS_METHOD.invoke(this.decompressor, (ByteBuffer)input.limit(compressedSize), (ByteBuffer)output.limit(uncompressedSize));
            }
            catch (IllegalAccessException e) {
                throw new DirectCodecPool.ParquetCompressionCodecException(e);
            }
            catch (InvocationTargetException e) {
                throw new DirectCodecPool.ParquetCompressionCodecException(e);
            }
            output.position(uncompressedSize);
        }

        @Override
        public void release() {
            DirectCodecPool.INSTANCE.returnDirectDecompressor(this.decompressor);
            this.extraDecompressor.release();
        }
    }

    public class IndirectDecompressor
    extends CodecFactory.BytesDecompressor {
        private final Decompressor decompressor;

        public IndirectDecompressor(CompressionCodec codec) {
            this.decompressor = DirectCodecPool.INSTANCE.codec(codec).borrowDecompressor();
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
            this.decompressor.reset();
            byte[] inputBytes = bytes.toByteArray();
            this.decompressor.setInput(inputBytes, 0, inputBytes.length);
            byte[] output = new byte[uncompressedSize];
            this.decompressor.decompress(output, 0, uncompressedSize);
            return BytesInput.from((byte[])output);
        }

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int uncompressedSize) throws IOException {
            this.decompressor.reset();
            byte[] inputBytes = new byte[compressedSize];
            input.position(0);
            input.get(inputBytes);
            this.decompressor.setInput(inputBytes, 0, inputBytes.length);
            byte[] outputBytes = new byte[uncompressedSize];
            this.decompressor.decompress(outputBytes, 0, uncompressedSize);
            output.clear();
            output.put(outputBytes);
        }

        @Override
        public void release() {
            DirectCodecPool.INSTANCE.returnDecompressor(this.decompressor);
        }
    }
}

