/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class LongColDivideLongColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    int colNum1;
    int colNum2;
    int outputColumn;

    public LongColDivideLongColumn(int colNum1, int colNum2, int outputColumn) {
        this();
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public LongColDivideLongColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        long[] vector2 = inputColVector2.vector;
        double[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = inputColVector1.isRepeating && inputColVector2.isRepeating;
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        boolean hasDivBy0 = false;
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            long denom = vector2[0];
            outputVector[0] = (double)vector1[0] / (double)denom;
            hasDivBy0 = hasDivBy0 || denom == 0L;
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    long denom = vector2[i];
                    outputVector[i] = (double)vector1[0] / (double)denom;
                    hasDivBy0 = hasDivBy0 || denom == 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    long denom = vector2[i];
                    outputVector[i] = (double)vector1[0] / (double)denom;
                    hasDivBy0 = hasDivBy0 || denom == 0L;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (vector2[0] == 0L) {
                outputColVector.noNulls = false;
                outputColVector.isRepeating = true;
                outputColVector.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = (double)vector1[i] / (double)vector2[0];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (double)vector1[i] / (double)vector2[0];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                long denom = vector2[i];
                outputVector[i] = (double)vector1[i] / (double)denom;
                hasDivBy0 = hasDivBy0 || denom == 0L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                long denom = vector2[i];
                outputVector[i] = (double)vector1[i] / (double)denom;
                hasDivBy0 = hasDivBy0 || denom == 0L;
            }
        }
        if (!hasDivBy0) {
            NullUtil.setNullDataEntriesDouble(outputColVector, batch.selectedInUse, sel, n);
        } else {
            NullUtil.setNullAndDivBy0DataEntriesDouble(outputColVector, batch.selectedInUse, sel, n, inputColVector2);
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "double";
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum1 + ", col " + this.colNum2;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

