/****************************************************************************************
 * Copyright (c) 2007 Nikolaj Hald Nielsen <nhn@kde.org>                                *
 *                                                                                      *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) any later           *
 * version.                                                                             *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#ifndef INFOOBSERVER_H
#define INFOOBSERVER_H

#include "amarok_export.h"

#include <QVariantMap>

/**
An abstract base class for observers that wants to be notified when here is new contex information available about an active service

    @author Nikolaj Hald Nielsen <nhn@kde.org> 
*/
class AMAROK_EXPORT InfoObserver{
public:
    virtual void infoChanged( QVariantMap infoMap ) = 0;
    virtual ~InfoObserver() {}
};

#endif
