/*
 * moves_order.h --- General package to store moves order.
 *
 * Copyright (c) 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2001-06-18 19:45:32 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef MOVES_ORDER_H
#define MOVES_ORDER_H

#include	"types.h"
#include	"expltype.h"

#include	<stdio.h>

/*--------------------------------------------------------------------------*/

typedef enum
{
    e_First_Move 	  = 1 ,
    e_Last_Move  	  = 2 ,
    e_First_And_Last_Move = e_First_Move | e_Last_Move
} move_type_t ;

/*--------------------------------------------------------------------------*/

struct moves_order_t*	create_moves_order(
    const exploration_t* exploration );
void			delete_moves_order(
    struct moves_order_t* moves_order );

/* This functions return FALSE if adding the new move constraint gives a
 * contradiction.  It return TRUE in the other case.
 */
bool_t	add_move_order( struct moves_order_t*	moves_order,
			piece_index_t		before_piece_index,
			unsigned int		before_move_index,
			move_type_t		before_type,
			piece_index_t		after_piece_index,
			unsigned int		after_move_index,
			move_type_t		after_type );

void	print_moves_order( FILE*			fd,
			   const struct moves_order_t*	moves_order,
			   const exploration_t*		exploration );

#endif /* MOVES_ORDER_H */
