/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jrtfs;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Formatter;
import jdk.internal.jimage.ImageReader;

final class JrtFileAttributes
implements BasicFileAttributes {
    private final ImageReader.Node node;

    JrtFileAttributes(ImageReader.Node node) {
        this.node = node;
    }

    @Override
    public FileTime creationTime() {
        return this.node.getFileAttributes().creationTime();
    }

    @Override
    public boolean isDirectory() {
        return this.node.isDirectory();
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public boolean isRegularFile() {
        return !this.isDirectory();
    }

    @Override
    public FileTime lastAccessTime() {
        return this.node.getFileAttributes().lastAccessTime();
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.node.getFileAttributes().lastModifiedTime();
    }

    @Override
    public long size() {
        return this.node.size();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.node.isLink();
    }

    @Override
    public Object fileKey() {
        return this.node.resolveLink(true);
    }

    public long compressedSize() {
        return this.node.compressedSize();
    }

    public String extension() {
        return this.node.extension();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(1024);
        try (Formatter fm = new Formatter(sb);){
            if (this.creationTime() != null) {
                fm.format("    creationTime    : %tc%n", this.creationTime().toMillis());
            } else {
                fm.format("    creationTime    : null%n", new Object[0]);
            }
            if (this.lastAccessTime() != null) {
                fm.format("    lastAccessTime  : %tc%n", this.lastAccessTime().toMillis());
            } else {
                fm.format("    lastAccessTime  : null%n", new Object[0]);
            }
            fm.format("    lastModifiedTime: %tc%n", this.lastModifiedTime().toMillis());
            fm.format("    isRegularFile   : %b%n", this.isRegularFile());
            fm.format("    isDirectory     : %b%n", this.isDirectory());
            fm.format("    isSymbolicLink  : %b%n", this.isSymbolicLink());
            fm.format("    isOther         : %b%n", this.isOther());
            fm.format("    fileKey         : %s%n", this.fileKey());
            fm.format("    size            : %d%n", this.size());
            fm.format("    compressedSize  : %d%n", this.compressedSize());
            fm.format("    extension       : %s%n", this.extension());
        }
        return sb.toString();
    }
}

