// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/kms/v1/service.proto

package kms

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [KeyManagementService.ListKeyRings][google.cloud.kms.v1.KeyManagementService.ListKeyRings].
type ListKeyRingsRequest struct {
	// Required. The resource name of the location associated with the
	// [KeyRings][google.cloud.kms.v1.KeyRing], in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [KeyRings][google.cloud.kms.v1.KeyRing] to include in the
	// response.  Further [KeyRings][google.cloud.kms.v1.KeyRing] can subsequently be obtained by
	// including the [ListKeyRingsResponse.next_page_token][google.cloud.kms.v1.ListKeyRingsResponse.next_page_token] in a subsequent
	// request.  If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListKeyRingsResponse.next_page_token][google.cloud.kms.v1.ListKeyRingsResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Only include resources that match the filter in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify how the results should be sorted. If not specified, the
	// results will be sorted in the default order.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeyRingsRequest) Reset()         { *m = ListKeyRingsRequest{} }
func (m *ListKeyRingsRequest) String() string { return proto.CompactTextString(m) }
func (*ListKeyRingsRequest) ProtoMessage()    {}
func (*ListKeyRingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{0}
}

func (m *ListKeyRingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeyRingsRequest.Unmarshal(m, b)
}
func (m *ListKeyRingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeyRingsRequest.Marshal(b, m, deterministic)
}
func (m *ListKeyRingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeyRingsRequest.Merge(m, src)
}
func (m *ListKeyRingsRequest) XXX_Size() int {
	return xxx_messageInfo_ListKeyRingsRequest.Size(m)
}
func (m *ListKeyRingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeyRingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeyRingsRequest proto.InternalMessageInfo

func (m *ListKeyRingsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListKeyRingsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListKeyRingsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListKeyRingsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListKeyRingsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// Request message for [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
type ListCryptoKeysRequest struct {
	// Required. The resource name of the [KeyRing][google.cloud.kms.v1.KeyRing] to list, in the format
	// `projects/*/locations/*/keyRings/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [CryptoKeys][google.cloud.kms.v1.CryptoKey] to include in the
	// response.  Further [CryptoKeys][google.cloud.kms.v1.CryptoKey] can subsequently be obtained by
	// including the [ListCryptoKeysResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeysResponse.next_page_token] in a subsequent
	// request.  If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListCryptoKeysResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeysResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The fields of the primary version to include in the response.
	VersionView CryptoKeyVersion_CryptoKeyVersionView `protobuf:"varint,4,opt,name=version_view,json=versionView,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionView" json:"version_view,omitempty"`
	// Optional. Only include resources that match the filter in the response.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify how the results should be sorted. If not specified, the
	// results will be sorted in the default order.
	OrderBy              string   `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeysRequest) Reset()         { *m = ListCryptoKeysRequest{} }
func (m *ListCryptoKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeysRequest) ProtoMessage()    {}
func (*ListCryptoKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{1}
}

func (m *ListCryptoKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeysRequest.Unmarshal(m, b)
}
func (m *ListCryptoKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListCryptoKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeysRequest.Merge(m, src)
}
func (m *ListCryptoKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeysRequest.Size(m)
}
func (m *ListCryptoKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeysRequest proto.InternalMessageInfo

func (m *ListCryptoKeysRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCryptoKeysRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCryptoKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListCryptoKeysRequest) GetVersionView() CryptoKeyVersion_CryptoKeyVersionView {
	if m != nil {
		return m.VersionView
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED
}

func (m *ListCryptoKeysRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListCryptoKeysRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// Request message for [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions].
type ListCryptoKeyVersionsRequest struct {
	// Required. The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to list, in the format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] to
	// include in the response. Further [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] can
	// subsequently be obtained by including the
	// [ListCryptoKeyVersionsResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeyVersionsResponse.next_page_token] in a subsequent request.
	// If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListCryptoKeyVersionsResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeyVersionsResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The fields to include in the response.
	View CryptoKeyVersion_CryptoKeyVersionView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionView" json:"view,omitempty"`
	// Optional. Only include resources that match the filter in the response.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify how the results should be sorted. If not specified, the
	// results will be sorted in the default order.
	OrderBy              string   `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeyVersionsRequest) Reset()         { *m = ListCryptoKeyVersionsRequest{} }
func (m *ListCryptoKeyVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeyVersionsRequest) ProtoMessage()    {}
func (*ListCryptoKeyVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{2}
}

func (m *ListCryptoKeyVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeyVersionsRequest.Unmarshal(m, b)
}
func (m *ListCryptoKeyVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeyVersionsRequest.Marshal(b, m, deterministic)
}
func (m *ListCryptoKeyVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeyVersionsRequest.Merge(m, src)
}
func (m *ListCryptoKeyVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeyVersionsRequest.Size(m)
}
func (m *ListCryptoKeyVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeyVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeyVersionsRequest proto.InternalMessageInfo

func (m *ListCryptoKeyVersionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCryptoKeyVersionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCryptoKeyVersionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListCryptoKeyVersionsRequest) GetView() CryptoKeyVersion_CryptoKeyVersionView {
	if m != nil {
		return m.View
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED
}

func (m *ListCryptoKeyVersionsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListCryptoKeyVersionsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// Request message for [KeyManagementService.ListImportJobs][google.cloud.kms.v1.KeyManagementService.ListImportJobs].
type ListImportJobsRequest struct {
	// Required. The resource name of the [KeyRing][google.cloud.kms.v1.KeyRing] to list, in the format
	// `projects/*/locations/*/keyRings/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [ImportJobs][google.cloud.kms.v1.ImportJob] to include in the
	// response. Further [ImportJobs][google.cloud.kms.v1.ImportJob] can subsequently be obtained by
	// including the [ListImportJobsResponse.next_page_token][google.cloud.kms.v1.ListImportJobsResponse.next_page_token] in a subsequent
	// request. If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListImportJobsResponse.next_page_token][google.cloud.kms.v1.ListImportJobsResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Only include resources that match the filter in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify how the results should be sorted. If not specified, the
	// results will be sorted in the default order.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListImportJobsRequest) Reset()         { *m = ListImportJobsRequest{} }
func (m *ListImportJobsRequest) String() string { return proto.CompactTextString(m) }
func (*ListImportJobsRequest) ProtoMessage()    {}
func (*ListImportJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{3}
}

func (m *ListImportJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListImportJobsRequest.Unmarshal(m, b)
}
func (m *ListImportJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListImportJobsRequest.Marshal(b, m, deterministic)
}
func (m *ListImportJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImportJobsRequest.Merge(m, src)
}
func (m *ListImportJobsRequest) XXX_Size() int {
	return xxx_messageInfo_ListImportJobsRequest.Size(m)
}
func (m *ListImportJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImportJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListImportJobsRequest proto.InternalMessageInfo

func (m *ListImportJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListImportJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListImportJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListImportJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListImportJobsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// Response message for [KeyManagementService.ListKeyRings][google.cloud.kms.v1.KeyManagementService.ListKeyRings].
type ListKeyRingsResponse struct {
	// The list of [KeyRings][google.cloud.kms.v1.KeyRing].
	KeyRings []*KeyRing `protobuf:"bytes,1,rep,name=key_rings,json=keyRings,proto3" json:"key_rings,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListKeyRingsRequest.page_token][google.cloud.kms.v1.ListKeyRingsRequest.page_token] to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [KeyRings][google.cloud.kms.v1.KeyRing] that matched the query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeyRingsResponse) Reset()         { *m = ListKeyRingsResponse{} }
func (m *ListKeyRingsResponse) String() string { return proto.CompactTextString(m) }
func (*ListKeyRingsResponse) ProtoMessage()    {}
func (*ListKeyRingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{4}
}

func (m *ListKeyRingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeyRingsResponse.Unmarshal(m, b)
}
func (m *ListKeyRingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeyRingsResponse.Marshal(b, m, deterministic)
}
func (m *ListKeyRingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeyRingsResponse.Merge(m, src)
}
func (m *ListKeyRingsResponse) XXX_Size() int {
	return xxx_messageInfo_ListKeyRingsResponse.Size(m)
}
func (m *ListKeyRingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeyRingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeyRingsResponse proto.InternalMessageInfo

func (m *ListKeyRingsResponse) GetKeyRings() []*KeyRing {
	if m != nil {
		return m.KeyRings
	}
	return nil
}

func (m *ListKeyRingsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListKeyRingsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Response message for [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
type ListCryptoKeysResponse struct {
	// The list of [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	CryptoKeys []*CryptoKey `protobuf:"bytes,1,rep,name=crypto_keys,json=cryptoKeys,proto3" json:"crypto_keys,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListCryptoKeysRequest.page_token][google.cloud.kms.v1.ListCryptoKeysRequest.page_token] to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [CryptoKeys][google.cloud.kms.v1.CryptoKey] that matched the query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeysResponse) Reset()         { *m = ListCryptoKeysResponse{} }
func (m *ListCryptoKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeysResponse) ProtoMessage()    {}
func (*ListCryptoKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{5}
}

func (m *ListCryptoKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeysResponse.Unmarshal(m, b)
}
func (m *ListCryptoKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListCryptoKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeysResponse.Merge(m, src)
}
func (m *ListCryptoKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeysResponse.Size(m)
}
func (m *ListCryptoKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeysResponse proto.InternalMessageInfo

func (m *ListCryptoKeysResponse) GetCryptoKeys() []*CryptoKey {
	if m != nil {
		return m.CryptoKeys
	}
	return nil
}

func (m *ListCryptoKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListCryptoKeysResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Response message for [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions].
type ListCryptoKeyVersionsResponse struct {
	// The list of [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	CryptoKeyVersions []*CryptoKeyVersion `protobuf:"bytes,1,rep,name=crypto_key_versions,json=cryptoKeyVersions,proto3" json:"crypto_key_versions,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListCryptoKeyVersionsRequest.page_token][google.cloud.kms.v1.ListCryptoKeyVersionsRequest.page_token] to retrieve the next page of
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] that matched the
	// query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeyVersionsResponse) Reset()         { *m = ListCryptoKeyVersionsResponse{} }
func (m *ListCryptoKeyVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeyVersionsResponse) ProtoMessage()    {}
func (*ListCryptoKeyVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{6}
}

func (m *ListCryptoKeyVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeyVersionsResponse.Unmarshal(m, b)
}
func (m *ListCryptoKeyVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeyVersionsResponse.Marshal(b, m, deterministic)
}
func (m *ListCryptoKeyVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeyVersionsResponse.Merge(m, src)
}
func (m *ListCryptoKeyVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeyVersionsResponse.Size(m)
}
func (m *ListCryptoKeyVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeyVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeyVersionsResponse proto.InternalMessageInfo

func (m *ListCryptoKeyVersionsResponse) GetCryptoKeyVersions() []*CryptoKeyVersion {
	if m != nil {
		return m.CryptoKeyVersions
	}
	return nil
}

func (m *ListCryptoKeyVersionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListCryptoKeyVersionsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Response message for [KeyManagementService.ListImportJobs][google.cloud.kms.v1.KeyManagementService.ListImportJobs].
type ListImportJobsResponse struct {
	// The list of [ImportJobs][google.cloud.kms.v1.ImportJob].
	ImportJobs []*ImportJob `protobuf:"bytes,1,rep,name=import_jobs,json=importJobs,proto3" json:"import_jobs,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListImportJobsRequest.page_token][google.cloud.kms.v1.ListImportJobsRequest.page_token] to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [ImportJobs][google.cloud.kms.v1.ImportJob] that matched the query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListImportJobsResponse) Reset()         { *m = ListImportJobsResponse{} }
func (m *ListImportJobsResponse) String() string { return proto.CompactTextString(m) }
func (*ListImportJobsResponse) ProtoMessage()    {}
func (*ListImportJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{7}
}

func (m *ListImportJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListImportJobsResponse.Unmarshal(m, b)
}
func (m *ListImportJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListImportJobsResponse.Marshal(b, m, deterministic)
}
func (m *ListImportJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImportJobsResponse.Merge(m, src)
}
func (m *ListImportJobsResponse) XXX_Size() int {
	return xxx_messageInfo_ListImportJobsResponse.Size(m)
}
func (m *ListImportJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImportJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListImportJobsResponse proto.InternalMessageInfo

func (m *ListImportJobsResponse) GetImportJobs() []*ImportJob {
	if m != nil {
		return m.ImportJobs
	}
	return nil
}

func (m *ListImportJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListImportJobsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for [KeyManagementService.GetKeyRing][google.cloud.kms.v1.KeyManagementService.GetKeyRing].
type GetKeyRingRequest struct {
	// The [name][google.cloud.kms.v1.KeyRing.name] of the [KeyRing][google.cloud.kms.v1.KeyRing] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetKeyRingRequest) Reset()         { *m = GetKeyRingRequest{} }
func (m *GetKeyRingRequest) String() string { return proto.CompactTextString(m) }
func (*GetKeyRingRequest) ProtoMessage()    {}
func (*GetKeyRingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{8}
}

func (m *GetKeyRingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetKeyRingRequest.Unmarshal(m, b)
}
func (m *GetKeyRingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetKeyRingRequest.Marshal(b, m, deterministic)
}
func (m *GetKeyRingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetKeyRingRequest.Merge(m, src)
}
func (m *GetKeyRingRequest) XXX_Size() int {
	return xxx_messageInfo_GetKeyRingRequest.Size(m)
}
func (m *GetKeyRingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetKeyRingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetKeyRingRequest proto.InternalMessageInfo

func (m *GetKeyRingRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.GetCryptoKey][google.cloud.kms.v1.KeyManagementService.GetCryptoKey].
type GetCryptoKeyRequest struct {
	// The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCryptoKeyRequest) Reset()         { *m = GetCryptoKeyRequest{} }
func (m *GetCryptoKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetCryptoKeyRequest) ProtoMessage()    {}
func (*GetCryptoKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{9}
}

func (m *GetCryptoKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCryptoKeyRequest.Unmarshal(m, b)
}
func (m *GetCryptoKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCryptoKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetCryptoKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCryptoKeyRequest.Merge(m, src)
}
func (m *GetCryptoKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetCryptoKeyRequest.Size(m)
}
func (m *GetCryptoKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCryptoKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCryptoKeyRequest proto.InternalMessageInfo

func (m *GetCryptoKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.GetCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.GetCryptoKeyVersion].
type GetCryptoKeyVersionRequest struct {
	// The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCryptoKeyVersionRequest) Reset()         { *m = GetCryptoKeyVersionRequest{} }
func (m *GetCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*GetCryptoKeyVersionRequest) ProtoMessage()    {}
func (*GetCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{10}
}

func (m *GetCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *GetCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *GetCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCryptoKeyVersionRequest.Merge(m, src)
}
func (m *GetCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_GetCryptoKeyVersionRequest.Size(m)
}
func (m *GetCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *GetCryptoKeyVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
type GetPublicKeyRequest struct {
	// The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key to
	// get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetPublicKeyRequest) Reset()         { *m = GetPublicKeyRequest{} }
func (m *GetPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetPublicKeyRequest) ProtoMessage()    {}
func (*GetPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{11}
}

func (m *GetPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPublicKeyRequest.Unmarshal(m, b)
}
func (m *GetPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPublicKeyRequest.Merge(m, src)
}
func (m *GetPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetPublicKeyRequest.Size(m)
}
func (m *GetPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPublicKeyRequest proto.InternalMessageInfo

func (m *GetPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.GetImportJob][google.cloud.kms.v1.KeyManagementService.GetImportJob].
type GetImportJobRequest struct {
	// The [name][google.cloud.kms.v1.ImportJob.name] of the [ImportJob][google.cloud.kms.v1.ImportJob] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetImportJobRequest) Reset()         { *m = GetImportJobRequest{} }
func (m *GetImportJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetImportJobRequest) ProtoMessage()    {}
func (*GetImportJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{12}
}

func (m *GetImportJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetImportJobRequest.Unmarshal(m, b)
}
func (m *GetImportJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetImportJobRequest.Marshal(b, m, deterministic)
}
func (m *GetImportJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetImportJobRequest.Merge(m, src)
}
func (m *GetImportJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetImportJobRequest.Size(m)
}
func (m *GetImportJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetImportJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetImportJobRequest proto.InternalMessageInfo

func (m *GetImportJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.CreateKeyRing][google.cloud.kms.v1.KeyManagementService.CreateKeyRing].
type CreateKeyRingRequest struct {
	// Required. The resource name of the location associated with the
	// [KeyRings][google.cloud.kms.v1.KeyRing], in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. It must be unique within a location and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`
	KeyRingId string `protobuf:"bytes,2,opt,name=key_ring_id,json=keyRingId,proto3" json:"key_ring_id,omitempty"`
	// A [KeyRing][google.cloud.kms.v1.KeyRing] with initial field values.
	KeyRing              *KeyRing `protobuf:"bytes,3,opt,name=key_ring,json=keyRing,proto3" json:"key_ring,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateKeyRingRequest) Reset()         { *m = CreateKeyRingRequest{} }
func (m *CreateKeyRingRequest) String() string { return proto.CompactTextString(m) }
func (*CreateKeyRingRequest) ProtoMessage()    {}
func (*CreateKeyRingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{13}
}

func (m *CreateKeyRingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateKeyRingRequest.Unmarshal(m, b)
}
func (m *CreateKeyRingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateKeyRingRequest.Marshal(b, m, deterministic)
}
func (m *CreateKeyRingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateKeyRingRequest.Merge(m, src)
}
func (m *CreateKeyRingRequest) XXX_Size() int {
	return xxx_messageInfo_CreateKeyRingRequest.Size(m)
}
func (m *CreateKeyRingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateKeyRingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateKeyRingRequest proto.InternalMessageInfo

func (m *CreateKeyRingRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateKeyRingRequest) GetKeyRingId() string {
	if m != nil {
		return m.KeyRingId
	}
	return ""
}

func (m *CreateKeyRingRequest) GetKeyRing() *KeyRing {
	if m != nil {
		return m.KeyRing
	}
	return nil
}

// Request message for [KeyManagementService.CreateCryptoKey][google.cloud.kms.v1.KeyManagementService.CreateCryptoKey].
type CreateCryptoKeyRequest struct {
	// Required. The [name][google.cloud.kms.v1.KeyRing.name] of the KeyRing associated with the
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. It must be unique within a KeyRing and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`
	CryptoKeyId string `protobuf:"bytes,2,opt,name=crypto_key_id,json=cryptoKeyId,proto3" json:"crypto_key_id,omitempty"`
	// A [CryptoKey][google.cloud.kms.v1.CryptoKey] with initial field values.
	CryptoKey *CryptoKey `protobuf:"bytes,3,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	// If set to true, the request will create a [CryptoKey][google.cloud.kms.v1.CryptoKey] without any
	// [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion]. You must manually call
	// [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion] or
	// [ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion]
	// before you can use this [CryptoKey][google.cloud.kms.v1.CryptoKey].
	SkipInitialVersionCreation bool     `protobuf:"varint,5,opt,name=skip_initial_version_creation,json=skipInitialVersionCreation,proto3" json:"skip_initial_version_creation,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *CreateCryptoKeyRequest) Reset()         { *m = CreateCryptoKeyRequest{} }
func (m *CreateCryptoKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateCryptoKeyRequest) ProtoMessage()    {}
func (*CreateCryptoKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{14}
}

func (m *CreateCryptoKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateCryptoKeyRequest.Unmarshal(m, b)
}
func (m *CreateCryptoKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateCryptoKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateCryptoKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateCryptoKeyRequest.Merge(m, src)
}
func (m *CreateCryptoKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateCryptoKeyRequest.Size(m)
}
func (m *CreateCryptoKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateCryptoKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateCryptoKeyRequest proto.InternalMessageInfo

func (m *CreateCryptoKeyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateCryptoKeyRequest) GetCryptoKeyId() string {
	if m != nil {
		return m.CryptoKeyId
	}
	return ""
}

func (m *CreateCryptoKeyRequest) GetCryptoKey() *CryptoKey {
	if m != nil {
		return m.CryptoKey
	}
	return nil
}

func (m *CreateCryptoKeyRequest) GetSkipInitialVersionCreation() bool {
	if m != nil {
		return m.SkipInitialVersionCreation
	}
	return false
}

// Request message for [KeyManagementService.CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion].
type CreateCryptoKeyVersionRequest struct {
	// Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with
	// the [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with initial field values.
	CryptoKeyVersion     *CryptoKeyVersion `protobuf:"bytes,2,opt,name=crypto_key_version,json=cryptoKeyVersion,proto3" json:"crypto_key_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateCryptoKeyVersionRequest) Reset()         { *m = CreateCryptoKeyVersionRequest{} }
func (m *CreateCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateCryptoKeyVersionRequest) ProtoMessage()    {}
func (*CreateCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{15}
}

func (m *CreateCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *CreateCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *CreateCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateCryptoKeyVersionRequest.Merge(m, src)
}
func (m *CreateCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateCryptoKeyVersionRequest.Size(m)
}
func (m *CreateCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *CreateCryptoKeyVersionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateCryptoKeyVersionRequest) GetCryptoKeyVersion() *CryptoKeyVersion {
	if m != nil {
		return m.CryptoKeyVersion
	}
	return nil
}

// Request message for [KeyManagementService.ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
type ImportCryptoKeyVersionRequest struct {
	// Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to
	// be imported into.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm] of
	// the key being imported. This does not need to match the
	// [version_template][google.cloud.kms.v1.CryptoKey.version_template] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] this
	// version imports into.
	Algorithm CryptoKeyVersion_CryptoKeyVersionAlgorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionAlgorithm" json:"algorithm,omitempty"`
	// Required. The [name][google.cloud.kms.v1.ImportJob.name] of the [ImportJob][google.cloud.kms.v1.ImportJob] that was used to
	// wrap this key material.
	ImportJob string `protobuf:"bytes,4,opt,name=import_job,json=importJob,proto3" json:"import_job,omitempty"`
	// Required. The incoming wrapped key material that is to be imported.
	//
	// Types that are valid to be assigned to WrappedKeyMaterial:
	//	*ImportCryptoKeyVersionRequest_RsaAesWrappedKey
	WrappedKeyMaterial   isImportCryptoKeyVersionRequest_WrappedKeyMaterial `protobuf_oneof:"wrapped_key_material"`
	XXX_NoUnkeyedLiteral struct{}                                           `json:"-"`
	XXX_unrecognized     []byte                                             `json:"-"`
	XXX_sizecache        int32                                              `json:"-"`
}

func (m *ImportCryptoKeyVersionRequest) Reset()         { *m = ImportCryptoKeyVersionRequest{} }
func (m *ImportCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*ImportCryptoKeyVersionRequest) ProtoMessage()    {}
func (*ImportCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{16}
}

func (m *ImportCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *ImportCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *ImportCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportCryptoKeyVersionRequest.Merge(m, src)
}
func (m *ImportCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_ImportCryptoKeyVersionRequest.Size(m)
}
func (m *ImportCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *ImportCryptoKeyVersionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ImportCryptoKeyVersionRequest) GetAlgorithm() CryptoKeyVersion_CryptoKeyVersionAlgorithm {
	if m != nil {
		return m.Algorithm
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
}

func (m *ImportCryptoKeyVersionRequest) GetImportJob() string {
	if m != nil {
		return m.ImportJob
	}
	return ""
}

type isImportCryptoKeyVersionRequest_WrappedKeyMaterial interface {
	isImportCryptoKeyVersionRequest_WrappedKeyMaterial()
}

type ImportCryptoKeyVersionRequest_RsaAesWrappedKey struct {
	RsaAesWrappedKey []byte `protobuf:"bytes,5,opt,name=rsa_aes_wrapped_key,json=rsaAesWrappedKey,proto3,oneof"`
}

func (*ImportCryptoKeyVersionRequest_RsaAesWrappedKey) isImportCryptoKeyVersionRequest_WrappedKeyMaterial() {
}

func (m *ImportCryptoKeyVersionRequest) GetWrappedKeyMaterial() isImportCryptoKeyVersionRequest_WrappedKeyMaterial {
	if m != nil {
		return m.WrappedKeyMaterial
	}
	return nil
}

func (m *ImportCryptoKeyVersionRequest) GetRsaAesWrappedKey() []byte {
	if x, ok := m.GetWrappedKeyMaterial().(*ImportCryptoKeyVersionRequest_RsaAesWrappedKey); ok {
		return x.RsaAesWrappedKey
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImportCryptoKeyVersionRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImportCryptoKeyVersionRequest_RsaAesWrappedKey)(nil),
	}
}

// Request message for [KeyManagementService.CreateImportJob][google.cloud.kms.v1.KeyManagementService.CreateImportJob].
type CreateImportJobRequest struct {
	// Required. The [name][google.cloud.kms.v1.KeyRing.name] of the [KeyRing][google.cloud.kms.v1.KeyRing] associated with the
	// [ImportJobs][google.cloud.kms.v1.ImportJob].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. It must be unique within a KeyRing and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`
	ImportJobId string `protobuf:"bytes,2,opt,name=import_job_id,json=importJobId,proto3" json:"import_job_id,omitempty"`
	// Required. An [ImportJob][google.cloud.kms.v1.ImportJob] with initial field values.
	ImportJob            *ImportJob `protobuf:"bytes,3,opt,name=import_job,json=importJob,proto3" json:"import_job,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CreateImportJobRequest) Reset()         { *m = CreateImportJobRequest{} }
func (m *CreateImportJobRequest) String() string { return proto.CompactTextString(m) }
func (*CreateImportJobRequest) ProtoMessage()    {}
func (*CreateImportJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{17}
}

func (m *CreateImportJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateImportJobRequest.Unmarshal(m, b)
}
func (m *CreateImportJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateImportJobRequest.Marshal(b, m, deterministic)
}
func (m *CreateImportJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateImportJobRequest.Merge(m, src)
}
func (m *CreateImportJobRequest) XXX_Size() int {
	return xxx_messageInfo_CreateImportJobRequest.Size(m)
}
func (m *CreateImportJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateImportJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateImportJobRequest proto.InternalMessageInfo

func (m *CreateImportJobRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateImportJobRequest) GetImportJobId() string {
	if m != nil {
		return m.ImportJobId
	}
	return ""
}

func (m *CreateImportJobRequest) GetImportJob() *ImportJob {
	if m != nil {
		return m.ImportJob
	}
	return nil
}

// Request message for [KeyManagementService.UpdateCryptoKey][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKey].
type UpdateCryptoKeyRequest struct {
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] with updated values.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	// Required list of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateCryptoKeyRequest) Reset()         { *m = UpdateCryptoKeyRequest{} }
func (m *UpdateCryptoKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCryptoKeyRequest) ProtoMessage()    {}
func (*UpdateCryptoKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{18}
}

func (m *UpdateCryptoKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCryptoKeyRequest.Unmarshal(m, b)
}
func (m *UpdateCryptoKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCryptoKeyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateCryptoKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCryptoKeyRequest.Merge(m, src)
}
func (m *UpdateCryptoKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCryptoKeyRequest.Size(m)
}
func (m *UpdateCryptoKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCryptoKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCryptoKeyRequest proto.InternalMessageInfo

func (m *UpdateCryptoKeyRequest) GetCryptoKey() *CryptoKey {
	if m != nil {
		return m.CryptoKey
	}
	return nil
}

func (m *UpdateCryptoKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [KeyManagementService.UpdateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyVersion].
type UpdateCryptoKeyVersionRequest struct {
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with updated values.
	CryptoKeyVersion *CryptoKeyVersion `protobuf:"bytes,1,opt,name=crypto_key_version,json=cryptoKeyVersion,proto3" json:"crypto_key_version,omitempty"`
	// Required list of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateCryptoKeyVersionRequest) Reset()         { *m = UpdateCryptoKeyVersionRequest{} }
func (m *UpdateCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCryptoKeyVersionRequest) ProtoMessage()    {}
func (*UpdateCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{19}
}

func (m *UpdateCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCryptoKeyVersionRequest.Merge(m, src)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCryptoKeyVersionRequest.Size(m)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *UpdateCryptoKeyVersionRequest) GetCryptoKeyVersion() *CryptoKeyVersion {
	if m != nil {
		return m.CryptoKeyVersion
	}
	return nil
}

func (m *UpdateCryptoKeyVersionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
type EncryptRequest struct {
	// Required. The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] or [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// to use for encryption.
	//
	// If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server will use its
	// [primary version][google.cloud.kms.v1.CryptoKey.primary].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The data to encrypt. Must be no larger than 64KiB.
	//
	// The maximum size depends on the key version's
	// [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level]. For
	// [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE] keys, the plaintext must be no larger
	// than 64KiB. For [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of the
	// plaintext and additional_authenticated_data fields must be no larger than
	// 8KiB.
	Plaintext []byte `protobuf:"bytes,2,opt,name=plaintext,proto3" json:"plaintext,omitempty"`
	// Optional data that, if specified, must also be provided during decryption
	// through [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
	//
	// The maximum size depends on the key version's
	// [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level]. For
	// [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE] keys, the AAD must be no larger than
	// 64KiB. For [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of the
	// plaintext and additional_authenticated_data fields must be no larger than
	// 8KiB.
	AdditionalAuthenticatedData []byte   `protobuf:"bytes,3,opt,name=additional_authenticated_data,json=additionalAuthenticatedData,proto3" json:"additional_authenticated_data,omitempty"`
	XXX_NoUnkeyedLiteral        struct{} `json:"-"`
	XXX_unrecognized            []byte   `json:"-"`
	XXX_sizecache               int32    `json:"-"`
}

func (m *EncryptRequest) Reset()         { *m = EncryptRequest{} }
func (m *EncryptRequest) String() string { return proto.CompactTextString(m) }
func (*EncryptRequest) ProtoMessage()    {}
func (*EncryptRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{20}
}

func (m *EncryptRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptRequest.Unmarshal(m, b)
}
func (m *EncryptRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptRequest.Marshal(b, m, deterministic)
}
func (m *EncryptRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptRequest.Merge(m, src)
}
func (m *EncryptRequest) XXX_Size() int {
	return xxx_messageInfo_EncryptRequest.Size(m)
}
func (m *EncryptRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptRequest proto.InternalMessageInfo

func (m *EncryptRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EncryptRequest) GetPlaintext() []byte {
	if m != nil {
		return m.Plaintext
	}
	return nil
}

func (m *EncryptRequest) GetAdditionalAuthenticatedData() []byte {
	if m != nil {
		return m.AdditionalAuthenticatedData
	}
	return nil
}

// Request message for [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
type DecryptRequest struct {
	// Required. The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption.
	// The server will choose the appropriate version.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The encrypted data originally returned in
	// [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
	Ciphertext []byte `protobuf:"bytes,2,opt,name=ciphertext,proto3" json:"ciphertext,omitempty"`
	// Optional data that must match the data originally supplied in
	// [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
	AdditionalAuthenticatedData []byte   `protobuf:"bytes,3,opt,name=additional_authenticated_data,json=additionalAuthenticatedData,proto3" json:"additional_authenticated_data,omitempty"`
	XXX_NoUnkeyedLiteral        struct{} `json:"-"`
	XXX_unrecognized            []byte   `json:"-"`
	XXX_sizecache               int32    `json:"-"`
}

func (m *DecryptRequest) Reset()         { *m = DecryptRequest{} }
func (m *DecryptRequest) String() string { return proto.CompactTextString(m) }
func (*DecryptRequest) ProtoMessage()    {}
func (*DecryptRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{21}
}

func (m *DecryptRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DecryptRequest.Unmarshal(m, b)
}
func (m *DecryptRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DecryptRequest.Marshal(b, m, deterministic)
}
func (m *DecryptRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DecryptRequest.Merge(m, src)
}
func (m *DecryptRequest) XXX_Size() int {
	return xxx_messageInfo_DecryptRequest.Size(m)
}
func (m *DecryptRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DecryptRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DecryptRequest proto.InternalMessageInfo

func (m *DecryptRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DecryptRequest) GetCiphertext() []byte {
	if m != nil {
		return m.Ciphertext
	}
	return nil
}

func (m *DecryptRequest) GetAdditionalAuthenticatedData() []byte {
	if m != nil {
		return m.AdditionalAuthenticatedData
	}
	return nil
}

// Request message for [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
type AsymmetricSignRequest struct {
	// Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for signing.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The digest of the data to sign. The digest must be produced with
	// the same digest algorithm as specified by the key version's
	// [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
	Digest               *Digest  `protobuf:"bytes,3,opt,name=digest,proto3" json:"digest,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AsymmetricSignRequest) Reset()         { *m = AsymmetricSignRequest{} }
func (m *AsymmetricSignRequest) String() string { return proto.CompactTextString(m) }
func (*AsymmetricSignRequest) ProtoMessage()    {}
func (*AsymmetricSignRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{22}
}

func (m *AsymmetricSignRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsymmetricSignRequest.Unmarshal(m, b)
}
func (m *AsymmetricSignRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsymmetricSignRequest.Marshal(b, m, deterministic)
}
func (m *AsymmetricSignRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsymmetricSignRequest.Merge(m, src)
}
func (m *AsymmetricSignRequest) XXX_Size() int {
	return xxx_messageInfo_AsymmetricSignRequest.Size(m)
}
func (m *AsymmetricSignRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AsymmetricSignRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AsymmetricSignRequest proto.InternalMessageInfo

func (m *AsymmetricSignRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AsymmetricSignRequest) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

// Request message for [KeyManagementService.AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt].
type AsymmetricDecryptRequest struct {
	// Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
	// decryption.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The data encrypted with the named [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s public
	// key using OAEP.
	Ciphertext           []byte   `protobuf:"bytes,3,opt,name=ciphertext,proto3" json:"ciphertext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AsymmetricDecryptRequest) Reset()         { *m = AsymmetricDecryptRequest{} }
func (m *AsymmetricDecryptRequest) String() string { return proto.CompactTextString(m) }
func (*AsymmetricDecryptRequest) ProtoMessage()    {}
func (*AsymmetricDecryptRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{23}
}

func (m *AsymmetricDecryptRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsymmetricDecryptRequest.Unmarshal(m, b)
}
func (m *AsymmetricDecryptRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsymmetricDecryptRequest.Marshal(b, m, deterministic)
}
func (m *AsymmetricDecryptRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsymmetricDecryptRequest.Merge(m, src)
}
func (m *AsymmetricDecryptRequest) XXX_Size() int {
	return xxx_messageInfo_AsymmetricDecryptRequest.Size(m)
}
func (m *AsymmetricDecryptRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AsymmetricDecryptRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AsymmetricDecryptRequest proto.InternalMessageInfo

func (m *AsymmetricDecryptRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AsymmetricDecryptRequest) GetCiphertext() []byte {
	if m != nil {
		return m.Ciphertext
	}
	return nil
}

// Response message for [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
type DecryptResponse struct {
	// The decrypted data originally supplied in [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
	Plaintext            []byte   `protobuf:"bytes,1,opt,name=plaintext,proto3" json:"plaintext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DecryptResponse) Reset()         { *m = DecryptResponse{} }
func (m *DecryptResponse) String() string { return proto.CompactTextString(m) }
func (*DecryptResponse) ProtoMessage()    {}
func (*DecryptResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{24}
}

func (m *DecryptResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DecryptResponse.Unmarshal(m, b)
}
func (m *DecryptResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DecryptResponse.Marshal(b, m, deterministic)
}
func (m *DecryptResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DecryptResponse.Merge(m, src)
}
func (m *DecryptResponse) XXX_Size() int {
	return xxx_messageInfo_DecryptResponse.Size(m)
}
func (m *DecryptResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DecryptResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DecryptResponse proto.InternalMessageInfo

func (m *DecryptResponse) GetPlaintext() []byte {
	if m != nil {
		return m.Plaintext
	}
	return nil
}

// Response message for [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
type EncryptResponse struct {
	// The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in encryption.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The encrypted data.
	Ciphertext           []byte   `protobuf:"bytes,2,opt,name=ciphertext,proto3" json:"ciphertext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptResponse) Reset()         { *m = EncryptResponse{} }
func (m *EncryptResponse) String() string { return proto.CompactTextString(m) }
func (*EncryptResponse) ProtoMessage()    {}
func (*EncryptResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{25}
}

func (m *EncryptResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptResponse.Unmarshal(m, b)
}
func (m *EncryptResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptResponse.Marshal(b, m, deterministic)
}
func (m *EncryptResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptResponse.Merge(m, src)
}
func (m *EncryptResponse) XXX_Size() int {
	return xxx_messageInfo_EncryptResponse.Size(m)
}
func (m *EncryptResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptResponse proto.InternalMessageInfo

func (m *EncryptResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EncryptResponse) GetCiphertext() []byte {
	if m != nil {
		return m.Ciphertext
	}
	return nil
}

// Response message for [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
type AsymmetricSignResponse struct {
	// The created signature.
	Signature            []byte   `protobuf:"bytes,1,opt,name=signature,proto3" json:"signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AsymmetricSignResponse) Reset()         { *m = AsymmetricSignResponse{} }
func (m *AsymmetricSignResponse) String() string { return proto.CompactTextString(m) }
func (*AsymmetricSignResponse) ProtoMessage()    {}
func (*AsymmetricSignResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{26}
}

func (m *AsymmetricSignResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsymmetricSignResponse.Unmarshal(m, b)
}
func (m *AsymmetricSignResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsymmetricSignResponse.Marshal(b, m, deterministic)
}
func (m *AsymmetricSignResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsymmetricSignResponse.Merge(m, src)
}
func (m *AsymmetricSignResponse) XXX_Size() int {
	return xxx_messageInfo_AsymmetricSignResponse.Size(m)
}
func (m *AsymmetricSignResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AsymmetricSignResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AsymmetricSignResponse proto.InternalMessageInfo

func (m *AsymmetricSignResponse) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

// Response message for [KeyManagementService.AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt].
type AsymmetricDecryptResponse struct {
	// The decrypted data originally encrypted with the matching public key.
	Plaintext            []byte   `protobuf:"bytes,1,opt,name=plaintext,proto3" json:"plaintext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AsymmetricDecryptResponse) Reset()         { *m = AsymmetricDecryptResponse{} }
func (m *AsymmetricDecryptResponse) String() string { return proto.CompactTextString(m) }
func (*AsymmetricDecryptResponse) ProtoMessage()    {}
func (*AsymmetricDecryptResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{27}
}

func (m *AsymmetricDecryptResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsymmetricDecryptResponse.Unmarshal(m, b)
}
func (m *AsymmetricDecryptResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsymmetricDecryptResponse.Marshal(b, m, deterministic)
}
func (m *AsymmetricDecryptResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsymmetricDecryptResponse.Merge(m, src)
}
func (m *AsymmetricDecryptResponse) XXX_Size() int {
	return xxx_messageInfo_AsymmetricDecryptResponse.Size(m)
}
func (m *AsymmetricDecryptResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AsymmetricDecryptResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AsymmetricDecryptResponse proto.InternalMessageInfo

func (m *AsymmetricDecryptResponse) GetPlaintext() []byte {
	if m != nil {
		return m.Plaintext
	}
	return nil
}

// Request message for [KeyManagementService.UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
type UpdateCryptoKeyPrimaryVersionRequest struct {
	// The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The id of the child [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use as primary.
	CryptoKeyVersionId   string   `protobuf:"bytes,2,opt,name=crypto_key_version_id,json=cryptoKeyVersionId,proto3" json:"crypto_key_version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateCryptoKeyPrimaryVersionRequest) Reset()         { *m = UpdateCryptoKeyPrimaryVersionRequest{} }
func (m *UpdateCryptoKeyPrimaryVersionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCryptoKeyPrimaryVersionRequest) ProtoMessage()    {}
func (*UpdateCryptoKeyPrimaryVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{28}
}

func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Unmarshal(m, b)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Merge(m, src)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Size(m)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest proto.InternalMessageInfo

func (m *UpdateCryptoKeyPrimaryVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateCryptoKeyPrimaryVersionRequest) GetCryptoKeyVersionId() string {
	if m != nil {
		return m.CryptoKeyVersionId
	}
	return ""
}

// Request message for [KeyManagementService.DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion].
type DestroyCryptoKeyVersionRequest struct {
	// The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to destroy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DestroyCryptoKeyVersionRequest) Reset()         { *m = DestroyCryptoKeyVersionRequest{} }
func (m *DestroyCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*DestroyCryptoKeyVersionRequest) ProtoMessage()    {}
func (*DestroyCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{29}
}

func (m *DestroyCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DestroyCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DestroyCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DestroyCryptoKeyVersionRequest.Merge(m, src)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_DestroyCryptoKeyVersionRequest.Size(m)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DestroyCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DestroyCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *DestroyCryptoKeyVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion].
type RestoreCryptoKeyVersionRequest struct {
	// The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to restore.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreCryptoKeyVersionRequest) Reset()         { *m = RestoreCryptoKeyVersionRequest{} }
func (m *RestoreCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreCryptoKeyVersionRequest) ProtoMessage()    {}
func (*RestoreCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{30}
}

func (m *RestoreCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreCryptoKeyVersionRequest.Merge(m, src)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreCryptoKeyVersionRequest.Size(m)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *RestoreCryptoKeyVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A [Digest][google.cloud.kms.v1.Digest] holds a cryptographic message digest.
type Digest struct {
	// Required. The message digest.
	//
	// Types that are valid to be assigned to Digest:
	//	*Digest_Sha256
	//	*Digest_Sha384
	//	*Digest_Sha512
	Digest               isDigest_Digest `protobuf_oneof:"digest"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Digest) Reset()         { *m = Digest{} }
func (m *Digest) String() string { return proto.CompactTextString(m) }
func (*Digest) ProtoMessage()    {}
func (*Digest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{31}
}

func (m *Digest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Digest.Unmarshal(m, b)
}
func (m *Digest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Digest.Marshal(b, m, deterministic)
}
func (m *Digest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Digest.Merge(m, src)
}
func (m *Digest) XXX_Size() int {
	return xxx_messageInfo_Digest.Size(m)
}
func (m *Digest) XXX_DiscardUnknown() {
	xxx_messageInfo_Digest.DiscardUnknown(m)
}

var xxx_messageInfo_Digest proto.InternalMessageInfo

type isDigest_Digest interface {
	isDigest_Digest()
}

type Digest_Sha256 struct {
	Sha256 []byte `protobuf:"bytes,1,opt,name=sha256,proto3,oneof"`
}

type Digest_Sha384 struct {
	Sha384 []byte `protobuf:"bytes,2,opt,name=sha384,proto3,oneof"`
}

type Digest_Sha512 struct {
	Sha512 []byte `protobuf:"bytes,3,opt,name=sha512,proto3,oneof"`
}

func (*Digest_Sha256) isDigest_Digest() {}

func (*Digest_Sha384) isDigest_Digest() {}

func (*Digest_Sha512) isDigest_Digest() {}

func (m *Digest) GetDigest() isDigest_Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

func (m *Digest) GetSha256() []byte {
	if x, ok := m.GetDigest().(*Digest_Sha256); ok {
		return x.Sha256
	}
	return nil
}

func (m *Digest) GetSha384() []byte {
	if x, ok := m.GetDigest().(*Digest_Sha384); ok {
		return x.Sha384
	}
	return nil
}

func (m *Digest) GetSha512() []byte {
	if x, ok := m.GetDigest().(*Digest_Sha512); ok {
		return x.Sha512
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Digest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Digest_Sha256)(nil),
		(*Digest_Sha384)(nil),
		(*Digest_Sha512)(nil),
	}
}

// Cloud KMS metadata for the given [google.cloud.location.Location][google.cloud.location.Location].
type LocationMetadata struct {
	// Indicates whether [CryptoKeys][google.cloud.kms.v1.CryptoKey] with
	// [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level]
	// [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] can be created in this location.
	HsmAvailable         bool     `protobuf:"varint,1,opt,name=hsm_available,json=hsmAvailable,proto3" json:"hsm_available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LocationMetadata) Reset()         { *m = LocationMetadata{} }
func (m *LocationMetadata) String() string { return proto.CompactTextString(m) }
func (*LocationMetadata) ProtoMessage()    {}
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{32}
}

func (m *LocationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationMetadata.Unmarshal(m, b)
}
func (m *LocationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationMetadata.Marshal(b, m, deterministic)
}
func (m *LocationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationMetadata.Merge(m, src)
}
func (m *LocationMetadata) XXX_Size() int {
	return xxx_messageInfo_LocationMetadata.Size(m)
}
func (m *LocationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LocationMetadata proto.InternalMessageInfo

func (m *LocationMetadata) GetHsmAvailable() bool {
	if m != nil {
		return m.HsmAvailable
	}
	return false
}

func init() {
	proto.RegisterType((*ListKeyRingsRequest)(nil), "google.cloud.kms.v1.ListKeyRingsRequest")
	proto.RegisterType((*ListCryptoKeysRequest)(nil), "google.cloud.kms.v1.ListCryptoKeysRequest")
	proto.RegisterType((*ListCryptoKeyVersionsRequest)(nil), "google.cloud.kms.v1.ListCryptoKeyVersionsRequest")
	proto.RegisterType((*ListImportJobsRequest)(nil), "google.cloud.kms.v1.ListImportJobsRequest")
	proto.RegisterType((*ListKeyRingsResponse)(nil), "google.cloud.kms.v1.ListKeyRingsResponse")
	proto.RegisterType((*ListCryptoKeysResponse)(nil), "google.cloud.kms.v1.ListCryptoKeysResponse")
	proto.RegisterType((*ListCryptoKeyVersionsResponse)(nil), "google.cloud.kms.v1.ListCryptoKeyVersionsResponse")
	proto.RegisterType((*ListImportJobsResponse)(nil), "google.cloud.kms.v1.ListImportJobsResponse")
	proto.RegisterType((*GetKeyRingRequest)(nil), "google.cloud.kms.v1.GetKeyRingRequest")
	proto.RegisterType((*GetCryptoKeyRequest)(nil), "google.cloud.kms.v1.GetCryptoKeyRequest")
	proto.RegisterType((*GetCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.GetCryptoKeyVersionRequest")
	proto.RegisterType((*GetPublicKeyRequest)(nil), "google.cloud.kms.v1.GetPublicKeyRequest")
	proto.RegisterType((*GetImportJobRequest)(nil), "google.cloud.kms.v1.GetImportJobRequest")
	proto.RegisterType((*CreateKeyRingRequest)(nil), "google.cloud.kms.v1.CreateKeyRingRequest")
	proto.RegisterType((*CreateCryptoKeyRequest)(nil), "google.cloud.kms.v1.CreateCryptoKeyRequest")
	proto.RegisterType((*CreateCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.CreateCryptoKeyVersionRequest")
	proto.RegisterType((*ImportCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.ImportCryptoKeyVersionRequest")
	proto.RegisterType((*CreateImportJobRequest)(nil), "google.cloud.kms.v1.CreateImportJobRequest")
	proto.RegisterType((*UpdateCryptoKeyRequest)(nil), "google.cloud.kms.v1.UpdateCryptoKeyRequest")
	proto.RegisterType((*UpdateCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.UpdateCryptoKeyVersionRequest")
	proto.RegisterType((*EncryptRequest)(nil), "google.cloud.kms.v1.EncryptRequest")
	proto.RegisterType((*DecryptRequest)(nil), "google.cloud.kms.v1.DecryptRequest")
	proto.RegisterType((*AsymmetricSignRequest)(nil), "google.cloud.kms.v1.AsymmetricSignRequest")
	proto.RegisterType((*AsymmetricDecryptRequest)(nil), "google.cloud.kms.v1.AsymmetricDecryptRequest")
	proto.RegisterType((*DecryptResponse)(nil), "google.cloud.kms.v1.DecryptResponse")
	proto.RegisterType((*EncryptResponse)(nil), "google.cloud.kms.v1.EncryptResponse")
	proto.RegisterType((*AsymmetricSignResponse)(nil), "google.cloud.kms.v1.AsymmetricSignResponse")
	proto.RegisterType((*AsymmetricDecryptResponse)(nil), "google.cloud.kms.v1.AsymmetricDecryptResponse")
	proto.RegisterType((*UpdateCryptoKeyPrimaryVersionRequest)(nil), "google.cloud.kms.v1.UpdateCryptoKeyPrimaryVersionRequest")
	proto.RegisterType((*DestroyCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.DestroyCryptoKeyVersionRequest")
	proto.RegisterType((*RestoreCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.RestoreCryptoKeyVersionRequest")
	proto.RegisterType((*Digest)(nil), "google.cloud.kms.v1.Digest")
	proto.RegisterType((*LocationMetadata)(nil), "google.cloud.kms.v1.LocationMetadata")
}

func init() { proto.RegisterFile("google/cloud/kms/v1/service.proto", fileDescriptor_723aeaeb61739a25) }

var fileDescriptor_723aeaeb61739a25 = []byte{
	// 2029 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xcd, 0x73, 0x1c, 0x47,
	0x15, 0x4f, 0xfb, 0x43, 0x96, 0x9e, 0x64, 0xc9, 0x6e, 0xd9, 0xb2, 0xb2, 0xb6, 0x54, 0x66, 0x1c,
	0x82, 0xad, 0x24, 0x3b, 0x68, 0x25, 0x3b, 0xf6, 0xba, 0x42, 0x6a, 0x65, 0x25, 0x8e, 0x90, 0x65,
	0x54, 0xa3, 0xd8, 0x26, 0x29, 0xa7, 0xc6, 0xad, 0xdd, 0xf6, 0x6a, 0xbc, 0x3b, 0x1f, 0x4c, 0xb7,
	0xa4, 0x6c, 0x20, 0x17, 0x0e, 0x90, 0x43, 0x6e, 0xa1, 0x8a, 0x50, 0x50, 0x14, 0x05, 0x37, 0x0a,
	0x0e, 0xdc, 0xe0, 0xc0, 0x8d, 0x53, 0x8e, 0x81, 0xc0, 0x2d, 0x27, 0xfe, 0x01, 0x0e, 0x54, 0x71,
	0x81, 0xa2, 0xa6, 0xa7, 0xe7, 0x73, 0x67, 0x66, 0x3f, 0xbc, 0x2e, 0xb8, 0x69, 0x7b, 0x5e, 0xbf,
	0xfe, 0xfd, 0xfa, 0xfd, 0x7e, 0x33, 0xfd, 0xba, 0x04, 0x5f, 0x69, 0xda, 0x76, 0xb3, 0x4d, 0xd5,
	0x7a, 0xdb, 0xde, 0x6f, 0xa8, 0x2d, 0x93, 0xa9, 0x07, 0xcb, 0x2a, 0xa3, 0xee, 0x81, 0x51, 0xa7,
	0x65, 0xc7, 0xb5, 0xb9, 0x8d, 0x67, 0xfd, 0x90, 0xb2, 0x08, 0x29, 0xb7, 0x4c, 0x56, 0x3e, 0x58,
	0x2e, 0x5d, 0x90, 0xf3, 0x88, 0x63, 0xa8, 0xc4, 0xb2, 0x6c, 0x4e, 0xb8, 0x61, 0x5b, 0xcc, 0x9f,
	0x52, 0xba, 0x94, 0x95, 0xd5, 0xa5, 0xcc, 0xde, 0x77, 0xeb, 0x34, 0x08, 0xba, 0x28, 0x83, 0xc4,
	0xaf, 0xdd, 0xfd, 0xc7, 0xea, 0x63, 0x83, 0xb6, 0x1b, 0xba, 0x49, 0x58, 0x4b, 0x46, 0x9c, 0x8b,
	0x2d, 0x52, 0x6f, 0x1b, 0xd4, 0xe2, 0xfe, 0x03, 0xe5, 0x67, 0x08, 0x66, 0xef, 0x18, 0x8c, 0x6f,
	0xd2, 0x8e, 0x66, 0x58, 0x4d, 0xa6, 0xd1, 0xef, 0xec, 0x53, 0xc6, 0xf1, 0x1c, 0x8c, 0x39, 0xc4,
	0xa5, 0x16, 0x9f, 0x47, 0x17, 0xd1, 0xe5, 0x09, 0x4d, 0xfe, 0xc2, 0xe7, 0x61, 0xc2, 0x21, 0x4d,
	0xaa, 0x33, 0xe3, 0x03, 0x3a, 0x7f, 0xe4, 0x22, 0xba, 0x7c, 0x5c, 0x1b, 0xf7, 0x06, 0x76, 0x8c,
	0x0f, 0x28, 0x5e, 0x00, 0x10, 0x0f, 0xb9, 0xdd, 0xa2, 0xd6, 0xfc, 0x51, 0x31, 0x51, 0x84, 0xbf,
	0xed, 0x0d, 0x78, 0x39, 0x1f, 0x1b, 0x6d, 0x4e, 0xdd, 0xf9, 0x63, 0x7e, 0x4e, 0xff, 0x17, 0x7e,
	0x1e, 0xc6, 0x6d, 0xb7, 0x41, 0x5d, 0x7d, 0xb7, 0x33, 0x7f, 0x5c, 0x3c, 0x39, 0x21, 0x7e, 0xaf,
	0x75, 0x94, 0x7f, 0x23, 0x38, 0xeb, 0xc1, 0xbb, 0xe5, 0x76, 0x1c, 0x6e, 0x6f, 0xd2, 0xce, 0x33,
	0x05, 0xf8, 0x1e, 0x4c, 0x1d, 0x50, 0x97, 0x19, 0xb6, 0xa5, 0x1f, 0x18, 0xf4, 0x50, 0xc0, 0x9c,
	0xae, 0x54, 0xcb, 0x19, 0x65, 0x2b, 0x87, 0x88, 0xee, 0xfb, 0x33, 0xba, 0x06, 0xee, 0x1b, 0xf4,
	0x50, 0x9b, 0x3c, 0x88, 0x7e, 0xc4, 0xf8, 0x1f, 0xcf, 0xe5, 0x3f, 0x96, 0xe4, 0xff, 0x4f, 0x04,
	0x17, 0x12, 0xfc, 0x65, 0xf2, 0x67, 0xba, 0x0d, 0x77, 0xe1, 0xd8, 0x88, 0xe8, 0x8b, 0x3c, 0xc3,
	0xf0, 0xfe, 0xb9, 0xac, 0xfb, 0x86, 0xe9, 0xd8, 0x2e, 0xff, 0xa6, 0xbd, 0xfb, 0xff, 0x26, 0xcc,
	0x4f, 0x11, 0x9c, 0x49, 0xfa, 0x86, 0x39, 0xb6, 0xc5, 0x28, 0xbe, 0x01, 0x13, 0x2d, 0xda, 0xd1,
	0x5d, 0x6f, 0x70, 0x1e, 0x5d, 0x3c, 0x7a, 0x79, 0xb2, 0x72, 0x21, 0x73, 0x07, 0xe5, 0x4c, 0x6d,
	0xbc, 0x25, 0x53, 0xe0, 0x17, 0x61, 0xc6, 0xa2, 0xef, 0x73, 0x3d, 0x06, 0xf5, 0x88, 0x58, 0xf5,
	0xa4, 0x37, 0xbc, 0x1d, 0xc2, 0x5d, 0x00, 0xe0, 0x36, 0x27, 0x6d, 0x9f, 0xeb, 0x51, 0xc1, 0x75,
	0x42, 0x8c, 0x78, 0x64, 0x95, 0x5f, 0x20, 0x98, 0x4b, 0x7b, 0x46, 0x82, 0x7b, 0x1d, 0x26, 0xeb,
	0x62, 0x54, 0x6f, 0xd1, 0x4e, 0x00, 0x6f, 0xb1, 0xb8, 0xc0, 0x1a, 0xd4, 0xc3, 0x44, 0xa3, 0x82,
	0xf8, 0x47, 0x04, 0x0b, 0x39, 0xb2, 0x96, 0x48, 0xef, 0xc1, 0x6c, 0x84, 0x54, 0x97, 0x2e, 0x0a,
	0x10, 0x7f, 0xb5, 0x2f, 0x49, 0x6a, 0xa7, 0xeb, 0xe9, 0xf4, 0xa3, 0xde, 0xe2, 0xb8, 0x3c, 0xa3,
	0x2d, 0x36, 0xc4, 0xa8, 0xfe, 0xc4, 0xde, 0x2d, 0xde, 0xe2, 0x70, 0xb6, 0x06, 0x46, 0x98, 0x68,
	0x54, 0x10, 0xbf, 0x06, 0xa7, 0x6f, 0xd3, 0x40, 0x9e, 0x81, 0x79, 0x30, 0x1c, 0xb3, 0x88, 0x49,
	0xa5, 0x75, 0xc4, 0xdf, 0xca, 0x15, 0x98, 0xbd, 0x4d, 0xa3, 0x4a, 0x14, 0x85, 0x7e, 0x1d, 0x4a,
	0xf1, 0xd0, 0x60, 0x9f, 0x7b, 0x26, 0xdf, 0xde, 0xdf, 0x6d, 0x1b, 0xf5, 0x1e, 0xc9, 0xfd, 0xd0,
	0x68, 0x4f, 0x0a, 0x42, 0x7f, 0x88, 0xe0, 0xcc, 0x2d, 0x97, 0x12, 0x4e, 0x53, 0xfc, 0xf2, 0x5e,
	0x0e, 0x8b, 0x30, 0x19, 0x98, 0x52, 0x37, 0x1a, 0x72, 0x3f, 0x27, 0xa4, 0xf1, 0x36, 0x1a, 0xf8,
	0x55, 0x18, 0x0f, 0x9e, 0x8b, 0x9d, 0xec, 0xe5, 0xd9, 0x13, 0x72, 0xaa, 0xf2, 0x57, 0x04, 0x73,
	0x3e, 0x92, 0xae, 0x0d, 0xcc, 0xc3, 0xa2, 0xc0, 0xc9, 0x98, 0xb2, 0x43, 0x34, 0x93, 0xa1, 0x58,
	0x37, 0x1a, 0xf8, 0x35, 0x80, 0x28, 0x46, 0x22, 0xea, 0x65, 0xd3, 0x89, 0x30, 0x01, 0xae, 0xc1,
	0x02, 0x6b, 0x19, 0x8e, 0x6e, 0x58, 0x06, 0x37, 0x48, 0x3b, 0xb0, 0x8f, 0x5e, 0xf7, 0x90, 0x1a,
	0xb6, 0x25, 0x5e, 0x66, 0xe3, 0x5a, 0xc9, 0x0b, 0xda, 0xf0, 0x63, 0x64, 0x2d, 0x6f, 0xc9, 0x08,
	0xe5, 0x63, 0x04, 0x0b, 0x29, 0x62, 0xa9, 0x72, 0xe7, 0xf1, 0xdb, 0x01, 0xdc, 0xed, 0x5c, 0x41,
	0xb2, 0x6f, 0xe3, 0x9e, 0x4a, 0x1b, 0x57, 0xf9, 0x0f, 0x82, 0x05, 0x5f, 0x1a, 0x83, 0xc2, 0x79,
	0x0f, 0x26, 0x48, 0xbb, 0x69, 0xbb, 0x06, 0xdf, 0x33, 0x05, 0x8a, 0xe9, 0xca, 0xeb, 0xc3, 0x7d,
	0xd1, 0x6a, 0x41, 0x1a, 0x2d, 0xca, 0xe8, 0xb9, 0x30, 0xb2, 0xbb, 0xfc, 0x7c, 0x4c, 0x84, 0x6e,
	0xc6, 0x2a, 0xcc, 0xba, 0x8c, 0xe8, 0x84, 0x32, 0xfd, 0xd0, 0x25, 0x8e, 0x43, 0x1b, 0xa2, 0xa2,
	0xde, 0xfe, 0x4f, 0xbd, 0xf5, 0x9c, 0x76, 0xca, 0x65, 0xa4, 0x46, 0xd9, 0x03, 0xff, 0xd1, 0x26,
	0xed, 0xac, 0xcd, 0xc1, 0x99, 0x58, 0xa0, 0x6e, 0x12, 0x4e, 0x5d, 0x83, 0xb4, 0x95, 0x4f, 0x42,
	0xa1, 0x75, 0x39, 0xa4, 0x40, 0x68, 0x11, 0xb4, 0x98, 0xd0, 0x42, 0x74, 0xbe, 0xd0, 0x62, 0xf0,
	0x8b, 0x84, 0x16, 0x2d, 0x1b, 0xd1, 0x53, 0x7e, 0x84, 0x60, 0xee, 0x9e, 0xd3, 0xc8, 0x92, 0x7f,
	0x52, 0xc2, 0x68, 0x50, 0x09, 0xdf, 0x84, 0xc9, 0x7d, 0x91, 0x58, 0x9c, 0x62, 0xa5, 0x7c, 0x4a,
	0xc1, 0xfc, 0xe0, 0xa0, 0x5b, 0x7e, 0xd3, 0x3b, 0xe8, 0x6e, 0x11, 0xd6, 0xd2, 0xc0, 0x0f, 0xf7,
	0xfe, 0x56, 0x7e, 0x87, 0x60, 0x21, 0x05, 0x2b, 0xa5, 0x96, 0x6c, 0x91, 0xa2, 0xa7, 0x12, 0xe9,
	0xd3, 0x61, 0xfe, 0x01, 0x82, 0xe9, 0x37, 0x2c, 0x91, 0xb3, 0xe0, 0xd5, 0x87, 0x2f, 0xc0, 0x84,
	0xd3, 0x26, 0x86, 0xc5, 0xe9, 0xfb, 0x5c, 0xac, 0x30, 0xa5, 0x45, 0x03, 0x78, 0x0d, 0x16, 0x48,
	0xa3, 0x61, 0x78, 0x0e, 0x26, 0x6d, 0x9d, 0xec, 0xf3, 0x3d, 0x6a, 0x71, 0xa3, 0x4e, 0x38, 0x6d,
	0xe8, 0x0d, 0xc2, 0x89, 0xa8, 0xf0, 0x94, 0x76, 0x3e, 0x0a, 0xaa, 0xc5, 0x63, 0xd6, 0x09, 0x27,
	0xca, 0x47, 0x08, 0xa6, 0xd7, 0x69, 0x4f, 0x20, 0x8b, 0x00, 0x75, 0xc3, 0xd9, 0xa3, 0x6e, 0x0c,
	0x49, 0x6c, 0x64, 0x24, 0x50, 0x1e, 0xc1, 0xd9, 0x1a, 0xeb, 0x98, 0x26, 0xe5, 0xae, 0x51, 0xdf,
	0x31, 0x9a, 0x45, 0x9f, 0x1a, 0xbc, 0x02, 0x63, 0x0d, 0xa3, 0x49, 0x19, 0x97, 0x32, 0x3e, 0x9f,
	0x59, 0xc6, 0x75, 0x11, 0xa2, 0xc9, 0x50, 0xe5, 0x2e, 0xcc, 0x47, 0x2b, 0x0c, 0xcc, 0xfa, 0x68,
	0x9a, 0xb5, 0xa2, 0xc2, 0x4c, 0x98, 0x45, 0x1e, 0x08, 0x12, 0x15, 0x43, 0xa9, 0x8a, 0x29, 0x6f,
	0xc0, 0x4c, 0x58, 0x75, 0x39, 0x61, 0x88, 0xdd, 0x56, 0xae, 0xc1, 0x5c, 0x7a, 0xa7, 0xa2, 0xe5,
	0x99, 0xd1, 0xb4, 0x08, 0xdf, 0x77, 0x69, 0xb0, 0x7c, 0x38, 0xa0, 0xdc, 0x80, 0xe7, 0x33, 0xf8,
	0xf7, 0x85, 0xdc, 0x84, 0x17, 0x52, 0x1e, 0xdb, 0x76, 0x0d, 0x93, 0xb8, 0x7d, 0x1c, 0x0b, 0xf0,
	0x32, 0x9c, 0xed, 0xb6, 0x5f, 0xf4, 0x8a, 0xc2, 0x69, 0x6b, 0x6d, 0x34, 0x94, 0x55, 0x58, 0x5c,
	0xa7, 0x8c, 0xbb, 0x76, 0x67, 0x90, 0xf3, 0xc7, 0x2a, 0x2c, 0x6a, 0x94, 0x71, 0xdb, 0xa5, 0x83,
	0xcc, 0x7a, 0x04, 0x63, 0xbe, 0x4e, 0xf0, 0x3c, 0x8c, 0xb1, 0x3d, 0x52, 0xb9, 0x7a, 0xcd, 0xe7,
	0xff, 0xd6, 0x73, 0x9a, 0xfc, 0x2d, 0x9f, 0xac, 0x5c, 0x5f, 0xf5, 0xab, 0x21, 0x9f, 0xac, 0x5c,
	0x5f, 0x95, 0x4f, 0xae, 0x2e, 0x57, 0x7c, 0x7d, 0xc8, 0x27, 0x57, 0x97, 0x2b, 0x6b, 0xe3, 0x81,
	0x44, 0x95, 0x57, 0xe1, 0xd4, 0x1d, 0xbb, 0x2e, 0x3e, 0xb5, 0x5b, 0x94, 0x13, 0xcf, 0x10, 0xf8,
	0x12, 0x9c, 0xdc, 0x63, 0xa6, 0x4e, 0x0e, 0x88, 0xd1, 0x26, 0xbb, 0x6d, 0x1f, 0xd2, 0xb8, 0x36,
	0xb5, 0xc7, 0xcc, 0x5a, 0x30, 0x56, 0xf9, 0xf1, 0x25, 0x38, 0xb3, 0x49, 0x3b, 0x5b, 0xc4, 0x22,
	0x4d, 0x6a, 0x52, 0x8b, 0xef, 0xf8, 0x37, 0x0c, 0xf8, 0x27, 0x08, 0xa6, 0xe2, 0x0d, 0x09, 0xbe,
	0x9c, 0xa9, 0xff, 0x8c, 0x5e, 0xbf, 0x74, 0xa5, 0x8f, 0x48, 0x5f, 0x12, 0xca, 0xea, 0xf7, 0xff,
	0xfc, 0xf7, 0x4f, 0x8e, 0x94, 0xf1, 0xcb, 0xea, 0xc1, 0xb2, 0xfa, 0x5d, 0xff, 0x43, 0xf3, 0x9a,
	0xe3, 0xda, 0x4f, 0x68, 0x9d, 0x33, 0x75, 0x49, 0x6d, 0x4b, 0x52, 0x4c, 0x5d, 0xfa, 0x50, 0x0d,
	0x1b, 0x9b, 0xdf, 0x20, 0x98, 0x4e, 0x76, 0x24, 0x78, 0x29, 0x77, 0xcd, 0xae, 0x56, 0xbf, 0xf4,
	0x52, 0x5f, 0xb1, 0x12, 0x61, 0x4d, 0x20, 0xbc, 0x89, 0x6f, 0xf4, 0x46, 0x18, 0x02, 0xf4, 0xc0,
	0xc6, 0x9a, 0x9c, 0x2f, 0xd2, 0x97, 0x0e, 0x61, 0xfb, 0xb0, 0xdc, 0x1b, 0x49, 0xaa, 0x41, 0x2f,
	0x55, 0x06, 0x99, 0x22, 0x39, 0xdc, 0x13, 0x1c, 0xbe, 0x85, 0xb7, 0x06, 0xe2, 0x10, 0xa3, 0x90,
	0x20, 0x14, 0xa2, 0x0f, 0xca, 0x10, 0x75, 0x2d, 0x05, 0x65, 0xe8, 0xea, 0xbc, 0x0b, 0xca, 0xd0,
	0xdd, 0x06, 0x0d, 0x5d, 0x86, 0x58, 0x23, 0xf4, 0x11, 0x02, 0x88, 0x5a, 0x18, 0xfc, 0x62, 0xe6,
	0xf2, 0x5d, 0x3d, 0x4e, 0xa9, 0xf0, 0xe4, 0x9e, 0x12, 0xb0, 0xe7, 0xf6, 0x3e, 0x50, 0xe1, 0x9f,
	0x22, 0x98, 0x8a, 0x77, 0x3e, 0x39, 0xe6, 0xca, 0xe8, 0xa3, 0x4a, 0x3d, 0xce, 0x3c, 0xa9, 0x8d,
	0xea, 0x0f, 0x50, 0xb2, 0xd2, 0xf8, 0x4f, 0x28, 0xd9, 0xc2, 0x05, 0xe7, 0x11, 0xb5, 0x27, 0xc8,
	0xe4, 0xbb, 0xb0, 0xd4, 0xdf, 0xc9, 0x27, 0x25, 0xcf, 0x21, 0x20, 0x77, 0x6b, 0xd3, 0xa3, 0xf1,
	0x07, 0x7f, 0x93, 0xc3, 0x66, 0x31, 0x7f, 0x93, 0xd3, 0xfd, 0x64, 0xce, 0x26, 0x87, 0x61, 0x8a,
	0x2e, 0x10, 0xbf, 0x83, 0x1f, 0x8c, 0x14, 0xb1, 0xea, 0x84, 0x50, 0xa5, 0x40, 0x42, 0x23, 0xe4,
	0x63, 0x4f, 0x1f, 0xdf, 0x4b, 0x3d, 0x8e, 0xdb, 0xc3, 0x09, 0x24, 0xb2, 0x91, 0xb7, 0xb3, 0x9f,
	0x22, 0x38, 0x99, 0xe8, 0x97, 0xf1, 0x95, 0x9c, 0x4a, 0x77, 0xf7, 0xd4, 0x3d, 0xfc, 0xf4, 0x0d,
	0x81, 0xee, 0xba, 0x32, 0xd0, 0x07, 0xa1, 0x1a, 0x76, 0xdb, 0xf8, 0xb7, 0x08, 0x66, 0x52, 0x7d,
	0x26, 0x7e, 0xa9, 0x00, 0xdc, 0xc0, 0xfe, 0xda, 0x12, 0x00, 0x6f, 0x2b, 0xc3, 0x7f, 0x0f, 0xaa,
	0xb1, 0x46, 0x06, 0x7f, 0xd9, 0xdd, 0xf0, 0x07, 0x76, 0xab, 0xf4, 0x03, 0x7b, 0x38, 0xc7, 0x19,
	0x82, 0x44, 0x5d, 0x19, 0xed, 0x07, 0xa1, 0x9a, 0xd1, 0x03, 0xe1, 0xbf, 0x20, 0x98, 0xcb, 0xee,
	0xb4, 0x73, 0x08, 0x16, 0xb6, 0xe5, 0xfd, 0x12, 0x94, 0x06, 0x55, 0xde, 0x1e, 0x2d, 0x41, 0xdf,
	0x06, 0x55, 0xb4, 0x14, 0xd3, 0x59, 0xe4, 0xd1, 0x22, 0x9d, 0x0d, 0x6c, 0xd3, 0x61, 0x75, 0x16,
	0x39, 0xb5, 0x1a, 0x6b, 0xc5, 0xf1, 0xef, 0x11, 0xcc, 0xa4, 0x8e, 0xd7, 0x39, 0x78, 0xb3, 0xfb,
	0xef, 0x9e, 0xbe, 0xf8, 0xb6, 0xc0, 0xab, 0x55, 0xd6, 0x05, 0xde, 0x48, 0x08, 0xe5, 0x61, 0x3e,
	0x41, 0x09, 0x8b, 0xfc, 0xa3, 0xfb, 0x52, 0xa0, 0x58, 0x41, 0x85, 0xad, 0x7a, 0xbf, 0x0a, 0xfa,
	0x9e, 0xe0, 0x73, 0x50, 0x79, 0x94, 0xe2, 0x13, 0x08, 0xbb, 0x3c, 0xaa, 0xb7, 0x7e, 0xa6, 0x6b,
	0x7e, 0x85, 0xe0, 0x84, 0xec, 0xe3, 0xf0, 0xa5, 0x4c, 0xc0, 0xc9, 0xde, 0xbe, 0xf4, 0x42, 0x71,
	0x90, 0x3c, 0x45, 0x05, 0xa2, 0x5a, 0x1b, 0xf6, 0xbb, 0xb5, 0xf4, 0x61, 0x95, 0xfa, 0x39, 0x3d,
	0x13, 0xfc, 0x12, 0xc1, 0x09, 0xd9, 0xe4, 0xe5, 0xa0, 0x4c, 0xb6, 0xc0, 0x39, 0x28, 0x53, 0x7d,
	0xa2, 0x72, 0x47, 0xa0, 0x7c, 0x53, 0xa9, 0x0d, 0x7d, 0x84, 0xa9, 0x36, 0x68, 0x08, 0xf2, 0x73,
	0x04, 0xd3, 0xc9, 0x5e, 0x36, 0xe7, 0x94, 0x9a, 0x79, 0x35, 0x90, 0x73, 0x4a, 0xcd, 0x6e, 0x8e,
	0x95, 0xa6, 0x40, 0x4e, 0x94, 0x87, 0x23, 0x3d, 0x17, 0x54, 0x49, 0x62, 0x35, 0x8f, 0xd4, 0x97,
	0x08, 0x4e, 0x77, 0x35, 0xda, 0xf8, 0x95, 0x1e, 0x58, 0x53, 0xd5, 0x28, 0xf7, 0x1b, 0x2e, 0xd9,
	0x3d, 0x11, 0xec, 0x1a, 0x8a, 0xfe, 0xac, 0xd8, 0xad, 0x47, 0x55, 0xfb, 0xa2, 0xfb, 0xca, 0x2d,
	0x79, 0x1d, 0x80, 0x6f, 0xf4, 0xe3, 0xfd, 0xcc, 0x2b, 0x84, 0x9e, 0xef, 0xb2, 0x77, 0x04, 0xd1,
	0x1d, 0xe5, 0xee, 0xf0, 0x02, 0xf4, 0x6f, 0xe2, 0x92, 0xcb, 0x7b, 0xbc, 0xfe, 0x86, 0xe0, 0x5c,
	0xce, 0xbd, 0x03, 0x5e, 0xc9, 0x71, 0x47, 0xd1, 0x2d, 0x45, 0xbf, 0xaf, 0xb3, 0x47, 0x82, 0xd2,
	0xbb, 0xca, 0xbd, 0xd1, 0xd6, 0xae, 0xe1, 0x83, 0x0b, 0x98, 0xe5, 0xdc, 0x8d, 0xe4, 0x30, 0x2b,
	0xbe, 0x49, 0xf9, 0x1f, 0x33, 0x73, 0x7d, 0x70, 0x55, 0xb4, 0x54, 0xe2, 0x9f, 0xd5, 0xce, 0x09,
	0x0c, 0x1e, 0x04, 0x1f, 0x13, 0x71, 0x0c, 0x56, 0xae, 0xdb, 0xe6, 0xe7, 0xb5, 0x07, 0x7b, 0x9c,
	0x3b, 0xac, 0xaa, 0xaa, 0x87, 0x87, 0x87, 0xa9, 0x87, 0x2a, 0xd9, 0xe7, 0x7b, 0xfe, 0x7f, 0x5a,
	0xbc, 0xe2, 0xb4, 0x09, 0x7f, 0x6c, 0xbb, 0xe6, 0xcb, 0x7d, 0x85, 0xb7, 0x4c, 0xb6, 0xf6, 0x31,
	0x82, 0x73, 0x75, 0xdb, 0xcc, 0xda, 0x84, 0xb5, 0xf1, 0x4d, 0x93, 0x6d, 0xbb, 0x36, 0xb7, 0xb7,
	0xd1, 0xbb, 0xd7, 0x64, 0x40, 0xd3, 0x6e, 0x13, 0xab, 0x59, 0xb6, 0xdd, 0xa6, 0xda, 0xa4, 0x96,
	0xb8, 0x1d, 0x56, 0xa3, 0x05, 0x12, 0xff, 0xf0, 0x71, 0xb3, 0x65, 0xb2, 0x7f, 0x21, 0xf4, 0xeb,
	0x23, 0xb3, 0xb7, 0xfd, 0xb9, 0xb7, 0x44, 0xf2, 0x4d, 0x93, 0x95, 0xef, 0x2f, 0x7f, 0x16, 0x8c,
	0x3e, 0x14, 0xa3, 0x0f, 0x37, 0x4d, 0xf6, 0xf0, 0xfe, 0xf2, 0xee, 0x98, 0xc8, 0xb8, 0xf2, 0xdf,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xd5, 0x1e, 0x95, 0x51, 0x97, 0x22, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// KeyManagementServiceClient is the client API for KeyManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeyManagementServiceClient interface {
	// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
	ListKeyRings(ctx context.Context, in *ListKeyRingsRequest, opts ...grpc.CallOption) (*ListKeyRingsResponse, error)
	// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error)
	// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	ListCryptoKeyVersions(ctx context.Context, in *ListCryptoKeyVersionsRequest, opts ...grpc.CallOption) (*ListCryptoKeyVersionsResponse, error)
	// Lists [ImportJobs][google.cloud.kms.v1.ImportJob].
	ListImportJobs(ctx context.Context, in *ListImportJobsRequest, opts ...grpc.CallOption) (*ListImportJobsResponse, error)
	// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
	GetKeyRing(ctx context.Context, in *GetKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error)
	// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey], as well as its
	// [primary][google.cloud.kms.v1.CryptoKey.primary] [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKey(ctx context.Context, in *GetCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Returns metadata for a given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKeyVersion(ctx context.Context, in *GetCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Returns the public key for the given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN] or
	// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
	GetPublicKey(ctx context.Context, in *GetPublicKeyRequest, opts ...grpc.CallOption) (*PublicKey, error)
	// Returns metadata for a given [ImportJob][google.cloud.kms.v1.ImportJob].
	GetImportJob(ctx context.Context, in *GetImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error)
	// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and Location.
	CreateKeyRing(ctx context.Context, in *CreateKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error)
	// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] and
	// [CryptoKey.version_template.algorithm][google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm]
	// are required.
	CreateCryptoKey(ctx context.Context, in *CreateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	//
	// The server will assign the next sequential id. If unset,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
	CreateCryptoKeyVersion(ctx context.Context, in *CreateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Imports a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] into an existing [CryptoKey][google.cloud.kms.v1.CryptoKey] using the
	// wrapped key material provided in the request.
	//
	// The version ID will be assigned the next sequential id within the
	// [CryptoKey][google.cloud.kms.v1.CryptoKey].
	ImportCryptoKeyVersion(ctx context.Context, in *ImportCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Create a new [ImportJob][google.cloud.kms.v1.ImportJob] within a [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [ImportJob.import_method][google.cloud.kms.v1.ImportJob.import_method] is required.
	CreateImportJob(ctx context.Context, in *CreateImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error)
	// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateCryptoKey(ctx context.Context, in *UpdateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s metadata.
	//
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] and
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] using this
	// method. See [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion] and [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] to
	// move between other states.
	UpdateCryptoKeyVersion(ctx context.Context, in *UpdateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Encrypts data, so that it can only be recovered by a call to [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
	// The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Encrypt(ctx context.Context, in *EncryptRequest, opts ...grpc.CallOption) (*EncryptResponse, error)
	// Decrypts data that was protected by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]. The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// must be [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Decrypt(ctx context.Context, in *DecryptRequest, opts ...grpc.CallOption) (*DecryptResponse, error)
	// Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// ASYMMETRIC_SIGN, producing a signature that can be verified with the public
	// key retrieved from [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	AsymmetricSign(ctx context.Context, in *AsymmetricSignRequest, opts ...grpc.CallOption) (*AsymmetricSignResponse, error)
	// Decrypts data that was encrypted with a public key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey] corresponding to a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] ASYMMETRIC_DECRYPT.
	AsymmetricDecrypt(ctx context.Context, in *AsymmetricDecryptRequest, opts ...grpc.CallOption) (*AsymmetricDecryptResponse, error)
	// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that will be used in [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
	//
	// Returns an error if called on an asymmetric key.
	UpdateCryptoKeyPrimaryVersion(ctx context.Context, in *UpdateCryptoKeyPrimaryVersionRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for destruction.
	//
	// Upon calling this method, [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be set to a time 24
	// hours in the future, at which point the [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be changed to
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED], and the key
	// material will be irrevocably destroyed.
	//
	// Before the [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is reached,
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] may be called to reverse the process.
	DestroyCryptoKeyVersion(ctx context.Context, in *DestroyCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// state.
	//
	// Upon restoration of the CryptoKeyVersion, [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be set to [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be cleared.
	RestoreCryptoKeyVersion(ctx context.Context, in *RestoreCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
}

type keyManagementServiceClient struct {
	cc *grpc.ClientConn
}

func NewKeyManagementServiceClient(cc *grpc.ClientConn) KeyManagementServiceClient {
	return &keyManagementServiceClient{cc}
}

func (c *keyManagementServiceClient) ListKeyRings(ctx context.Context, in *ListKeyRingsRequest, opts ...grpc.CallOption) (*ListKeyRingsResponse, error) {
	out := new(ListKeyRingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListKeyRings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error) {
	out := new(ListCryptoKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListCryptoKeyVersions(ctx context.Context, in *ListCryptoKeyVersionsRequest, opts ...grpc.CallOption) (*ListCryptoKeyVersionsResponse, error) {
	out := new(ListCryptoKeyVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeyVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListImportJobs(ctx context.Context, in *ListImportJobsRequest, opts ...grpc.CallOption) (*ListImportJobsResponse, error) {
	out := new(ListImportJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListImportJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetKeyRing(ctx context.Context, in *GetKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error) {
	out := new(KeyRing)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetKeyRing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetCryptoKey(ctx context.Context, in *GetCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetCryptoKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetCryptoKeyVersion(ctx context.Context, in *GetCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetPublicKey(ctx context.Context, in *GetPublicKeyRequest, opts ...grpc.CallOption) (*PublicKey, error) {
	out := new(PublicKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetImportJob(ctx context.Context, in *GetImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error) {
	out := new(ImportJob)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetImportJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateKeyRing(ctx context.Context, in *CreateKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error) {
	out := new(KeyRing)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateKeyRing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateCryptoKey(ctx context.Context, in *CreateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateCryptoKeyVersion(ctx context.Context, in *CreateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ImportCryptoKeyVersion(ctx context.Context, in *ImportCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ImportCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateImportJob(ctx context.Context, in *CreateImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error) {
	out := new(ImportJob)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateImportJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKey(ctx context.Context, in *UpdateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKeyVersion(ctx context.Context, in *UpdateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) Encrypt(ctx context.Context, in *EncryptRequest, opts ...grpc.CallOption) (*EncryptResponse, error) {
	out := new(EncryptResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/Encrypt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) Decrypt(ctx context.Context, in *DecryptRequest, opts ...grpc.CallOption) (*DecryptResponse, error) {
	out := new(DecryptResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/Decrypt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) AsymmetricSign(ctx context.Context, in *AsymmetricSignRequest, opts ...grpc.CallOption) (*AsymmetricSignResponse, error) {
	out := new(AsymmetricSignResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/AsymmetricSign", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) AsymmetricDecrypt(ctx context.Context, in *AsymmetricDecryptRequest, opts ...grpc.CallOption) (*AsymmetricDecryptResponse, error) {
	out := new(AsymmetricDecryptResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/AsymmetricDecrypt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKeyPrimaryVersion(ctx context.Context, in *UpdateCryptoKeyPrimaryVersionRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyPrimaryVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) DestroyCryptoKeyVersion(ctx context.Context, in *DestroyCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/DestroyCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) RestoreCryptoKeyVersion(ctx context.Context, in *RestoreCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/RestoreCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyManagementServiceServer is the server API for KeyManagementService service.
type KeyManagementServiceServer interface {
	// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
	ListKeyRings(context.Context, *ListKeyRingsRequest) (*ListKeyRingsResponse, error)
	// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	ListCryptoKeys(context.Context, *ListCryptoKeysRequest) (*ListCryptoKeysResponse, error)
	// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	ListCryptoKeyVersions(context.Context, *ListCryptoKeyVersionsRequest) (*ListCryptoKeyVersionsResponse, error)
	// Lists [ImportJobs][google.cloud.kms.v1.ImportJob].
	ListImportJobs(context.Context, *ListImportJobsRequest) (*ListImportJobsResponse, error)
	// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
	GetKeyRing(context.Context, *GetKeyRingRequest) (*KeyRing, error)
	// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey], as well as its
	// [primary][google.cloud.kms.v1.CryptoKey.primary] [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKey(context.Context, *GetCryptoKeyRequest) (*CryptoKey, error)
	// Returns metadata for a given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKeyVersion(context.Context, *GetCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Returns the public key for the given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN] or
	// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
	GetPublicKey(context.Context, *GetPublicKeyRequest) (*PublicKey, error)
	// Returns metadata for a given [ImportJob][google.cloud.kms.v1.ImportJob].
	GetImportJob(context.Context, *GetImportJobRequest) (*ImportJob, error)
	// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and Location.
	CreateKeyRing(context.Context, *CreateKeyRingRequest) (*KeyRing, error)
	// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] and
	// [CryptoKey.version_template.algorithm][google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm]
	// are required.
	CreateCryptoKey(context.Context, *CreateCryptoKeyRequest) (*CryptoKey, error)
	// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	//
	// The server will assign the next sequential id. If unset,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
	CreateCryptoKeyVersion(context.Context, *CreateCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Imports a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] into an existing [CryptoKey][google.cloud.kms.v1.CryptoKey] using the
	// wrapped key material provided in the request.
	//
	// The version ID will be assigned the next sequential id within the
	// [CryptoKey][google.cloud.kms.v1.CryptoKey].
	ImportCryptoKeyVersion(context.Context, *ImportCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Create a new [ImportJob][google.cloud.kms.v1.ImportJob] within a [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [ImportJob.import_method][google.cloud.kms.v1.ImportJob.import_method] is required.
	CreateImportJob(context.Context, *CreateImportJobRequest) (*ImportJob, error)
	// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateCryptoKey(context.Context, *UpdateCryptoKeyRequest) (*CryptoKey, error)
	// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s metadata.
	//
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] and
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] using this
	// method. See [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion] and [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] to
	// move between other states.
	UpdateCryptoKeyVersion(context.Context, *UpdateCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Encrypts data, so that it can only be recovered by a call to [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
	// The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Encrypt(context.Context, *EncryptRequest) (*EncryptResponse, error)
	// Decrypts data that was protected by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]. The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// must be [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Decrypt(context.Context, *DecryptRequest) (*DecryptResponse, error)
	// Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// ASYMMETRIC_SIGN, producing a signature that can be verified with the public
	// key retrieved from [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	AsymmetricSign(context.Context, *AsymmetricSignRequest) (*AsymmetricSignResponse, error)
	// Decrypts data that was encrypted with a public key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey] corresponding to a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] ASYMMETRIC_DECRYPT.
	AsymmetricDecrypt(context.Context, *AsymmetricDecryptRequest) (*AsymmetricDecryptResponse, error)
	// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that will be used in [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
	//
	// Returns an error if called on an asymmetric key.
	UpdateCryptoKeyPrimaryVersion(context.Context, *UpdateCryptoKeyPrimaryVersionRequest) (*CryptoKey, error)
	// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for destruction.
	//
	// Upon calling this method, [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be set to a time 24
	// hours in the future, at which point the [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be changed to
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED], and the key
	// material will be irrevocably destroyed.
	//
	// Before the [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is reached,
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] may be called to reverse the process.
	DestroyCryptoKeyVersion(context.Context, *DestroyCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// state.
	//
	// Upon restoration of the CryptoKeyVersion, [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be set to [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be cleared.
	RestoreCryptoKeyVersion(context.Context, *RestoreCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
}

func RegisterKeyManagementServiceServer(s *grpc.Server, srv KeyManagementServiceServer) {
	s.RegisterService(&_KeyManagementService_serviceDesc, srv)
}

func _KeyManagementService_ListKeyRings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeyRingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListKeyRings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListKeyRings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListKeyRings(ctx, req.(*ListKeyRingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListCryptoKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCryptoKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListCryptoKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListCryptoKeys(ctx, req.(*ListCryptoKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListCryptoKeyVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCryptoKeyVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListCryptoKeyVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeyVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListCryptoKeyVersions(ctx, req.(*ListCryptoKeyVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListImportJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImportJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListImportJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListImportJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListImportJobs(ctx, req.(*ListImportJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetKeyRing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetKeyRing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetKeyRing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetKeyRing(ctx, req.(*GetKeyRingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetCryptoKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetCryptoKey(ctx, req.(*GetCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetCryptoKeyVersion(ctx, req.(*GetCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetPublicKey(ctx, req.(*GetPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetImportJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetImportJob(ctx, req.(*GetImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateKeyRing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateKeyRing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateKeyRing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateKeyRing(ctx, req.(*CreateKeyRingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateCryptoKey(ctx, req.(*CreateCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateCryptoKeyVersion(ctx, req.(*CreateCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ImportCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ImportCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ImportCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ImportCryptoKeyVersion(ctx, req.(*ImportCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateImportJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateImportJob(ctx, req.(*CreateImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKey(ctx, req.(*UpdateCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyVersion(ctx, req.(*UpdateCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_Encrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EncryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).Encrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/Encrypt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).Encrypt(ctx, req.(*EncryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_Decrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).Decrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/Decrypt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).Decrypt(ctx, req.(*DecryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_AsymmetricSign_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsymmetricSignRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).AsymmetricSign(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/AsymmetricSign",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).AsymmetricSign(ctx, req.(*AsymmetricSignRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_AsymmetricDecrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsymmetricDecryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).AsymmetricDecrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/AsymmetricDecrypt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).AsymmetricDecrypt(ctx, req.(*AsymmetricDecryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKeyPrimaryVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyPrimaryVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyPrimaryVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyPrimaryVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyPrimaryVersion(ctx, req.(*UpdateCryptoKeyPrimaryVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_DestroyCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).DestroyCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/DestroyCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).DestroyCryptoKeyVersion(ctx, req.(*DestroyCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_RestoreCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).RestoreCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/RestoreCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).RestoreCryptoKeyVersion(ctx, req.(*RestoreCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KeyManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.v1.KeyManagementService",
	HandlerType: (*KeyManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListKeyRings",
			Handler:    _KeyManagementService_ListKeyRings_Handler,
		},
		{
			MethodName: "ListCryptoKeys",
			Handler:    _KeyManagementService_ListCryptoKeys_Handler,
		},
		{
			MethodName: "ListCryptoKeyVersions",
			Handler:    _KeyManagementService_ListCryptoKeyVersions_Handler,
		},
		{
			MethodName: "ListImportJobs",
			Handler:    _KeyManagementService_ListImportJobs_Handler,
		},
		{
			MethodName: "GetKeyRing",
			Handler:    _KeyManagementService_GetKeyRing_Handler,
		},
		{
			MethodName: "GetCryptoKey",
			Handler:    _KeyManagementService_GetCryptoKey_Handler,
		},
		{
			MethodName: "GetCryptoKeyVersion",
			Handler:    _KeyManagementService_GetCryptoKeyVersion_Handler,
		},
		{
			MethodName: "GetPublicKey",
			Handler:    _KeyManagementService_GetPublicKey_Handler,
		},
		{
			MethodName: "GetImportJob",
			Handler:    _KeyManagementService_GetImportJob_Handler,
		},
		{
			MethodName: "CreateKeyRing",
			Handler:    _KeyManagementService_CreateKeyRing_Handler,
		},
		{
			MethodName: "CreateCryptoKey",
			Handler:    _KeyManagementService_CreateCryptoKey_Handler,
		},
		{
			MethodName: "CreateCryptoKeyVersion",
			Handler:    _KeyManagementService_CreateCryptoKeyVersion_Handler,
		},
		{
			MethodName: "ImportCryptoKeyVersion",
			Handler:    _KeyManagementService_ImportCryptoKeyVersion_Handler,
		},
		{
			MethodName: "CreateImportJob",
			Handler:    _KeyManagementService_CreateImportJob_Handler,
		},
		{
			MethodName: "UpdateCryptoKey",
			Handler:    _KeyManagementService_UpdateCryptoKey_Handler,
		},
		{
			MethodName: "UpdateCryptoKeyVersion",
			Handler:    _KeyManagementService_UpdateCryptoKeyVersion_Handler,
		},
		{
			MethodName: "Encrypt",
			Handler:    _KeyManagementService_Encrypt_Handler,
		},
		{
			MethodName: "Decrypt",
			Handler:    _KeyManagementService_Decrypt_Handler,
		},
		{
			MethodName: "AsymmetricSign",
			Handler:    _KeyManagementService_AsymmetricSign_Handler,
		},
		{
			MethodName: "AsymmetricDecrypt",
			Handler:    _KeyManagementService_AsymmetricDecrypt_Handler,
		},
		{
			MethodName: "UpdateCryptoKeyPrimaryVersion",
			Handler:    _KeyManagementService_UpdateCryptoKeyPrimaryVersion_Handler,
		},
		{
			MethodName: "DestroyCryptoKeyVersion",
			Handler:    _KeyManagementService_DestroyCryptoKeyVersion_Handler,
		},
		{
			MethodName: "RestoreCryptoKeyVersion",
			Handler:    _KeyManagementService_RestoreCryptoKeyVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/v1/service.proto",
}
