// DO NOT EDIT: This file is autogenerated via the builtin command.

package promql

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   106,
				},
				File:   "join_test.flux",
				Source: "package promql_test\n\nimport \"internal/promql\"\nimport \"testing\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,0,2018-12-19T22:13:30Z,_m,a,t,1\n,,0,2018-12-19T22:13:40Z,_m,a,t,2\n,,0,2018-12-19T22:13:50Z,_m,a,t,3\n,,0,2018-12-19T22:14:00Z,_m,a,t,4\n,,0,2018-12-19T22:14:10Z,_m,a,t,5\n,,0,2018-12-19T22:14:20Z,_m,a,t,6\n,,1,2018-12-19T22:13:30Z,_m,a,g,2\n,,1,2018-12-19T22:13:40Z,_m,a,g,3\n,,1,2018-12-19T22:13:50Z,_m,a,g,4\n,,1,2018-12-19T22:14:00Z,_m,a,g,5\n,,1,2018-12-19T22:14:10Z,_m,a,g,6\n,,1,2018-12-19T22:14:20Z,_m,a,g,7\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,2,2018-12-19T22:13:30Z,_m,a,t,1\n,,2,2018-12-19T22:13:40Z,_m,a,t,2\n,,2,2018-12-19T22:13:50Z,_m,a,t,3\n,,2,2018-12-19T22:14:00Z,_m,a,t,4\n,,2,2018-12-19T22:14:10Z,_m,a,t,5\n,,2,2018-12-19T22:14:20Z,_m,a,t,6\n,,3,2018-12-19T22:13:30Z,_m,a,g,1\n,,3,2018-12-19T22:13:40Z,_m,a,g,2\n,,3,2018-12-19T22:13:50Z,_m,a,g,3\n,,3,2018-12-19T22:14:00Z,_m,a,g,4\n,,3,2018-12-19T22:14:10Z,_m,a,g,5\n,,3,2018-12-19T22:14:20Z,_m,a,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,4,2018-12-19T22:13:30Z,_m,b,s,1\n,,4,2018-12-19T22:13:40Z,_m,b,s,2\n,,4,2018-12-19T22:13:50Z,_m,b,s,3\n,,4,2018-12-19T22:14:00Z,_m,b,s,4\n,,4,2018-12-19T22:14:10Z,_m,b,s,5\n,,4,2018-12-19T22:14:20Z,_m,b,s,6\n,,5,2018-12-19T22:13:30Z,_m,b,g,1\n,,5,2018-12-19T22:13:40Z,_m,b,g,2\n,,5,2018-12-19T22:13:50Z,_m,b,g,3\n,,5,2018-12-19T22:14:00Z,_m,b,g,4\n,,5,2018-12-19T22:14:10Z,_m,b,g,5\n,,5,2018-12-19T22:14:20Z,_m,b,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,6,2018-12-19T22:13:30Z,_m,b,s,1\n,,6,2018-12-19T22:13:40Z,_m,b,s,2\n,,6,2018-12-19T22:13:50Z,_m,b,s,3\n,,6,2018-12-19T22:14:00Z,_m,b,s,4\n,,6,2018-12-19T22:14:10Z,_m,b,s,5\n,,6,2018-12-19T22:14:20Z,_m,b,s,6\n,,7,2018-12-19T22:13:30Z,_m,b,p,1\n,,7,2018-12-19T22:13:40Z,_m,b,p,2\n,,7,2018-12-19T22:13:50Z,_m,b,p,3\n,,7,2018-12-19T22:14:00Z,_m,b,p,4\n,,7,2018-12-19T22:14:10Z,_m,b,p,5\n,,7,2018-12-19T22:14:20Z,_m,b,p,6\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,double,double\n#group,false,false,true,true,false,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,tag0,value_a,value_b\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:30Z,_m,g,2,1\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:40Z,_m,g,3,2\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:50Z,_m,g,4,3\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:00Z,_m,g,5,4\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:10Z,_m,g,6,5\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:20Z,_m,g,7,6\n\"\n\njoin_test_fn = (table=<-) => {\n    a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})\n\n    b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})\n\n    return promql.join(left:a, right:b, fn:(left, right) => ({left with value_b: right.value_b}))\n}\n\ntest prom_join = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   74,
					},
					File:   "join_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,0,2018-12-19T22:13:30Z,_m,a,t,1\n,,0,2018-12-19T22:13:40Z,_m,a,t,2\n,,0,2018-12-19T22:13:50Z,_m,a,t,3\n,,0,2018-12-19T22:14:00Z,_m,a,t,4\n,,0,2018-12-19T22:14:10Z,_m,a,t,5\n,,0,2018-12-19T22:14:20Z,_m,a,t,6\n,,1,2018-12-19T22:13:30Z,_m,a,g,2\n,,1,2018-12-19T22:13:40Z,_m,a,g,3\n,,1,2018-12-19T22:13:50Z,_m,a,g,4\n,,1,2018-12-19T22:14:00Z,_m,a,g,5\n,,1,2018-12-19T22:14:10Z,_m,a,g,6\n,,1,2018-12-19T22:14:20Z,_m,a,g,7\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,2,2018-12-19T22:13:30Z,_m,a,t,1\n,,2,2018-12-19T22:13:40Z,_m,a,t,2\n,,2,2018-12-19T22:13:50Z,_m,a,t,3\n,,2,2018-12-19T22:14:00Z,_m,a,t,4\n,,2,2018-12-19T22:14:10Z,_m,a,t,5\n,,2,2018-12-19T22:14:20Z,_m,a,t,6\n,,3,2018-12-19T22:13:30Z,_m,a,g,1\n,,3,2018-12-19T22:13:40Z,_m,a,g,2\n,,3,2018-12-19T22:13:50Z,_m,a,g,3\n,,3,2018-12-19T22:14:00Z,_m,a,g,4\n,,3,2018-12-19T22:14:10Z,_m,a,g,5\n,,3,2018-12-19T22:14:20Z,_m,a,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,4,2018-12-19T22:13:30Z,_m,b,s,1\n,,4,2018-12-19T22:13:40Z,_m,b,s,2\n,,4,2018-12-19T22:13:50Z,_m,b,s,3\n,,4,2018-12-19T22:14:00Z,_m,b,s,4\n,,4,2018-12-19T22:14:10Z,_m,b,s,5\n,,4,2018-12-19T22:14:20Z,_m,b,s,6\n,,5,2018-12-19T22:13:30Z,_m,b,g,1\n,,5,2018-12-19T22:13:40Z,_m,b,g,2\n,,5,2018-12-19T22:13:50Z,_m,b,g,3\n,,5,2018-12-19T22:14:00Z,_m,b,g,4\n,,5,2018-12-19T22:14:10Z,_m,b,g,5\n,,5,2018-12-19T22:14:20Z,_m,b,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,6,2018-12-19T22:13:30Z,_m,b,s,1\n,,6,2018-12-19T22:13:40Z,_m,b,s,2\n,,6,2018-12-19T22:13:50Z,_m,b,s,3\n,,6,2018-12-19T22:14:00Z,_m,b,s,4\n,,6,2018-12-19T22:14:10Z,_m,b,s,5\n,,6,2018-12-19T22:14:20Z,_m,b,s,6\n,,7,2018-12-19T22:13:30Z,_m,b,p,1\n,,7,2018-12-19T22:13:40Z,_m,b,p,2\n,,7,2018-12-19T22:13:50Z,_m,b,p,3\n,,7,2018-12-19T22:14:00Z,_m,b,p,4\n,,7,2018-12-19T22:14:10Z,_m,b,p,5\n,,7,2018-12-19T22:14:20Z,_m,b,p,6\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "join_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   74,
						},
						File:   "join_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,0,2018-12-19T22:13:30Z,_m,a,t,1\n,,0,2018-12-19T22:13:40Z,_m,a,t,2\n,,0,2018-12-19T22:13:50Z,_m,a,t,3\n,,0,2018-12-19T22:14:00Z,_m,a,t,4\n,,0,2018-12-19T22:14:10Z,_m,a,t,5\n,,0,2018-12-19T22:14:20Z,_m,a,t,6\n,,1,2018-12-19T22:13:30Z,_m,a,g,2\n,,1,2018-12-19T22:13:40Z,_m,a,g,3\n,,1,2018-12-19T22:13:50Z,_m,a,g,4\n,,1,2018-12-19T22:14:00Z,_m,a,g,5\n,,1,2018-12-19T22:14:10Z,_m,a,g,6\n,,1,2018-12-19T22:14:20Z,_m,a,g,7\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,2,2018-12-19T22:13:30Z,_m,a,t,1\n,,2,2018-12-19T22:13:40Z,_m,a,t,2\n,,2,2018-12-19T22:13:50Z,_m,a,t,3\n,,2,2018-12-19T22:14:00Z,_m,a,t,4\n,,2,2018-12-19T22:14:10Z,_m,a,t,5\n,,2,2018-12-19T22:14:20Z,_m,a,t,6\n,,3,2018-12-19T22:13:30Z,_m,a,g,1\n,,3,2018-12-19T22:13:40Z,_m,a,g,2\n,,3,2018-12-19T22:13:50Z,_m,a,g,3\n,,3,2018-12-19T22:14:00Z,_m,a,g,4\n,,3,2018-12-19T22:14:10Z,_m,a,g,5\n,,3,2018-12-19T22:14:20Z,_m,a,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,4,2018-12-19T22:13:30Z,_m,b,s,1\n,,4,2018-12-19T22:13:40Z,_m,b,s,2\n,,4,2018-12-19T22:13:50Z,_m,b,s,3\n,,4,2018-12-19T22:14:00Z,_m,b,s,4\n,,4,2018-12-19T22:14:10Z,_m,b,s,5\n,,4,2018-12-19T22:14:20Z,_m,b,s,6\n,,5,2018-12-19T22:13:30Z,_m,b,g,1\n,,5,2018-12-19T22:13:40Z,_m,b,g,2\n,,5,2018-12-19T22:13:50Z,_m,b,g,3\n,,5,2018-12-19T22:14:00Z,_m,b,g,4\n,,5,2018-12-19T22:14:10Z,_m,b,g,5\n,,5,2018-12-19T22:14:20Z,_m,b,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,6,2018-12-19T22:13:30Z,_m,b,s,1\n,,6,2018-12-19T22:13:40Z,_m,b,s,2\n,,6,2018-12-19T22:13:50Z,_m,b,s,3\n,,6,2018-12-19T22:14:00Z,_m,b,s,4\n,,6,2018-12-19T22:14:10Z,_m,b,s,5\n,,6,2018-12-19T22:14:20Z,_m,b,s,6\n,,7,2018-12-19T22:13:30Z,_m,b,p,1\n,,7,2018-12-19T22:13:40Z,_m,b,p,2\n,,7,2018-12-19T22:13:50Z,_m,b,p,3\n,,7,2018-12-19T22:14:00Z,_m,b,p,4\n,,7,2018-12-19T22:14:10Z,_m,b,p,5\n,,7,2018-12-19T22:14:20Z,_m,b,p,6\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,0,2018-12-19T22:13:30Z,_m,a,t,1\n,,0,2018-12-19T22:13:40Z,_m,a,t,2\n,,0,2018-12-19T22:13:50Z,_m,a,t,3\n,,0,2018-12-19T22:14:00Z,_m,a,t,4\n,,0,2018-12-19T22:14:10Z,_m,a,t,5\n,,0,2018-12-19T22:14:20Z,_m,a,t,6\n,,1,2018-12-19T22:13:30Z,_m,a,g,2\n,,1,2018-12-19T22:13:40Z,_m,a,g,3\n,,1,2018-12-19T22:13:50Z,_m,a,g,4\n,,1,2018-12-19T22:14:00Z,_m,a,g,5\n,,1,2018-12-19T22:14:10Z,_m,a,g,6\n,,1,2018-12-19T22:14:20Z,_m,a,g,7\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,2,2018-12-19T22:13:30Z,_m,a,t,1\n,,2,2018-12-19T22:13:40Z,_m,a,t,2\n,,2,2018-12-19T22:13:50Z,_m,a,t,3\n,,2,2018-12-19T22:14:00Z,_m,a,t,4\n,,2,2018-12-19T22:14:10Z,_m,a,t,5\n,,2,2018-12-19T22:14:20Z,_m,a,t,6\n,,3,2018-12-19T22:13:30Z,_m,a,g,1\n,,3,2018-12-19T22:13:40Z,_m,a,g,2\n,,3,2018-12-19T22:13:50Z,_m,a,g,3\n,,3,2018-12-19T22:14:00Z,_m,a,g,4\n,,3,2018-12-19T22:14:10Z,_m,a,g,5\n,,3,2018-12-19T22:14:20Z,_m,a,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag0,_value\n,,4,2018-12-19T22:13:30Z,_m,b,s,1\n,,4,2018-12-19T22:13:40Z,_m,b,s,2\n,,4,2018-12-19T22:13:50Z,_m,b,s,3\n,,4,2018-12-19T22:14:00Z,_m,b,s,4\n,,4,2018-12-19T22:14:10Z,_m,b,s,5\n,,4,2018-12-19T22:14:20Z,_m,b,s,6\n,,5,2018-12-19T22:13:30Z,_m,b,g,1\n,,5,2018-12-19T22:13:40Z,_m,b,g,2\n,,5,2018-12-19T22:13:50Z,_m,b,g,3\n,,5,2018-12-19T22:14:00Z,_m,b,g,4\n,,5,2018-12-19T22:14:10Z,_m,b,g,5\n,,5,2018-12-19T22:14:20Z,_m,b,g,6\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,tag1,_value\n,,6,2018-12-19T22:13:30Z,_m,b,s,1\n,,6,2018-12-19T22:13:40Z,_m,b,s,2\n,,6,2018-12-19T22:13:50Z,_m,b,s,3\n,,6,2018-12-19T22:14:00Z,_m,b,s,4\n,,6,2018-12-19T22:14:10Z,_m,b,s,5\n,,6,2018-12-19T22:14:20Z,_m,b,s,6\n,,7,2018-12-19T22:13:30Z,_m,b,p,1\n,,7,2018-12-19T22:13:40Z,_m,b,p,2\n,,7,2018-12-19T22:13:50Z,_m,b,p,3\n,,7,2018-12-19T22:14:00Z,_m,b,p,4\n,,7,2018-12-19T22:14:10Z,_m,b,p,5\n,,7,2018-12-19T22:14:20Z,_m,b,p,6\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   87,
					},
					File:   "join_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,double,double\n#group,false,false,true,true,false,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,tag0,value_a,value_b\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:30Z,_m,g,2,1\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:40Z,_m,g,3,2\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:50Z,_m,g,4,3\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:00Z,_m,g,5,4\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:10Z,_m,g,6,5\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:20Z,_m,g,7,6\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   76,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   76,
						},
						File:   "join_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   76,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   87,
						},
						File:   "join_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,double,double\n#group,false,false,true,true,false,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,tag0,value_a,value_b\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:30Z,_m,g,2,1\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:40Z,_m,g,3,2\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:50Z,_m,g,4,3\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:00Z,_m,g,5,4\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:10Z,_m,g,6,5\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:20Z,_m,g,7,6\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   76,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,double,double\n#group,false,false,true,true,false,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,tag0,value_a,value_b\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:30Z,_m,g,2,1\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:40Z,_m,g,3,2\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:13:50Z,_m,g,4,3\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:00Z,_m,g,5,4\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:10Z,_m,g,6,5\n,,0,2018-12-19T00:00:00Z,2018-12-20T00:00:00Z,2018-12-19T22:14:20Z,_m,g,7,6\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   103,
					},
					File:   "join_test.flux",
					Source: "join_test_fn = (table=<-) => {\n    a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})\n\n    b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})\n\n    return promql.join(left:a, right:b, fn:(left, right) => ({left with value_b: right.value_b}))\n}",
					Start: ast.Position{
						Column: 1,
						Line:   89,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   89,
						},
						File:   "join_test.flux",
						Source: "join_test_fn",
						Start: ast.Position{
							Column: 1,
							Line:   89,
						},
					},
				},
				Name: "join_test_fn",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   103,
						},
						File:   "join_test.flux",
						Source: "(table=<-) => {\n    a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})\n\n    b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})\n\n    return promql.join(left:a, right:b, fn:(left, right) => ({left with value_b: right.value_b}))\n}",
						Start: ast.Position{
							Column: 16,
							Line:   89,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   103,
							},
							File:   "join_test.flux",
							Source: "{\n    a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})\n\n    b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})\n\n    return promql.join(left:a, right:b, fn:(left, right) => ({left with value_b: right.value_b}))\n}",
							Start: ast.Position{
								Column: 30,
								Line:   89,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   94,
								},
								File:   "join_test.flux",
								Source: "a = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})",
								Start: ast.Position{
									Column: 5,
									Line:   90,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   90,
									},
									File:   "join_test.flux",
									Source: "a",
									Start: ast.Position{
										Column: 5,
										Line:   90,
									},
								},
							},
							Name: "a",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   90,
													},
													File:   "join_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 9,
														Line:   90,
													},
												},
											},
											Name: "table",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   91,
												},
												File:   "join_test.flux",
												Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)",
												Start: ast.Position{
													Column: 9,
													Line:   90,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   91,
														},
														File:   "join_test.flux",
														Source: "start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z",
														Start: ast.Position{
															Column: 18,
															Line:   91,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   91,
															},
															File:   "join_test.flux",
															Source: "start: 2018-12-19T00:00:00Z",
															Start: ast.Position{
																Column: 18,
																Line:   91,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   91,
																},
																File:   "join_test.flux",
																Source: "start",
																Start: ast.Position{
																	Column: 18,
																	Line:   91,
																},
															},
														},
														Name: "start",
													},
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   91,
																},
																File:   "join_test.flux",
																Source: "2018-12-19T00:00:00Z",
																Start: ast.Position{
																	Column: 25,
																	Line:   91,
																},
															},
														},
														Value: parser.MustParseTime("2018-12-19T00:00:00Z"),
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   91,
															},
															File:   "join_test.flux",
															Source: "stop: 2018-12-20T00:00:00Z",
															Start: ast.Position{
																Column: 47,
																Line:   91,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   91,
																},
																File:   "join_test.flux",
																Source: "stop",
																Start: ast.Position{
																	Column: 47,
																	Line:   91,
																},
															},
														},
														Name: "stop",
													},
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   91,
																},
																File:   "join_test.flux",
																Source: "2018-12-20T00:00:00Z",
																Start: ast.Position{
																	Column: 53,
																	Line:   91,
																},
															},
														},
														Value: parser.MustParseTime("2018-12-20T00:00:00Z"),
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   91,
													},
													File:   "join_test.flux",
													Source: "range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)",
													Start: ast.Position{
														Column: 12,
														Line:   91,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   91,
														},
														File:   "join_test.flux",
														Source: "range",
														Start: ast.Position{
															Column: 12,
															Line:   91,
														},
													},
												},
												Name: "range",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   92,
											},
											File:   "join_test.flux",
											Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")",
											Start: ast.Position{
												Column: 9,
												Line:   90,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   92,
													},
													File:   "join_test.flux",
													Source: "fn: (r) => r._field == \"a\"",
													Start: ast.Position{
														Column: 19,
														Line:   92,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   92,
														},
														File:   "join_test.flux",
														Source: "fn: (r) => r._field == \"a\"",
														Start: ast.Position{
															Column: 19,
															Line:   92,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   92,
															},
															File:   "join_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   92,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   92,
															},
															File:   "join_test.flux",
															Source: "(r) => r._field == \"a\"",
															Start: ast.Position{
																Column: 23,
																Line:   92,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   92,
																},
																File:   "join_test.flux",
																Source: "r._field == \"a\"",
																Start: ast.Position{
																	Column: 30,
																	Line:   92,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   92,
																	},
																	File:   "join_test.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 30,
																		Line:   92,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   92,
																		},
																		File:   "join_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   92,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   92,
																		},
																		File:   "join_test.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 32,
																			Line:   92,
																		},
																	},
																},
																Name: "_field",
															},
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   92,
																	},
																	File:   "join_test.flux",
																	Source: "\"a\"",
																	Start: ast.Position{
																		Column: 42,
																		Line:   92,
																	},
																},
															},
															Value: "a",
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   92,
																},
																File:   "join_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   92,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   92,
																	},
																	File:   "join_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   92,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   92,
												},
												File:   "join_test.flux",
												Source: "filter(fn: (r) => r._field == \"a\")",
												Start: ast.Position{
													Column: 12,
													Line:   92,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   92,
													},
													File:   "join_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   92,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   93,
										},
										File:   "join_test.flux",
										Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])",
										Start: ast.Position{
											Column: 9,
											Line:   90,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   93,
												},
												File:   "join_test.flux",
												Source: "columns: [\"_field\"]",
												Start: ast.Position{
													Column: 17,
													Line:   93,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   93,
													},
													File:   "join_test.flux",
													Source: "columns: [\"_field\"]",
													Start: ast.Position{
														Column: 17,
														Line:   93,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   93,
														},
														File:   "join_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   93,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   93,
														},
														File:   "join_test.flux",
														Source: "[\"_field\"]",
														Start: ast.Position{
															Column: 26,
															Line:   93,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   93,
															},
															File:   "join_test.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 27,
																Line:   93,
															},
														},
													},
													Value: "_field",
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   93,
											},
											File:   "join_test.flux",
											Source: "drop(columns: [\"_field\"])",
											Start: ast.Position{
												Column: 12,
												Line:   93,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   93,
												},
												File:   "join_test.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   93,
												},
											},
										},
										Name: "drop",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   94,
									},
									File:   "join_test.flux",
									Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"a\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_a\"})",
									Start: ast.Position{
										Column: 9,
										Line:   90,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   94,
											},
											File:   "join_test.flux",
											Source: "columns: {_value: \"value_a\"}",
											Start: ast.Position{
												Column: 19,
												Line:   94,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   94,
												},
												File:   "join_test.flux",
												Source: "columns: {_value: \"value_a\"}",
												Start: ast.Position{
													Column: 19,
													Line:   94,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   94,
													},
													File:   "join_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 19,
														Line:   94,
													},
												},
											},
											Name: "columns",
										},
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   94,
													},
													File:   "join_test.flux",
													Source: "{_value: \"value_a\"}",
													Start: ast.Position{
														Column: 28,
														Line:   94,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   94,
														},
														File:   "join_test.flux",
														Source: "_value: \"value_a\"",
														Start: ast.Position{
															Column: 29,
															Line:   94,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   94,
															},
															File:   "join_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 29,
																Line:   94,
															},
														},
													},
													Name: "_value",
												},
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   94,
															},
															File:   "join_test.flux",
															Source: "\"value_a\"",
															Start: ast.Position{
																Column: 37,
																Line:   94,
															},
														},
													},
													Value: "value_a",
												},
											}},
											With: nil,
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   94,
										},
										File:   "join_test.flux",
										Source: "rename(columns: {_value: \"value_a\"})",
										Start: ast.Position{
											Column: 12,
											Line:   94,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   94,
											},
											File:   "join_test.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 12,
												Line:   94,
											},
										},
									},
									Name: "rename",
								},
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   100,
								},
								File:   "join_test.flux",
								Source: "b = table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})",
								Start: ast.Position{
									Column: 5,
									Line:   96,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   96,
									},
									File:   "join_test.flux",
									Source: "b",
									Start: ast.Position{
										Column: 5,
										Line:   96,
									},
								},
							},
							Name: "b",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   96,
													},
													File:   "join_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 9,
														Line:   96,
													},
												},
											},
											Name: "table",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   97,
												},
												File:   "join_test.flux",
												Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)",
												Start: ast.Position{
													Column: 9,
													Line:   96,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   97,
														},
														File:   "join_test.flux",
														Source: "start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z",
														Start: ast.Position{
															Column: 18,
															Line:   97,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   97,
															},
															File:   "join_test.flux",
															Source: "start: 2018-12-19T00:00:00Z",
															Start: ast.Position{
																Column: 18,
																Line:   97,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   97,
																},
																File:   "join_test.flux",
																Source: "start",
																Start: ast.Position{
																	Column: 18,
																	Line:   97,
																},
															},
														},
														Name: "start",
													},
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   97,
																},
																File:   "join_test.flux",
																Source: "2018-12-19T00:00:00Z",
																Start: ast.Position{
																	Column: 25,
																	Line:   97,
																},
															},
														},
														Value: parser.MustParseTime("2018-12-19T00:00:00Z"),
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   97,
															},
															File:   "join_test.flux",
															Source: "stop: 2018-12-20T00:00:00Z",
															Start: ast.Position{
																Column: 47,
																Line:   97,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   97,
																},
																File:   "join_test.flux",
																Source: "stop",
																Start: ast.Position{
																	Column: 47,
																	Line:   97,
																},
															},
														},
														Name: "stop",
													},
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   97,
																},
																File:   "join_test.flux",
																Source: "2018-12-20T00:00:00Z",
																Start: ast.Position{
																	Column: 53,
																	Line:   97,
																},
															},
														},
														Value: parser.MustParseTime("2018-12-20T00:00:00Z"),
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   97,
													},
													File:   "join_test.flux",
													Source: "range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)",
													Start: ast.Position{
														Column: 12,
														Line:   97,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   97,
														},
														File:   "join_test.flux",
														Source: "range",
														Start: ast.Position{
															Column: 12,
															Line:   97,
														},
													},
												},
												Name: "range",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   98,
											},
											File:   "join_test.flux",
											Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")",
											Start: ast.Position{
												Column: 9,
												Line:   96,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   98,
													},
													File:   "join_test.flux",
													Source: "fn: (r) => r._field == \"b\"",
													Start: ast.Position{
														Column: 19,
														Line:   98,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   98,
														},
														File:   "join_test.flux",
														Source: "fn: (r) => r._field == \"b\"",
														Start: ast.Position{
															Column: 19,
															Line:   98,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   98,
															},
															File:   "join_test.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   98,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   98,
															},
															File:   "join_test.flux",
															Source: "(r) => r._field == \"b\"",
															Start: ast.Position{
																Column: 23,
																Line:   98,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   98,
																},
																File:   "join_test.flux",
																Source: "r._field == \"b\"",
																Start: ast.Position{
																	Column: 30,
																	Line:   98,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   98,
																	},
																	File:   "join_test.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 30,
																		Line:   98,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   98,
																		},
																		File:   "join_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   98,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   98,
																		},
																		File:   "join_test.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 32,
																			Line:   98,
																		},
																	},
																},
																Name: "_field",
															},
														},
														Operator: 17,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   98,
																	},
																	File:   "join_test.flux",
																	Source: "\"b\"",
																	Start: ast.Position{
																		Column: 42,
																		Line:   98,
																	},
																},
															},
															Value: "b",
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   98,
																},
																File:   "join_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   98,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   98,
																	},
																	File:   "join_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   98,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   98,
												},
												File:   "join_test.flux",
												Source: "filter(fn: (r) => r._field == \"b\")",
												Start: ast.Position{
													Column: 12,
													Line:   98,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   98,
													},
													File:   "join_test.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   98,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   99,
										},
										File:   "join_test.flux",
										Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])",
										Start: ast.Position{
											Column: 9,
											Line:   96,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   99,
												},
												File:   "join_test.flux",
												Source: "columns: [\"_field\"]",
												Start: ast.Position{
													Column: 17,
													Line:   99,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   99,
													},
													File:   "join_test.flux",
													Source: "columns: [\"_field\"]",
													Start: ast.Position{
														Column: 17,
														Line:   99,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   99,
														},
														File:   "join_test.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   99,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   99,
														},
														File:   "join_test.flux",
														Source: "[\"_field\"]",
														Start: ast.Position{
															Column: 26,
															Line:   99,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   99,
															},
															File:   "join_test.flux",
															Source: "\"_field\"",
															Start: ast.Position{
																Column: 27,
																Line:   99,
															},
														},
													},
													Value: "_field",
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   99,
											},
											File:   "join_test.flux",
											Source: "drop(columns: [\"_field\"])",
											Start: ast.Position{
												Column: 12,
												Line:   99,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   99,
												},
												File:   "join_test.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   99,
												},
											},
										},
										Name: "drop",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   100,
									},
									File:   "join_test.flux",
									Source: "table\n        |> range(start: 2018-12-19T00:00:00Z, stop: 2018-12-20T00:00:00Z)\n        |> filter(fn: (r) => r._field == \"b\")\n        |> drop(columns: [\"_field\"])\n        |> rename(columns: {_value: \"value_b\"})",
									Start: ast.Position{
										Column: 9,
										Line:   96,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   100,
											},
											File:   "join_test.flux",
											Source: "columns: {_value: \"value_b\"}",
											Start: ast.Position{
												Column: 19,
												Line:   100,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   100,
												},
												File:   "join_test.flux",
												Source: "columns: {_value: \"value_b\"}",
												Start: ast.Position{
													Column: 19,
													Line:   100,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   100,
													},
													File:   "join_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 19,
														Line:   100,
													},
												},
											},
											Name: "columns",
										},
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   100,
													},
													File:   "join_test.flux",
													Source: "{_value: \"value_b\"}",
													Start: ast.Position{
														Column: 28,
														Line:   100,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   100,
														},
														File:   "join_test.flux",
														Source: "_value: \"value_b\"",
														Start: ast.Position{
															Column: 29,
															Line:   100,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   100,
															},
															File:   "join_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 29,
																Line:   100,
															},
														},
													},
													Name: "_value",
												},
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   100,
															},
															File:   "join_test.flux",
															Source: "\"value_b\"",
															Start: ast.Position{
																Column: 37,
																Line:   100,
															},
														},
													},
													Value: "value_b",
												},
											}},
											With: nil,
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   100,
										},
										File:   "join_test.flux",
										Source: "rename(columns: {_value: \"value_b\"})",
										Start: ast.Position{
											Column: 12,
											Line:   100,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   100,
											},
											File:   "join_test.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 12,
												Line:   100,
											},
										},
									},
									Name: "rename",
								},
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 97,
											Line:   102,
										},
										File:   "join_test.flux",
										Source: "left:a, right:b, fn:(left, right) => ({left with value_b: right.value_b})",
										Start: ast.Position{
											Column: 24,
											Line:   102,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   102,
											},
											File:   "join_test.flux",
											Source: "left:a",
											Start: ast.Position{
												Column: 24,
												Line:   102,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   102,
												},
												File:   "join_test.flux",
												Source: "left",
												Start: ast.Position{
													Column: 24,
													Line:   102,
												},
											},
										},
										Name: "left",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   102,
												},
												File:   "join_test.flux",
												Source: "a",
												Start: ast.Position{
													Column: 29,
													Line:   102,
												},
											},
										},
										Name: "a",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   102,
											},
											File:   "join_test.flux",
											Source: "right:b",
											Start: ast.Position{
												Column: 32,
												Line:   102,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   102,
												},
												File:   "join_test.flux",
												Source: "right",
												Start: ast.Position{
													Column: 32,
													Line:   102,
												},
											},
										},
										Name: "right",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   102,
												},
												File:   "join_test.flux",
												Source: "b",
												Start: ast.Position{
													Column: 38,
													Line:   102,
												},
											},
										},
										Name: "b",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 97,
												Line:   102,
											},
											File:   "join_test.flux",
											Source: "fn:(left, right) => ({left with value_b: right.value_b})",
											Start: ast.Position{
												Column: 41,
												Line:   102,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   102,
												},
												File:   "join_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 41,
													Line:   102,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 97,
													Line:   102,
												},
												File:   "join_test.flux",
												Source: "(left, right) => ({left with value_b: right.value_b})",
												Start: ast.Position{
													Column: 44,
													Line:   102,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 97,
														Line:   102,
													},
													File:   "join_test.flux",
													Source: "({left with value_b: right.value_b})",
													Start: ast.Position{
														Column: 61,
														Line:   102,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 96,
															Line:   102,
														},
														File:   "join_test.flux",
														Source: "{left with value_b: right.value_b}",
														Start: ast.Position{
															Column: 62,
															Line:   102,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 95,
																Line:   102,
															},
															File:   "join_test.flux",
															Source: "value_b: right.value_b",
															Start: ast.Position{
																Column: 73,
																Line:   102,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 80,
																	Line:   102,
																},
																File:   "join_test.flux",
																Source: "value_b",
																Start: ast.Position{
																	Column: 73,
																	Line:   102,
																},
															},
														},
														Name: "value_b",
													},
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 95,
																	Line:   102,
																},
																File:   "join_test.flux",
																Source: "right.value_b",
																Start: ast.Position{
																	Column: 82,
																	Line:   102,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   102,
																	},
																	File:   "join_test.flux",
																	Source: "right",
																	Start: ast.Position{
																		Column: 82,
																		Line:   102,
																	},
																},
															},
															Name: "right",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 95,
																		Line:   102,
																	},
																	File:   "join_test.flux",
																	Source: "value_b",
																	Start: ast.Position{
																		Column: 88,
																		Line:   102,
																	},
																},
															},
															Name: "value_b",
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   102,
															},
															File:   "join_test.flux",
															Source: "left",
															Start: ast.Position{
																Column: 63,
																Line:   102,
															},
														},
													},
													Name: "left",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   102,
													},
													File:   "join_test.flux",
													Source: "left",
													Start: ast.Position{
														Column: 45,
														Line:   102,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   102,
														},
														File:   "join_test.flux",
														Source: "left",
														Start: ast.Position{
															Column: 45,
															Line:   102,
														},
													},
												},
												Name: "left",
											},
											Value: nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   102,
													},
													File:   "join_test.flux",
													Source: "right",
													Start: ast.Position{
														Column: 51,
														Line:   102,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   102,
														},
														File:   "join_test.flux",
														Source: "right",
														Start: ast.Position{
															Column: 51,
															Line:   102,
														},
													},
												},
												Name: "right",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   102,
									},
									File:   "join_test.flux",
									Source: "promql.join(left:a, right:b, fn:(left, right) => ({left with value_b: right.value_b}))",
									Start: ast.Position{
										Column: 12,
										Line:   102,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   102,
										},
										File:   "join_test.flux",
										Source: "promql.join",
										Start: ast.Position{
											Column: 12,
											Line:   102,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   102,
											},
											File:   "join_test.flux",
											Source: "promql",
											Start: ast.Position{
												Column: 12,
												Line:   102,
											},
										},
									},
									Name: "promql",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   102,
											},
											File:   "join_test.flux",
											Source: "join",
											Start: ast.Position{
												Column: 19,
												Line:   102,
											},
										},
									},
									Name: "join",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   102,
								},
								File:   "join_test.flux",
								Source: "return promql.join(left:a, right:b, fn:(left, right) => ({left with value_b: right.value_b}))",
								Start: ast.Position{
									Column: 5,
									Line:   102,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   89,
							},
							File:   "join_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 17,
								Line:   89,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   89,
								},
								File:   "join_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 17,
									Line:   89,
								},
							},
						},
						Name: "table",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   89,
							},
							File:   "join_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   89,
							},
						},
					}},
				}},
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   106,
						},
						File:   "join_test.flux",
						Source: "prom_join = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   105,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   105,
							},
							File:   "join_test.flux",
							Source: "prom_join",
							Start: ast.Position{
								Column: 6,
								Line:   105,
							},
						},
					},
					Name: "prom_join",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   106,
							},
							File:   "join_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
							Start: ast.Position{
								Column: 18,
								Line:   105,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   106,
								},
								File:   "join_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
								Start: ast.Position{
									Column: 2,
									Line:   106,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   106,
									},
									File:   "join_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn}",
									Start: ast.Position{
										Column: 3,
										Line:   106,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   106,
										},
										File:   "join_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   106,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   106,
											},
											File:   "join_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   106,
											},
										},
									},
									Name: "input",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   106,
												},
												File:   "join_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   106,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   106,
													},
													File:   "join_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   106,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   106,
														},
														File:   "join_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   106,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   106,
														},
														File:   "join_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   106,
														},
													},
												},
												Name: "inData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   106,
											},
											File:   "join_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   106,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   106,
												},
												File:   "join_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   106,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   106,
													},
													File:   "join_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   106,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   106,
													},
													File:   "join_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   106,
													},
												},
											},
											Name: "loadStorage",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   106,
										},
										File:   "join_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   106,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   106,
											},
											File:   "join_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   106,
											},
										},
									},
									Name: "want",
								},
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   106,
												},
												File:   "join_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   106,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   106,
													},
													File:   "join_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   106,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   106,
														},
														File:   "join_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   106,
														},
													},
												},
												Name: "csv",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   106,
														},
														File:   "join_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   106,
														},
													},
												},
												Name: "outData",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   106,
											},
											File:   "join_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   106,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   106,
												},
												File:   "join_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   106,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   106,
													},
													File:   "join_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   106,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   106,
													},
													File:   "join_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   106,
													},
												},
											},
											Name: "loadMem",
										},
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   106,
										},
										File:   "join_test.flux",
										Source: "fn: join_test_fn",
										Start: ast.Position{
											Column: 82,
											Line:   106,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   106,
											},
											File:   "join_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   106,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   106,
											},
											File:   "join_test.flux",
											Source: "join_test_fn",
											Start: ast.Position{
												Column: 86,
												Line:   106,
											},
										},
									},
									Name: "join_test_fn",
								},
							}},
							With: nil,
						},
					},
					Params: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   106,
					},
					File:   "join_test.flux",
					Source: "test prom_join = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: join_test_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   105,
					},
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   3,
					},
					File:   "join_test.flux",
					Source: "import \"internal/promql\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   3,
						},
						File:   "join_test.flux",
						Source: "\"internal/promql\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "internal/promql",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "join_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "join_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "join_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "join_test.flux",
					Source: "package promql_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "join_test.flux",
						Source: "promql_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "promql_test",
			},
		},
	}},
	Package: "promql_test",
	Path:    "internal/promql",
}}
